/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.DeliveryArtifact;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Environment;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentArtifactPinRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row6;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class EnvironmentArtifactPin
extends TableImpl<EnvironmentArtifactPinRecord> {
    private static final long serialVersionUID = 375106413L;
    public static final EnvironmentArtifactPin ENVIRONMENT_ARTIFACT_PIN = new EnvironmentArtifactPin();
    public final TableField<EnvironmentArtifactPinRecord, String> ENVIRONMENT_UID = EnvironmentArtifactPin.createField((Name)DSL.name((String)"environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactPinRecord, String> ARTIFACT_UID = EnvironmentArtifactPin.createField((Name)DSL.name((String)"artifact_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactPinRecord, String> ARTIFACT_VERSION = EnvironmentArtifactPin.createField((Name)DSL.name((String)"artifact_version"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactPinRecord, String> PINNED_BY = EnvironmentArtifactPin.createField((Name)DSL.name((String)"pinned_by"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactPinRecord, String> COMMENT = EnvironmentArtifactPin.createField((Name)DSL.name((String)"comment"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactPinRecord, Instant> PINNED_AT = EnvironmentArtifactPin.createField((Name)DSL.name((String)"pinned_at"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());

    public Class<EnvironmentArtifactPinRecord> getRecordType() {
        return EnvironmentArtifactPinRecord.class;
    }

    public EnvironmentArtifactPin() {
        this(DSL.name((String)"environment_artifact_pin"), null);
    }

    public EnvironmentArtifactPin(String alias) {
        this(DSL.name((String)alias), (Table<EnvironmentArtifactPinRecord>)ENVIRONMENT_ARTIFACT_PIN);
    }

    public EnvironmentArtifactPin(Name alias) {
        this(alias, (Table<EnvironmentArtifactPinRecord>)ENVIRONMENT_ARTIFACT_PIN);
    }

    private EnvironmentArtifactPin(Name alias, Table<EnvironmentArtifactPinRecord> aliased) {
        this(alias, aliased, null);
    }

    private EnvironmentArtifactPin(Name alias, Table<EnvironmentArtifactPinRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> EnvironmentArtifactPin(Table<O> child, ForeignKey<O, EnvironmentArtifactPinRecord> key) {
        super(child, key, (Table)ENVIRONMENT_ARTIFACT_PIN);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public UniqueKey<EnvironmentArtifactPinRecord> getPrimaryKey() {
        return Keys.KEY_ENVIRONMENT_ARTIFACT_PIN_PRIMARY;
    }

    public List<UniqueKey<EnvironmentArtifactPinRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ENVIRONMENT_ARTIFACT_PIN_PRIMARY);
    }

    public List<ForeignKey<EnvironmentArtifactPinRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ENVIRONMENT_ARTIFACT_PIN_ENVIRONMENT, Keys.FK_ENVIRONMENT_ARTIFACT_PIN_DELIVERY_ARTIFACT);
    }

    public Environment environment() {
        return new Environment(this, Keys.FK_ENVIRONMENT_ARTIFACT_PIN_ENVIRONMENT);
    }

    public DeliveryArtifact deliveryArtifact() {
        return new DeliveryArtifact(this, Keys.FK_ENVIRONMENT_ARTIFACT_PIN_DELIVERY_ARTIFACT);
    }

    public EnvironmentArtifactPin as(String alias) {
        return new EnvironmentArtifactPin(DSL.name((String)alias), (Table<EnvironmentArtifactPinRecord>)this);
    }

    public EnvironmentArtifactPin as(Name alias) {
        return new EnvironmentArtifactPin(alias, (Table<EnvironmentArtifactPinRecord>)this);
    }

    public EnvironmentArtifactPin rename(String name) {
        return new EnvironmentArtifactPin(DSL.name((String)name), null);
    }

    public EnvironmentArtifactPin rename(Name name) {
        return new EnvironmentArtifactPin(name, null);
    }

    public Row6<String, String, String, String, String, Instant> fieldsRow() {
        return (Row6)super.fieldsRow();
    }
}

