/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.api.constraints.ConstraintStatus;
import com.netflix.spinnaker.keel.persistence.metamodel.Indexes;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Environment;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentArtifactConstraintRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row11;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class EnvironmentArtifactConstraint
extends TableImpl<EnvironmentArtifactConstraintRecord> {
    private static final long serialVersionUID = 1704454659L;
    public static final EnvironmentArtifactConstraint ENVIRONMENT_ARTIFACT_CONSTRAINT = new EnvironmentArtifactConstraint();
    public final TableField<EnvironmentArtifactConstraintRecord, String> UID = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, String> ENVIRONMENT_UID = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, String> ARTIFACT_VERSION = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"artifact_version"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, String> ARTIFACT_REFERENCE = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"artifact_reference"), (DataType)SQLDataType.VARCHAR((int)150).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, String> TYPE = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"type"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, Instant> CREATED_AT = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"created_at"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<EnvironmentArtifactConstraintRecord, ConstraintStatus> STATUS = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"status"), (DataType)SQLDataType.VARCHAR((int)64), (Table)this, (String)"", (Converter)new EnumConverter(String.class, ConstraintStatus.class));
    public final TableField<EnvironmentArtifactConstraintRecord, String> JUDGED_BY = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"judged_by"), (DataType)SQLDataType.VARCHAR((int)512), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, Instant> JUDGED_AT = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"judged_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<EnvironmentArtifactConstraintRecord, String> COMMENT = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"comment"), (DataType)SQLDataType.VARCHAR((int)1024), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactConstraintRecord, String> ATTRIBUTES = EnvironmentArtifactConstraint.createField((Name)DSL.name((String)"attributes"), (DataType)SQLDataType.LONGVARCHAR, (Table)this, (String)"");

    public Class<EnvironmentArtifactConstraintRecord> getRecordType() {
        return EnvironmentArtifactConstraintRecord.class;
    }

    public EnvironmentArtifactConstraint() {
        this(DSL.name((String)"environment_artifact_constraint"), null);
    }

    public EnvironmentArtifactConstraint(String alias) {
        this(DSL.name((String)alias), (Table<EnvironmentArtifactConstraintRecord>)ENVIRONMENT_ARTIFACT_CONSTRAINT);
    }

    public EnvironmentArtifactConstraint(Name alias) {
        this(alias, (Table<EnvironmentArtifactConstraintRecord>)ENVIRONMENT_ARTIFACT_CONSTRAINT);
    }

    private EnvironmentArtifactConstraint(Name alias, Table<EnvironmentArtifactConstraintRecord> aliased) {
        this(alias, aliased, null);
    }

    private EnvironmentArtifactConstraint(Name alias, Table<EnvironmentArtifactConstraintRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> EnvironmentArtifactConstraint(Table<O> child, ForeignKey<O, EnvironmentArtifactConstraintRecord> key) {
        super(child, key, (Table)ENVIRONMENT_ARTIFACT_CONSTRAINT);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.ENVIRONMENT_ARTIFACT_CONSTRAINT_ENV_VERSION_REFERENCE_IDX, Indexes.ENVIRONMENT_ARTIFACT_CONSTRAINT_ENVIRONMENT_ARTIFACT_CONSTRAINT_JUDGED_AT_IDX, Indexes.ENVIRONMENT_ARTIFACT_CONSTRAINT_ENVIRONMENT_ARTIFACT_CONSTRAINT_UID_STATUS_IDX);
    }

    public UniqueKey<EnvironmentArtifactConstraintRecord> getPrimaryKey() {
        return Keys.KEY_ENVIRONMENT_ARTIFACT_CONSTRAINT_PRIMARY;
    }

    public List<UniqueKey<EnvironmentArtifactConstraintRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ENVIRONMENT_ARTIFACT_CONSTRAINT_PRIMARY, Keys.KEY_ENVIRONMENT_ARTIFACT_CONSTRAINT_CONSTRAINT_UNIQUE);
    }

    public List<ForeignKey<EnvironmentArtifactConstraintRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ENVIRONMENT_ARTIFACT_CONSTRAINT_ENVIRONMENT);
    }

    public Environment environment() {
        return new Environment(this, Keys.FK_ENVIRONMENT_ARTIFACT_CONSTRAINT_ENVIRONMENT);
    }

    public EnvironmentArtifactConstraint as(String alias) {
        return new EnvironmentArtifactConstraint(DSL.name((String)alias), (Table<EnvironmentArtifactConstraintRecord>)this);
    }

    public EnvironmentArtifactConstraint as(Name alias) {
        return new EnvironmentArtifactConstraint(alias, (Table<EnvironmentArtifactConstraintRecord>)this);
    }

    public EnvironmentArtifactConstraint rename(String name) {
        return new EnvironmentArtifactConstraint(DSL.name((String)name), null);
    }

    public EnvironmentArtifactConstraint rename(Name name) {
        return new EnvironmentArtifactConstraint(name, null);
    }

    public Row11<String, String, String, String, String, Instant, ConstraintStatus, String, Instant, String, String> fieldsRow() {
        return (Row11)super.fieldsRow();
    }
}

