/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.persistence.metamodel.Indexes;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.DeliveryConfig;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.DeliveryConfigLastCheckedRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row4;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class DeliveryConfigLastChecked
extends TableImpl<DeliveryConfigLastCheckedRecord> {
    private static final long serialVersionUID = -1077873020L;
    public static final DeliveryConfigLastChecked DELIVERY_CONFIG_LAST_CHECKED = new DeliveryConfigLastChecked();
    public final TableField<DeliveryConfigLastCheckedRecord, String> DELIVERY_CONFIG_UID = DeliveryConfigLastChecked.createField((Name)DSL.name((String)"delivery_config_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<DeliveryConfigLastCheckedRecord, Instant> AT = DeliveryConfigLastChecked.createField((Name)DSL.name((String)"at"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<DeliveryConfigLastCheckedRecord, String> LEASED_BY = DeliveryConfigLastChecked.createField((Name)DSL.name((String)"leased_by"), (DataType)SQLDataType.VARCHAR((int)64), (Table)this, (String)"");
    public final TableField<DeliveryConfigLastCheckedRecord, Instant> LEASED_AT = DeliveryConfigLastChecked.createField((Name)DSL.name((String)"leased_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());

    public Class<DeliveryConfigLastCheckedRecord> getRecordType() {
        return DeliveryConfigLastCheckedRecord.class;
    }

    public DeliveryConfigLastChecked() {
        this(DSL.name((String)"delivery_config_last_checked"), null);
    }

    public DeliveryConfigLastChecked(String alias) {
        this(DSL.name((String)alias), (Table<DeliveryConfigLastCheckedRecord>)DELIVERY_CONFIG_LAST_CHECKED);
    }

    public DeliveryConfigLastChecked(Name alias) {
        this(alias, (Table<DeliveryConfigLastCheckedRecord>)DELIVERY_CONFIG_LAST_CHECKED);
    }

    private DeliveryConfigLastChecked(Name alias, Table<DeliveryConfigLastCheckedRecord> aliased) {
        this(alias, aliased, null);
    }

    private DeliveryConfigLastChecked(Name alias, Table<DeliveryConfigLastCheckedRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> DeliveryConfigLastChecked(Table<O> child, ForeignKey<O, DeliveryConfigLastCheckedRecord> key) {
        super(child, key, (Table)DELIVERY_CONFIG_LAST_CHECKED);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.DELIVERY_CONFIG_LAST_CHECKED_DELIVERY_CONFIG_LAST_CHECKED_AT_LEASED_BY_LEASED_AT_IDX);
    }

    public UniqueKey<DeliveryConfigLastCheckedRecord> getPrimaryKey() {
        return Keys.KEY_DELIVERY_CONFIG_LAST_CHECKED_PRIMARY;
    }

    public List<UniqueKey<DeliveryConfigLastCheckedRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_DELIVERY_CONFIG_LAST_CHECKED_PRIMARY);
    }

    public List<ForeignKey<DeliveryConfigLastCheckedRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_DELIVERY_CONFIG_LAST_CHECKED_DELIVERY_CONFIG);
    }

    public DeliveryConfig deliveryConfig() {
        return new DeliveryConfig(this, Keys.FK_DELIVERY_CONFIG_LAST_CHECKED_DELIVERY_CONFIG);
    }

    public DeliveryConfigLastChecked as(String alias) {
        return new DeliveryConfigLastChecked(DSL.name((String)alias), (Table<DeliveryConfigLastCheckedRecord>)this);
    }

    public DeliveryConfigLastChecked as(Name alias) {
        return new DeliveryConfigLastChecked(alias, (Table<DeliveryConfigLastCheckedRecord>)this);
    }

    public DeliveryConfigLastChecked rename(String name) {
        return new DeliveryConfigLastChecked(DSL.name((String)name), null);
    }

    public DeliveryConfigLastChecked rename(Name name) {
        return new DeliveryConfigLastChecked(name, null);
    }

    public Row4<String, Instant, String, Instant> fieldsRow() {
        return (Row4)super.fieldsRow();
    }
}

