/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.JsonToMapConverter;
import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.api.action.ActionType;
import com.netflix.spinnaker.keel.api.constraints.ConstraintStatus;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.DeliveryArtifact;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Environment;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ActionStateRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row10;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class ActionState
extends TableImpl<ActionStateRecord> {
    private static final long serialVersionUID = -1804010162L;
    public static final ActionState ACTION_STATE = new ActionState();
    public final TableField<ActionStateRecord, String> ENVIRONMENT_UID = ActionState.createField((Name)DSL.name((String)"environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<ActionStateRecord, String> ARTIFACT_UID = ActionState.createField((Name)DSL.name((String)"artifact_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<ActionStateRecord, String> ARTIFACT_VERSION = ActionState.createField((Name)DSL.name((String)"artifact_version"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<ActionStateRecord, ActionType> TYPE = ActionState.createField((Name)DSL.name((String)"type"), (DataType)SQLDataType.VARCHAR((int)100).nullable(false), (Table)this, (String)"", (Converter)new EnumConverter(String.class, ActionType.class));
    public final TableField<ActionStateRecord, String> ACTION_ID = ActionState.createField((Name)DSL.name((String)"action_id"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<ActionStateRecord, ConstraintStatus> STATUS = ActionState.createField((Name)DSL.name((String)"status"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"", (Converter)new EnumConverter(String.class, ConstraintStatus.class));
    public final TableField<ActionStateRecord, Instant> STARTED_AT = ActionState.createField((Name)DSL.name((String)"started_at"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<ActionStateRecord, Instant> ENDED_AT = ActionState.createField((Name)DSL.name((String)"ended_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<ActionStateRecord, String> LINK = ActionState.createField((Name)DSL.name((String)"link"), (DataType)SQLDataType.VARCHAR((int)511), (Table)this, (String)"");
    public final TableField<ActionStateRecord, Map<String, ?>> METADATA = ActionState.createField((Name)DSL.name((String)"metadata"), (DataType)SQLDataType.JSON.nullable(false), (Table)this, (String)"", (Converter)new JsonToMapConverter());

    public Class<ActionStateRecord> getRecordType() {
        return ActionStateRecord.class;
    }

    public ActionState() {
        this(DSL.name((String)"action_state"), null);
    }

    public ActionState(String alias) {
        this(DSL.name((String)alias), (Table<ActionStateRecord>)ACTION_STATE);
    }

    public ActionState(Name alias) {
        this(alias, (Table<ActionStateRecord>)ACTION_STATE);
    }

    private ActionState(Name alias, Table<ActionStateRecord> aliased) {
        this(alias, aliased, null);
    }

    private ActionState(Name alias, Table<ActionStateRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> ActionState(Table<O> child, ForeignKey<O, ActionStateRecord> key) {
        super(child, key, (Table)ACTION_STATE);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public UniqueKey<ActionStateRecord> getPrimaryKey() {
        return Keys.KEY_ACTION_STATE_PRIMARY;
    }

    public List<UniqueKey<ActionStateRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ACTION_STATE_PRIMARY);
    }

    public List<ForeignKey<ActionStateRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_VERIFICATION_STATE_ENVIRONMENT, Keys.FK_VERIFICATION_STATE_DELIVERY_ARTIFACT);
    }

    public Environment environment() {
        return new Environment(this, Keys.FK_VERIFICATION_STATE_ENVIRONMENT);
    }

    public DeliveryArtifact deliveryArtifact() {
        return new DeliveryArtifact(this, Keys.FK_VERIFICATION_STATE_DELIVERY_ARTIFACT);
    }

    public ActionState as(String alias) {
        return new ActionState(DSL.name((String)alias), (Table<ActionStateRecord>)this);
    }

    public ActionState as(Name alias) {
        return new ActionState(alias, (Table<ActionStateRecord>)this);
    }

    public ActionState rename(String name) {
        return new ActionState(DSL.name((String)name), null);
    }

    public ActionState rename(Name name) {
        return new ActionState(name, null);
    }

    public Row10<String, String, String, ActionType, String, ConstraintStatus, Instant, Instant, String, Map<String, ?>> fieldsRow() {
        return (Row10)super.fieldsRow();
    }
}

