/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.api.ec2;

import com.netflix.spinnaker.keel.api.DeployHealth;
import com.netflix.spinnaker.keel.api.ExcludedFromDiff;
import com.netflix.spinnaker.keel.api.VersionedArtifactProvider;
import com.netflix.spinnaker.keel.api.ec2.Capacity;
import com.netflix.spinnaker.keel.api.ec2.ClusterDependencies;
import com.netflix.spinnaker.keel.api.ec2.HealthCheckType;
import com.netflix.spinnaker.keel.api.ec2.Location;
import com.netflix.spinnaker.keel.api.ec2.Metric;
import com.netflix.spinnaker.keel.api.ec2.Scaling;
import com.netflix.spinnaker.keel.api.ec2.ServerGroup$InstanceCounts$WhenMappings;
import com.netflix.spinnaker.keel.api.ec2.TerminationPolicy;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b.\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001:\u0005PQRSTB\u00b3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0019\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001a\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0002\u0010\u001eJ\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010>\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001aH\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u001dH\u00c6\u0003J\t\u0010A\u001a\u00020\u0005H\u00c6\u0003J\t\u0010B\u001a\u00020\u0007H\u00c6\u0003J\t\u0010C\u001a\u00020\tH\u00c6\u0003J\t\u0010D\u001a\u00020\u000bH\u00c6\u0003J\t\u0010E\u001a\u00020\rH\u00c6\u0003J\t\u0010F\u001a\u00020\u000fH\u00c6\u0003J\u0015\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011H\u00c6\u0003J\t\u0010H\u001a\u00020\u0013H\u00c6\u0003J\u00bd\u0001\u0010I\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0019\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00c6\u0001J\u0013\u0010J\u001a\u00020\u00132\b\u0010K\u001a\u0004\u0018\u00010LH\u00d6\u0003J\t\u0010M\u001a\u00020NH\u00d6\u0001J\t\u0010O\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00038\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010\u0019\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001a8\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00038\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010 R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006U"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup;", "Lcom/netflix/spinnaker/keel/api/VersionedArtifactProvider;", "name", "", "location", "Lcom/netflix/spinnaker/keel/api/ec2/Location;", "launchConfiguration", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$LaunchConfiguration;", "capacity", "Lcom/netflix/spinnaker/keel/api/ec2/Capacity;", "dependencies", "Lcom/netflix/spinnaker/keel/api/ec2/ClusterDependencies;", "health", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$Health;", "scaling", "Lcom/netflix/spinnaker/keel/api/ec2/Scaling;", "tags", "", "onlyEnabledServerGroup", "", "image", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$ActiveServerGroupImage;", "buildInfo", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$BuildInfo;", "artifactName", "artifactType", "Lcom/netflix/spinnaker/keel/api/artifacts/ArtifactType;", "artifactVersion", "instanceCounts", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$InstanceCounts;", "(Ljava/lang/String;Lcom/netflix/spinnaker/keel/api/ec2/Location;Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$LaunchConfiguration;Lcom/netflix/spinnaker/keel/api/ec2/Capacity;Lcom/netflix/spinnaker/keel/api/ec2/ClusterDependencies;Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$Health;Lcom/netflix/spinnaker/keel/api/ec2/Scaling;Ljava/util/Map;ZLcom/netflix/spinnaker/keel/api/ec2/ServerGroup$ActiveServerGroupImage;Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$BuildInfo;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$InstanceCounts;)V", "getArtifactName", "()Ljava/lang/String;", "getArtifactType", "getArtifactVersion", "getBuildInfo", "()Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$BuildInfo;", "getCapacity", "()Lcom/netflix/spinnaker/keel/api/ec2/Capacity;", "getDependencies", "()Lcom/netflix/spinnaker/keel/api/ec2/ClusterDependencies;", "getHealth", "()Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$Health;", "getImage", "()Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$ActiveServerGroupImage;", "getInstanceCounts", "()Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$InstanceCounts;", "getLaunchConfiguration", "()Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$LaunchConfiguration;", "getLocation", "()Lcom/netflix/spinnaker/keel/api/ec2/Location;", "getName", "getOnlyEnabledServerGroup", "()Z", "getScaling", "()Lcom/netflix/spinnaker/keel/api/ec2/Scaling;", "getTags", "()Ljava/util/Map;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "ActiveServerGroupImage", "BuildInfo", "Health", "InstanceCounts", "LaunchConfiguration", "keel-ec2-api"})
public final class ServerGroup
implements VersionedArtifactProvider {
    @NotNull
    private final String name;
    @NotNull
    private final Location location;
    @NotNull
    private final LaunchConfiguration launchConfiguration;
    @NotNull
    private final Capacity capacity;
    @NotNull
    private final ClusterDependencies dependencies;
    @NotNull
    private final Health health;
    @NotNull
    private final Scaling scaling;
    @NotNull
    private final Map<String, String> tags;
    private final boolean onlyEnabledServerGroup;
    @Nullable
    private final ActiveServerGroupImage image;
    @Nullable
    private final BuildInfo buildInfo;
    @Nullable
    private final String artifactName;
    @Nullable
    private final String artifactType;
    @Nullable
    private final String artifactVersion;
    @Nullable
    private final InstanceCounts instanceCounts;

    @ExcludedFromDiff
    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final LaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    @NotNull
    public final Capacity getCapacity() {
        return this.capacity;
    }

    @NotNull
    public final ClusterDependencies getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final Health getHealth() {
        return this.health;
    }

    @NotNull
    public final Scaling getScaling() {
        return this.scaling;
    }

    @NotNull
    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final boolean getOnlyEnabledServerGroup() {
        return this.onlyEnabledServerGroup;
    }

    @ExcludedFromDiff
    @Nullable
    public final ActiveServerGroupImage getImage() {
        return this.image;
    }

    @ExcludedFromDiff
    @Nullable
    public final BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @ExcludedFromDiff
    @Nullable
    public String getArtifactName() {
        return this.artifactName;
    }

    @ExcludedFromDiff
    @Nullable
    public String getArtifactType() {
        return this.artifactType;
    }

    @ExcludedFromDiff
    @Nullable
    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    @ExcludedFromDiff
    @Nullable
    public final InstanceCounts getInstanceCounts() {
        return this.instanceCounts;
    }

    public ServerGroup(@NotNull String name, @NotNull Location location, @NotNull LaunchConfiguration launchConfiguration, @NotNull Capacity capacity, @NotNull ClusterDependencies dependencies, @NotNull Health health, @NotNull Scaling scaling, @NotNull Map<String, String> tags, boolean onlyEnabledServerGroup, @Nullable ActiveServerGroupImage image, @Nullable BuildInfo buildInfo, @Nullable String artifactName, @Nullable String artifactType, @Nullable String artifactVersion, @Nullable InstanceCounts instanceCounts) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)launchConfiguration, (String)"launchConfiguration");
        Intrinsics.checkNotNullParameter((Object)capacity, (String)"capacity");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)health, (String)"health");
        Intrinsics.checkNotNullParameter((Object)scaling, (String)"scaling");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.name = name;
        this.location = location;
        this.launchConfiguration = launchConfiguration;
        this.capacity = capacity;
        this.dependencies = dependencies;
        this.health = health;
        this.scaling = scaling;
        this.tags = tags;
        this.onlyEnabledServerGroup = onlyEnabledServerGroup;
        this.image = image;
        this.buildInfo = buildInfo;
        this.artifactName = artifactName;
        this.artifactType = artifactType;
        this.artifactVersion = artifactVersion;
        this.instanceCounts = instanceCounts;
        boolean bl = this.capacity.getDesired() != null && !this.scaling.hasScalingPolicies() || this.capacity.getDesired() == null && this.scaling.hasScalingPolicies();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "capacity.desired and auto-scaling policies are mutually exclusive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ServerGroup(String string, Location location, LaunchConfiguration launchConfiguration, Capacity capacity, ClusterDependencies clusterDependencies, Health health, Scaling scaling, Map map, boolean bl, ActiveServerGroupImage activeServerGroupImage, BuildInfo buildInfo, String string2, String string3, String string4, InstanceCounts instanceCounts, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            capacity = new Capacity(1, 1, 1);
        }
        if ((n & 0x10) != 0) {
            clusterDependencies = new ClusterDependencies(null, null, null, 7, null);
        }
        if ((n & 0x20) != 0) {
            health = new Health(null, null, null, null, null, 31, null);
        }
        if ((n & 0x40) != 0) {
            scaling = new Scaling(null, null, null, 7, null);
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x100) != 0) {
            bl = true;
        }
        if ((n & 0x200) != 0) {
            activeServerGroupImage = null;
        }
        if ((n & 0x400) != 0) {
            buildInfo = null;
        }
        if ((n & 0x800) != 0) {
            string2 = null;
        }
        if ((n & 0x1000) != 0) {
            string3 = "deb";
        }
        if ((n & 0x2000) != 0) {
            string4 = null;
        }
        if ((n & 0x4000) != 0) {
            instanceCounts = null;
        }
        this(string, location, launchConfiguration, capacity, clusterDependencies, health, scaling, map, bl, activeServerGroupImage, buildInfo, string2, string3, string4, instanceCounts);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Location component2() {
        return this.location;
    }

    @NotNull
    public final LaunchConfiguration component3() {
        return this.launchConfiguration;
    }

    @NotNull
    public final Capacity component4() {
        return this.capacity;
    }

    @NotNull
    public final ClusterDependencies component5() {
        return this.dependencies;
    }

    @NotNull
    public final Health component6() {
        return this.health;
    }

    @NotNull
    public final Scaling component7() {
        return this.scaling;
    }

    @NotNull
    public final Map<String, String> component8() {
        return this.tags;
    }

    public final boolean component9() {
        return this.onlyEnabledServerGroup;
    }

    @Nullable
    public final ActiveServerGroupImage component10() {
        return this.image;
    }

    @Nullable
    public final BuildInfo component11() {
        return this.buildInfo;
    }

    @Nullable
    public final String component12() {
        return this.getArtifactName();
    }

    @Nullable
    public final String component13() {
        return this.getArtifactType();
    }

    @Nullable
    public final String component14() {
        return this.getArtifactVersion();
    }

    @Nullable
    public final InstanceCounts component15() {
        return this.instanceCounts;
    }

    @NotNull
    public final ServerGroup copy(@NotNull String name, @NotNull Location location, @NotNull LaunchConfiguration launchConfiguration, @NotNull Capacity capacity, @NotNull ClusterDependencies dependencies, @NotNull Health health, @NotNull Scaling scaling, @NotNull Map<String, String> tags, boolean onlyEnabledServerGroup, @Nullable ActiveServerGroupImage image, @Nullable BuildInfo buildInfo, @Nullable String artifactName, @Nullable String artifactType, @Nullable String artifactVersion, @Nullable InstanceCounts instanceCounts) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)launchConfiguration, (String)"launchConfiguration");
        Intrinsics.checkNotNullParameter((Object)capacity, (String)"capacity");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)health, (String)"health");
        Intrinsics.checkNotNullParameter((Object)scaling, (String)"scaling");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new ServerGroup(name, location, launchConfiguration, capacity, dependencies, health, scaling, tags, onlyEnabledServerGroup, image, buildInfo, artifactName, artifactType, artifactVersion, instanceCounts);
    }

    public static /* synthetic */ ServerGroup copy$default(ServerGroup serverGroup, String string, Location location, LaunchConfiguration launchConfiguration, Capacity capacity, ClusterDependencies clusterDependencies, Health health, Scaling scaling, Map map, boolean bl, ActiveServerGroupImage activeServerGroupImage, BuildInfo buildInfo, String string2, String string3, String string4, InstanceCounts instanceCounts, int n, Object object) {
        if ((n & 1) != 0) {
            string = serverGroup.name;
        }
        if ((n & 2) != 0) {
            location = serverGroup.location;
        }
        if ((n & 4) != 0) {
            launchConfiguration = serverGroup.launchConfiguration;
        }
        if ((n & 8) != 0) {
            capacity = serverGroup.capacity;
        }
        if ((n & 0x10) != 0) {
            clusterDependencies = serverGroup.dependencies;
        }
        if ((n & 0x20) != 0) {
            health = serverGroup.health;
        }
        if ((n & 0x40) != 0) {
            scaling = serverGroup.scaling;
        }
        if ((n & 0x80) != 0) {
            map = serverGroup.tags;
        }
        if ((n & 0x100) != 0) {
            bl = serverGroup.onlyEnabledServerGroup;
        }
        if ((n & 0x200) != 0) {
            activeServerGroupImage = serverGroup.image;
        }
        if ((n & 0x400) != 0) {
            buildInfo = serverGroup.buildInfo;
        }
        if ((n & 0x800) != 0) {
            string2 = serverGroup.getArtifactName();
        }
        if ((n & 0x1000) != 0) {
            string3 = serverGroup.getArtifactType();
        }
        if ((n & 0x2000) != 0) {
            string4 = serverGroup.getArtifactVersion();
        }
        if ((n & 0x4000) != 0) {
            instanceCounts = serverGroup.instanceCounts;
        }
        return serverGroup.copy(string, location, launchConfiguration, capacity, clusterDependencies, health, scaling, map, bl, activeServerGroupImage, buildInfo, string2, string3, string4, instanceCounts);
    }

    @NotNull
    public String toString() {
        return "ServerGroup(name=" + this.name + ", location=" + this.location + ", launchConfiguration=" + this.launchConfiguration + ", capacity=" + this.capacity + ", dependencies=" + this.dependencies + ", health=" + this.health + ", scaling=" + this.scaling + ", tags=" + this.tags + ", onlyEnabledServerGroup=" + this.onlyEnabledServerGroup + ", image=" + this.image + ", buildInfo=" + this.buildInfo + ", artifactName=" + this.getArtifactName() + ", artifactType=" + this.getArtifactType() + ", artifactVersion=" + this.getArtifactVersion() + ", instanceCounts=" + this.instanceCounts + ")";
    }

    public int hashCode() {
        String string = this.name;
        Location location = this.location;
        LaunchConfiguration launchConfiguration = this.launchConfiguration;
        Capacity capacity = this.capacity;
        ClusterDependencies clusterDependencies = this.dependencies;
        Health health = this.health;
        Scaling scaling = this.scaling;
        Map<String, String> map = this.tags;
        int n = ((((((((string != null ? string.hashCode() : 0) * 31 + (location != null ? ((Object)location).hashCode() : 0)) * 31 + (launchConfiguration != null ? ((Object)launchConfiguration).hashCode() : 0)) * 31 + (capacity != null ? ((Object)capacity).hashCode() : 0)) * 31 + (clusterDependencies != null ? ((Object)clusterDependencies).hashCode() : 0)) * 31 + (health != null ? ((Object)health).hashCode() : 0)) * 31 + (scaling != null ? ((Object)scaling).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31;
        int n2 = this.onlyEnabledServerGroup ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        ActiveServerGroupImage activeServerGroupImage = this.image;
        BuildInfo buildInfo = this.buildInfo;
        String string2 = this.getArtifactName();
        String string3 = this.getArtifactType();
        String string4 = this.getArtifactVersion();
        InstanceCounts instanceCounts = this.instanceCounts;
        return ((((((n + n2) * 31 + (activeServerGroupImage != null ? ((Object)activeServerGroupImage).hashCode() : 0)) * 31 + (buildInfo != null ? ((Object)buildInfo).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (instanceCounts != null ? ((Object)instanceCounts).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ServerGroup)) break block3;
                ServerGroup serverGroup = (ServerGroup)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)serverGroup.name) || !Intrinsics.areEqual((Object)this.location, (Object)serverGroup.location) || !Intrinsics.areEqual((Object)this.launchConfiguration, (Object)serverGroup.launchConfiguration) || !Intrinsics.areEqual((Object)this.capacity, (Object)serverGroup.capacity) || !Intrinsics.areEqual((Object)this.dependencies, (Object)serverGroup.dependencies) || !Intrinsics.areEqual((Object)this.health, (Object)serverGroup.health) || !Intrinsics.areEqual((Object)this.scaling, (Object)serverGroup.scaling) || !Intrinsics.areEqual(this.tags, serverGroup.tags) || this.onlyEnabledServerGroup != serverGroup.onlyEnabledServerGroup || !Intrinsics.areEqual((Object)this.image, (Object)serverGroup.image) || !Intrinsics.areEqual((Object)this.buildInfo, (Object)serverGroup.buildInfo) || !Intrinsics.areEqual((Object)this.getArtifactName(), (Object)serverGroup.getArtifactName()) || !Intrinsics.areEqual((Object)this.getArtifactType(), (Object)serverGroup.getArtifactType()) || !Intrinsics.areEqual((Object)this.getArtifactVersion(), (Object)serverGroup.getArtifactVersion()) || !Intrinsics.areEqual((Object)this.instanceCounts, (Object)serverGroup.instanceCounts)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JK\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$ActiveServerGroupImage;", "", "imageId", "", "appVersion", "baseImageName", "name", "imageLocation", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAppVersion", "()Ljava/lang/String;", "getBaseImageName", "getDescription", "getImageId", "getImageLocation", "getName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "keel-ec2-api"})
    public static final class ActiveServerGroupImage {
        @NotNull
        private final String imageId;
        @Nullable
        private final String appVersion;
        @Nullable
        private final String baseImageName;
        @NotNull
        private final String name;
        @NotNull
        private final String imageLocation;
        @Nullable
        private final String description;

        @ExcludedFromDiff
        @NotNull
        public final String getImageId() {
            return this.imageId;
        }

        @Nullable
        public final String getAppVersion() {
            return this.appVersion;
        }

        @Nullable
        public final String getBaseImageName() {
            return this.baseImageName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getImageLocation() {
            return this.imageLocation;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public ActiveServerGroupImage(@NotNull String imageId, @Nullable String appVersion, @Nullable String baseImageName, @NotNull String name, @NotNull String imageLocation, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)imageLocation, (String)"imageLocation");
            this.imageId = imageId;
            this.appVersion = appVersion;
            this.baseImageName = baseImageName;
            this.name = name;
            this.imageLocation = imageLocation;
            this.description = description;
        }

        @NotNull
        public final String component1() {
            return this.imageId;
        }

        @Nullable
        public final String component2() {
            return this.appVersion;
        }

        @Nullable
        public final String component3() {
            return this.baseImageName;
        }

        @NotNull
        public final String component4() {
            return this.name;
        }

        @NotNull
        public final String component5() {
            return this.imageLocation;
        }

        @Nullable
        public final String component6() {
            return this.description;
        }

        @NotNull
        public final ActiveServerGroupImage copy(@NotNull String imageId, @Nullable String appVersion, @Nullable String baseImageName, @NotNull String name, @NotNull String imageLocation, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)imageLocation, (String)"imageLocation");
            return new ActiveServerGroupImage(imageId, appVersion, baseImageName, name, imageLocation, description);
        }

        public static /* synthetic */ ActiveServerGroupImage copy$default(ActiveServerGroupImage activeServerGroupImage, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = activeServerGroupImage.imageId;
            }
            if ((n & 2) != 0) {
                string2 = activeServerGroupImage.appVersion;
            }
            if ((n & 4) != 0) {
                string3 = activeServerGroupImage.baseImageName;
            }
            if ((n & 8) != 0) {
                string4 = activeServerGroupImage.name;
            }
            if ((n & 0x10) != 0) {
                string5 = activeServerGroupImage.imageLocation;
            }
            if ((n & 0x20) != 0) {
                string6 = activeServerGroupImage.description;
            }
            return activeServerGroupImage.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "ActiveServerGroupImage(imageId=" + this.imageId + ", appVersion=" + this.appVersion + ", baseImageName=" + this.baseImageName + ", name=" + this.name + ", imageLocation=" + this.imageLocation + ", description=" + this.description + ")";
        }

        public int hashCode() {
            String string = this.imageId;
            String string2 = this.appVersion;
            String string3 = this.baseImageName;
            String string4 = this.name;
            String string5 = this.imageLocation;
            String string6 = this.description;
            return (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActiveServerGroupImage)) break block3;
                    ActiveServerGroupImage activeServerGroupImage = (ActiveServerGroupImage)object;
                    if (!Intrinsics.areEqual((Object)this.imageId, (Object)activeServerGroupImage.imageId) || !Intrinsics.areEqual((Object)this.appVersion, (Object)activeServerGroupImage.appVersion) || !Intrinsics.areEqual((Object)this.baseImageName, (Object)activeServerGroupImage.baseImageName) || !Intrinsics.areEqual((Object)this.name, (Object)activeServerGroupImage.name) || !Intrinsics.areEqual((Object)this.imageLocation, (Object)activeServerGroupImage.imageLocation) || !Intrinsics.areEqual((Object)this.description, (Object)activeServerGroupImage.description)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$BuildInfo;", "", "packageName", "", "(Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "keel-ec2-api"})
    public static final class BuildInfo {
        @Nullable
        private final String packageName;

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public BuildInfo(@Nullable String packageName) {
            this.packageName = packageName;
        }

        @Nullable
        public final String component1() {
            return this.packageName;
        }

        @NotNull
        public final BuildInfo copy(@Nullable String packageName) {
            return new BuildInfo(packageName);
        }

        public static /* synthetic */ BuildInfo copy$default(BuildInfo buildInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = buildInfo.packageName;
            }
            return buildInfo.copy(string);
        }

        @NotNull
        public String toString() {
            return "BuildInfo(packageName=" + this.packageName + ")";
        }

        public int hashCode() {
            String string = this.packageName;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BuildInfo)) break block3;
                    BuildInfo buildInfo = (BuildInfo)object;
                    if (!Intrinsics.areEqual((Object)this.packageName, (Object)buildInfo.packageName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00c6\u0003JG\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$Health;", "", "cooldown", "Ljava/time/Duration;", "warmup", "healthCheckType", "Lcom/netflix/spinnaker/keel/api/ec2/HealthCheckType;", "enabledMetrics", "", "Lcom/netflix/spinnaker/keel/api/ec2/Metric;", "terminationPolicies", "Lcom/netflix/spinnaker/keel/api/ec2/TerminationPolicy;", "(Ljava/time/Duration;Ljava/time/Duration;Lcom/netflix/spinnaker/keel/api/ec2/HealthCheckType;Ljava/util/Set;Ljava/util/Set;)V", "getCooldown", "()Ljava/time/Duration;", "getEnabledMetrics", "()Ljava/util/Set;", "getHealthCheckType", "()Lcom/netflix/spinnaker/keel/api/ec2/HealthCheckType;", "getTerminationPolicies", "getWarmup", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "keel-ec2-api"})
    public static final class Health {
        @NotNull
        private final Duration cooldown;
        @NotNull
        private final Duration warmup;
        @NotNull
        private final HealthCheckType healthCheckType;
        @NotNull
        private final Set<Metric> enabledMetrics;
        @NotNull
        private final Set<TerminationPolicy> terminationPolicies;

        @NotNull
        public final Duration getCooldown() {
            return this.cooldown;
        }

        @NotNull
        public final Duration getWarmup() {
            return this.warmup;
        }

        @NotNull
        public final HealthCheckType getHealthCheckType() {
            return this.healthCheckType;
        }

        @NotNull
        public final Set<Metric> getEnabledMetrics() {
            return this.enabledMetrics;
        }

        @NotNull
        public final Set<TerminationPolicy> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        public Health(@NotNull Duration cooldown, @NotNull Duration warmup, @NotNull HealthCheckType healthCheckType, @NotNull Set<? extends Metric> enabledMetrics, @NotNull Set<? extends TerminationPolicy> terminationPolicies) {
            Intrinsics.checkNotNullParameter((Object)cooldown, (String)"cooldown");
            Intrinsics.checkNotNullParameter((Object)warmup, (String)"warmup");
            Intrinsics.checkNotNullParameter((Object)((Object)healthCheckType), (String)"healthCheckType");
            Intrinsics.checkNotNullParameter(enabledMetrics, (String)"enabledMetrics");
            Intrinsics.checkNotNullParameter(terminationPolicies, (String)"terminationPolicies");
            this.cooldown = cooldown;
            this.warmup = warmup;
            this.healthCheckType = healthCheckType;
            this.enabledMetrics = enabledMetrics;
            this.terminationPolicies = terminationPolicies;
        }

        public /* synthetic */ Health(Duration duration, Duration duration2, HealthCheckType healthCheckType, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Duration duration3 = Duration.ofSeconds(10L);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"Duration.ofSeconds(10)");
                duration = duration3;
            }
            if ((n & 2) != 0) {
                Duration duration4 = Duration.ofSeconds(600L);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"Duration.ofSeconds(600)");
                duration2 = duration4;
            }
            if ((n & 4) != 0) {
                healthCheckType = HealthCheckType.EC2;
            }
            if ((n & 8) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                set2 = SetsKt.setOf((Object)((Object)TerminationPolicy.OldestInstance));
            }
            this(duration, duration2, healthCheckType, set, set2);
        }

        public Health() {
            this(null, null, null, null, null, 31, null);
        }

        @NotNull
        public final Duration component1() {
            return this.cooldown;
        }

        @NotNull
        public final Duration component2() {
            return this.warmup;
        }

        @NotNull
        public final HealthCheckType component3() {
            return this.healthCheckType;
        }

        @NotNull
        public final Set<Metric> component4() {
            return this.enabledMetrics;
        }

        @NotNull
        public final Set<TerminationPolicy> component5() {
            return this.terminationPolicies;
        }

        @NotNull
        public final Health copy(@NotNull Duration cooldown, @NotNull Duration warmup, @NotNull HealthCheckType healthCheckType, @NotNull Set<? extends Metric> enabledMetrics, @NotNull Set<? extends TerminationPolicy> terminationPolicies) {
            Intrinsics.checkNotNullParameter((Object)cooldown, (String)"cooldown");
            Intrinsics.checkNotNullParameter((Object)warmup, (String)"warmup");
            Intrinsics.checkNotNullParameter((Object)((Object)healthCheckType), (String)"healthCheckType");
            Intrinsics.checkNotNullParameter(enabledMetrics, (String)"enabledMetrics");
            Intrinsics.checkNotNullParameter(terminationPolicies, (String)"terminationPolicies");
            return new Health(cooldown, warmup, healthCheckType, enabledMetrics, terminationPolicies);
        }

        public static /* synthetic */ Health copy$default(Health health, Duration duration, Duration duration2, HealthCheckType healthCheckType, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                duration = health.cooldown;
            }
            if ((n & 2) != 0) {
                duration2 = health.warmup;
            }
            if ((n & 4) != 0) {
                healthCheckType = health.healthCheckType;
            }
            if ((n & 8) != 0) {
                set = health.enabledMetrics;
            }
            if ((n & 0x10) != 0) {
                set2 = health.terminationPolicies;
            }
            return health.copy(duration, duration2, healthCheckType, set, set2);
        }

        @NotNull
        public String toString() {
            return "Health(cooldown=" + this.cooldown + ", warmup=" + this.warmup + ", healthCheckType=" + (Object)((Object)this.healthCheckType) + ", enabledMetrics=" + this.enabledMetrics + ", terminationPolicies=" + this.terminationPolicies + ")";
        }

        public int hashCode() {
            Duration duration = this.cooldown;
            Duration duration2 = this.warmup;
            HealthCheckType healthCheckType = this.healthCheckType;
            Set<Metric> set = this.enabledMetrics;
            Set<TerminationPolicy> set2 = this.terminationPolicies;
            return ((((duration != null ? ((Object)duration).hashCode() : 0) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + (healthCheckType != null ? ((Object)((Object)healthCheckType)).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Health)) break block3;
                    Health health = (Health)object;
                    if (!Intrinsics.areEqual((Object)this.cooldown, (Object)health.cooldown) || !Intrinsics.areEqual((Object)this.warmup, (Object)health.warmup) || !Intrinsics.areEqual((Object)((Object)this.healthCheckType), (Object)((Object)health.healthCheckType)) || !Intrinsics.areEqual(this.enabledMetrics, health.enabledMetrics) || !Intrinsics.areEqual(this.terminationPolicies, health.terminationPolicies)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$InstanceCounts;", "", "total", "", "up", "down", "unknown", "outOfService", "starting", "(IIIIII)V", "getDown", "()I", "getOutOfService", "getStarting", "getTotal", "getUnknown", "getUp", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "isHealthy", "health", "Lcom/netflix/spinnaker/keel/api/DeployHealth;", "capacity", "Lcom/netflix/spinnaker/keel/api/ec2/Capacity;", "toString", "", "keel-ec2-api"})
    public static final class InstanceCounts {
        private final int total;
        private final int up;
        private final int down;
        private final int unknown;
        private final int outOfService;
        private final int starting;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isHealthy(@NotNull DeployHealth health, @NotNull Capacity capacity) {
            Intrinsics.checkNotNullParameter((Object)health, (String)"health");
            Intrinsics.checkNotNullParameter((Object)capacity, (String)"capacity");
            if (capacity.getMin() > this.total) return false;
            if (this.total > capacity.getMax()) return false;
            switch (ServerGroup$InstanceCounts$WhenMappings.$EnumSwitchMapping$0[health.ordinal()]) {
                case 1: {
                    if (this.up != this.total) return false;
                    return true;
                }
                case 2: {
                    if (this.up + this.unknown != this.total) return false;
                    return true;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        public final int getTotal() {
            return this.total;
        }

        public final int getUp() {
            return this.up;
        }

        public final int getDown() {
            return this.down;
        }

        public final int getUnknown() {
            return this.unknown;
        }

        public final int getOutOfService() {
            return this.outOfService;
        }

        public final int getStarting() {
            return this.starting;
        }

        public InstanceCounts(int total, int up, int down, int unknown, int outOfService, int starting) {
            this.total = total;
            this.up = up;
            this.down = down;
            this.unknown = unknown;
            this.outOfService = outOfService;
            this.starting = starting;
        }

        public final int component1() {
            return this.total;
        }

        public final int component2() {
            return this.up;
        }

        public final int component3() {
            return this.down;
        }

        public final int component4() {
            return this.unknown;
        }

        public final int component5() {
            return this.outOfService;
        }

        public final int component6() {
            return this.starting;
        }

        @NotNull
        public final InstanceCounts copy(int total, int up, int down, int unknown, int outOfService, int starting) {
            return new InstanceCounts(total, up, down, unknown, outOfService, starting);
        }

        public static /* synthetic */ InstanceCounts copy$default(InstanceCounts instanceCounts, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = instanceCounts.total;
            }
            if ((n7 & 2) != 0) {
                n2 = instanceCounts.up;
            }
            if ((n7 & 4) != 0) {
                n3 = instanceCounts.down;
            }
            if ((n7 & 8) != 0) {
                n4 = instanceCounts.unknown;
            }
            if ((n7 & 0x10) != 0) {
                n5 = instanceCounts.outOfService;
            }
            if ((n7 & 0x20) != 0) {
                n6 = instanceCounts.starting;
            }
            return instanceCounts.copy(n, n2, n3, n4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "InstanceCounts(total=" + this.total + ", up=" + this.up + ", down=" + this.down + ", unknown=" + this.unknown + ", outOfService=" + this.outOfService + ", starting=" + this.starting + ")";
        }

        public int hashCode() {
            return ((((Integer.hashCode(this.total) * 31 + Integer.hashCode(this.up)) * 31 + Integer.hashCode(this.down)) * 31 + Integer.hashCode(this.unknown)) * 31 + Integer.hashCode(this.outOfService)) * 31 + Integer.hashCode(this.starting);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InstanceCounts)) break block3;
                    InstanceCounts instanceCounts = (InstanceCounts)object;
                    if (this.total != instanceCounts.total || this.up != instanceCounts.up || this.down != instanceCounts.down || this.unknown != instanceCounts.unknown || this.outOfService != instanceCounts.outOfService || this.starting != instanceCounts.starting) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Ji\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$LaunchConfiguration;", "", "imageId", "", "appVersion", "baseImageName", "instanceType", "ebsOptimized", "", "iamRole", "keyPair", "instanceMonitoring", "ramdiskId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "getAppVersion", "()Ljava/lang/String;", "getBaseImageName", "getEbsOptimized", "()Z", "getIamRole", "getImageId", "getInstanceMonitoring", "getInstanceType", "getKeyPair", "getRamdiskId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "keel-ec2-api"})
    public static final class LaunchConfiguration {
        @NotNull
        private final String imageId;
        @Nullable
        private final String appVersion;
        @Nullable
        private final String baseImageName;
        @NotNull
        private final String instanceType;
        private final boolean ebsOptimized;
        @NotNull
        private final String iamRole;
        @NotNull
        private final String keyPair;
        private final boolean instanceMonitoring;
        @Nullable
        private final String ramdiskId;
        public static final boolean DEFAULT_EBS_OPTIMIZED = false;
        public static final boolean DEFAULT_INSTANCE_MONITORING = false;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getImageId() {
            return this.imageId;
        }

        @Nullable
        public final String getAppVersion() {
            return this.appVersion;
        }

        @Nullable
        public final String getBaseImageName() {
            return this.baseImageName;
        }

        @NotNull
        public final String getInstanceType() {
            return this.instanceType;
        }

        public final boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @NotNull
        public final String getIamRole() {
            return this.iamRole;
        }

        @NotNull
        public final String getKeyPair() {
            return this.keyPair;
        }

        public final boolean getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Nullable
        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public LaunchConfiguration(@NotNull String imageId, @Nullable String appVersion, @Nullable String baseImageName, @NotNull String instanceType, boolean ebsOptimized, @NotNull String iamRole, @NotNull String keyPair, boolean instanceMonitoring, @Nullable String ramdiskId) {
            Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
            Intrinsics.checkNotNullParameter((Object)instanceType, (String)"instanceType");
            Intrinsics.checkNotNullParameter((Object)iamRole, (String)"iamRole");
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            this.imageId = imageId;
            this.appVersion = appVersion;
            this.baseImageName = baseImageName;
            this.instanceType = instanceType;
            this.ebsOptimized = ebsOptimized;
            this.iamRole = iamRole;
            this.keyPair = keyPair;
            this.instanceMonitoring = instanceMonitoring;
            this.ramdiskId = ramdiskId;
        }

        public /* synthetic */ LaunchConfiguration(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, boolean bl2, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x80) != 0) {
                bl2 = false;
            }
            if ((n & 0x100) != 0) {
                string7 = null;
            }
            this(string, string2, string3, string4, bl, string5, string6, bl2, string7);
        }

        @NotNull
        public final String component1() {
            return this.imageId;
        }

        @Nullable
        public final String component2() {
            return this.appVersion;
        }

        @Nullable
        public final String component3() {
            return this.baseImageName;
        }

        @NotNull
        public final String component4() {
            return this.instanceType;
        }

        public final boolean component5() {
            return this.ebsOptimized;
        }

        @NotNull
        public final String component6() {
            return this.iamRole;
        }

        @NotNull
        public final String component7() {
            return this.keyPair;
        }

        public final boolean component8() {
            return this.instanceMonitoring;
        }

        @Nullable
        public final String component9() {
            return this.ramdiskId;
        }

        @NotNull
        public final LaunchConfiguration copy(@NotNull String imageId, @Nullable String appVersion, @Nullable String baseImageName, @NotNull String instanceType, boolean ebsOptimized, @NotNull String iamRole, @NotNull String keyPair, boolean instanceMonitoring, @Nullable String ramdiskId) {
            Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
            Intrinsics.checkNotNullParameter((Object)instanceType, (String)"instanceType");
            Intrinsics.checkNotNullParameter((Object)iamRole, (String)"iamRole");
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            return new LaunchConfiguration(imageId, appVersion, baseImageName, instanceType, ebsOptimized, iamRole, keyPair, instanceMonitoring, ramdiskId);
        }

        public static /* synthetic */ LaunchConfiguration copy$default(LaunchConfiguration launchConfiguration, String string, String string2, String string3, String string4, boolean bl, String string5, String string6, boolean bl2, String string7, int n, Object object) {
            if ((n & 1) != 0) {
                string = launchConfiguration.imageId;
            }
            if ((n & 2) != 0) {
                string2 = launchConfiguration.appVersion;
            }
            if ((n & 4) != 0) {
                string3 = launchConfiguration.baseImageName;
            }
            if ((n & 8) != 0) {
                string4 = launchConfiguration.instanceType;
            }
            if ((n & 0x10) != 0) {
                bl = launchConfiguration.ebsOptimized;
            }
            if ((n & 0x20) != 0) {
                string5 = launchConfiguration.iamRole;
            }
            if ((n & 0x40) != 0) {
                string6 = launchConfiguration.keyPair;
            }
            if ((n & 0x80) != 0) {
                bl2 = launchConfiguration.instanceMonitoring;
            }
            if ((n & 0x100) != 0) {
                string7 = launchConfiguration.ramdiskId;
            }
            return launchConfiguration.copy(string, string2, string3, string4, bl, string5, string6, bl2, string7);
        }

        @NotNull
        public String toString() {
            return "LaunchConfiguration(imageId=" + this.imageId + ", appVersion=" + this.appVersion + ", baseImageName=" + this.baseImageName + ", instanceType=" + this.instanceType + ", ebsOptimized=" + this.ebsOptimized + ", iamRole=" + this.iamRole + ", keyPair=" + this.keyPair + ", instanceMonitoring=" + this.instanceMonitoring + ", ramdiskId=" + this.ramdiskId + ")";
        }

        public int hashCode() {
            String string = this.imageId;
            String string2 = this.appVersion;
            String string3 = this.baseImageName;
            String string4 = this.instanceType;
            int n = ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31;
            int n2 = this.ebsOptimized ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string5 = this.iamRole;
            String string6 = this.keyPair;
            int n3 = (((n + n2) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31;
            int n4 = this.instanceMonitoring ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            String string7 = this.ramdiskId;
            return (n3 + n4) * 31 + (string7 != null ? string7.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LaunchConfiguration)) break block3;
                    LaunchConfiguration launchConfiguration = (LaunchConfiguration)object;
                    if (!Intrinsics.areEqual((Object)this.imageId, (Object)launchConfiguration.imageId) || !Intrinsics.areEqual((Object)this.appVersion, (Object)launchConfiguration.appVersion) || !Intrinsics.areEqual((Object)this.baseImageName, (Object)launchConfiguration.baseImageName) || !Intrinsics.areEqual((Object)this.instanceType, (Object)launchConfiguration.instanceType) || this.ebsOptimized != launchConfiguration.ebsOptimized || !Intrinsics.areEqual((Object)this.iamRole, (Object)launchConfiguration.iamRole) || !Intrinsics.areEqual((Object)this.keyPair, (Object)launchConfiguration.keyPair) || this.instanceMonitoring != launchConfiguration.instanceMonitoring || !Intrinsics.areEqual((Object)this.ramdiskId, (Object)launchConfiguration.ramdiskId)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$LaunchConfiguration$Companion;", "", "()V", "DEFAULT_EBS_OPTIMIZED", "", "DEFAULT_INSTANCE_MONITORING", "defaultIamRoleFor", "", "application", "keel-ec2-api"})
        public static final class Companion {
            @NotNull
            public final String defaultIamRoleFor(@NotNull String application) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                return application + "InstanceProfile";
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

