/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.api.ec2;

import com.netflix.spinnaker.keel.api.Locations;
import com.netflix.spinnaker.keel.api.SubnetAwareRegionSpec;
import com.netflix.spinnaker.keel.api.ec2.Capacity;
import com.netflix.spinnaker.keel.api.ec2.ClusterDependencies;
import com.netflix.spinnaker.keel.api.ec2.ClusterSpec;
import com.netflix.spinnaker.keel.api.ec2.ClusterSpecKt;
import com.netflix.spinnaker.keel.api.ec2.HealthCheckType;
import com.netflix.spinnaker.keel.api.ec2.LaunchConfigurationSpec;
import com.netflix.spinnaker.keel.api.ec2.Location;
import com.netflix.spinnaker.keel.api.ec2.Metric;
import com.netflix.spinnaker.keel.api.ec2.Scaling;
import com.netflix.spinnaker.keel.api.ec2.ServerGroup;
import com.netflix.spinnaker.keel.api.ec2.TerminationPolicy;
import com.netflix.spinnaker.keel.api.ec2.VirtualMachineImage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u001aI\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b*\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0018\u00010\u00062\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0006H\u0082\u0002\u001a1\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b*\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\nH\u0082\u0002\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n*\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u001a"}, d2={"get", "Lcom/netflix/spinnaker/keel/api/SubnetAwareRegionSpec;", "Lcom/netflix/spinnaker/keel/api/Locations;", "region", "", "plus", "", "K", "V", "map", "", "E", "elements", "resolve", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup;", "Lcom/netflix/spinnaker/keel/api/ec2/ClusterSpec;", "resolveCapacity", "Lcom/netflix/spinnaker/keel/api/ec2/Capacity;", "resolveDependencies", "Lcom/netflix/spinnaker/keel/api/ec2/ClusterDependencies;", "resolveHealth", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$Health;", "resolveLaunchConfiguration", "Lcom/netflix/spinnaker/keel/api/ec2/ServerGroup$LaunchConfiguration;", "resolveScaling", "Lcom/netflix/spinnaker/keel/api/ec2/Scaling;", "keel-ec2-api"})
public final class ClusterSpecKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ServerGroup> resolve(@NotNull ClusterSpec $this$resolve) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolve, (String)"$this$resolve");
        Iterable $this$map$iv = $this$resolve.getLocations().getRegions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SubnetAwareRegionSpec subnetAwareRegionSpec = (SubnetAwareRegionSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = $this$resolve.getLocations().getVpc();
            if (string == null) {
                String string2 = "No vpc supplied or resolved";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String string3 = $this$resolve.getLocations().getSubnet();
            if (string3 == null) {
                String string4 = "No subnet purpose supplied or resolved";
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            ClusterSpec.ServerGroupSpec serverGroupSpec = $this$resolve.getOverrides().get(it.getName());
            ServerGroup serverGroup = new ServerGroup($this$resolve.getMoniker().toString(), new Location($this$resolve.getLocations().getAccount(), it.getName(), string, string3, it.getAvailabilityZones()), ClusterSpecKt.resolveLaunchConfiguration($this$resolve, (SubnetAwareRegionSpec)it), ClusterSpecKt.resolveCapacity($this$resolve, it.getName()), ClusterSpecKt.resolveDependencies($this$resolve, it.getName()), ClusterSpecKt.resolveHealth($this$resolve, it.getName()), ClusterSpecKt.resolveScaling($this$resolve, it.getName()), ClusterSpecKt.plus($this$resolve.getDefaults().getTags(), serverGroupSpec != null ? serverGroupSpec.getTags() : null), false, null, null, $this$resolve.getArtifactName(), null, $this$resolve.getArtifactVersion(), null, 22272, null);
            collection.add(serverGroup);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final ServerGroup.LaunchConfiguration resolveLaunchConfiguration(ClusterSpec $this$resolveLaunchConfiguration, SubnetAwareRegionSpec region) {
        Object object;
        Object object2 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object2 == null || (object2 = ((ClusterSpec.ServerGroupSpec)object2).getLaunchConfiguration()) == null || (object2 = ((LaunchConfigurationSpec)object2).getImage()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object2 = launchConfigurationSpec != null ? launchConfigurationSpec.getImage() : null;
        }
        Object object3 = object2;
        boolean bl = false;
        boolean bl2 = false;
        if (object3 == null) {
            boolean bl3 = false;
            String string = "No image resolved / specified for " + region.getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object image = object3;
        String string = ((VirtualMachineImage)image).getAppVersion();
        String string2 = ((VirtualMachineImage)image).getBaseImageName();
        String string3 = ((VirtualMachineImage)image).getId();
        Object object4 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object4 == null || (object4 = ((ClusterSpec.ServerGroupSpec)object4).getLaunchConfiguration()) == null || (object4 = ((LaunchConfigurationSpec)object4).getInstanceType()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object4 = launchConfigurationSpec != null ? launchConfigurationSpec.getInstanceType() : null;
        }
        object3 = object4;
        bl = false;
        bl2 = false;
        if (object3 == null) {
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            boolean bl42 = false;
            String string7 = "No instance type resolved for " + $this$resolveLaunchConfiguration.getId() + " (region " + region.getName() + ") and cannot determine a default";
            String string8 = string6;
            String string9 = string5;
            String string10 = string4;
            String string11 = string7;
            throw (Throwable)new IllegalStateException(string11.toString());
        }
        Object object5 = object3;
        Object object6 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object6 == null || (object6 = ((ClusterSpec.ServerGroupSpec)object6).getLaunchConfiguration()) == null || (object6 = ((LaunchConfigurationSpec)object6).getEbsOptimized()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object6 = launchConfigurationSpec != null ? launchConfigurationSpec.getEbsOptimized() : null;
        }
        boolean bl5 = object6 != null ? (Boolean)object6 : false;
        bl = false;
        bl2 = false;
        bl2 = false;
        boolean bl42 = false;
        boolean bl6 = bl5;
        Object object7 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object7 == null || (object7 = ((ClusterSpec.ServerGroupSpec)object7).getLaunchConfiguration()) == null || (object7 = ((LaunchConfigurationSpec)object7).getIamRole()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object7 = object = launchConfigurationSpec != null ? launchConfigurationSpec.getIamRole() : null;
        }
        if (object7 == null) {
            object = ServerGroup.LaunchConfiguration.Companion.defaultIamRoleFor($this$resolveLaunchConfiguration.getMoniker().getApp());
        }
        Object object8 = object;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl42 = false;
        if (object8 == null) {
            boolean bl7 = false;
            String bl42 = "Required value was null.";
            throw (Throwable)new IllegalStateException(bl42.toString());
        }
        Object object9 = object8;
        Object object10 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object10 == null || (object10 = ((ClusterSpec.ServerGroupSpec)object10).getLaunchConfiguration()) == null || (object10 = ((LaunchConfigurationSpec)object10).getKeyPair()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object10 = launchConfigurationSpec != null ? launchConfigurationSpec.getKeyPair() : null;
        }
        object8 = object10;
        bl = false;
        bl2 = false;
        if (object8 == null) {
            Object object11 = object9;
            boolean bl8 = bl6;
            Object object12 = object5;
            String string12 = string3;
            String string13 = string2;
            String string14 = string;
            boolean bl9 = false;
            String string15 = "No keypair resolved for " + $this$resolveLaunchConfiguration.getId() + " (region " + region.getName() + ") and cannot determine a default";
            String string16 = string14;
            String string17 = string13;
            String string18 = string12;
            Object object13 = object12;
            boolean bl10 = bl8;
            Object object14 = object11;
            String string19 = string15;
            throw (Throwable)new IllegalStateException(string19.toString());
        }
        Object object15 = object8;
        Object object16 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object16 == null || (object16 = ((ClusterSpec.ServerGroupSpec)object16).getLaunchConfiguration()) == null || (object16 = ((LaunchConfigurationSpec)object16).getInstanceMonitoring()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object16 = launchConfigurationSpec != null ? launchConfigurationSpec.getInstanceMonitoring() : null;
        }
        boolean bl11 = object16 != null ? (Boolean)object16 : false;
        Object object17 = $this$resolveLaunchConfiguration.getOverrides().get(region.getName());
        if (object17 == null || (object17 = ((ClusterSpec.ServerGroupSpec)object17).getLaunchConfiguration()) == null || (object17 = ((LaunchConfigurationSpec)object17).getRamdiskId()) == null) {
            LaunchConfigurationSpec launchConfigurationSpec = $this$resolveLaunchConfiguration.getDefaults().getLaunchConfiguration();
            object17 = launchConfigurationSpec != null ? launchConfigurationSpec.getRamdiskId() : null;
        }
        object8 = object17;
        bl = bl11;
        Object object18 = object15;
        Object object19 = object9;
        boolean bl12 = bl6;
        Object object20 = object5;
        String string20 = string3;
        String string21 = string2;
        String string22 = string;
        Object object21 = object8;
        boolean bl13 = bl;
        Object object22 = object18;
        Object object23 = object19;
        boolean bl14 = bl12;
        Object object24 = object20;
        String string23 = string21;
        String string24 = string22;
        String string25 = string20;
        return new ServerGroup.LaunchConfiguration(string25, string24, string23, (String)object24, bl14, (String)object23, (String)object22, bl13, (String)object21);
    }

    @NotNull
    public static final Capacity resolveCapacity(@NotNull ClusterSpec $this$resolveCapacity, @NotNull String region) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$resolveCapacity, (String)"$this$resolveCapacity");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Object object2 = $this$resolveCapacity.getOverrides().get(region);
        if (object2 == null || (object2 = ((ClusterSpec.ServerGroupSpec)object2).getCapacity()) == null) {
            object2 = object = $this$resolveCapacity.getDefaults().getCapacity();
        }
        if (object2 == null) {
            object = new Capacity(1, 1, 1);
        }
        return object;
    }

    private static final Scaling resolveScaling(ClusterSpec $this$resolveScaling, String region) {
        Object object;
        Object object2;
        Object object3;
        Scaling scaling = $this$resolveScaling.getDefaults().getScaling();
        Scaling scaling2 = $this$resolveScaling.getDefaults().getScaling();
        Scaling scaling3 = $this$resolveScaling.getDefaults().getScaling();
        return new Scaling(ClusterSpecKt.plus(scaling != null ? scaling.getSuspendedProcesses() : null, (object3 = $this$resolveScaling.getOverrides().get(region)) != null && (object3 = ((ClusterSpec.ServerGroupSpec)object3).getScaling()) != null ? ((Scaling)object3).getSuspendedProcesses() : null), ClusterSpecKt.plus(scaling2 != null ? scaling2.getTargetTrackingPolicies() : null, (object2 = $this$resolveScaling.getOverrides().get(region)) != null && (object2 = ((ClusterSpec.ServerGroupSpec)object2).getScaling()) != null ? ((Scaling)object2).getTargetTrackingPolicies() : null), ClusterSpecKt.plus(scaling3 != null ? scaling3.getStepScalingPolicies() : null, (object = $this$resolveScaling.getOverrides().get(region)) != null && (object = ((ClusterSpec.ServerGroupSpec)object).getScaling()) != null ? ((Scaling)object).getStepScalingPolicies() : null));
    }

    private static final ClusterDependencies resolveDependencies(ClusterSpec $this$resolveDependencies, String region) {
        Object object;
        Object object2;
        Object object3;
        ClusterDependencies clusterDependencies = $this$resolveDependencies.getDefaults().getDependencies();
        ClusterDependencies clusterDependencies2 = $this$resolveDependencies.getDefaults().getDependencies();
        ClusterDependencies clusterDependencies3 = $this$resolveDependencies.getDefaults().getDependencies();
        return new ClusterDependencies(ClusterSpecKt.plus(clusterDependencies != null ? clusterDependencies.getLoadBalancerNames() : null, (object3 = $this$resolveDependencies.getOverrides().get(region)) != null && (object3 = ((ClusterSpec.ServerGroupSpec)object3).getDependencies()) != null ? ((ClusterDependencies)object3).getLoadBalancerNames() : null), ClusterSpecKt.plus(clusterDependencies2 != null ? clusterDependencies2.getSecurityGroupNames() : null, (object2 = $this$resolveDependencies.getOverrides().get(region)) != null && (object2 = ((ClusterSpec.ServerGroupSpec)object2).getDependencies()) != null ? ((ClusterDependencies)object2).getSecurityGroupNames() : null), ClusterSpecKt.plus(clusterDependencies3 != null ? clusterDependencies3.getTargetGroups() : null, (object = $this$resolveDependencies.getOverrides().get(region)) != null && (object = ((ClusterSpec.ServerGroupSpec)object).getDependencies()) != null ? ((ClusterDependencies)object).getTargetGroups() : null));
    }

    private static final ServerGroup.Health resolveHealth(ClusterSpec $this$resolveHealth, String region) {
        Set<TerminationPolicy> set;
        Set<TerminationPolicy> set2;
        Set<Metric> set3;
        Set<Metric> set4;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        Object var5_5;
        Lazy lazy;
        Object object5;
        Object var3_2 = null;
        Lazy lazy2 = LazyKt.lazy((Function0)resolveHealth.default.2.INSTANCE);
        Object object6 = $this$resolveHealth.getOverrides().get(region);
        if (object6 == null || (object6 = ((ClusterSpec.ServerGroupSpec)object6).getHealth()) == null || (object6 = ((ClusterSpec.HealthSpec)object6).getCooldown()) == null) {
            ClusterSpec.HealthSpec healthSpec = $this$resolveHealth.getDefaults().getHealth();
            object6 = object5 = healthSpec != null ? healthSpec.getCooldown() : null;
        }
        if (object6 == null) {
            lazy = lazy2;
            var5_5 = null;
            bl = false;
            object5 = ((ServerGroup.Health)lazy.getValue()).getCooldown();
        }
        if ((object4 = $this$resolveHealth.getOverrides().get(region)) == null || (object4 = ((ClusterSpec.ServerGroupSpec)object4).getHealth()) == null || (object4 = ((ClusterSpec.HealthSpec)object4).getWarmup()) == null) {
            ClusterSpec.HealthSpec healthSpec = $this$resolveHealth.getDefaults().getHealth();
            object4 = object3 = healthSpec != null ? healthSpec.getWarmup() : null;
        }
        if (object4 == null) {
            lazy = lazy2;
            var5_5 = null;
            bl = false;
            object3 = ((ServerGroup.Health)lazy.getValue()).getWarmup();
        }
        if ((object2 = $this$resolveHealth.getOverrides().get(region)) == null || (object2 = ((ClusterSpec.ServerGroupSpec)object2).getHealth()) == null || (object2 = ((ClusterSpec.HealthSpec)object2).getHealthCheckType()) == null) {
            ClusterSpec.HealthSpec healthSpec = $this$resolveHealth.getDefaults().getHealth();
            object2 = object = healthSpec != null ? healthSpec.getHealthCheckType() : null;
        }
        if (object2 == null) {
            lazy = lazy2;
            var5_5 = null;
            bl = false;
            object = ((ServerGroup.Health)lazy.getValue()).getHealthCheckType();
        }
        if ((set4 = $this$resolveHealth.getOverrides().get(region)) == null || (set4 = ((ClusterSpec.ServerGroupSpec)((Object)set4)).getHealth()) == null || (set4 = ((ClusterSpec.HealthSpec)((Object)set4)).getEnabledMetrics()) == null) {
            ClusterSpec.HealthSpec healthSpec = $this$resolveHealth.getDefaults().getHealth();
            set4 = set3 = healthSpec != null ? healthSpec.getEnabledMetrics() : null;
        }
        if (set4 == null) {
            lazy = lazy2;
            var5_5 = null;
            bl = false;
            set3 = ((ServerGroup.Health)lazy.getValue()).getEnabledMetrics();
        }
        if ((set2 = $this$resolveHealth.getOverrides().get(region)) == null || (set2 = ((ClusterSpec.ServerGroupSpec)((Object)set2)).getHealth()) == null || (set2 = ((ClusterSpec.HealthSpec)((Object)set2)).getTerminationPolicies()) == null) {
            ClusterSpec.HealthSpec healthSpec = $this$resolveHealth.getDefaults().getHealth();
            set2 = set = healthSpec != null ? healthSpec.getTerminationPolicies() : null;
        }
        if (set2 == null) {
            lazy = lazy2;
            var5_5 = null;
            bl = false;
            set = ((ServerGroup.Health)lazy.getValue()).getTerminationPolicies();
        }
        return new ServerGroup.Health((Duration)object5, (Duration)object3, (HealthCheckType)((Object)object), set3, set);
    }

    @NotNull
    public static final SubnetAwareRegionSpec get(@NotNull Locations<SubnetAwareRegionSpec> $this$get, @NotNull String region) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter($this$get, (String)"$this$get");
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Iterable $this$first$iv = $this$get.getRegions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                SubnetAwareRegionSpec it = (SubnetAwareRegionSpec)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)region)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (SubnetAwareRegionSpec)element$iv2;
    }

    private static final <E> Set<E> plus(Set<? extends E> $this$plus, Set<? extends E> elements) {
        Set set;
        if ($this$plus == null || $this$plus.isEmpty()) {
            set = elements;
            if (set == null) {
                set = SetsKt.emptySet();
            }
        } else if (elements == null || elements.isEmpty()) {
            set = $this$plus;
        } else {
            boolean bl = false;
            Set set2 = new LinkedHashSet();
            boolean bl2 = false;
            boolean bl3 = false;
            Set it = set2;
            boolean bl4 = false;
            it.addAll($this$plus);
            it.addAll(elements);
            set = set2;
        }
        return set;
    }

    private static final <K, V> Map<K, V> plus(Map<K, ? extends V> $this$plus, Map<K, ? extends V> map) {
        Map map2;
        if ($this$plus == null || $this$plus.isEmpty()) {
            map2 = map;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
        } else if (map == null || map.isEmpty()) {
            map2 = $this$plus;
        } else {
            boolean bl = false;
            Map map3 = new LinkedHashMap();
            boolean bl2 = false;
            boolean bl3 = false;
            Map it = map3;
            boolean bl4 = false;
            it.putAll($this$plus);
            it.putAll(map);
            map2 = map3;
        }
        return map2;
    }
}

