/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.api.ec2;

import com.netflix.spinnaker.keel.api.Moniker;
import com.netflix.spinnaker.keel.api.SubnetAwareLocations;
import com.netflix.spinnaker.keel.api.UnhappyControl;
import com.netflix.spinnaker.keel.api.ec2.ClassicLoadBalancerHealthCheck;
import com.netflix.spinnaker.keel.api.ec2.ClassicLoadBalancerListener;
import com.netflix.spinnaker.keel.api.ec2.ClassicLoadBalancerOverride;
import com.netflix.spinnaker.keel.api.ec2.LoadBalancerDependencies;
import com.netflix.spinnaker.keel.api.ec2.LoadBalancerSpec;
import com.netflix.spinnaker.keel.api.ec2.LoadBalancerType;
import com.netflix.spinnaker.keel.api.schema.Optional;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002Bc\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\u0010\u0016J\t\u00105\u001a\u00020\u0004H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\t\u00108\u001a\u00020\nH\u00c6\u0003J\t\u00109\u001a\u00020\fH\u00c6\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003J\t\u0010;\u001a\u00020\u0011H\u00c6\u0003J\u0015\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u00c6\u0003Jk\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u00c6\u0001J\u0013\u0010>\u001a\u00020\b2\b\u0010?\u001a\u0004\u0018\u00010@H\u00d6\u0003J\t\u0010A\u001a\u00020+H\u00d6\u0001J\t\u0010B\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\u0004\u0018\u00010+X\u0096D\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0016\u00103\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001f\u00a8\u0006C"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ClassicLoadBalancerSpec;", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerSpec;", "Lcom/netflix/spinnaker/keel/api/UnhappyControl;", "moniker", "Lcom/netflix/spinnaker/keel/api/Moniker;", "locations", "Lcom/netflix/spinnaker/keel/api/SubnetAwareLocations;", "internal", "", "dependencies", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;", "idleTimeout", "Ljava/time/Duration;", "listeners", "", "Lcom/netflix/spinnaker/keel/api/ec2/ClassicLoadBalancerListener;", "healthCheck", "Lcom/netflix/spinnaker/keel/api/ec2/ClassicLoadBalancerHealthCheck;", "overrides", "", "", "Lcom/netflix/spinnaker/keel/api/ec2/ClassicLoadBalancerOverride;", "(Lcom/netflix/spinnaker/keel/api/Moniker;Lcom/netflix/spinnaker/keel/api/SubnetAwareLocations;ZLcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;Ljava/time/Duration;Ljava/util/Set;Lcom/netflix/spinnaker/keel/api/ec2/ClassicLoadBalancerHealthCheck;Ljava/util/Map;)V", "getDependencies", "()Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;", "getHealthCheck", "()Lcom/netflix/spinnaker/keel/api/ec2/ClassicLoadBalancerHealthCheck;", "id", "getId", "()Ljava/lang/String;", "getIdleTimeout", "()Ljava/time/Duration;", "getInternal", "()Z", "getListeners", "()Ljava/util/Set;", "loadBalancerType", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerType;", "getLoadBalancerType", "()Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerType;", "getLocations", "()Lcom/netflix/spinnaker/keel/api/SubnetAwareLocations;", "maxDiffCount", "", "getMaxDiffCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMoniker", "()Lcom/netflix/spinnaker/keel/api/Moniker;", "getOverrides", "()Ljava/util/Map;", "unhappyWaitTime", "getUnhappyWaitTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "toString", "keel-ec2-api"})
public final class ClassicLoadBalancerSpec
implements LoadBalancerSpec,
UnhappyControl {
    @Nullable
    private final Integer maxDiffCount;
    @Nullable
    private final Duration unhappyWaitTime;
    @NotNull
    private final LoadBalancerType loadBalancerType;
    @NotNull
    private final String id;
    @NotNull
    private final Moniker moniker;
    @NotNull
    private final SubnetAwareLocations locations;
    private final boolean internal;
    @NotNull
    private final LoadBalancerDependencies dependencies;
    @NotNull
    private final Duration idleTimeout;
    @NotNull
    private final Set<ClassicLoadBalancerListener> listeners;
    @NotNull
    private final ClassicLoadBalancerHealthCheck healthCheck;
    @NotNull
    private final Map<String, ClassicLoadBalancerOverride> overrides;

    @Nullable
    public Integer getMaxDiffCount() {
        return this.maxDiffCount;
    }

    @Nullable
    public Duration getUnhappyWaitTime() {
        return this.unhappyWaitTime;
    }

    @Override
    @NotNull
    public LoadBalancerType getLoadBalancerType() {
        return this.loadBalancerType;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Override
    @NotNull
    public SubnetAwareLocations getLocations() {
        return this.locations;
    }

    @Override
    public boolean getInternal() {
        return this.internal;
    }

    @Override
    @NotNull
    public LoadBalancerDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @NotNull
    public final Set<ClassicLoadBalancerListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final ClassicLoadBalancerHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @NotNull
    public final Map<String, ClassicLoadBalancerOverride> getOverrides() {
        return this.overrides;
    }

    public ClassicLoadBalancerSpec(@NotNull Moniker moniker, @Optional @NotNull SubnetAwareLocations locations, boolean internal, @NotNull LoadBalancerDependencies dependencies, @NotNull Duration idleTimeout, @NotNull Set<ClassicLoadBalancerListener> listeners, @NotNull ClassicLoadBalancerHealthCheck healthCheck, @NotNull Map<String, ClassicLoadBalancerOverride> overrides) {
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)"idleTimeout");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)healthCheck, (String)"healthCheck");
        Intrinsics.checkNotNullParameter(overrides, (String)"overrides");
        this.moniker = moniker;
        this.locations = locations;
        this.internal = internal;
        this.dependencies = dependencies;
        this.idleTimeout = idleTimeout;
        this.listeners = listeners;
        this.healthCheck = healthCheck;
        this.overrides = overrides;
        boolean bl = this.getMoniker().toString().length() <= 32;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "load balancer names have a 32 character limit";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxDiffCount = 2;
        this.loadBalancerType = LoadBalancerType.CLASSIC;
        this.id = this.getLocations().getAccount() + ':' + this.getMoniker();
    }

    public /* synthetic */ ClassicLoadBalancerSpec(Moniker moniker, SubnetAwareLocations subnetAwareLocations, boolean bl, LoadBalancerDependencies loadBalancerDependencies, Duration duration, Set set, ClassicLoadBalancerHealthCheck classicLoadBalancerHealthCheck, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            loadBalancerDependencies = new LoadBalancerDependencies(null, 1, null);
        }
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofSeconds(60)");
            duration = duration2;
        }
        if ((n & 0x20) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        this(moniker, subnetAwareLocations, bl, loadBalancerDependencies, duration, set, classicLoadBalancerHealthCheck, map);
    }

    @NotNull
    public String getApplication() {
        return LoadBalancerSpec.DefaultImpls.getApplication(this);
    }

    @NotNull
    public String getDisplayName() {
        return LoadBalancerSpec.DefaultImpls.getDisplayName(this);
    }

    @NotNull
    public final Moniker component1() {
        return this.getMoniker();
    }

    @NotNull
    public final SubnetAwareLocations component2() {
        return this.getLocations();
    }

    public final boolean component3() {
        return this.getInternal();
    }

    @NotNull
    public final LoadBalancerDependencies component4() {
        return this.getDependencies();
    }

    @NotNull
    public final Duration component5() {
        return this.getIdleTimeout();
    }

    @NotNull
    public final Set<ClassicLoadBalancerListener> component6() {
        return this.listeners;
    }

    @NotNull
    public final ClassicLoadBalancerHealthCheck component7() {
        return this.healthCheck;
    }

    @NotNull
    public final Map<String, ClassicLoadBalancerOverride> component8() {
        return this.overrides;
    }

    @NotNull
    public final ClassicLoadBalancerSpec copy(@NotNull Moniker moniker, @Optional @NotNull SubnetAwareLocations locations, boolean internal, @NotNull LoadBalancerDependencies dependencies, @NotNull Duration idleTimeout, @NotNull Set<ClassicLoadBalancerListener> listeners, @NotNull ClassicLoadBalancerHealthCheck healthCheck, @NotNull Map<String, ClassicLoadBalancerOverride> overrides) {
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)"idleTimeout");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)healthCheck, (String)"healthCheck");
        Intrinsics.checkNotNullParameter(overrides, (String)"overrides");
        return new ClassicLoadBalancerSpec(moniker, locations, internal, dependencies, idleTimeout, listeners, healthCheck, overrides);
    }

    public static /* synthetic */ ClassicLoadBalancerSpec copy$default(ClassicLoadBalancerSpec classicLoadBalancerSpec, Moniker moniker, SubnetAwareLocations subnetAwareLocations, boolean bl, LoadBalancerDependencies loadBalancerDependencies, Duration duration, Set set, ClassicLoadBalancerHealthCheck classicLoadBalancerHealthCheck, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            moniker = classicLoadBalancerSpec.getMoniker();
        }
        if ((n & 2) != 0) {
            subnetAwareLocations = classicLoadBalancerSpec.getLocations();
        }
        if ((n & 4) != 0) {
            bl = classicLoadBalancerSpec.getInternal();
        }
        if ((n & 8) != 0) {
            loadBalancerDependencies = classicLoadBalancerSpec.getDependencies();
        }
        if ((n & 0x10) != 0) {
            duration = classicLoadBalancerSpec.getIdleTimeout();
        }
        if ((n & 0x20) != 0) {
            set = classicLoadBalancerSpec.listeners;
        }
        if ((n & 0x40) != 0) {
            classicLoadBalancerHealthCheck = classicLoadBalancerSpec.healthCheck;
        }
        if ((n & 0x80) != 0) {
            map = classicLoadBalancerSpec.overrides;
        }
        return classicLoadBalancerSpec.copy(moniker, subnetAwareLocations, bl, loadBalancerDependencies, duration, set, classicLoadBalancerHealthCheck, map);
    }

    @NotNull
    public String toString() {
        return "ClassicLoadBalancerSpec(moniker=" + this.getMoniker() + ", locations=" + this.getLocations() + ", internal=" + this.getInternal() + ", dependencies=" + this.getDependencies() + ", idleTimeout=" + this.getIdleTimeout() + ", listeners=" + this.listeners + ", healthCheck=" + this.healthCheck + ", overrides=" + this.overrides + ")";
    }

    public int hashCode() {
        Moniker moniker = this.getMoniker();
        SubnetAwareLocations subnetAwareLocations = this.getLocations();
        int n = ((moniker != null ? moniker.hashCode() : 0) * 31 + (subnetAwareLocations != null ? subnetAwareLocations.hashCode() : 0)) * 31;
        int n2 = this.getInternal() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        LoadBalancerDependencies loadBalancerDependencies = this.getDependencies();
        Duration duration = this.getIdleTimeout();
        Set<ClassicLoadBalancerListener> set = this.listeners;
        ClassicLoadBalancerHealthCheck classicLoadBalancerHealthCheck = this.healthCheck;
        Map<String, ClassicLoadBalancerOverride> map = this.overrides;
        return (((((n + n2) * 31 + (loadBalancerDependencies != null ? ((Object)loadBalancerDependencies).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (classicLoadBalancerHealthCheck != null ? ((Object)classicLoadBalancerHealthCheck).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ClassicLoadBalancerSpec)) break block3;
                ClassicLoadBalancerSpec classicLoadBalancerSpec = (ClassicLoadBalancerSpec)object;
                if (!Intrinsics.areEqual((Object)this.getMoniker(), (Object)classicLoadBalancerSpec.getMoniker()) || !Intrinsics.areEqual((Object)this.getLocations(), (Object)classicLoadBalancerSpec.getLocations()) || this.getInternal() != classicLoadBalancerSpec.getInternal() || !Intrinsics.areEqual((Object)this.getDependencies(), (Object)classicLoadBalancerSpec.getDependencies()) || !Intrinsics.areEqual((Object)this.getIdleTimeout(), (Object)classicLoadBalancerSpec.getIdleTimeout()) || !Intrinsics.areEqual(this.listeners, classicLoadBalancerSpec.listeners) || !Intrinsics.areEqual((Object)this.healthCheck, (Object)classicLoadBalancerSpec.healthCheck) || !Intrinsics.areEqual(this.overrides, classicLoadBalancerSpec.overrides)) break block3;
            }
            return true;
        }
        return false;
    }
}

