/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.api.ec2;

import com.netflix.spinnaker.keel.api.Moniker;
import com.netflix.spinnaker.keel.api.SubnetAwareLocations;
import com.netflix.spinnaker.keel.api.UnhappyControl;
import com.netflix.spinnaker.keel.api.ec2.LoadBalancerDependencies;
import com.netflix.spinnaker.keel.api.ec2.LoadBalancerSpec;
import com.netflix.spinnaker.keel.api.ec2.LoadBalancerType;
import com.netflix.spinnaker.keel.api.ec2.TargetGroupAttributes;
import com.netflix.spinnaker.keel.api.schema.Discriminator;
import com.netflix.spinnaker.keel.api.schema.Optional;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002:\bBCDEFGHIBg\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\u0010\u0016J\t\u00104\u001a\u00020\u0004H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\bH\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c6\u0003J\t\u00108\u001a\u00020\fH\u00c6\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u00c6\u0003J\u0015\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u00c6\u0003Jq\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u00c6\u0001J\u0013\u0010=\u001a\u00020\b2\b\u0010>\u001a\u0004\u0018\u00010?H\u00d6\u0003J\t\u0010@\u001a\u00020)H\u00d6\u0001J\t\u0010A\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0018\u0010(\u001a\u0004\u0018\u00010)X\u0096D\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010!R\u0016\u00102\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001d\u00a8\u0006J"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec;", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerSpec;", "Lcom/netflix/spinnaker/keel/api/UnhappyControl;", "moniker", "Lcom/netflix/spinnaker/keel/api/Moniker;", "locations", "Lcom/netflix/spinnaker/keel/api/SubnetAwareLocations;", "internal", "", "dependencies", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;", "idleTimeout", "Ljava/time/Duration;", "listeners", "", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Listener;", "targetGroups", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$TargetGroup;", "overrides", "", "", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$ApplicationLoadBalancerOverride;", "(Lcom/netflix/spinnaker/keel/api/Moniker;Lcom/netflix/spinnaker/keel/api/SubnetAwareLocations;ZLcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;Ljava/time/Duration;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "getDependencies", "()Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;", "id", "getId", "()Ljava/lang/String;", "getIdleTimeout", "()Ljava/time/Duration;", "getInternal", "()Z", "getListeners", "()Ljava/util/Set;", "loadBalancerType", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerType;", "getLoadBalancerType", "()Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerType;", "getLocations", "()Lcom/netflix/spinnaker/keel/api/SubnetAwareLocations;", "maxDiffCount", "", "getMaxDiffCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMoniker", "()Lcom/netflix/spinnaker/keel/api/Moniker;", "getOverrides", "()Ljava/util/Map;", "getTargetGroups", "unhappyWaitTime", "getUnhappyWaitTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "toString", "Action", "ApplicationLoadBalancerOverride", "AuthenticateOidcActionConfig", "Condition", "Listener", "RedirectConfig", "Rule", "TargetGroup", "keel-ec2-api"})
public final class ApplicationLoadBalancerSpec
implements LoadBalancerSpec,
UnhappyControl {
    @Nullable
    private final Integer maxDiffCount;
    @Nullable
    private final Duration unhappyWaitTime;
    @NotNull
    private final LoadBalancerType loadBalancerType;
    @NotNull
    private final String id;
    @NotNull
    private final Moniker moniker;
    @NotNull
    private final SubnetAwareLocations locations;
    private final boolean internal;
    @NotNull
    private final LoadBalancerDependencies dependencies;
    @NotNull
    private final Duration idleTimeout;
    @NotNull
    private final Set<Listener> listeners;
    @NotNull
    private final Set<TargetGroup> targetGroups;
    @NotNull
    private final Map<String, ApplicationLoadBalancerOverride> overrides;

    @Nullable
    public Integer getMaxDiffCount() {
        return this.maxDiffCount;
    }

    @Nullable
    public Duration getUnhappyWaitTime() {
        return this.unhappyWaitTime;
    }

    @Override
    @NotNull
    public LoadBalancerType getLoadBalancerType() {
        return this.loadBalancerType;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Override
    @NotNull
    public SubnetAwareLocations getLocations() {
        return this.locations;
    }

    @Override
    public boolean getInternal() {
        return this.internal;
    }

    @Override
    @NotNull
    public LoadBalancerDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @NotNull
    public final Set<Listener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final Set<TargetGroup> getTargetGroups() {
        return this.targetGroups;
    }

    @NotNull
    public final Map<String, ApplicationLoadBalancerOverride> getOverrides() {
        return this.overrides;
    }

    public ApplicationLoadBalancerSpec(@NotNull Moniker moniker, @Optional @NotNull SubnetAwareLocations locations, boolean internal, @NotNull LoadBalancerDependencies dependencies, @NotNull Duration idleTimeout, @NotNull Set<Listener> listeners, @NotNull Set<TargetGroup> targetGroups, @NotNull Map<String, ApplicationLoadBalancerOverride> overrides) {
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)"idleTimeout");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter(targetGroups, (String)"targetGroups");
        Intrinsics.checkNotNullParameter(overrides, (String)"overrides");
        this.moniker = moniker;
        this.locations = locations;
        this.internal = internal;
        this.dependencies = dependencies;
        this.idleTimeout = idleTimeout;
        this.listeners = listeners;
        this.targetGroups = targetGroups;
        this.overrides = overrides;
        boolean bl = this.getMoniker().toString().length() <= 32;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "load balancer names have a 32 character limit";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxDiffCount = 2;
        this.loadBalancerType = LoadBalancerType.APPLICATION;
        this.id = this.getLocations().getAccount() + ':' + this.getMoniker();
    }

    public /* synthetic */ ApplicationLoadBalancerSpec(Moniker moniker, SubnetAwareLocations subnetAwareLocations, boolean bl, LoadBalancerDependencies loadBalancerDependencies, Duration duration, Set set, Set set2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            loadBalancerDependencies = new LoadBalancerDependencies(null, 1, null);
        }
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofSeconds(60)");
            duration = duration2;
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        this(moniker, subnetAwareLocations, bl, loadBalancerDependencies, duration, set, set2, map);
    }

    @NotNull
    public String getApplication() {
        return LoadBalancerSpec.DefaultImpls.getApplication(this);
    }

    @NotNull
    public String getDisplayName() {
        return LoadBalancerSpec.DefaultImpls.getDisplayName(this);
    }

    @NotNull
    public final Moniker component1() {
        return this.getMoniker();
    }

    @NotNull
    public final SubnetAwareLocations component2() {
        return this.getLocations();
    }

    public final boolean component3() {
        return this.getInternal();
    }

    @NotNull
    public final LoadBalancerDependencies component4() {
        return this.getDependencies();
    }

    @NotNull
    public final Duration component5() {
        return this.getIdleTimeout();
    }

    @NotNull
    public final Set<Listener> component6() {
        return this.listeners;
    }

    @NotNull
    public final Set<TargetGroup> component7() {
        return this.targetGroups;
    }

    @NotNull
    public final Map<String, ApplicationLoadBalancerOverride> component8() {
        return this.overrides;
    }

    @NotNull
    public final ApplicationLoadBalancerSpec copy(@NotNull Moniker moniker, @Optional @NotNull SubnetAwareLocations locations, boolean internal, @NotNull LoadBalancerDependencies dependencies, @NotNull Duration idleTimeout, @NotNull Set<Listener> listeners, @NotNull Set<TargetGroup> targetGroups, @NotNull Map<String, ApplicationLoadBalancerOverride> overrides) {
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)"idleTimeout");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter(targetGroups, (String)"targetGroups");
        Intrinsics.checkNotNullParameter(overrides, (String)"overrides");
        return new ApplicationLoadBalancerSpec(moniker, locations, internal, dependencies, idleTimeout, listeners, targetGroups, overrides);
    }

    public static /* synthetic */ ApplicationLoadBalancerSpec copy$default(ApplicationLoadBalancerSpec applicationLoadBalancerSpec, Moniker moniker, SubnetAwareLocations subnetAwareLocations, boolean bl, LoadBalancerDependencies loadBalancerDependencies, Duration duration, Set set, Set set2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            moniker = applicationLoadBalancerSpec.getMoniker();
        }
        if ((n & 2) != 0) {
            subnetAwareLocations = applicationLoadBalancerSpec.getLocations();
        }
        if ((n & 4) != 0) {
            bl = applicationLoadBalancerSpec.getInternal();
        }
        if ((n & 8) != 0) {
            loadBalancerDependencies = applicationLoadBalancerSpec.getDependencies();
        }
        if ((n & 0x10) != 0) {
            duration = applicationLoadBalancerSpec.getIdleTimeout();
        }
        if ((n & 0x20) != 0) {
            set = applicationLoadBalancerSpec.listeners;
        }
        if ((n & 0x40) != 0) {
            set2 = applicationLoadBalancerSpec.targetGroups;
        }
        if ((n & 0x80) != 0) {
            map = applicationLoadBalancerSpec.overrides;
        }
        return applicationLoadBalancerSpec.copy(moniker, subnetAwareLocations, bl, loadBalancerDependencies, duration, set, set2, map);
    }

    @NotNull
    public String toString() {
        return "ApplicationLoadBalancerSpec(moniker=" + this.getMoniker() + ", locations=" + this.getLocations() + ", internal=" + this.getInternal() + ", dependencies=" + this.getDependencies() + ", idleTimeout=" + this.getIdleTimeout() + ", listeners=" + this.listeners + ", targetGroups=" + this.targetGroups + ", overrides=" + this.overrides + ")";
    }

    public int hashCode() {
        Moniker moniker = this.getMoniker();
        SubnetAwareLocations subnetAwareLocations = this.getLocations();
        int n = ((moniker != null ? moniker.hashCode() : 0) * 31 + (subnetAwareLocations != null ? subnetAwareLocations.hashCode() : 0)) * 31;
        int n2 = this.getInternal() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        LoadBalancerDependencies loadBalancerDependencies = this.getDependencies();
        Duration duration = this.getIdleTimeout();
        Set<Listener> set = this.listeners;
        Set<TargetGroup> set2 = this.targetGroups;
        Map<String, ApplicationLoadBalancerOverride> map = this.overrides;
        return (((((n + n2) * 31 + (loadBalancerDependencies != null ? ((Object)loadBalancerDependencies).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ApplicationLoadBalancerSpec)) break block3;
                ApplicationLoadBalancerSpec applicationLoadBalancerSpec = (ApplicationLoadBalancerSpec)object;
                if (!Intrinsics.areEqual((Object)this.getMoniker(), (Object)applicationLoadBalancerSpec.getMoniker()) || !Intrinsics.areEqual((Object)this.getLocations(), (Object)applicationLoadBalancerSpec.getLocations()) || this.getInternal() != applicationLoadBalancerSpec.getInternal() || !Intrinsics.areEqual((Object)this.getDependencies(), (Object)applicationLoadBalancerSpec.getDependencies()) || !Intrinsics.areEqual((Object)this.getIdleTimeout(), (Object)applicationLoadBalancerSpec.getIdleTimeout()) || !Intrinsics.areEqual(this.listeners, applicationLoadBalancerSpec.listeners) || !Intrinsics.areEqual(this.targetGroups, applicationLoadBalancerSpec.targetGroups) || !Intrinsics.areEqual(this.overrides, applicationLoadBalancerSpec.overrides)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00c6\u0003JI\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Listener;", "", "port", "", "protocol", "", "certificate", "rules", "", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Rule;", "defaultActions", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action;", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;)V", "getCertificate", "()Ljava/lang/String;", "getDefaultActions", "()Ljava/util/Set;", "getPort", "()I", "getProtocol", "getRules", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "keel-ec2-api"})
    public static final class Listener {
        private final int port;
        @NotNull
        private final String protocol;
        @Nullable
        private final String certificate;
        @NotNull
        private final Set<Rule> rules;
        @NotNull
        private final Set<Action> defaultActions;

        public final int getPort() {
            return this.port;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @Nullable
        public final String getCertificate() {
            return this.certificate;
        }

        @NotNull
        public final Set<Rule> getRules() {
            return this.rules;
        }

        @NotNull
        public final Set<Action> getDefaultActions() {
            return this.defaultActions;
        }

        public Listener(int port, @NotNull String protocol, @Nullable String certificate, @NotNull Set<Rule> rules, @NotNull Set<? extends Action> defaultActions) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(defaultActions, (String)"defaultActions");
            this.port = port;
            this.protocol = protocol;
            this.certificate = certificate;
            this.rules = rules;
            this.defaultActions = defaultActions;
            if (Intrinsics.areEqual((Object)this.protocol, (Object)"HTTPS")) {
                String string = this.certificate;
                boolean bl = false;
                boolean bl2 = false;
                if (string == null) {
                    boolean bl3 = false;
                    String string2 = "HTTPS listeners must specify a certificate";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
            }
        }

        public /* synthetic */ Listener(int n, String string, String string2, Set set, Set set2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n2 & 0x10) != 0) {
                set2 = SetsKt.emptySet();
            }
            this(n, string, string2, set, set2);
        }

        public final int component1() {
            return this.port;
        }

        @NotNull
        public final String component2() {
            return this.protocol;
        }

        @Nullable
        public final String component3() {
            return this.certificate;
        }

        @NotNull
        public final Set<Rule> component4() {
            return this.rules;
        }

        @NotNull
        public final Set<Action> component5() {
            return this.defaultActions;
        }

        @NotNull
        public final Listener copy(int port, @NotNull String protocol, @Nullable String certificate, @NotNull Set<Rule> rules, @NotNull Set<? extends Action> defaultActions) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(defaultActions, (String)"defaultActions");
            return new Listener(port, protocol, certificate, rules, defaultActions);
        }

        public static /* synthetic */ Listener copy$default(Listener listener, int n, String string, String string2, Set set, Set set2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = listener.port;
            }
            if ((n2 & 2) != 0) {
                string = listener.protocol;
            }
            if ((n2 & 4) != 0) {
                string2 = listener.certificate;
            }
            if ((n2 & 8) != 0) {
                set = listener.rules;
            }
            if ((n2 & 0x10) != 0) {
                set2 = listener.defaultActions;
            }
            return listener.copy(n, string, string2, set, set2);
        }

        @NotNull
        public String toString() {
            return "Listener(port=" + this.port + ", protocol=" + this.protocol + ", certificate=" + this.certificate + ", rules=" + this.rules + ", defaultActions=" + this.defaultActions + ")";
        }

        public int hashCode() {
            String string = this.protocol;
            String string2 = this.certificate;
            Set<Rule> set = this.rules;
            Set<Action> set2 = this.defaultActions;
            return (((Integer.hashCode(this.port) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Listener)) break block3;
                    Listener listener = (Listener)object;
                    if (this.port != listener.port || !Intrinsics.areEqual((Object)this.protocol, (Object)listener.protocol) || !Intrinsics.areEqual((Object)this.certificate, (Object)listener.certificate) || !Intrinsics.areEqual(this.rules, listener.rules) || !Intrinsics.areEqual(this.defaultActions, listener.defaultActions)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b(\b\u0086\b\u0018\u00002\u00020\u0001B\u008d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u000bH\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u0014H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\t\u00103\u001a\u00020\u000bH\u00c6\u0003J\t\u00104\u001a\u00020\u0007H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\u0095\u0001\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u00c6\u0001J\u0013\u00108\u001a\u00020\t2\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020\u0007H\u00d6\u0001J\b\u0010;\u001a\u00020\u0003H\u0016R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001bR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 \u00a8\u0006<"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$TargetGroup;", "", "name", "", "targetType", "protocol", "port", "", "healthCheckEnabled", "", "healthCheckTimeout", "Ljava/time/Duration;", "healthCheckPort", "healthCheckProtocol", "healthCheckHttpCode", "healthCheckPath", "healthCheckInterval", "healthyThresholdCount", "unhealthyThresholdCount", "attributes", "Lcom/netflix/spinnaker/keel/api/ec2/TargetGroupAttributes;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZLjava/time/Duration;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;IILcom/netflix/spinnaker/keel/api/ec2/TargetGroupAttributes;)V", "getAttributes", "()Lcom/netflix/spinnaker/keel/api/ec2/TargetGroupAttributes;", "getHealthCheckEnabled", "()Z", "getHealthCheckHttpCode", "()Ljava/lang/String;", "getHealthCheckInterval", "()Ljava/time/Duration;", "getHealthCheckPath", "getHealthCheckPort", "()I", "getHealthCheckProtocol", "getHealthCheckTimeout", "getHealthyThresholdCount", "getName", "getPort", "getProtocol", "getTargetType", "getUnhealthyThresholdCount", "component1", "component10", "component11", "component12", "component13", "component14", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "keel-ec2-api"})
    public static final class TargetGroup {
        @NotNull
        private final String name;
        @NotNull
        private final String targetType;
        @NotNull
        private final String protocol;
        private final int port;
        private final boolean healthCheckEnabled;
        @NotNull
        private final Duration healthCheckTimeout;
        private final int healthCheckPort;
        @NotNull
        private final String healthCheckProtocol;
        @NotNull
        private final String healthCheckHttpCode;
        @NotNull
        private final String healthCheckPath;
        @NotNull
        private final Duration healthCheckInterval;
        private final int healthyThresholdCount;
        private final int unhealthyThresholdCount;
        @NotNull
        private final TargetGroupAttributes attributes;

        @NotNull
        public String toString() {
            return this.name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTargetType() {
            return this.targetType;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        public final int getPort() {
            return this.port;
        }

        public final boolean getHealthCheckEnabled() {
            return this.healthCheckEnabled;
        }

        @NotNull
        public final Duration getHealthCheckTimeout() {
            return this.healthCheckTimeout;
        }

        public final int getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @NotNull
        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @NotNull
        public final String getHealthCheckHttpCode() {
            return this.healthCheckHttpCode;
        }

        @NotNull
        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @NotNull
        public final Duration getHealthCheckInterval() {
            return this.healthCheckInterval;
        }

        public final int getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        public final int getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @NotNull
        public final TargetGroupAttributes getAttributes() {
            return this.attributes;
        }

        public TargetGroup(@NotNull String name, @NotNull String targetType, @NotNull String protocol, int port, boolean healthCheckEnabled, @NotNull Duration healthCheckTimeout, int healthCheckPort, @NotNull String healthCheckProtocol, @NotNull String healthCheckHttpCode, @NotNull String healthCheckPath, @NotNull Duration healthCheckInterval, int healthyThresholdCount, int unhealthyThresholdCount, @NotNull TargetGroupAttributes attributes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)healthCheckTimeout, (String)"healthCheckTimeout");
            Intrinsics.checkNotNullParameter((Object)healthCheckProtocol, (String)"healthCheckProtocol");
            Intrinsics.checkNotNullParameter((Object)healthCheckHttpCode, (String)"healthCheckHttpCode");
            Intrinsics.checkNotNullParameter((Object)healthCheckPath, (String)"healthCheckPath");
            Intrinsics.checkNotNullParameter((Object)healthCheckInterval, (String)"healthCheckInterval");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            this.name = name;
            this.targetType = targetType;
            this.protocol = protocol;
            this.port = port;
            this.healthCheckEnabled = healthCheckEnabled;
            this.healthCheckTimeout = healthCheckTimeout;
            this.healthCheckPort = healthCheckPort;
            this.healthCheckProtocol = healthCheckProtocol;
            this.healthCheckHttpCode = healthCheckHttpCode;
            this.healthCheckPath = healthCheckPath;
            this.healthCheckInterval = healthCheckInterval;
            this.healthyThresholdCount = healthyThresholdCount;
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            this.attributes = attributes;
            boolean bl = this.name.length() <= 32;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "targetGroup names have a 32 character limit";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ TargetGroup(String string, String string2, String string3, int n, boolean bl, Duration duration, int n2, String string4, String string5, String string6, Duration duration2, int n3, int n4, TargetGroupAttributes targetGroupAttributes, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 2) != 0) {
                string2 = "instance";
            }
            if ((n5 & 4) != 0) {
                string3 = "HTTP";
            }
            if ((n5 & 0x10) != 0) {
                bl = true;
            }
            if ((n5 & 0x20) != 0) {
                Duration duration3 = Duration.ofSeconds(5L);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"Duration.ofSeconds(5)");
                duration = duration3;
            }
            if ((n5 & 0x40) != 0) {
                n2 = 7001;
            }
            if ((n5 & 0x80) != 0) {
                string4 = "HTTP";
            }
            if ((n5 & 0x100) != 0) {
                string5 = "200-299";
            }
            if ((n5 & 0x200) != 0) {
                string6 = "/healthcheck";
            }
            if ((n5 & 0x400) != 0) {
                Duration duration4 = Duration.ofSeconds(10L);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"Duration.ofSeconds(10)");
                duration2 = duration4;
            }
            if ((n5 & 0x800) != 0) {
                n3 = 10;
            }
            if ((n5 & 0x1000) != 0) {
                n4 = 2;
            }
            if ((n5 & 0x2000) != 0) {
                targetGroupAttributes = new TargetGroupAttributes(false, 0, null, 0, 0, null, 63, null);
            }
            this(string, string2, string3, n, bl, duration, n2, string4, string5, string6, duration2, n3, n4, targetGroupAttributes);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.targetType;
        }

        @NotNull
        public final String component3() {
            return this.protocol;
        }

        public final int component4() {
            return this.port;
        }

        public final boolean component5() {
            return this.healthCheckEnabled;
        }

        @NotNull
        public final Duration component6() {
            return this.healthCheckTimeout;
        }

        public final int component7() {
            return this.healthCheckPort;
        }

        @NotNull
        public final String component8() {
            return this.healthCheckProtocol;
        }

        @NotNull
        public final String component9() {
            return this.healthCheckHttpCode;
        }

        @NotNull
        public final String component10() {
            return this.healthCheckPath;
        }

        @NotNull
        public final Duration component11() {
            return this.healthCheckInterval;
        }

        public final int component12() {
            return this.healthyThresholdCount;
        }

        public final int component13() {
            return this.unhealthyThresholdCount;
        }

        @NotNull
        public final TargetGroupAttributes component14() {
            return this.attributes;
        }

        @NotNull
        public final TargetGroup copy(@NotNull String name, @NotNull String targetType, @NotNull String protocol, int port, boolean healthCheckEnabled, @NotNull Duration healthCheckTimeout, int healthCheckPort, @NotNull String healthCheckProtocol, @NotNull String healthCheckHttpCode, @NotNull String healthCheckPath, @NotNull Duration healthCheckInterval, int healthyThresholdCount, int unhealthyThresholdCount, @NotNull TargetGroupAttributes attributes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)healthCheckTimeout, (String)"healthCheckTimeout");
            Intrinsics.checkNotNullParameter((Object)healthCheckProtocol, (String)"healthCheckProtocol");
            Intrinsics.checkNotNullParameter((Object)healthCheckHttpCode, (String)"healthCheckHttpCode");
            Intrinsics.checkNotNullParameter((Object)healthCheckPath, (String)"healthCheckPath");
            Intrinsics.checkNotNullParameter((Object)healthCheckInterval, (String)"healthCheckInterval");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            return new TargetGroup(name, targetType, protocol, port, healthCheckEnabled, healthCheckTimeout, healthCheckPort, healthCheckProtocol, healthCheckHttpCode, healthCheckPath, healthCheckInterval, healthyThresholdCount, unhealthyThresholdCount, attributes);
        }

        public static /* synthetic */ TargetGroup copy$default(TargetGroup targetGroup, String string, String string2, String string3, int n, boolean bl, Duration duration, int n2, String string4, String string5, String string6, Duration duration2, int n3, int n4, TargetGroupAttributes targetGroupAttributes, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = targetGroup.name;
            }
            if ((n5 & 2) != 0) {
                string2 = targetGroup.targetType;
            }
            if ((n5 & 4) != 0) {
                string3 = targetGroup.protocol;
            }
            if ((n5 & 8) != 0) {
                n = targetGroup.port;
            }
            if ((n5 & 0x10) != 0) {
                bl = targetGroup.healthCheckEnabled;
            }
            if ((n5 & 0x20) != 0) {
                duration = targetGroup.healthCheckTimeout;
            }
            if ((n5 & 0x40) != 0) {
                n2 = targetGroup.healthCheckPort;
            }
            if ((n5 & 0x80) != 0) {
                string4 = targetGroup.healthCheckProtocol;
            }
            if ((n5 & 0x100) != 0) {
                string5 = targetGroup.healthCheckHttpCode;
            }
            if ((n5 & 0x200) != 0) {
                string6 = targetGroup.healthCheckPath;
            }
            if ((n5 & 0x400) != 0) {
                duration2 = targetGroup.healthCheckInterval;
            }
            if ((n5 & 0x800) != 0) {
                n3 = targetGroup.healthyThresholdCount;
            }
            if ((n5 & 0x1000) != 0) {
                n4 = targetGroup.unhealthyThresholdCount;
            }
            if ((n5 & 0x2000) != 0) {
                targetGroupAttributes = targetGroup.attributes;
            }
            return targetGroup.copy(string, string2, string3, n, bl, duration, n2, string4, string5, string6, duration2, n3, n4, targetGroupAttributes);
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.targetType;
            String string3 = this.protocol;
            int n = ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + Integer.hashCode(this.port)) * 31;
            int n2 = this.healthCheckEnabled ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            Duration duration = this.healthCheckTimeout;
            String string4 = this.healthCheckProtocol;
            String string5 = this.healthCheckHttpCode;
            String string6 = this.healthCheckPath;
            Duration duration2 = this.healthCheckInterval;
            TargetGroupAttributes targetGroupAttributes = this.attributes;
            return (((((((((n + n2) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + Integer.hashCode(this.healthCheckPort)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + Integer.hashCode(this.healthyThresholdCount)) * 31 + Integer.hashCode(this.unhealthyThresholdCount)) * 31 + (targetGroupAttributes != null ? ((Object)targetGroupAttributes).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TargetGroup)) break block3;
                    TargetGroup targetGroup = (TargetGroup)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)targetGroup.name) || !Intrinsics.areEqual((Object)this.targetType, (Object)targetGroup.targetType) || !Intrinsics.areEqual((Object)this.protocol, (Object)targetGroup.protocol) || this.port != targetGroup.port || this.healthCheckEnabled != targetGroup.healthCheckEnabled || !Intrinsics.areEqual((Object)this.healthCheckTimeout, (Object)targetGroup.healthCheckTimeout) || this.healthCheckPort != targetGroup.healthCheckPort || !Intrinsics.areEqual((Object)this.healthCheckProtocol, (Object)targetGroup.healthCheckProtocol) || !Intrinsics.areEqual((Object)this.healthCheckHttpCode, (Object)targetGroup.healthCheckHttpCode) || !Intrinsics.areEqual((Object)this.healthCheckPath, (Object)targetGroup.healthCheckPath) || !Intrinsics.areEqual((Object)this.healthCheckInterval, (Object)targetGroup.healthCheckInterval) || this.healthyThresholdCount != targetGroup.healthyThresholdCount || this.unhealthyThresholdCount != targetGroup.unhealthyThresholdCount || !Intrinsics.areEqual((Object)this.attributes, (Object)targetGroup.attributes)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0003J9\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$ApplicationLoadBalancerOverride;", "", "dependencies", "Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;", "listeners", "", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Listener;", "targetGroups", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$TargetGroup;", "(Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;Ljava/util/Set;Ljava/util/Set;)V", "getDependencies", "()Lcom/netflix/spinnaker/keel/api/ec2/LoadBalancerDependencies;", "getListeners", "()Ljava/util/Set;", "getTargetGroups", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "keel-ec2-api"})
    public static final class ApplicationLoadBalancerOverride {
        @Nullable
        private final LoadBalancerDependencies dependencies;
        @Nullable
        private final Set<Listener> listeners;
        @Nullable
        private final Set<TargetGroup> targetGroups;

        @Nullable
        public final LoadBalancerDependencies getDependencies() {
            return this.dependencies;
        }

        @Nullable
        public final Set<Listener> getListeners() {
            return this.listeners;
        }

        @Nullable
        public final Set<TargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        public ApplicationLoadBalancerOverride(@Nullable LoadBalancerDependencies dependencies, @Nullable Set<Listener> listeners, @Nullable Set<TargetGroup> targetGroups) {
            this.dependencies = dependencies;
            this.listeners = listeners;
            this.targetGroups = targetGroups;
        }

        public /* synthetic */ ApplicationLoadBalancerOverride(LoadBalancerDependencies loadBalancerDependencies, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                loadBalancerDependencies = null;
            }
            if ((n & 2) != 0) {
                set = null;
            }
            if ((n & 4) != 0) {
                set2 = null;
            }
            this(loadBalancerDependencies, set, set2);
        }

        public ApplicationLoadBalancerOverride() {
            this(null, null, null, 7, null);
        }

        @Nullable
        public final LoadBalancerDependencies component1() {
            return this.dependencies;
        }

        @Nullable
        public final Set<Listener> component2() {
            return this.listeners;
        }

        @Nullable
        public final Set<TargetGroup> component3() {
            return this.targetGroups;
        }

        @NotNull
        public final ApplicationLoadBalancerOverride copy(@Nullable LoadBalancerDependencies dependencies, @Nullable Set<Listener> listeners, @Nullable Set<TargetGroup> targetGroups) {
            return new ApplicationLoadBalancerOverride(dependencies, listeners, targetGroups);
        }

        public static /* synthetic */ ApplicationLoadBalancerOverride copy$default(ApplicationLoadBalancerOverride applicationLoadBalancerOverride, LoadBalancerDependencies loadBalancerDependencies, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                loadBalancerDependencies = applicationLoadBalancerOverride.dependencies;
            }
            if ((n & 2) != 0) {
                set = applicationLoadBalancerOverride.listeners;
            }
            if ((n & 4) != 0) {
                set2 = applicationLoadBalancerOverride.targetGroups;
            }
            return applicationLoadBalancerOverride.copy(loadBalancerDependencies, set, set2);
        }

        @NotNull
        public String toString() {
            return "ApplicationLoadBalancerOverride(dependencies=" + this.dependencies + ", listeners=" + this.listeners + ", targetGroups=" + this.targetGroups + ")";
        }

        public int hashCode() {
            LoadBalancerDependencies loadBalancerDependencies = this.dependencies;
            Set<Listener> set = this.listeners;
            Set<TargetGroup> set2 = this.targetGroups;
            return ((loadBalancerDependencies != null ? ((Object)loadBalancerDependencies).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ApplicationLoadBalancerOverride)) break block3;
                    ApplicationLoadBalancerOverride applicationLoadBalancerOverride = (ApplicationLoadBalancerOverride)object;
                    if (!Intrinsics.areEqual((Object)this.dependencies, (Object)applicationLoadBalancerOverride.dependencies) || !Intrinsics.areEqual(this.listeners, applicationLoadBalancerOverride.listeners) || !Intrinsics.areEqual(this.targetGroups, applicationLoadBalancerOverride.targetGroups)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\b8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action;", "", "()V", "order", "", "getOrder", "()I", "type", "", "getType$annotations", "getType", "()Ljava/lang/String;", "AuthenticateOidcAction", "ForwardAction", "RedirectAction", "keel-ec2-api"})
    public static abstract class Action {
        @Discriminator
        public static /* synthetic */ void getType$annotations() {
        }

        @NotNull
        public abstract String getType();

        public abstract int getOrder();

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action$ForwardAction;", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action;", "order", "", "targetGroupName", "", "(ILjava/lang/String;)V", "getOrder", "()I", "getTargetGroupName", "()Ljava/lang/String;", "type", "getType", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "keel-ec2-api"})
        public static final class ForwardAction
        extends Action {
            @NotNull
            private final String type;
            private final int order;
            @NotNull
            private final String targetGroupName;

            @Override
            @NotNull
            public String getType() {
                return this.type;
            }

            @Override
            public int getOrder() {
                return this.order;
            }

            @NotNull
            public final String getTargetGroupName() {
                return this.targetGroupName;
            }

            public ForwardAction(int order, @NotNull String targetGroupName) {
                Intrinsics.checkNotNullParameter((Object)targetGroupName, (String)"targetGroupName");
                this.order = order;
                this.targetGroupName = targetGroupName;
                this.type = "forward";
            }

            public final int component1() {
                return this.getOrder();
            }

            @NotNull
            public final String component2() {
                return this.targetGroupName;
            }

            @NotNull
            public final ForwardAction copy(int order, @NotNull String targetGroupName) {
                Intrinsics.checkNotNullParameter((Object)targetGroupName, (String)"targetGroupName");
                return new ForwardAction(order, targetGroupName);
            }

            public static /* synthetic */ ForwardAction copy$default(ForwardAction forwardAction, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = forwardAction.getOrder();
                }
                if ((n2 & 2) != 0) {
                    string = forwardAction.targetGroupName;
                }
                return forwardAction.copy(n, string);
            }

            @NotNull
            public String toString() {
                return "ForwardAction(order=" + this.getOrder() + ", targetGroupName=" + this.targetGroupName + ")";
            }

            public int hashCode() {
                String string = this.targetGroupName;
                return Integer.hashCode(this.getOrder()) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ForwardAction)) break block3;
                        ForwardAction forwardAction = (ForwardAction)object;
                        if (this.getOrder() != forwardAction.getOrder() || !Intrinsics.areEqual((Object)this.targetGroupName, (Object)forwardAction.targetGroupName)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action$RedirectAction;", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action;", "order", "", "redirectConfig", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$RedirectConfig;", "(ILcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$RedirectConfig;)V", "getOrder", "()I", "getRedirectConfig", "()Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$RedirectConfig;", "type", "", "getType", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "keel-ec2-api"})
        public static final class RedirectAction
        extends Action {
            @NotNull
            private final String type;
            private final int order;
            @NotNull
            private final RedirectConfig redirectConfig;

            @Override
            @NotNull
            public String getType() {
                return this.type;
            }

            @Override
            public int getOrder() {
                return this.order;
            }

            @NotNull
            public final RedirectConfig getRedirectConfig() {
                return this.redirectConfig;
            }

            public RedirectAction(int order, @NotNull RedirectConfig redirectConfig) {
                Intrinsics.checkNotNullParameter((Object)redirectConfig, (String)"redirectConfig");
                this.order = order;
                this.redirectConfig = redirectConfig;
                this.type = "redirect";
            }

            public final int component1() {
                return this.getOrder();
            }

            @NotNull
            public final RedirectConfig component2() {
                return this.redirectConfig;
            }

            @NotNull
            public final RedirectAction copy(int order, @NotNull RedirectConfig redirectConfig) {
                Intrinsics.checkNotNullParameter((Object)redirectConfig, (String)"redirectConfig");
                return new RedirectAction(order, redirectConfig);
            }

            public static /* synthetic */ RedirectAction copy$default(RedirectAction redirectAction, int n, RedirectConfig redirectConfig, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = redirectAction.getOrder();
                }
                if ((n2 & 2) != 0) {
                    redirectConfig = redirectAction.redirectConfig;
                }
                return redirectAction.copy(n, redirectConfig);
            }

            @NotNull
            public String toString() {
                return "RedirectAction(order=" + this.getOrder() + ", redirectConfig=" + this.redirectConfig + ")";
            }

            public int hashCode() {
                RedirectConfig redirectConfig = this.redirectConfig;
                return Integer.hashCode(this.getOrder()) * 31 + (redirectConfig != null ? ((Object)redirectConfig).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof RedirectAction)) break block3;
                        RedirectAction redirectAction = (RedirectAction)object;
                        if (this.getOrder() != redirectAction.getOrder() || !Intrinsics.areEqual((Object)this.redirectConfig, (Object)redirectAction.redirectConfig)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action$AuthenticateOidcAction;", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action;", "order", "", "authenticateOidcConfig", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$AuthenticateOidcActionConfig;", "(ILcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$AuthenticateOidcActionConfig;)V", "getAuthenticateOidcConfig", "()Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$AuthenticateOidcActionConfig;", "getOrder", "()I", "type", "", "getType", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "keel-ec2-api"})
        public static final class AuthenticateOidcAction
        extends Action {
            @NotNull
            private final String type;
            private final int order;
            @NotNull
            private final AuthenticateOidcActionConfig authenticateOidcConfig;

            @Override
            @NotNull
            public String getType() {
                return this.type;
            }

            @Override
            public int getOrder() {
                return this.order;
            }

            @NotNull
            public final AuthenticateOidcActionConfig getAuthenticateOidcConfig() {
                return this.authenticateOidcConfig;
            }

            public AuthenticateOidcAction(int order, @NotNull AuthenticateOidcActionConfig authenticateOidcConfig) {
                Intrinsics.checkNotNullParameter((Object)authenticateOidcConfig, (String)"authenticateOidcConfig");
                this.order = order;
                this.authenticateOidcConfig = authenticateOidcConfig;
                this.type = "authenticate-oidc";
            }

            public final int component1() {
                return this.getOrder();
            }

            @NotNull
            public final AuthenticateOidcActionConfig component2() {
                return this.authenticateOidcConfig;
            }

            @NotNull
            public final AuthenticateOidcAction copy(int order, @NotNull AuthenticateOidcActionConfig authenticateOidcConfig) {
                Intrinsics.checkNotNullParameter((Object)authenticateOidcConfig, (String)"authenticateOidcConfig");
                return new AuthenticateOidcAction(order, authenticateOidcConfig);
            }

            public static /* synthetic */ AuthenticateOidcAction copy$default(AuthenticateOidcAction authenticateOidcAction, int n, AuthenticateOidcActionConfig authenticateOidcActionConfig, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = authenticateOidcAction.getOrder();
                }
                if ((n2 & 2) != 0) {
                    authenticateOidcActionConfig = authenticateOidcAction.authenticateOidcConfig;
                }
                return authenticateOidcAction.copy(n, authenticateOidcActionConfig);
            }

            @NotNull
            public String toString() {
                return "AuthenticateOidcAction(order=" + this.getOrder() + ", authenticateOidcConfig=" + this.authenticateOidcConfig + ")";
            }

            public int hashCode() {
                AuthenticateOidcActionConfig authenticateOidcActionConfig = this.authenticateOidcConfig;
                return Integer.hashCode(this.getOrder()) * 31 + (authenticateOidcActionConfig != null ? ((Object)authenticateOidcActionConfig).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof AuthenticateOidcAction)) break block3;
                        AuthenticateOidcAction authenticateOidcAction = (AuthenticateOidcAction)object;
                        if (this.getOrder() != authenticateOidcAction.getOrder() || !Intrinsics.areEqual((Object)this.authenticateOidcConfig, (Object)authenticateOidcAction.authenticateOidcConfig)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J=\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Rule;", "", "priority", "", "conditions", "", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Condition;", "actions", "Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Action;", "default", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Z)V", "getActions", "()Ljava/util/List;", "getConditions", "getDefault", "()Z", "getPriority", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "keel-ec2-api"})
    public static final class Rule {
        @NotNull
        private final String priority;
        @NotNull
        private final List<Condition> conditions;
        @NotNull
        private final List<Action> actions;
        private final boolean default;

        @NotNull
        public final String getPriority() {
            return this.priority;
        }

        @NotNull
        public final List<Condition> getConditions() {
            return this.conditions;
        }

        @NotNull
        public final List<Action> getActions() {
            return this.actions;
        }

        public final boolean getDefault() {
            return this.default;
        }

        public Rule(@NotNull String priority, @NotNull List<Condition> conditions, @NotNull List<? extends Action> actions, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            this.priority = priority;
            this.conditions = conditions;
            this.actions = actions;
            this.default = bl;
        }

        public /* synthetic */ Rule(String string, List list, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, list, list2, bl);
        }

        @NotNull
        public final String component1() {
            return this.priority;
        }

        @NotNull
        public final List<Condition> component2() {
            return this.conditions;
        }

        @NotNull
        public final List<Action> component3() {
            return this.actions;
        }

        public final boolean component4() {
            return this.default;
        }

        @NotNull
        public final Rule copy(@NotNull String priority, @NotNull List<Condition> conditions, @NotNull List<? extends Action> actions, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            return new Rule(priority, conditions, actions, bl);
        }

        public static /* synthetic */ Rule copy$default(Rule rule, String string, List list, List list2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = rule.priority;
            }
            if ((n & 2) != 0) {
                list = rule.conditions;
            }
            if ((n & 4) != 0) {
                list2 = rule.actions;
            }
            if ((n & 8) != 0) {
                bl = rule.default;
            }
            return rule.copy(string, list, list2, bl);
        }

        @NotNull
        public String toString() {
            return "Rule(priority=" + this.priority + ", conditions=" + this.conditions + ", actions=" + this.actions + ", default=" + this.default + ")";
        }

        public int hashCode() {
            String string = this.priority;
            List<Condition> list = this.conditions;
            List<Action> list2 = this.actions;
            int n = (((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31;
            int n2 = this.default ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Rule)) break block3;
                    Rule rule = (Rule)object;
                    if (!Intrinsics.areEqual((Object)this.priority, (Object)rule.priority) || !Intrinsics.areEqual(this.conditions, rule.conditions) || !Intrinsics.areEqual(this.actions, rule.actions) || this.default != rule.default) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$Condition;", "", "field", "", "values", "", "(Ljava/lang/String;Ljava/util/List;)V", "getField", "()Ljava/lang/String;", "getValues", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "keel-ec2-api"})
    public static final class Condition {
        @NotNull
        private final String field;
        @NotNull
        private final List<String> values;

        @NotNull
        public final String getField() {
            return this.field;
        }

        @NotNull
        public final List<String> getValues() {
            return this.values;
        }

        public Condition(@NotNull String field, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.field = field;
            this.values = values;
        }

        @NotNull
        public final String component1() {
            return this.field;
        }

        @NotNull
        public final List<String> component2() {
            return this.values;
        }

        @NotNull
        public final Condition copy(@NotNull String field, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new Condition(field, values);
        }

        public static /* synthetic */ Condition copy$default(Condition condition, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = condition.field;
            }
            if ((n & 2) != 0) {
                list = condition.values;
            }
            return condition.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "Condition(field=" + this.field + ", values=" + this.values + ")";
        }

        public int hashCode() {
            String string = this.field;
            List<String> list = this.values;
            return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Condition)) break block3;
                    Condition condition = (Condition)object;
                    if (!Intrinsics.areEqual((Object)this.field, (Object)condition.field) || !Intrinsics.areEqual(this.values, condition.values)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JI\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$RedirectConfig;", "", "protocol", "", "host", "port", "path", "query", "statusCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPath", "getPort", "getProtocol", "getQuery", "getStatusCode", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "keel-ec2-api"})
    public static final class RedirectConfig {
        @NotNull
        private final String protocol;
        @NotNull
        private final String host;
        @Nullable
        private final String port;
        @NotNull
        private final String path;
        @Nullable
        private final String query;
        @NotNull
        private final String statusCode;

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Nullable
        public final String getPort() {
            return this.port;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final String getQuery() {
            return this.query;
        }

        @NotNull
        public final String getStatusCode() {
            return this.statusCode;
        }

        public RedirectConfig(@NotNull String protocol, @NotNull String host, @Nullable String port, @NotNull String path, @Nullable String query, @NotNull String statusCode) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.path = path;
            this.query = query;
            this.statusCode = statusCode;
        }

        @NotNull
        public final String component1() {
            return this.protocol;
        }

        @NotNull
        public final String component2() {
            return this.host;
        }

        @Nullable
        public final String component3() {
            return this.port;
        }

        @NotNull
        public final String component4() {
            return this.path;
        }

        @Nullable
        public final String component5() {
            return this.query;
        }

        @NotNull
        public final String component6() {
            return this.statusCode;
        }

        @NotNull
        public final RedirectConfig copy(@NotNull String protocol, @NotNull String host, @Nullable String port, @NotNull String path, @Nullable String query, @NotNull String statusCode) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
            return new RedirectConfig(protocol, host, port, path, query, statusCode);
        }

        public static /* synthetic */ RedirectConfig copy$default(RedirectConfig redirectConfig, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = redirectConfig.protocol;
            }
            if ((n & 2) != 0) {
                string2 = redirectConfig.host;
            }
            if ((n & 4) != 0) {
                string3 = redirectConfig.port;
            }
            if ((n & 8) != 0) {
                string4 = redirectConfig.path;
            }
            if ((n & 0x10) != 0) {
                string5 = redirectConfig.query;
            }
            if ((n & 0x20) != 0) {
                string6 = redirectConfig.statusCode;
            }
            return redirectConfig.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "RedirectConfig(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", path=" + this.path + ", query=" + this.query + ", statusCode=" + this.statusCode + ")";
        }

        public int hashCode() {
            String string = this.protocol;
            String string2 = this.host;
            String string3 = this.port;
            String string4 = this.path;
            String string5 = this.query;
            String string6 = this.statusCode;
            return (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RedirectConfig)) break block3;
                    RedirectConfig redirectConfig = (RedirectConfig)object;
                    if (!Intrinsics.areEqual((Object)this.protocol, (Object)redirectConfig.protocol) || !Intrinsics.areEqual((Object)this.host, (Object)redirectConfig.host) || !Intrinsics.areEqual((Object)this.port, (Object)redirectConfig.port) || !Intrinsics.areEqual((Object)this.path, (Object)redirectConfig.path) || !Intrinsics.areEqual((Object)this.query, (Object)redirectConfig.query) || !Intrinsics.areEqual((Object)this.statusCode, (Object)redirectConfig.statusCode)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003J\u0017\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rH\u00c6\u0003Jq\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/netflix/spinnaker/keel/api/ec2/ApplicationLoadBalancerSpec$AuthenticateOidcActionConfig;", "", "issuer", "", "authorizationEndpoint", "tokenEndpoint", "userInfoEndpoint", "clientId", "sessionCookieName", "scope", "sessionTimeout", "Ljava/time/Duration;", "authenticationRequestExtraParams", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/util/Map;)V", "getAuthenticationRequestExtraParams", "()Ljava/util/Map;", "getAuthorizationEndpoint", "()Ljava/lang/String;", "getClientId", "getIssuer", "getScope", "getSessionCookieName", "getSessionTimeout", "()Ljava/time/Duration;", "getTokenEndpoint", "getUserInfoEndpoint", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "keel-ec2-api"})
    public static final class AuthenticateOidcActionConfig {
        @NotNull
        private final String issuer;
        @NotNull
        private final String authorizationEndpoint;
        @NotNull
        private final String tokenEndpoint;
        @NotNull
        private final String userInfoEndpoint;
        @NotNull
        private final String clientId;
        @NotNull
        private final String sessionCookieName;
        @NotNull
        private final String scope;
        @NotNull
        private final Duration sessionTimeout;
        @NotNull
        private final Map<String, Object> authenticationRequestExtraParams;

        @NotNull
        public final String getIssuer() {
            return this.issuer;
        }

        @NotNull
        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @NotNull
        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        @NotNull
        public final String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getSessionCookieName() {
            return this.sessionCookieName;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final Duration getSessionTimeout() {
            return this.sessionTimeout;
        }

        @NotNull
        public final Map<String, Object> getAuthenticationRequestExtraParams() {
            return this.authenticationRequestExtraParams;
        }

        public AuthenticateOidcActionConfig(@NotNull String issuer, @NotNull String authorizationEndpoint, @NotNull String tokenEndpoint, @NotNull String userInfoEndpoint, @NotNull String clientId, @NotNull String sessionCookieName, @NotNull String scope, @NotNull Duration sessionTimeout, @NotNull Map<String, ? extends Object> authenticationRequestExtraParams) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)authorizationEndpoint, (String)"authorizationEndpoint");
            Intrinsics.checkNotNullParameter((Object)tokenEndpoint, (String)"tokenEndpoint");
            Intrinsics.checkNotNullParameter((Object)userInfoEndpoint, (String)"userInfoEndpoint");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)sessionCookieName, (String)"sessionCookieName");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)sessionTimeout, (String)"sessionTimeout");
            Intrinsics.checkNotNullParameter(authenticationRequestExtraParams, (String)"authenticationRequestExtraParams");
            this.issuer = issuer;
            this.authorizationEndpoint = authorizationEndpoint;
            this.tokenEndpoint = tokenEndpoint;
            this.userInfoEndpoint = userInfoEndpoint;
            this.clientId = clientId;
            this.sessionCookieName = sessionCookieName;
            this.scope = scope;
            this.sessionTimeout = sessionTimeout;
            this.authenticationRequestExtraParams = authenticationRequestExtraParams;
        }

        public /* synthetic */ AuthenticateOidcActionConfig(String string, String string2, String string3, String string4, String string5, String string6, String string7, Duration duration, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x100) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, string2, string3, string4, string5, string6, string7, duration, map);
        }

        @NotNull
        public final String component1() {
            return this.issuer;
        }

        @NotNull
        public final String component2() {
            return this.authorizationEndpoint;
        }

        @NotNull
        public final String component3() {
            return this.tokenEndpoint;
        }

        @NotNull
        public final String component4() {
            return this.userInfoEndpoint;
        }

        @NotNull
        public final String component5() {
            return this.clientId;
        }

        @NotNull
        public final String component6() {
            return this.sessionCookieName;
        }

        @NotNull
        public final String component7() {
            return this.scope;
        }

        @NotNull
        public final Duration component8() {
            return this.sessionTimeout;
        }

        @NotNull
        public final Map<String, Object> component9() {
            return this.authenticationRequestExtraParams;
        }

        @NotNull
        public final AuthenticateOidcActionConfig copy(@NotNull String issuer, @NotNull String authorizationEndpoint, @NotNull String tokenEndpoint, @NotNull String userInfoEndpoint, @NotNull String clientId, @NotNull String sessionCookieName, @NotNull String scope, @NotNull Duration sessionTimeout, @NotNull Map<String, ? extends Object> authenticationRequestExtraParams) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)authorizationEndpoint, (String)"authorizationEndpoint");
            Intrinsics.checkNotNullParameter((Object)tokenEndpoint, (String)"tokenEndpoint");
            Intrinsics.checkNotNullParameter((Object)userInfoEndpoint, (String)"userInfoEndpoint");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)sessionCookieName, (String)"sessionCookieName");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)sessionTimeout, (String)"sessionTimeout");
            Intrinsics.checkNotNullParameter(authenticationRequestExtraParams, (String)"authenticationRequestExtraParams");
            return new AuthenticateOidcActionConfig(issuer, authorizationEndpoint, tokenEndpoint, userInfoEndpoint, clientId, sessionCookieName, scope, sessionTimeout, authenticationRequestExtraParams);
        }

        public static /* synthetic */ AuthenticateOidcActionConfig copy$default(AuthenticateOidcActionConfig authenticateOidcActionConfig, String string, String string2, String string3, String string4, String string5, String string6, String string7, Duration duration, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = authenticateOidcActionConfig.issuer;
            }
            if ((n & 2) != 0) {
                string2 = authenticateOidcActionConfig.authorizationEndpoint;
            }
            if ((n & 4) != 0) {
                string3 = authenticateOidcActionConfig.tokenEndpoint;
            }
            if ((n & 8) != 0) {
                string4 = authenticateOidcActionConfig.userInfoEndpoint;
            }
            if ((n & 0x10) != 0) {
                string5 = authenticateOidcActionConfig.clientId;
            }
            if ((n & 0x20) != 0) {
                string6 = authenticateOidcActionConfig.sessionCookieName;
            }
            if ((n & 0x40) != 0) {
                string7 = authenticateOidcActionConfig.scope;
            }
            if ((n & 0x80) != 0) {
                duration = authenticateOidcActionConfig.sessionTimeout;
            }
            if ((n & 0x100) != 0) {
                map = authenticateOidcActionConfig.authenticationRequestExtraParams;
            }
            return authenticateOidcActionConfig.copy(string, string2, string3, string4, string5, string6, string7, duration, map);
        }

        @NotNull
        public String toString() {
            return "AuthenticateOidcActionConfig(issuer=" + this.issuer + ", authorizationEndpoint=" + this.authorizationEndpoint + ", tokenEndpoint=" + this.tokenEndpoint + ", userInfoEndpoint=" + this.userInfoEndpoint + ", clientId=" + this.clientId + ", sessionCookieName=" + this.sessionCookieName + ", scope=" + this.scope + ", sessionTimeout=" + this.sessionTimeout + ", authenticationRequestExtraParams=" + this.authenticationRequestExtraParams + ")";
        }

        public int hashCode() {
            String string = this.issuer;
            String string2 = this.authorizationEndpoint;
            String string3 = this.tokenEndpoint;
            String string4 = this.userInfoEndpoint;
            String string5 = this.clientId;
            String string6 = this.sessionCookieName;
            String string7 = this.scope;
            Duration duration = this.sessionTimeout;
            Map<String, Object> map = this.authenticationRequestExtraParams;
            return ((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AuthenticateOidcActionConfig)) break block3;
                    AuthenticateOidcActionConfig authenticateOidcActionConfig = (AuthenticateOidcActionConfig)object;
                    if (!Intrinsics.areEqual((Object)this.issuer, (Object)authenticateOidcActionConfig.issuer) || !Intrinsics.areEqual((Object)this.authorizationEndpoint, (Object)authenticateOidcActionConfig.authorizationEndpoint) || !Intrinsics.areEqual((Object)this.tokenEndpoint, (Object)authenticateOidcActionConfig.tokenEndpoint) || !Intrinsics.areEqual((Object)this.userInfoEndpoint, (Object)authenticateOidcActionConfig.userInfoEndpoint) || !Intrinsics.areEqual((Object)this.clientId, (Object)authenticateOidcActionConfig.clientId) || !Intrinsics.areEqual((Object)this.sessionCookieName, (Object)authenticateOidcActionConfig.sessionCookieName) || !Intrinsics.areEqual((Object)this.scope, (Object)authenticateOidcActionConfig.scope) || !Intrinsics.areEqual((Object)this.sessionTimeout, (Object)authenticateOidcActionConfig.sessionTimeout) || !Intrinsics.areEqual(this.authenticationRequestExtraParams, authenticateOidcActionConfig.authenticationRequestExtraParams)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

