/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AliasConfiguration;
import com.amazonaws.services.lambda.model.AliasRoutingConfiguration;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateAliasResult;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateAliasResult;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.UpsertLambdaFunctionAliasDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UpsertLambdaAliasAtomicOperation
extends AbstractLambdaAtomicOperation<UpsertLambdaFunctionAliasDescription, Object>
implements AtomicOperation<Object> {
    public UpsertLambdaAliasAtomicOperation(UpsertLambdaFunctionAliasDescription description) {
        super(description, "UPSERT_LAMBDA_FUNCTION_ALIAS");
    }

    public Object operate(List priorOutputs) {
        String functionName = ((UpsertLambdaFunctionAliasDescription)this.description).getFunctionName();
        String region = ((UpsertLambdaFunctionAliasDescription)this.description).getRegion();
        String account = ((UpsertLambdaFunctionAliasDescription)this.description).getAccount();
        LambdaFunction cache = (LambdaFunction)this.lambdaFunctionProvider.getFunction(account, region, functionName);
        List<AliasConfiguration> aliasConfigurations = cache.getAliasConfigurations();
        boolean aliasExists = false;
        for (AliasConfiguration aliasConfiguration : aliasConfigurations) {
            if (!aliasConfiguration.getName().equalsIgnoreCase(((UpsertLambdaFunctionAliasDescription)this.description).getAliasName())) continue;
            aliasExists = true;
        }
        return aliasExists ? this.updateAliasResult(cache) : this.createAliasResult(cache);
    }

    private UpdateAliasResult updateAliasResult(LambdaFunction cache) {
        this.updateTaskStatus("Initializing Updating of AWS Lambda Function Alias Operation...");
        LinkedHashMap<String, Double> routingConfig = new LinkedHashMap<String, Double>();
        String minorFunctionVersion = ((UpsertLambdaFunctionAliasDescription)this.description).getMinorFunctionVersion();
        Double weightToMinorFunctionVersion = ((UpsertLambdaFunctionAliasDescription)this.description).getWeightToMinorFunctionVersion();
        if (StringUtils.isNotEmpty((CharSequence)minorFunctionVersion) && weightToMinorFunctionVersion != null) {
            routingConfig.put(((UpsertLambdaFunctionAliasDescription)this.description).getMinorFunctionVersion(), ((UpsertLambdaFunctionAliasDescription)this.description).getWeightToMinorFunctionVersion());
        }
        AWSLambda client = this.getLambdaClient();
        UpdateAliasRequest request = new UpdateAliasRequest().withFunctionName(cache.getFunctionArn()).withDescription(((UpsertLambdaFunctionAliasDescription)this.description).getAliasDescription()).withFunctionVersion(((UpsertLambdaFunctionAliasDescription)this.description).getMajorFunctionVersion()).withName(((UpsertLambdaFunctionAliasDescription)this.description).getAliasName()).withRoutingConfig(new AliasRoutingConfiguration().withAdditionalVersionWeights(routingConfig));
        UpdateAliasResult result = client.updateAlias(request);
        this.updateTaskStatus("Finished Updating of AWS Lambda Function Alias Operation...");
        return result;
    }

    private CreateAliasResult createAliasResult(LambdaFunction cache) {
        this.updateTaskStatus("Initializing Creation of AWS Lambda Function Alias Operation...");
        LinkedHashMap<String, Double> routingConfig = new LinkedHashMap<String, Double>();
        String minorFunctionVersion = ((UpsertLambdaFunctionAliasDescription)this.description).getMinorFunctionVersion();
        Double weightToMinorFunctionVersion = ((UpsertLambdaFunctionAliasDescription)this.description).getWeightToMinorFunctionVersion();
        if (StringUtils.isNotEmpty((CharSequence)minorFunctionVersion) && weightToMinorFunctionVersion != null) {
            routingConfig.put(((UpsertLambdaFunctionAliasDescription)this.description).getMinorFunctionVersion(), ((UpsertLambdaFunctionAliasDescription)this.description).getWeightToMinorFunctionVersion());
        }
        AWSLambda client = this.getLambdaClient();
        CreateAliasRequest request = new CreateAliasRequest().withFunctionName(cache.getFunctionArn()).withDescription(((UpsertLambdaFunctionAliasDescription)this.description).getAliasDescription()).withFunctionVersion(((UpsertLambdaFunctionAliasDescription)this.description).getMajorFunctionVersion()).withName(((UpsertLambdaFunctionAliasDescription)this.description).getAliasName()).withRoutingConfig(new AliasRoutingConfiguration().withAdditionalVersionWeights(routingConfig));
        CreateAliasResult result = client.createAlias(request);
        this.updateTaskStatus("Finished Creation of AWS Lambda Function Alias Operation...");
        return result;
    }
}

