/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.PublishVersionResult;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.PublishLambdaFunctionVersionDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class PublishLambdaAtomicOperation
extends AbstractLambdaAtomicOperation<PublishLambdaFunctionVersionDescription, PublishVersionResult>
implements AtomicOperation<PublishVersionResult> {
    public PublishLambdaAtomicOperation(PublishLambdaFunctionVersionDescription description) {
        super(description, "PUBLISH_LAMBDA_FUNCTION_VERSION");
    }

    public PublishVersionResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Atomic Operation AWS Lambda for PublishVersion...");
        return this.publishFunctionVersion(((PublishLambdaFunctionVersionDescription)this.description).getFunctionName(), ((PublishLambdaFunctionVersionDescription)this.description).getDescription(), ((PublishLambdaFunctionVersionDescription)this.description).getRevisionId());
    }

    private PublishVersionResult publishFunctionVersion(String functionName, String description, String revisionId) {
        AWSLambda client = this.getLambdaClient();
        PublishVersionRequest req = new PublishVersionRequest().withFunctionName(functionName).withDescription(description).withRevisionId(revisionId);
        PublishVersionResult result = client.publishVersion(req);
        this.updateTaskStatus("Finished Atomic Operation AWS Lambda for PublishVersion...");
        return result;
    }
}

