/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.specto.hoverfly.junit.core.model.RequestFieldMatcher;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class BodyRequestMatcherCustomDeserializer
extends JsonDeserializer<List<RequestFieldMatcher>> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<RequestFieldMatcher> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        CollectionType matcherType = deserializationContext.getTypeFactory().constructCollectionType(List.class, RequestFieldMatcher.class);
        List matchers = (List)deserializationContext.readValue(jsonParser, (JavaType)matcherType);
        matchers.stream().filter(matcher -> matcher.getMatcher() == RequestFieldMatcher.MatcherType.FORM).forEach(formMatcher -> {
            try {
                String rawFormMatcherValue = this.objectMapper.writeValueAsString(formMatcher.getValue());
                Map formMatcherValue = (Map)this.objectMapper.readValue(rawFormMatcherValue, (TypeReference)new TypeReference<Map<String, List<RequestFieldMatcher>>>(){});
                formMatcher.setValue(formMatcherValue);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return matchers;
    }
}

