/*
 * Decompiled with CFR 0.152.
 */
package io.socket.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Url {
    private static Pattern PATTERN_HTTP = Pattern.compile("^http|ws$");
    private static Pattern PATTERN_HTTPS = Pattern.compile("^(http|ws)s$");
    private static Pattern PATTERN_AUTHORITY = Pattern.compile("^(.*@)?([^:]+)(:\\d+)?$");

    private Url() {
    }

    public static URL parse(String uri) throws URISyntaxException {
        return Url.parse(new URI(uri));
    }

    public static URL parse(URI uri) {
        String path;
        int port;
        String protocol = uri.getScheme();
        if (protocol == null || !protocol.matches("^https?|wss?$")) {
            protocol = "https";
        }
        if ((port = uri.getPort()) == -1) {
            if (PATTERN_HTTP.matcher(protocol).matches()) {
                port = 80;
            } else if (PATTERN_HTTPS.matcher(protocol).matches()) {
                port = 443;
            }
        }
        if ((path = uri.getRawPath()) == null || path.length() == 0) {
            path = "/";
        }
        String userInfo = uri.getRawUserInfo();
        String query = uri.getRawQuery();
        String fragment = uri.getRawFragment();
        String _host = uri.getHost();
        if (_host == null) {
            _host = Url.extractHostFromAuthorityPart(uri.getRawAuthority());
        }
        try {
            return new URL(protocol + "://" + (userInfo != null ? userInfo + "@" : "") + _host + (port != -1 ? ":" + port : "") + path + (query != null ? "?" + query : "") + (fragment != null ? "#" + fragment : ""));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String extractId(String url) throws MalformedURLException {
        return Url.extractId(new URL(url));
    }

    public static String extractId(URL url) {
        String protocol = url.getProtocol();
        int port = url.getPort();
        if (port == -1) {
            if (PATTERN_HTTP.matcher(protocol).matches()) {
                port = 80;
            } else if (PATTERN_HTTPS.matcher(protocol).matches()) {
                port = 443;
            }
        }
        return protocol + "://" + url.getHost() + ":" + port;
    }

    private static String extractHostFromAuthorityPart(String authority) {
        if (authority == null) {
            throw new RuntimeException("unable to parse the host from the authority");
        }
        Matcher matcher = PATTERN_AUTHORITY.matcher(authority);
        if (!matcher.matches()) {
            throw new RuntimeException("unable to parse the host from the authority");
        }
        return matcher.group(2);
    }
}

