/*
 * Decompiled with CFR 0.152.
 */
package io.socket.parser;

import io.socket.emitter.Emitter;
import io.socket.parser.Binary;
import io.socket.parser.Packet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONTokener;

public class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class.getName());
    public static final int CONNECT = 0;
    public static final int DISCONNECT = 1;
    public static final int EVENT = 2;
    public static final int ACK = 3;
    public static final int ERROR = 4;
    public static final int BINARY_EVENT = 5;
    public static final int BINARY_ACK = 6;
    public static int protocol = 4;
    public static String[] types = new String[]{"CONNECT", "DISCONNECT", "EVENT", "ACK", "ERROR", "BINARY_EVENT", "BINARY_ACK"};

    private Parser() {
    }

    private static Packet<String> error() {
        return new Packet<String>(4, "parser error");
    }

    static class BinaryReconstructor {
        public Packet reconPack;
        List<byte[]> buffers;

        BinaryReconstructor(Packet packet) {
            this.reconPack = packet;
            this.buffers = new ArrayList<byte[]>();
        }

        public Packet takeBinaryData(byte[] binData) {
            this.buffers.add(binData);
            if (this.buffers.size() == this.reconPack.attachments) {
                Packet packet = Binary.reconstructPacket(this.reconPack, (byte[][])this.buffers.toArray((T[])new byte[this.buffers.size()][]));
                this.finishReconstruction();
                return packet;
            }
            return null;
        }

        public void finishReconstruction() {
            this.reconPack = null;
            this.buffers = new ArrayList<byte[]>();
        }
    }

    public static class Decoder
    extends Emitter {
        public static String EVENT_DECODED = "decoded";
        BinaryReconstructor reconstructor = null;

        public void add(String obj) {
            Packet packet = Decoder.decodeString(obj);
            if (5 == packet.type || 6 == packet.type) {
                this.reconstructor = new BinaryReconstructor(packet);
                if (this.reconstructor.reconPack.attachments == 0) {
                    this.emit(EVENT_DECODED, new Object[]{packet});
                }
            } else {
                this.emit(EVENT_DECODED, new Object[]{packet});
            }
        }

        public void add(byte[] obj) {
            if (this.reconstructor == null) {
                throw new RuntimeException("got binary data when not reconstructing a packet");
            }
            Packet packet = this.reconstructor.takeBinaryData(obj);
            if (packet != null) {
                this.reconstructor = null;
                this.emit(EVENT_DECODED, new Object[]{packet});
            }
        }

        private static Packet decodeString(String str) {
            Character next;
            Packet p = new Packet();
            int i = 0;
            int length = str.length();
            p.type = Character.getNumericValue(str.charAt(0));
            if (p.type < 0 || p.type > types.length - 1) {
                return Parser.error();
            }
            if (5 == p.type || 6 == p.type) {
                if (!str.contains("-") || length <= i + 1) {
                    return Parser.error();
                }
                StringBuilder attachments = new StringBuilder();
                while (str.charAt(++i) != '-') {
                    attachments.append(str.charAt(i));
                }
                p.attachments = Integer.parseInt(attachments.toString());
            }
            if (length > i + 1 && '/' == str.charAt(i + 1)) {
                char c;
                StringBuilder nsp = new StringBuilder();
                while (',' != (c = str.charAt(++i))) {
                    nsp.append(c);
                    if (i + 1 != length) continue;
                    break;
                }
                p.nsp = nsp.toString();
            } else {
                p.nsp = "/";
            }
            if (length > i + 1 && Character.getNumericValue((next = Character.valueOf(str.charAt(i + 1))).charValue()) > -1) {
                StringBuilder id = new StringBuilder();
                do {
                    char c;
                    if (Character.getNumericValue(c = str.charAt(++i)) < 0) {
                        --i;
                        break;
                    }
                    id.append(c);
                } while (i + 1 != length);
                try {
                    p.id = Integer.parseInt(id.toString());
                }
                catch (NumberFormatException e) {
                    return Parser.error();
                }
            }
            if (length > i + 1) {
                try {
                    str.charAt(++i);
                    p.data = new JSONTokener(str.substring(i)).nextValue();
                }
                catch (JSONException e) {
                    return Parser.error();
                }
            }
            logger.fine(String.format("decoded %s as %s", str, p));
            return p;
        }

        public void destroy() {
            if (this.reconstructor != null) {
                this.reconstructor.finishReconstruction();
            }
        }
    }

    public static class Encoder {
        public void encode(Packet obj, Callback callback) {
            logger.fine(String.format("encoding packet %s", obj));
            if (5 == obj.type || 6 == obj.type) {
                this.encodeAsBinary(obj, callback);
            } else {
                String encoding = this.encodeAsString(obj);
                callback.call(new String[]{encoding});
            }
        }

        private String encodeAsString(Packet obj) {
            StringBuilder str = new StringBuilder();
            boolean nsp = false;
            str.append(obj.type);
            if (5 == obj.type || 6 == obj.type) {
                str.append(obj.attachments);
                str.append("-");
            }
            if (obj.nsp != null && obj.nsp.length() != 0 && !"/".equals(obj.nsp)) {
                nsp = true;
                str.append(obj.nsp);
            }
            if (obj.id >= 0) {
                if (nsp) {
                    str.append(",");
                    nsp = false;
                }
                str.append(obj.id);
            }
            if (obj.data != null) {
                if (nsp) {
                    str.append(",");
                }
                str.append(obj.data);
            }
            logger.fine(String.format("encoded %s as %s", obj, str));
            return str.toString();
        }

        private void encodeAsBinary(Packet obj, Callback callback) {
            Binary.DeconstructedPacket deconstruction = Binary.deconstructPacket(obj);
            String pack = this.encodeAsString(deconstruction.packet);
            ArrayList buffers = new ArrayList(Arrays.asList(deconstruction.buffers));
            buffers.add(0, pack);
            callback.call(buffers.toArray());
        }

        public static interface Callback {
            public void call(Object[] var1);
        }
    }
}

