/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.beans.Introspector;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ParameterProcessor {
    private static final Logger LOG = Logger.getLogger(ParameterProcessor.class);
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)\\}");
    private static Comparator<Parameter> parameterComparator = Comparator.comparing(Parameter::getIn).thenComparing(Parameter::getName);
    private static Set<DotName> openApiParameterAnnotations = new HashSet<DotName>(Arrays.asList(OpenApiConstants.DOTNAME_PARAMETER, OpenApiConstants.DOTNAME_PARAMETERS));
    private final IndexView index;
    private final Function<AnnotationInstance, ParameterImpl> reader;
    private final List<AnnotationScannerExtension> extensions;
    private Map<ParameterContextKey, ParameterContext> params = new HashMap<ParameterContextKey, ParameterContext>();
    private Map<String, AnnotationInstance> formParams = new LinkedHashMap<String, AnnotationInstance>();
    private String formMediaType;
    private Map<String, Map<String, AnnotationInstance>> matrixParams = new LinkedHashMap<String, Map<String, AnnotationInstance>>();
    private Set<String> processedMatrixSegments = new HashSet<String>();

    private ParameterProcessor(IndexView index, Function<AnnotationInstance, ParameterImpl> reader, List<AnnotationScannerExtension> extensions) {
        this.index = index;
        this.reader = reader;
        this.extensions = extensions;
    }

    public static ResourceParameters process(IndexView index, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, ParameterImpl> reader, List<AnnotationScannerExtension> extensions) {
        ResourceParameters parameters = new ResourceParameters();
        ParameterProcessor processor = new ParameterProcessor(index, reader, extensions);
        ClassInfo resourceMethodClass = resourceMethod.declaringClass();
        processor.readParametersInherited(resourceMethodClass, null, false);
        if (!resourceClass.equals(resourceMethodClass)) {
            processor.readParameters(resourceClass, null, true);
        }
        parameters.setPathItemParameters(processor.getParameters(resourceMethod));
        processor.reset();
        resourceMethod.annotations().stream().filter(a -> !a.target().equals(resourceMethod)).forEach(annotation -> {
            if (openApiParameterAnnotations.contains(annotation.name())) {
                processor.readParameterAnnotation((AnnotationInstance)annotation);
            } else {
                processor.readAnnotatedType((AnnotationInstance)annotation);
            }
        });
        resourceMethod.annotations().stream().filter(a -> a.target().equals(resourceMethod)).filter(a -> openApiParameterAnnotations.contains(a.name())).forEach(processor::readParameterAnnotation);
        parameters.setOperationParameters(processor.getParameters(resourceMethod));
        List<Parameter> allParameters = parameters.getAllParameters();
        parameters.setPathItemPath(processor.generatePath((AnnotationTarget)resourceClass, allParameters));
        parameters.setOperationPath(processor.generatePath((AnnotationTarget)resourceMethod, allParameters));
        parameters.sort();
        parameters.setFormBodyContent(processor.getFormBodyContent());
        return parameters;
    }

    private void reset() {
        this.params.clear();
        this.formParams.clear();
        this.matrixParams.clear();
    }

    String generatePath(AnnotationTarget target, List<Parameter> parameters) {
        StringBuilder path = new StringBuilder(ParameterProcessor.pathOf(target));
        if (path.length() > 0) {
            path.insert(0, '/');
        }
        Matcher templateMatcher = TEMPLATE_PARAM_PATTERN.matcher(path);
        while (templateMatcher.find()) {
            String variableName = templateMatcher.group(1).trim();
            String variablePattern = templateMatcher.group(2).trim();
            parameters.stream().filter(p -> variableName.equals(p.getName())).filter(ParameterProcessor::templateParameterPatternEligible).forEach(p -> p.getSchema().setPattern(variablePattern));
            String replacement = templateMatcher.replaceFirst('{' + variableName + '}');
            path.setLength(0);
            path.append(replacement);
            templateMatcher = TEMPLATE_PARAM_PATTERN.matcher(path);
        }
        parameters.stream().filter(p -> Parameter.Style.MATRIX.equals((Object)p.getStyle())).filter(p -> !this.processedMatrixSegments.contains(p.getName())).filter(p -> path.indexOf(p.getName()) > -1).forEach(matrix -> {
            String segmentName = matrix.getName();
            this.processedMatrixSegments.add(segmentName);
            String matrixRef = '{' + segmentName + '}';
            int insertIndex = -1;
            insertIndex = path.lastIndexOf(matrixRef);
            if (insertIndex > -1) {
                insertIndex += matrixRef.length();
                String generatedName = segmentName + "Matrix";
                matrix.setName(generatedName);
                matrixRef = '{' + generatedName + '}';
            } else {
                insertIndex = path.lastIndexOf(segmentName);
                if (insertIndex > -1) {
                    insertIndex += segmentName.length();
                }
            }
            if (insertIndex > -1) {
                path.insert(insertIndex, matrixRef);
            } else {
                LOG.warnf("Matrix parameter references missing path segment: %s", (Object)segmentName);
            }
        });
        return path.toString();
    }

    static boolean templateParameterPatternEligible(Parameter param) {
        return Parameter.In.PATH.equals((Object)param.getIn()) && !Parameter.Style.MATRIX.equals((Object)param.getStyle()) && param.getSchema() != null && Schema.SchemaType.STRING.equals((Object)param.getSchema().getType()) && param.getSchema().getPattern() == null;
    }

    private List<Parameter> getParameters(MethodInfo resourceMethod) {
        ArrayList parameters = new ArrayList();
        for (Map.Entry<String, Map<String, AnnotationInstance>> matrixPath : this.matrixParams.entrySet()) {
            String segmentName = matrixPath.getKey();
            ParameterContext context2 = this.params.values().stream().filter(p -> p.oaiParam != null).filter(p -> p.oaiParam.getStyle() == Parameter.Style.MATRIX).filter(p -> segmentName.equals(p.name)).findFirst().orElseGet(() -> {
                ParameterContext generated = new ParameterContext();
                generated.name = segmentName;
                generated.location = Parameter.In.PATH;
                generated.style = Parameter.Style.MATRIX;
                generated.jaxRsParam = JaxRsParameter.MATRIX_PARAM;
                generated.target = null;
                generated.targetType = null;
                generated.oaiParam = new ParameterImpl();
                generated.oaiParam.setStyle(Parameter.Style.MATRIX);
                generated.oaiParam.setExplode(Boolean.TRUE);
                this.params.put(new ParameterContextKey(generated), generated);
                return generated;
            });
            List<Schema> schemas = ModelUtil.getParameterSchemas(context2.oaiParam);
            if (schemas.isEmpty()) {
                SchemaImpl schema = new SchemaImpl();
                schema.setType(Schema.SchemaType.OBJECT);
                ModelUtil.setParameterSchema(context2.oaiParam, schema);
                schemas = Arrays.asList(schema);
            }
            for (Schema schema : schemas) {
                this.setSchemaProperties(schema, Collections.emptyMap(), matrixPath.getValue());
            }
        }
        this.params.values().stream().forEach(context -> {
            ParameterImpl param = context.oaiParam == null ? new ParameterImpl() : context.oaiParam;
            param.setName(context.name);
            if (param.getIn() == null && context.location != null) {
                param.setIn(context.location);
            }
            if (ParameterProcessor.isIgnoredParameter(param, (AnnotationTarget)resourceMethod)) {
                return;
            }
            if (param.getIn() == Parameter.In.PATH) {
                param.setRequired(true);
            }
            if (param.getStyle() == null && context.jaxRsParam != null) {
                param.setStyle(context.jaxRsParam.style);
            }
            if (!ModelUtil.parameterHasSchema(param) && context.targetType != null) {
                Schema schema = SchemaFactory.typeToSchema(this.index, context.targetType, this.extensions);
                ModelUtil.setParameterSchema(param, schema);
            }
            if (param.getDeprecated() == null && TypeUtil.hasAnnotation(context.target, OpenApiConstants.DOTNAME_DEPRECATED)) {
                param.setDeprecated(Boolean.TRUE);
            }
            if (param.getSchema() != null) {
                BeanValidationScanner.applyConstraints(context.target, param.getSchema(), param.getName(), (target, name) -> {
                    if (param.getRequired() == null) {
                        param.setRequired(Boolean.TRUE);
                    }
                });
                if (param.getSchema().getDefaultValue() == null) {
                    param.getSchema().setDefaultValue(context.jaxRsDefaultValue);
                }
            }
            if (param.getRequired() == null && TypeUtil.isOptional(context.targetType)) {
                param.setRequired(Boolean.FALSE);
            }
            parameters.add(param);
        });
        return parameters.isEmpty() ? null : parameters.stream().sorted(Comparator.comparing(Parameter::getIn).thenComparing(Parameter::getName)).collect(Collectors.toList());
    }

    private Content getFormBodyContent() {
        if (this.formParams.isEmpty()) {
            return null;
        }
        ContentImpl content = new ContentImpl();
        MediaTypeImpl mediaType = new MediaTypeImpl();
        SchemaImpl schema = new SchemaImpl();
        HashMap<String, Encoding> encodings = new HashMap<String, Encoding>();
        schema.setType(Schema.SchemaType.OBJECT);
        mediaType.setSchema(schema);
        this.setSchemaProperties(schema, encodings, this.formParams);
        if (encodings.size() > 0) {
            mediaType.setEncoding(encodings);
        }
        String mediaTypeName = this.formMediaType != null ? this.formMediaType : "application/x-www-form-urlencoded";
        content.addMediaType(mediaTypeName, mediaType);
        return content;
    }

    void setSchemaProperties(Schema schema, Map<String, Encoding> encodings, Map<String, AnnotationInstance> params) {
        for (Map.Entry<String, AnnotationInstance> param : params.entrySet()) {
            String paramName = param.getKey();
            AnnotationTarget paramTarget = param.getValue().target();
            ParameterProcessor.addEncoding(encodings, paramName, paramTarget);
            Type paramType = ParameterProcessor.getType(paramTarget);
            Schema paramSchema = SchemaFactory.typeToSchema(this.index, paramType, this.extensions);
            Object defaultValue = ParameterProcessor.getDefaultValue(paramTarget);
            if (paramSchema.getDefaultValue() == null) {
                paramSchema.setDefaultValue(defaultValue);
            }
            BeanValidationScanner.applyConstraints(paramTarget, paramSchema, paramName, (target, name) -> {
                List requiredProperties = schema.getRequired();
                if (requiredProperties == null || !requiredProperties.contains(name)) {
                    schema.addRequired(name);
                }
            });
            if (paramSchema.getNullable() == null && TypeUtil.isOptional(paramType)) {
                paramSchema.setNullable(Boolean.TRUE);
            }
            if (schema.getProperties() != null) {
                paramSchema = MergeUtil.mergeObjects(schema.getProperties().get(paramName), paramSchema);
            }
            schema.addProperty(paramName, paramSchema);
        }
    }

    static void addEncoding(Map<String, Encoding> encodings, String paramName, AnnotationTarget paramTarget) {
        if (paramTarget == null) {
            return;
        }
        AnnotationInstance type = TypeUtil.getAnnotation(paramTarget, OpenApiConstants.DOTNAME_RESTEASY_PART_TYPE);
        if (type != null) {
            EncodingImpl encoding = new EncodingImpl();
            encoding.setContentType(type.value().asString());
            encodings.put(paramName, encoding);
        }
    }

    static boolean isIgnoredParameter(ParameterImpl parameter, AnnotationTarget resourceMethod) {
        String paramName = parameter.getName();
        Parameter.In paramIn = parameter.getIn();
        if (paramIn == null) {
            return true;
        }
        if (parameter.isHidden()) {
            return true;
        }
        if ((paramName == null || paramName.trim().isEmpty()) && parameter.getRef() == null) {
            return true;
        }
        if (paramIn == Parameter.In.PATH && !ParameterProcessor.parameterInPath(paramName, parameter.getStyle(), ParameterProcessor.fullPathOf(resourceMethod))) {
            return true;
        }
        if (paramIn == Parameter.In.HEADER && paramName != null) {
            switch (paramName.toUpperCase()) {
                case "ACCEPT": 
                case "AUTHORIZATION": 
                case "CONTENT-TYPE": {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean parameterInPath(String paramName, Parameter.Style paramStyle, String resourcePath) {
        if (paramName == null || resourcePath == null) {
            return true;
        }
        String regex = Parameter.Style.MATRIX.equals((Object)paramStyle) ? String.format("(?:\\{[ \\t]*|^|/?)\\Q%s\\E(?:[ \\t]*(?:}|:)|/?|$)", paramName) : String.format("\\{[ \\t]*\\Q%s\\E[ \\t]*(?:}|:)", paramName);
        return Pattern.compile(regex).matcher(resourcePath).find();
    }

    void readParameterAnnotation(AnnotationInstance annotation) {
        AnnotationValue annotationValue;
        DotName name = annotation.name();
        if (OpenApiConstants.DOTNAME_PARAMETER.equals((Object)name)) {
            this.readAnnotatedType(annotation, null, false);
        } else if (OpenApiConstants.DOTNAME_PARAMETERS.equals((Object)name) && (annotationValue = annotation.value()) != null) {
            for (AnnotationInstance nested : annotationValue.asNestedArray()) {
                this.readAnnotatedType(AnnotationInstance.create((DotName)nested.name(), (AnnotationTarget)annotation.target(), (List)nested.values()), null, false);
            }
        }
    }

    void readAnnotatedType(AnnotationInstance annotation) {
        this.readAnnotatedType(annotation, null, false);
    }

    void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (OpenApiConstants.DOTNAME_PARAMETER.equals((Object)name)) {
            ParameterImpl oaiParam = this.reader.apply(annotation);
            this.readParameter(new ParameterContextKey(oaiParam.getName(), oaiParam.getIn(), this.styleOf(oaiParam)), oaiParam, null, null, annotation.target(), overriddenParametersOnly);
        } else {
            JaxRsParameter jaxRsParam = JaxRsParameter.forName(name);
            if (jaxRsParam != null) {
                AnnotationTarget target = annotation.target();
                Type targetType = ParameterProcessor.getType(target);
                if (jaxRsParam.style == Parameter.Style.FORM) {
                    this.formParams.put(ParameterProcessor.paramName(annotation), annotation);
                } else if (jaxRsParam.style == Parameter.Style.MATRIX) {
                    String pathSegment;
                    String string = pathSegment = beanParamAnnotation != null ? ParameterProcessor.lastPathSegmentOf(beanParamAnnotation.target()) : ParameterProcessor.lastPathSegmentOf(target);
                    if (!this.matrixParams.containsKey(pathSegment)) {
                        this.matrixParams.put(pathSegment, new HashMap());
                    }
                    this.matrixParams.get(pathSegment).put(ParameterProcessor.paramName(annotation), annotation);
                } else if (jaxRsParam.location == Parameter.In.PATH && targetType != null && OpenApiConstants.DOTNAME_PATH_SEGMENT.equals((Object)targetType.name())) {
                    String pathSegment = (String)JandexUtil.value(annotation, "value");
                    if (!this.matrixParams.containsKey(pathSegment)) {
                        this.matrixParams.put(pathSegment, new HashMap());
                    }
                } else if (jaxRsParam.location != null) {
                    this.readParameter(new ParameterContextKey(ParameterProcessor.paramName(annotation), jaxRsParam.location, jaxRsParam.defaultStyle), null, jaxRsParam, ParameterProcessor.getDefaultValue(target), target, overriddenParametersOnly);
                } else if (target != null) {
                    this.setMediaType(jaxRsParam);
                    if (TypeUtil.isOptional(targetType)) {
                        targetType = TypeUtil.getOptionalType(targetType);
                    }
                    if (targetType != null) {
                        ClassInfo beanParam = this.index.getClassByName(targetType.name());
                        this.readParametersInherited(beanParam, annotation, overriddenParametersOnly);
                    }
                }
            }
        }
    }

    Parameter.Style styleOf(Parameter param) {
        if (param.getStyle() != null) {
            return param.getStyle();
        }
        if (param.getIn() != null) {
            switch (param.getIn()) {
                case COOKIE: 
                case QUERY: {
                    return Parameter.Style.FORM;
                }
                case HEADER: 
                case PATH: {
                    return Parameter.Style.SIMPLE;
                }
            }
        }
        return null;
    }

    private void setMediaType(JaxRsParameter jaxRsParam) {
        if (jaxRsParam.mediaType != null && this.formMediaType == null) {
            this.formMediaType = jaxRsParam.mediaType;
        }
    }

    static String paramName(AnnotationInstance annotation) {
        AnnotationValue value = annotation.value();
        String valueString = null;
        if (value != null && (valueString = value.asString()).length() > 0) {
            return valueString;
        }
        AnnotationTarget target = annotation.target();
        switch (target.kind()) {
            case FIELD: {
                valueString = target.asField().name();
                break;
            }
            case METHOD_PARAMETER: {
                valueString = target.asMethodParameter().name();
                break;
            }
            case METHOD: {
                MethodInfo method = target.asMethod();
                if (method.parameters().size() != 1) break;
                String methodName = method.name();
                if (methodName.startsWith("set")) {
                    valueString = Introspector.decapitalize(methodName.substring(3));
                    break;
                }
                valueString = methodName;
                break;
            }
        }
        return valueString;
    }

    static Object getDefaultValue(AnnotationTarget target) {
        AnnotationInstance defaultValueAnno = TypeUtil.getAnnotation(target, OpenApiConstants.DOTNAME_DEFAULT_VALUE);
        Object defaultValue = null;
        if (defaultValueAnno != null) {
            PrimitiveType.Primitive primitive;
            Object primitiveValue;
            String defaultValueString = JandexUtil.stringValue(defaultValueAnno, "value");
            defaultValue = defaultValueString;
            Type targetType = ParameterProcessor.getType(target);
            if (targetType != null && targetType.kind() == Type.Kind.PRIMITIVE && (primitiveValue = ParameterProcessor.primitiveToObject(primitive = targetType.asPrimitiveType().primitive(), defaultValueString)) != null) {
                defaultValue = primitiveValue;
            }
        }
        return defaultValue;
    }

    static Object primitiveToObject(PrimitiveType.Primitive primitive, String stringValue) {
        Constable value = null;
        try {
            switch (primitive) {
                case BOOLEAN: {
                    value = Boolean.valueOf(Boolean.parseBoolean(stringValue));
                    break;
                }
                case CHAR: {
                    if (stringValue.length() != 1) break;
                    value = Character.valueOf(stringValue.charAt(0));
                    break;
                }
                case BYTE: {
                    byte[] bytes = stringValue.getBytes();
                    if (bytes.length != 1) break;
                    value = bytes[0];
                    break;
                }
                case SHORT: 
                case INT: 
                case LONG: {
                    value = Long.valueOf(stringValue);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    value = Double.valueOf(stringValue);
                }
            }
        }
        catch (Exception e) {
            LOG.warnf("Value '%s' is not a valid %s default", (Object)stringValue, (Object)primitive.name().toLowerCase());
        }
        return value;
    }

    static String lastPathSegmentOf(AnnotationTarget target) {
        String fullPath = ParameterProcessor.fullPathOf(target);
        String lastSegment = null;
        if (fullPath != null && (lastSegment = fullPath.substring(fullPath.lastIndexOf(47) + 1)).startsWith("{") && lastSegment.endsWith("}")) {
            lastSegment = lastSegment.substring(1, lastSegment.length() - 1);
        }
        return lastSegment;
    }

    static String fullPathOf(AnnotationTarget target) {
        String pathSegment = null;
        switch (target.kind()) {
            case FIELD: {
                pathSegment = ParameterProcessor.pathOf((AnnotationTarget)target.asField().declaringClass());
                break;
            }
            case METHOD: {
                pathSegment = ParameterProcessor.methodPath(target.asMethod());
                break;
            }
            case METHOD_PARAMETER: {
                pathSegment = ParameterProcessor.methodPath(target.asMethodParameter().method());
                break;
            }
        }
        return pathSegment;
    }

    static String methodPath(MethodInfo method) {
        String methodPath = ParameterProcessor.pathOf((AnnotationTarget)method);
        String classPath = ParameterProcessor.pathOf((AnnotationTarget)method.declaringClass());
        if (methodPath.isEmpty()) {
            return classPath;
        }
        return classPath + '/' + methodPath;
    }

    static String pathOf(AnnotationTarget target) {
        AnnotationInstance path = null;
        switch (target.kind()) {
            case CLASS: {
                path = target.asClass().classAnnotation(OpenApiConstants.DOTNAME_PATH);
                break;
            }
            case METHOD: {
                path = target.asMethod().annotation(OpenApiConstants.DOTNAME_PATH);
                break;
            }
        }
        if (path != null) {
            String pathValue = path.value().asString();
            if (pathValue.startsWith("/")) {
                pathValue = pathValue.substring(1);
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            return pathValue;
        }
        return "";
    }

    static Type getType(AnnotationTarget target) {
        if (target == null) {
            return null;
        }
        Type type = null;
        switch (target.kind()) {
            case FIELD: {
                type = target.asField().type();
                break;
            }
            case METHOD: {
                List methodParams = target.asMethod().parameters();
                if (methodParams.size() != 1) break;
                type = (Type)methodParams.get(0);
                break;
            }
            case METHOD_PARAMETER: {
                type = JandexUtil.getMethodParameterType(target.asMethodParameter());
                break;
            }
        }
        return type;
    }

    void readParameter(ParameterContextKey key, ParameterImpl oaiParam, JaxRsParameter jaxRsParam, Object jaxRsDefaultValue, AnnotationTarget target, boolean overriddenParametersOnly) {
        boolean oaiNameOverride;
        ParameterContext context = this.getParameterContext(key, target);
        boolean addParam = false;
        if (context == null) {
            if (overriddenParametersOnly) {
                return;
            }
            context = new ParameterContext();
            addParam = true;
        }
        boolean bl = oaiNameOverride = oaiParam != null && key.name != null && !key.name.equals(context.name) && context.location != Parameter.In.PATH;
        if (context.name == null || oaiNameOverride) {
            if (context.name != null) {
                this.params.remove(new ParameterContextKey(context));
                addParam = true;
            }
            context.name = key.name;
        }
        if (context.location == null) {
            context.location = key.location;
        }
        if (context.style == null) {
            context.style = key.style;
        }
        context.oaiParam = MergeUtil.mergeObjects(context.oaiParam, oaiParam);
        if (context.jaxRsParam == null) {
            context.jaxRsParam = jaxRsParam;
            context.jaxRsDefaultValue = jaxRsDefaultValue;
        }
        if (context.target == null || context.target.kind() == AnnotationTarget.Kind.METHOD) {
            context.target = target;
            context.targetType = ParameterProcessor.getType(target);
        }
        if (addParam) {
            this.params.put(new ParameterContextKey(context), context);
        }
    }

    ParameterContext getParameterContext(ParameterContextKey key, AnnotationTarget target) {
        ParameterContext context = this.params.get(key);
        if (context == null) {
            context = this.params.values().stream().filter(c -> this.haveSameAnnotatedTarget((ParameterContext)c, target, key.name)).findFirst().orElse(null);
        }
        if (context == null) {
            context = this.params.values().stream().filter(c -> {
                if (c.location == null || key.location == null) {
                    return Objects.equals(c.name, key.name) && Objects.equals(c.style, key.style);
                }
                return false;
            }).findFirst().orElse(null);
        }
        return context;
    }

    boolean haveSameAnnotatedTarget(ParameterContext context, AnnotationTarget target, String name) {
        boolean nameMatches;
        boolean bl = nameMatches = context.name == null || name == null || Objects.equals(context.name, name);
        if (target.equals(context.target)) {
            return nameMatches || target.kind() != AnnotationTarget.Kind.METHOD;
        }
        if (nameMatches && target.kind() == AnnotationTarget.Kind.METHOD && context.target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            return context.target.asMethodParameter().method().equals((Object)target);
        }
        return false;
    }

    void readParametersInherited(ClassInfo clazz, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        AugmentedIndexView augmentedIndex = new AugmentedIndexView(this.index);
        ArrayList<ClassInfo> ancestors = new ArrayList<ClassInfo>(JandexUtil.inheritanceChain(this.index, clazz, null).keySet());
        Collections.reverse(ancestors);
        ancestors.forEach(c -> {
            c.interfaceTypes().stream().map(augmentedIndex::getClass).filter(Objects::nonNull).forEach(iface -> this.readParameters((ClassInfo)iface, beanParamAnnotation, overriddenParametersOnly));
            this.readParameters((ClassInfo)c, beanParamAnnotation, overriddenParametersOnly);
        });
    }

    void readParameters(ClassInfo clazz, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        for (Map.Entry entry : clazz.annotations().entrySet()) {
            DotName name = (DotName)entry.getKey();
            if (!OpenApiConstants.DOTNAME_PARAMETER.equals((Object)name) && !JaxRsParameter.isParameter(name)) continue;
            for (AnnotationInstance annotation : (List)entry.getValue()) {
                if (!this.isBeanPropertyParam(annotation)) continue;
                this.readAnnotatedType(annotation, beanParamAnnotation, overriddenParametersOnly);
            }
        }
    }

    boolean isBeanPropertyParam(AnnotationInstance annotation) {
        AnnotationTarget target = annotation.target();
        boolean relevant = false;
        switch (target.kind()) {
            case FIELD: {
                FieldInfo field = target.asField();
                relevant = ParameterProcessor.hasParameters(field.annotations());
                break;
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo param = target.asMethodParameter();
                relevant = !ParameterProcessor.isResourceMethod(param.method()) && ParameterProcessor.hasParameters(TypeUtil.getAnnotations((AnnotationTarget)param)) && !this.isSubResourceLocator(param.method());
                break;
            }
            case METHOD: {
                MethodInfo method = target.asMethod();
                relevant = !ParameterProcessor.isResourceMethod(method) && ParameterProcessor.hasParameters(method.annotations()) && ParameterProcessor.getType(target) != null && !this.isSubResourceLocator(method);
                break;
            }
        }
        return relevant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSubResourceLocator(MethodInfo method) {
        if (method.returnType().kind() != Type.Kind.CLASS) return false;
        if (!method.hasAnnotation(OpenApiConstants.DOTNAME_PATH)) return false;
        if (!method.annotations().stream().map(AnnotationInstance::name).noneMatch(OpenApiConstants.DOTNAME_JAXRS_HTTP_METHODS::contains)) return false;
        return true;
    }

    static boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(OpenApiConstants.DOTNAME_JAXRS_HTTP_METHODS::contains);
    }

    static boolean hasParameters(Collection<AnnotationInstance> annotations) {
        return annotations.stream().map(AnnotationInstance::name).anyMatch(ParameterProcessor::isParameter);
    }

    static boolean isParameter(DotName annotationName) {
        if (JaxRsParameter.isParameter(annotationName)) {
            return true;
        }
        if (OpenApiConstants.DOTNAME_PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return OpenApiConstants.DOTNAME_PARAMETERS.equals((Object)annotationName);
    }

    static class ParameterContextKey {
        final String name;
        final Parameter.In location;
        final Parameter.Style style;

        ParameterContextKey(String name, Parameter.In location, Parameter.Style style) {
            this.name = name;
            this.location = location;
            this.style = style;
        }

        ParameterContextKey(ParameterContext context) {
            this.name = context.name;
            this.location = context.location;
            this.style = context.style;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterContextKey) {
                ParameterContextKey other = (ParameterContextKey)obj;
                return Objects.equals(this.name, other.name) && Objects.equals(this.location, other.location) && Objects.equals(this.style, other.style);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.location, this.style);
        }

        public String toString() {
            return "name: " + this.name + "; in: " + this.location;
        }
    }

    static class ParameterContext {
        String name;
        Parameter.In location;
        Parameter.Style style;
        ParameterImpl oaiParam;
        JaxRsParameter jaxRsParam;
        Object jaxRsDefaultValue;
        AnnotationTarget target;
        Type targetType;

        ParameterContext() {
        }

        public String toString() {
            return "name: " + this.name + "; in: " + this.location + "; target: " + this.target;
        }
    }

    public static enum JaxRsParameter {
        PATH_PARAM(OpenApiConstants.DOTNAME_PATH_PARAM, Parameter.In.PATH, null, Parameter.Style.SIMPLE),
        MATRIX_PARAM(OpenApiConstants.DOTNAME_MATRIX_PARAM, Parameter.In.PATH, Parameter.Style.MATRIX, Parameter.Style.MATRIX),
        QUERY_PARAM(OpenApiConstants.DOTNAME_QUERY_PARAM, Parameter.In.QUERY, null, Parameter.Style.FORM),
        FORM_PARAM(OpenApiConstants.DOTNAME_FORM_PARAM, null, Parameter.Style.FORM, Parameter.Style.FORM),
        HEADER_PARAM(OpenApiConstants.DOTNAME_HEADER_PARAM, Parameter.In.HEADER, null, Parameter.Style.SIMPLE),
        COOKIE_PARAM(OpenApiConstants.DOTNAME_COOKIE_PARAM, Parameter.In.COOKIE, null, Parameter.Style.FORM),
        BEAN_PARAM(OpenApiConstants.DOTNAME_BEAN_PARAM, null, null, null),
        RESTEASY_PATH_PARAM(OpenApiConstants.DOTNAME_RESTEASY_PATH_PARAM, Parameter.In.PATH, null, Parameter.Style.SIMPLE),
        RESTEASY_MATRIX_PARAM(OpenApiConstants.DOTNAME_RESTEASY_MATRIX_PARAM, Parameter.In.PATH, Parameter.Style.MATRIX, Parameter.Style.MATRIX),
        RESTEASY_QUERY_PARAM(OpenApiConstants.DOTNAME_RESTEASY_QUERY_PARAM, Parameter.In.QUERY, null, Parameter.Style.FORM),
        RESTEASY_FORM_PARAM(OpenApiConstants.DOTNAME_RESTEASY_FORM_PARAM, null, Parameter.Style.FORM, Parameter.Style.FORM),
        RESTEASY_HEADER_PARAM(OpenApiConstants.DOTNAME_RESTEASY_HEADER_PARAM, Parameter.In.HEADER, null, Parameter.Style.SIMPLE),
        RESTEASY_COOKIE_PARAM(OpenApiConstants.DOTNAME_RESTEASY_COOKIE_PARAM, Parameter.In.COOKIE, null, Parameter.Style.FORM),
        RESTEASY_MULITIPART_FORM(OpenApiConstants.DOTNAME_RESTEASY_MULTIPART_FORM, null, null, null, "multipart/form-data");

        private final DotName name;
        final Parameter.In location;
        final Parameter.Style style;
        final Parameter.Style defaultStyle;
        final String mediaType;

        private JaxRsParameter(DotName name, Parameter.In location, Parameter.Style style, Parameter.Style defaultStyle, String mediaType) {
            this.name = name;
            this.location = location;
            this.style = style;
            this.defaultStyle = defaultStyle;
            this.mediaType = mediaType;
        }

        private JaxRsParameter(DotName name, Parameter.In location, Parameter.Style style, Parameter.Style defaultStyle) {
            this(name, location, style, defaultStyle, null);
        }

        static JaxRsParameter forName(DotName annotationName) {
            for (JaxRsParameter value : JaxRsParameter.values()) {
                if (!value.name.equals((Object)annotationName)) continue;
                return value;
            }
            return null;
        }

        public static boolean isParameter(DotName annotationName) {
            for (JaxRsParameter value : JaxRsParameter.values()) {
                if (!value.name.equals((Object)annotationName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ResourceParameters {
        private String pathItemPath;
        private List<Parameter> pathItemParameters;
        private String operationPath;
        private List<Parameter> operationParameters;
        private Content formBodyContent;

        public List<Parameter> getPathItemParameters() {
            return this.pathItemParameters;
        }

        public String getOperationPath() {
            return this.pathItemPath + this.operationPath;
        }

        public List<Parameter> getOperationParameters() {
            return this.operationParameters;
        }

        public Content getFormBodyContent() {
            return this.formBodyContent;
        }

        public Schema getFormBodySchema() {
            if (this.formBodyContent != null) {
                return ((MediaType)this.formBodyContent.getMediaTypes().values().iterator().next()).getSchema();
            }
            return null;
        }

        List<Parameter> getAllParameters() {
            ArrayList<Parameter> all = new ArrayList<Parameter>();
            if (this.pathItemParameters != null) {
                all.addAll(this.pathItemParameters);
            }
            if (this.operationParameters != null) {
                all.addAll(this.operationParameters);
            }
            return all;
        }

        void setPathItemPath(String pathItemPath) {
            this.pathItemPath = pathItemPath;
        }

        void setPathItemParameters(List<Parameter> pathItemParameters) {
            this.pathItemParameters = pathItemParameters;
        }

        void setOperationPath(String operationPath) {
            this.operationPath = operationPath;
        }

        void setOperationParameters(List<Parameter> operationParameters) {
            this.operationParameters = operationParameters;
        }

        void setFormBodyContent(Content formBodyContent) {
            this.formBodyContent = formBodyContent;
        }

        void sort() {
            if (this.pathItemParameters != null) {
                this.pathItemParameters.sort(parameterComparator);
            }
            if (this.operationParameters != null) {
                this.operationParameters.sort(parameterComparator);
            }
        }
    }
}

