/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.internal.models.media.SchemaSupport;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.IterableStandin;
import io.smallrye.openapi.runtime.scanner.MapStandin;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.StreamStandin;
import io.smallrye.openapi.runtime.scanner.dataobject.AnnotationTargetProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.IgnoreResolver;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.BaseStream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class OpenApiDataObjectScanner {
    public static final DotName ITERABLE_INTERFACE_NAME = DotName.createSimple((String)Iterable.class.getName());
    public static final Type ITERABLE_TYPE = Type.create((DotName)ITERABLE_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName STREAM_INTERFACE_NAME = DotName.createSimple((String)BaseStream.class.getName());
    public static final Type STREAM_TYPE = Type.create((DotName)STREAM_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName MAP_INTERFACE_NAME = DotName.createSimple((String)Map.class.getName());
    public static final Type MAP_TYPE = Type.create((DotName)MAP_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName SET_INTERFACE_NAME = DotName.createSimple((String)Set.class.getName());
    public static final Type SET_TYPE = Type.create((DotName)SET_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName ENUM_INTERFACE_NAME = DotName.createSimple((String)Enum.class.getName());
    public static final Type ENUM_TYPE = Type.create((DotName)ENUM_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final Type STRING_TYPE = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
    public static final Type ARRAY_TYPE_OBJECT = Type.create((DotName)DotName.createSimple((String)Map[].class.getName()), (Type.Kind)Type.Kind.ARRAY);
    private static ClassInfo iterableStandin;
    private static ClassInfo mapStandin;
    private static ClassInfo streamStandin;
    private static List<ClassInfo> standinClasses;
    private Schema rootSchema;
    private AnnotationTarget rootAnnotationTarget;
    private final Type rootClassType;
    private final ClassInfo rootClassInfo;
    private final AnnotationScannerContext context;
    private final AugmentedIndexView index;
    private final DataObjectDeque objectStack;

    private static void index(Indexer indexer, String resourceName) {
        try (InputStream stream = OpenApiDataObjectScanner.class.getResourceAsStream(resourceName);){
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public OpenApiDataObjectScanner(AnnotationScannerContext context, Type classType) {
        this(context, null, classType);
    }

    public OpenApiDataObjectScanner(AnnotationScannerContext context, AnnotationTarget annotationTarget, Type classType) {
        this.context = context;
        this.index = context.getAugmentedIndex();
        this.objectStack = new DataObjectDeque(this.index);
        this.rootClassType = classType;
        this.rootSchema = OASFactory.createSchema();
        this.rootClassInfo = this.initialType(classType);
        this.rootAnnotationTarget = annotationTarget;
    }

    public static Schema process(AnnotationScannerContext context, Type type) {
        try {
            context.getScanStack().push(type);
            Schema schema = new OpenApiDataObjectScanner(context, type).process();
            return schema;
        }
        finally {
            context.getScanStack().pop();
        }
    }

    public static Schema process(PrimitiveType primitive) {
        Schema primitiveSchema = OASFactory.createSchema();
        TypeUtil.applyTypeAttributes((Type)primitive, primitiveSchema);
        return primitiveSchema;
    }

    Schema process() {
        ScannerLogging.logger.startProcessing(this.rootClassType.name());
        if (TypeUtil.isTerminalType(this.rootClassType)) {
            Schema simpleSchema = OASFactory.createSchema();
            TypeUtil.applyTypeAttributes(this.rootClassType, simpleSchema);
            return simpleSchema;
        }
        if (this.isA(this.rootClassType, ENUM_TYPE) && this.index.containsClass(this.rootClassType)) {
            return SchemaFactory.enumToSchema(this.context, this.rootClassType);
        }
        if (this.rootClassInfo == null && this.objectStack.isEmpty()) {
            ScannerLogging.logger.schemaTypeNotFound(this.rootClassType.name());
            return OASFactory.createSchema().addType(Schema.SchemaType.OBJECT);
        }
        DataObjectDeque.PathEntry root = this.objectStack.rootNode(this.rootAnnotationTarget, this.rootClassInfo, this.rootClassType, this.rootSchema);
        if (standinClasses.contains(this.rootClassInfo)) {
            this.resolveSpecial(root, this.rootClassType, this.rootClassInfo);
        } else {
            this.objectStack.push(root);
        }
        this.depthFirstGraphSearch();
        return this.rootSchema;
    }

    private void depthFirstGraphSearch() {
        while (!this.objectStack.isEmpty()) {
            List types;
            DataObjectDeque.PathEntry currentPathEntry = this.objectStack.pop();
            Type currentType = currentPathEntry.getClazzType();
            Schema entrySchema = currentPathEntry.getSchema();
            SchemaRegistry registry = this.context.getSchemaRegistry();
            if (registry.hasSchema(currentType, this.context.getJsonViews(), null)) {
                entrySchema.setRef(registry.lookupRef(currentType, this.context.getJsonViews()).getRef());
                continue;
            }
            ClassInfo currentClass = currentPathEntry.getClazz();
            Schema currentSchema = currentPathEntry.getSchema();
            AnnotationTarget currentTarget = currentPathEntry.getAnnotationTarget();
            boolean allowRegistration = !IgnoreResolver.configuresVisibility(this.context, currentTarget);
            currentSchema = this.readKlass(currentClass, currentType, currentSchema, allowRegistration);
            TypeUtil.mapDeprecated(this.context, (AnnotationTarget)currentClass, () -> ((Schema)currentSchema).getDeprecated(), arg_0 -> ((Schema)currentSchema).setDeprecated(arg_0));
            currentPathEntry.setSchema(currentSchema);
            if (!OpenApiDataObjectScanner.hasNonNullType(currentSchema)) {
                SchemaSupport.setType(currentSchema, Schema.SchemaType.OBJECT);
            } else if (allowRegistration) {
                this.maybeRegisterSchema(currentType, currentSchema, entrySchema);
            }
            if ((types = currentSchema.getType()) == null || !types.contains(Schema.SchemaType.OBJECT)) continue;
            ScannerLogging.logger.gettingFields(currentType, currentClass);
            AnnotationTarget reference = currentPathEntry.getAnnotationTarget();
            Map<String, TypeResolver> properties = TypeResolver.getAllFields(this.context, currentType, currentClass, reference);
            this.processClassAnnotations(currentSchema, currentClass);
            properties.values().stream().filter(resolver -> !resolver.isIgnored()).forEach(resolver -> AnnotationTargetProcessor.process(this.context, this.objectStack, resolver, currentPathEntry));
            this.processInheritance(currentPathEntry);
        }
    }

    private void maybeRegisterSchema(Type currentType, Schema currentSchema, Schema entrySchema) {
        Schema refTarget;
        Schema ref = SchemaFactory.schemaRegistration(this.context, currentType, currentSchema);
        if (ref != currentSchema && !currentSchema.getType().contains(Schema.SchemaType.OBJECT) && ref.getRef() != null && (refTarget = this.context.getSchemaRegistry().lookupSchema(currentType, this.context.getJsonViews())) != entrySchema) {
            entrySchema.setAll(Collections.emptyMap());
            entrySchema.setRef(ref.getRef());
        }
    }

    private static boolean hasNonNullType(Schema schema) {
        return SchemaSupport.getNonNullType(schema) != null;
    }

    private void processClassAnnotations(Schema schema, ClassInfo classInfo) {
        String xmlElementName = (String)this.context.annotations().getAnnotationValue((AnnotationTarget)classInfo, JaxbConstants.XML_ROOTELEMENT, "name");
        if (xmlElementName != null && !classInfo.simpleName().equals(xmlElementName)) {
            schema.setXml(OASFactory.createXML().name(xmlElementName));
        }
    }

    private void processInheritance(DataObjectDeque.PathEntry currentPathEntry) {
        ClassInfo currentClass = currentPathEntry.getClazz();
        Schema currentSchema = currentPathEntry.getSchema();
        Type currentType = currentPathEntry.getClazzType();
        Type superClassType = currentClass.superClassType();
        if (TypeUtil.isIncludedAllOf(this.context, currentClass, currentType)) {
            this.encloseCurrentSchema(currentSchema, currentType, currentPathEntry);
        } else if (superClassType != null && this.context.getConfig().getAutoInheritance() != OpenApiConfig.AutoInheritance.NONE && !TypeUtil.knownJavaType(superClassType.name()) && this.context.annotations().getAnnotationValue((AnnotationTarget)currentClass, SchemaConstant.DOTNAME_SCHEMA, "allOf") == null) {
            Schema parentSchema = OASFactory.createSchema();
            this.objectStack.push((AnnotationTarget)currentClass, currentPathEntry, superClassType, parentSchema);
            parentSchema = this.context.getSchemaRegistry().registerReference(superClassType, this.context.getJsonViews(), null, parentSchema);
            currentSchema.addAllOf(parentSchema);
            if (this.context.getConfig().getAutoInheritance() == OpenApiConfig.AutoInheritance.BOTH) {
                this.encloseCurrentSchema(currentSchema, currentType, currentPathEntry);
            }
        }
    }

    private void encloseCurrentSchema(Schema currentSchema, Type currentType, DataObjectDeque.PathEntry currentPathEntry) {
        Schema enclosingSchema = OASFactory.createSchema().allOf(currentSchema.getAllOf()).addAllOf(currentSchema);
        currentSchema.setAllOf(null);
        currentSchema = enclosingSchema;
        currentPathEntry.setSchema(currentSchema);
        if (this.rootClassType.equals((Object)currentType)) {
            this.rootSchema = enclosingSchema;
        }
        if (this.context.getSchemaRegistry().hasSchema(currentType, this.context.getJsonViews(), null)) {
            this.context.getSchemaRegistry().register(currentType, this.context.getJsonViews(), enclosingSchema);
        }
    }

    private Schema readKlass(ClassInfo currentClass, Type currentType, Schema currentSchema, boolean registerSchema) {
        AnnotationInstance annotation = TypeUtil.getSchemaAnnotation(this.context, (AnnotationTarget)currentClass);
        Schema classSchema = annotation != null ? SchemaFactory.readSchema(this.context, currentSchema, annotation, currentClass, registerSchema) : (this.isA(currentType, ENUM_TYPE) ? SchemaFactory.enumToSchema(this.context, currentType) : currentSchema);
        return classSchema;
    }

    private void resolveSpecial(DataObjectDeque.PathEntry root, Type type, ClassInfo standin) {
        ParameterizedType standinType = ((Type)standin.interfaceTypes().get(0)).asParameterizedType();
        if (this.typeArgumentMismatch(type, standin)) {
            type = TypeResolver.resolveParameterizedAncestor(this.context, type, (Type)standinType).map(Type.class::cast).orElse(type);
        }
        Map<String, TypeResolver> fieldResolution = TypeResolver.getAllFields(this.context, type, standin, root.getAnnotationTarget());
        this.rootSchema = this.preProcessSpecial(type, fieldResolution.values().iterator().next(), root);
    }

    private boolean typeArgumentMismatch(Type type, ClassInfo standin) {
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return true;
        }
        return standin.typeParameters().size() < type.asParameterizedType().arguments().size();
    }

    private Schema preProcessSpecial(Type type, TypeResolver typeResolver, DataObjectDeque.PathEntry currentPathEntry) {
        return AnnotationTargetProcessor.process(this.context, this.objectStack, typeResolver, currentPathEntry, type);
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.context, testSubject, test);
    }

    private ClassInfo initialType(Type type) {
        if (this.isA(type, ITERABLE_TYPE)) {
            return iterableStandin;
        }
        if (this.isA(type, MAP_TYPE)) {
            return mapStandin;
        }
        if (this.isA(type, STREAM_TYPE)) {
            return streamStandin;
        }
        return this.index.getClass(type);
    }

    static {
        Indexer indexer = new Indexer();
        OpenApiDataObjectScanner.index(indexer, "IterableStandin.class");
        OpenApiDataObjectScanner.index(indexer, "MapStandin.class");
        OpenApiDataObjectScanner.index(indexer, "StreamStandin.class");
        Index index = indexer.complete();
        iterableStandin = index.getClassByName(DotName.createSimple((String)IterableStandin.class.getName()));
        mapStandin = index.getClassByName(DotName.createSimple((String)MapStandin.class.getName()));
        streamStandin = index.getClassByName(DotName.createSimple((String)StreamStandin.class.getName()));
        standinClasses = Arrays.asList(iterableStandin, mapStandin, streamStandin);
    }
}

