/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;

public interface OpenApiConfig {
    public static final DuplicateOperationIdBehavior DUPLICATE_OPERATION_ID_BEHAVIOR_DEFAULT = DuplicateOperationIdBehavior.WARN;
    public static final Integer MAXIMUM_STATIC_FILE_SIZE_DEFAULT = 0x300000;

    public static OpenApiConfig fromConfig(Config config) {
        return new OpenApiConfigImpl(config);
    }

    public <R, T> T getConfigValue(String var1, Class<R> var2, Function<R, T> var3, Supplier<T> var4);

    public <R, T> Map<String, T> getConfigValueMap(String var1, Class<R> var2, Function<R, T> var3);

    default public <T> T getConfigValue(String propertyName, Class<T> type, Supplier<T> defaultValue) {
        return this.getConfigValue(propertyName, type, Function.identity(), defaultValue);
    }

    default public String modelReader() {
        return this.getConfigValue("mp.openapi.model.reader", String.class, () -> null);
    }

    default public String filter() {
        return this.getConfigValue("mp.openapi.filter", String.class, () -> null);
    }

    default public boolean scanDisable() {
        return this.getConfigValue("mp.openapi.scan.disable", Boolean.class, () -> Boolean.FALSE);
    }

    default public Set<String> scanPackages() {
        return this.getConfigValue("mp.openapi.scan.packages", String[].class, this::toSet, Collections::emptySet);
    }

    default public Set<String> scanClasses() {
        return this.getConfigValue("mp.openapi.scan.classes", String[].class, this::toSet, Collections::emptySet);
    }

    default public Set<String> scanExcludePackages() {
        return this.getConfigValue("mp.openapi.scan.exclude.packages", String[].class, values -> {
            Set<String> valueSet = this.toSet((String[])values);
            valueSet.addAll(OpenApiConstants.NEVER_SCAN_PACKAGES);
            return Collections.unmodifiableSet(valueSet);
        }, () -> OpenApiConstants.NEVER_SCAN_PACKAGES);
    }

    default public Set<String> scanExcludeClasses() {
        return this.getConfigValue("mp.openapi.scan.exclude.classes", String[].class, values -> {
            Set<String> valueSet = this.toSet((String[])values);
            valueSet.addAll(OpenApiConstants.NEVER_SCAN_CLASSES);
            return Collections.unmodifiableSet(valueSet);
        }, () -> OpenApiConstants.NEVER_SCAN_CLASSES);
    }

    default public boolean scanBeanValidation() {
        return this.getConfigValue("mp.openapi.scan.beanvalidation", Boolean.class, () -> Boolean.TRUE);
    }

    default public List<String> servers() {
        return this.getConfigValue("mp.openapi.servers", String[].class, this::toList, Collections::emptyList);
    }

    default public List<String> pathServers(String path) {
        return this.getConfigValue("mp.openapi.servers.path." + path, String[].class, this::toList, Collections::emptyList);
    }

    default public List<String> operationServers(String operationId) {
        return this.getConfigValue("mp.openapi.servers.operation." + operationId, String[].class, this::toList, Collections::emptyList);
    }

    default public boolean scanDependenciesDisable() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.scan-dependencies.disable", Boolean.class, () -> this.getConfigValue("mp.openapi.extensions.scan-dependencies.disable", Boolean.class, () -> Boolean.FALSE));
    }

    default public Set<String> scanDependenciesJars() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.scan-dependencies.jars", String[].class, this::toSet, () -> this.getConfigValue("mp.openapi.extensions.scan-dependencies.jars", String[].class, this::toSet, Collections::emptySet));
    }

    default public boolean arrayReferencesEnable() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.array-references.enable", Boolean.class, () -> Boolean.TRUE);
    }

    default public String customSchemaRegistryClass() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.custom-schema-registry.class", String.class, () -> this.getConfigValue("mp.openapi.extensions.custom-schema-registry.class", String.class, () -> null));
    }

    default public boolean applicationPathDisable() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.application-path.disable", Boolean.class, () -> this.getConfigValue("mp.openapi.extensions.application-path.disable", Boolean.class, () -> Boolean.FALSE));
    }

    default public boolean privatePropertiesEnable() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.private-properties.enable", Boolean.class, () -> Boolean.TRUE);
    }

    default public String propertyNamingStrategy() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.property-naming-strategy", String.class, () -> "IDENTITY");
    }

    default public boolean sortedPropertiesEnable() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.sorted-properties.enable", Boolean.class, () -> Boolean.FALSE);
    }

    default public Map<String, String> getSchemas() {
        return this.getConfigValueMap("mp.openapi.schema.", String.class, Function.identity());
    }

    default public String getOpenApiVersion() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.openapi", String.class, () -> null);
    }

    default public String getInfoTitle() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.title", String.class, () -> null);
    }

    default public String getInfoVersion() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.version", String.class, () -> null);
    }

    default public String getInfoDescription() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.description", String.class, () -> null);
    }

    default public String getInfoTermsOfService() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.termsOfService", String.class, () -> null);
    }

    default public String getInfoContactEmail() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.contact.email", String.class, () -> null);
    }

    default public String getInfoContactName() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.contact.name", String.class, () -> null);
    }

    default public String getInfoContactUrl() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.contact.url", String.class, () -> null);
    }

    default public String getInfoLicenseName() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.license.name", String.class, () -> null);
    }

    default public String getInfoLicenseUrl() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.info.license.url", String.class, () -> null);
    }

    default public OperationIdStrategy getOperationIdStrategy() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.operationIdStrategy", String.class, OperationIdStrategy::valueOf, () -> null);
    }

    default public DuplicateOperationIdBehavior getDuplicateOperationIdBehavior() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.duplicateOperationIdBehavior", String.class, DuplicateOperationIdBehavior::valueOf, () -> DUPLICATE_OPERATION_ID_BEHAVIOR_DEFAULT);
    }

    default public Optional<String[]> getDefaultProduces() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.defaultProduces", String[].class, Optional::of, Optional::empty);
    }

    default public Optional<String[]> getDefaultConsumes() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.defaultConsumes", String[].class, Optional::of, Optional::empty);
    }

    default public Optional<Boolean> allowNakedPathParameter() {
        return Optional.empty();
    }

    public void setAllowNakedPathParameter(Boolean var1);

    default public void doAllowNakedPathParameter() {
        this.setAllowNakedPathParameter(Boolean.TRUE);
    }

    default public Set<String> getScanProfiles() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.scan.profiles", String[].class, this::toSet, Collections::emptySet);
    }

    default public Set<String> getScanExcludeProfiles() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.scan.exclude.profiles", String[].class, this::toSet, Collections::emptySet);
    }

    default public Map<String, String> getScanResourceClasses() {
        return this.getConfigValueMap("mp.openapi.extensions.smallrye.scan.resource-class.", String.class, Function.identity());
    }

    default public boolean removeUnusedSchemas() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.remove-unused-schemas.enable", Boolean.class, () -> Boolean.FALSE);
    }

    default public Integer getMaximumStaticFileSize() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.maximumStaticFileSize", Integer.class, () -> MAXIMUM_STATIC_FILE_SIZE_DEFAULT);
    }

    default public AutoInheritance getAutoInheritance() {
        return this.getConfigValue("mp.openapi.extensions.smallrye.auto-inheritance", String.class, AutoInheritance::valueOf, () -> AutoInheritance.NONE);
    }

    default public Set<String> toSet(String[] items) {
        return Arrays.stream(items).map(String::trim).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public List<String> toList(String[] items) {
        return Arrays.stream(items).map(String::trim).collect(Collectors.toCollection(ArrayList::new));
    }

    public static enum AutoInheritance {
        NONE,
        BOTH,
        PARENT_ONLY;

    }

    public static enum DuplicateOperationIdBehavior {
        FAIL,
        WARN;

    }

    public static enum OperationIdStrategy {
        METHOD,
        CLASS_METHOD,
        PACKAGE_CLASS_METHOD;

    }
}

