/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AnnotationTargetProcessor
implements BeanValidationScanner.RequirementHandler {
    private final AnnotationScannerContext context;
    private final DataObjectDeque objectStack;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final TypeResolver typeResolver;
    private final Type entityType;
    private final AnnotationTarget annotationTarget;
    private static final List<Function<Schema, Object>> SCHEMA_ASSERTION_PROVIDERS = Arrays.asList(Schema::getAdditionalPropertiesBoolean, Schema::getAdditionalPropertiesSchema, Schema::getAllOf, Schema::getAnyOf, Schema::getDiscriminator, Schema::getEnumeration, Schema::getExclusiveMaximum, Schema::getExclusiveMinimum, Schema::getFormat, Schema::getItems, Schema::getMaximum, Schema::getMaxItems, Schema::getMaxLength, Schema::getMaxProperties, Schema::getMinimum, Schema::getMinItems, Schema::getMinLength, Schema::getMinProperties, Schema::getMultipleOf, Schema::getNot, Schema::getNullable, Schema::getOneOf, Schema::getPattern, Schema::getProperties, Reference::getRef, Schema::getRequired, Schema::getUniqueItems, Schema::getXml);
    private static final List<Function<Schema, Object>> SCHEMA_ANNOTATION_PROVIDERS = Arrays.asList(Schema::getDefaultValue, Schema::getDeprecated, Schema::getDescription, Schema::getExample, Extensible::getExtensions, Schema::getExternalDocs, Schema::getReadOnly, Schema::getTitle, Schema::getWriteOnly);

    private AnnotationTargetProcessor(AnnotationScannerContext context, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, AnnotationTarget annotationTarget, Type entityType) {
        this.context = context;
        this.objectStack = objectStack;
        this.parentPathEntry = parentPathEntry;
        this.typeResolver = typeResolver;
        this.entityType = entityType;
        this.annotationTarget = annotationTarget;
    }

    public static Schema process(AnnotationScannerContext context, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(context, objectStack, parentPathEntry, typeResolver, typeResolver.getAnnotationTarget(), typeResolver.getUnresolvedType());
        return fp.processField();
    }

    public static Schema process(AnnotationScannerContext context, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(context, objectStack, parentPathEntry, typeResolver, (AnnotationTarget)context.getAugmentedIndex().getClass(type), type);
        return fp.processField();
    }

    @Override
    public void setRequired(AnnotationTarget target, String propertyKey) {
        AnnotationInstance schemaAnnotation;
        List requiredProperties = this.parentPathEntry.getSchema().getRequired();
        if (!(requiredProperties != null && requiredProperties.contains(propertyKey) || (schemaAnnotation = TypeUtil.getSchemaAnnotation(target)) != null && schemaAnnotation.value("required") != null)) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
    }

    Schema processField() {
        boolean registrationCandidate;
        Type registrationType;
        Type fieldType;
        Schema typeSchema;
        TypeProcessor typeProcessor;
        AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(this.annotationTarget);
        String propertyKey = this.typeResolver.getPropertyName();
        if (schemaAnnotation != null && JandexUtil.hasImplementation(schemaAnnotation)) {
            typeProcessor = null;
            typeSchema = null;
            fieldType = (Type)Annotations.value(schemaAnnotation, "implementation");
            registrationType = null;
            registrationCandidate = false;
        } else {
            typeProcessor = new TypeProcessor(this.context, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, new SchemaImpl(), this.annotationTarget);
            fieldType = typeProcessor.processType();
            Schema initTypeSchema = typeProcessor.getSchema();
            if (!TypeUtil.isTypeOverridden(fieldType, schemaAnnotation)) {
                TypeUtil.applyTypeAttributes(fieldType, initTypeSchema);
            }
            registrationType = TypeUtil.isWrappedType(this.entityType) ? fieldType : this.entityType;
            registrationCandidate = !JandexUtil.isRef(schemaAnnotation) && SchemaRegistry.register(registrationType, this.context.getJsonViews(), this.typeResolver, initTypeSchema, (reg, key) -> null) != initTypeSchema;
            typeSchema = registrationCandidate && SchemaRegistry.hasSchema(registrationType, this.context.getJsonViews(), this.typeResolver) ? SchemaRegistry.currentInstance().lookupSchema(TypeResolver.resolve(registrationType, this.typeResolver), this.context.getJsonViews()) : initTypeSchema;
        }
        Schema fieldSchema = schemaAnnotation != null ? this.readSchemaAnnotatedField(propertyKey, schemaAnnotation, fieldType) : (registrationCandidate ? new SchemaImpl().type(typeSchema.getType()) : (Schema)MergeUtil.mergeObjects(new SchemaImpl(), typeSchema));
        Optional<BeanValidationScanner> constraintScanner = this.context.getBeanValidationScanner();
        if (constraintScanner.isPresent()) {
            for (AnnotationTarget contraintTarget : this.typeResolver.getConstraintTargets()) {
                constraintScanner.get().applyConstraints(contraintTarget, fieldSchema, propertyKey, this);
            }
        }
        if (fieldSchema.getNullable() == null && TypeUtil.isOptional(this.entityType)) {
            fieldSchema.setNullable(Boolean.TRUE);
        }
        if (fieldSchema.getReadOnly() == null && this.typeResolver.isReadOnly()) {
            fieldSchema.setReadOnly(Boolean.TRUE);
        }
        if (fieldSchema.getWriteOnly() == null && this.typeResolver.isWriteOnly()) {
            fieldSchema.setWriteOnly(Boolean.TRUE);
        }
        TypeUtil.mapDeprecated(this.annotationTarget, () -> ((Schema)fieldSchema).getDeprecated(), arg_0 -> ((Schema)fieldSchema).setDeprecated(arg_0));
        this.processFieldAnnotations(fieldSchema, this.typeResolver);
        Schema parentSchema = this.parentPathEntry.getSchema();
        Schema existingFieldSchema = ModelUtil.getPropertySchema(parentSchema, propertyKey);
        if (existingFieldSchema != null) {
            fieldSchema = MergeUtil.mergeObjects(fieldSchema, existingFieldSchema);
        }
        if (registrationCandidate) {
            if (this.fieldAssertionConflicts(fieldSchema, typeSchema)) {
                fieldSchema = SchemaFactory.includeTypeSchema(this.context, fieldSchema, fieldType);
            } else {
                typeProcessor.pushObjectStackInput();
                Schema registeredTypeSchema = typeSchema.getType() != Schema.SchemaType.ARRAY ? SchemaRegistry.registerReference(registrationType, this.context.getJsonViews(), this.typeResolver, typeSchema) : SchemaRegistry.checkRegistration(registrationType, this.context.getJsonViews(), this.typeResolver, typeSchema);
                if (fieldSchema.getAllOf() == null && (this.fieldAssertionsOverrideType(fieldSchema, typeSchema) || this.fieldSpecifiesAnnotation(fieldSchema))) {
                    TypeUtil.clearMatchingDefaultAttributes(fieldSchema, typeSchema);
                    fieldSchema.addAllOf(registeredTypeSchema);
                    SchemaImpl.addTypeObserver(typeSchema, fieldSchema);
                } else {
                    fieldSchema = registeredTypeSchema;
                }
            }
        } else if (!JandexUtil.isRef(schemaAnnotation)) {
            if (typeProcessor != null) {
                typeProcessor.pushObjectStackInput();
            }
            fieldSchema = MergeUtil.mergeObjects(typeSchema, fieldSchema);
        }
        parentSchema.addProperty(propertyKey, fieldSchema);
        return fieldSchema;
    }

    private void processFieldAnnotations(Schema fieldSchema, TypeResolver typeResolver) {
        String name = typeResolver.getBeanPropertyName();
        FieldInfo field = typeResolver.getField();
        if (field != null && this.processXmlAttr(name, fieldSchema, Annotations.getAnnotation((AnnotationTarget)field, JaxbConstants.XML_ATTRIBUTE), Annotations.getAnnotation((AnnotationTarget)field, JaxbConstants.XML_ELEMENT), Annotations.getAnnotation((AnnotationTarget)field, JaxbConstants.XML_WRAPPERELEMENT))) {
            return;
        }
        MethodInfo readMethod = typeResolver.getReadMethod();
        if (readMethod != null && this.processXmlAttr(name, fieldSchema, Annotations.getAnnotation((AnnotationTarget)readMethod, JaxbConstants.XML_ATTRIBUTE), Annotations.getAnnotation((AnnotationTarget)readMethod, JaxbConstants.XML_ELEMENT), Annotations.getAnnotation((AnnotationTarget)readMethod, JaxbConstants.XML_WRAPPERELEMENT))) {
            return;
        }
        MethodInfo writeMethod = typeResolver.getWriteMethod();
        if (writeMethod != null && this.processXmlAttr(name, fieldSchema, Annotations.getAnnotation((AnnotationTarget)writeMethod, JaxbConstants.XML_ATTRIBUTE), Annotations.getAnnotation((AnnotationTarget)writeMethod, JaxbConstants.XML_ELEMENT), Annotations.getAnnotation((AnnotationTarget)writeMethod, JaxbConstants.XML_WRAPPERELEMENT))) {
            return;
        }
    }

    private boolean processXmlAttr(String name, Schema fieldSchema, AnnotationInstance xmlAttr, AnnotationInstance xmlElement, AnnotationInstance xmlWrapper) {
        if (xmlAttr == null && xmlWrapper == null && xmlElement == null) {
            return false;
        }
        if (xmlAttr != null) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().attribute(Boolean.valueOf(true));
            this.setXmlName(fieldSchema, name, xmlAttr);
        }
        if (xmlWrapper != null) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().wrapped(Boolean.valueOf(true));
            this.setXmlName(fieldSchema, name, xmlWrapper);
            if (xmlElement != null) {
                this.setXmlName(fieldSchema.getItems(), name, xmlElement);
                return true;
            }
        }
        if (xmlElement != null) {
            this.setXmlName(fieldSchema, name, xmlElement);
        }
        return true;
    }

    private void setXmlIfEmpty(Schema schema) {
        if (schema.getXml() != null) {
            return;
        }
        schema.setXml((XML)new XMLImpl());
    }

    private void setXmlName(Schema fieldSchema, String realName, AnnotationInstance xmlAttr) {
        String annName;
        AnnotationValue name = xmlAttr.value("name");
        if (fieldSchema != null && name != null && !(annName = name.asString()).equals(realName)) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().name(annName);
        }
    }

    private Schema readSchemaAnnotatedField(String propertyKey, AnnotationInstance annotation, Type postProcessedField) {
        DataObjectLogging.logger.processingFieldAnnotation(annotation, propertyKey);
        if (Annotations.value(annotation, "required", Boolean.FALSE).booleanValue()) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
        Map<Object, Object> defaults = JandexUtil.isArraySchema(annotation) || TypeUtil.isTypeOverridden(postProcessedField, annotation) ? Collections.emptyMap() : TypeUtil.getTypeAttributes(postProcessedField);
        return SchemaFactory.readSchema(this.context, (Schema)new SchemaImpl(), annotation, defaults);
    }

    boolean fieldAssertionConflicts(Schema fieldSchema, Schema typeSchema) {
        return SCHEMA_ASSERTION_PROVIDERS.stream().map(provider -> {
            Object typeAttr;
            Object fieldAttr = provider.apply(fieldSchema);
            if (fieldAttr != null && (typeAttr = provider.apply(typeSchema)) != null && !fieldAttr.equals(typeAttr)) {
                return true;
            }
            return false;
        }).anyMatch(Boolean.TRUE::equals);
    }

    boolean fieldAssertionsOverrideType(Schema fieldSchema, Schema typeSchema) {
        return SCHEMA_ASSERTION_PROVIDERS.stream().map(provider -> {
            Object fieldAttr = provider.apply(fieldSchema);
            if (fieldAttr != null) {
                return !fieldAttr.equals(provider.apply(typeSchema));
            }
            return false;
        }).anyMatch(Boolean.TRUE::equals);
    }

    boolean fieldSpecifiesAnnotation(Schema fieldSchema) {
        return null != SCHEMA_ANNOTATION_PROVIDERS.stream().map(provider -> provider.apply(fieldSchema)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

