/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.UnspecifiedMetadata;
import io.smallrye.metrics.app.ConcurrentGaugeImpl;
import io.smallrye.metrics.app.CounterImpl;
import io.smallrye.metrics.app.ExponentiallyDecayingReservoir;
import io.smallrye.metrics.app.HistogramImpl;
import io.smallrye.metrics.app.MeterImpl;
import io.smallrye.metrics.app.TimerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.logging.Logger;

@Vetoed
public class MetricsRegistryImpl
extends MetricRegistry {
    private static Logger log = Logger.getLogger(MetricsRegistryImpl.class);
    private Map<String, Metadata> metadataMap = new HashMap<String, Metadata>();
    private Map<MetricID, Metric> metricMap = new ConcurrentHashMap<MetricID, Metric>();
    private Map<MetricID, Object> originMap = new HashMap<MetricID, Object>();

    public synchronized <T extends Metric> T register(String name, T metric) {
        MetricType type;
        MetricID metricID = new MetricID(name);
        if (this.metricMap.keySet().contains(metricID)) {
            throw new IllegalArgumentException("A metric with name " + name + " already exists");
        }
        Class<?> metricCls = metric.getClass();
        if (metricCls.getName().contains("Lambda")) {
            String tname = metricCls.getGenericInterfaces()[0].getTypeName();
            tname = tname.substring(tname.lastIndexOf(46) + 1);
            tname = tname.toLowerCase();
            type = MetricType.from((String)tname);
        } else {
            type = metricCls.isAnonymousClass() ? MetricType.from(metricCls.getInterfaces().length == 0 ? metricCls.getSuperclass().getInterfaces()[0] : metricCls.getInterfaces()[0]) : (!metricCls.isInterface() ? MetricType.from(metricCls.getInterfaces()[0]) : MetricType.from(metricCls));
        }
        Metadata m = Metadata.builder().withName(name).withType(type).build();
        this.metricMap.put(metricID, metric);
        this.metadataMap.put(name, m);
        return metric;
    }

    public <T extends Metric> T register(Metadata metadata, T metric) {
        return this.register(metadata, metric, null);
    }

    public synchronized <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) {
        boolean reusableFlag;
        String name = metadata.getName();
        if (name == null) {
            throw new IllegalArgumentException("Metric name must not be null");
        }
        MetricID metricID = new MetricID(name, tags);
        Metadata existingMetadata = this.metadataMap.get(name);
        boolean bl = reusableFlag = existingMetadata == null || existingMetadata.isReusable();
        if (metadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
            reusableFlag = false;
        }
        if (this.metricMap.keySet().contains(metricID) && !reusableFlag) {
            throw new IllegalArgumentException("A metric with metricID " + metricID + " already exists");
        }
        if (existingMetadata != null) {
            if (metadata instanceof UnspecifiedMetadata) {
                if (!metadata.getType().equals(existingMetadata.getType())) {
                    throw new IllegalArgumentException("There is an existing metric with name " + name + " but of different type (" + existingMetadata.getType() + ")");
                }
                this.metricMap.put(metricID, metric);
            } else {
                this.verifyMetadataEquality(metadata, existingMetadata);
                this.metricMap.put(metricID, metric);
                if (metadata instanceof OriginAndMetadata) {
                    this.originMap.put(metricID, ((OriginAndMetadata)metadata).getOrigin());
                }
            }
        } else if (metadata instanceof UnspecifiedMetadata) {
            Metadata realMetadata = ((UnspecifiedMetadata)metadata).convertToRealMetadata();
            this.metadataMap.put(name, realMetadata);
            this.metricMap.put(metricID, metric);
        } else {
            if (metadata instanceof OriginAndMetadata) {
                this.originMap.put(metricID, ((OriginAndMetadata)metadata).getOrigin());
                this.metadataMap.put(name, ((OriginAndMetadata)metadata).getMetadata());
            } else {
                this.metadataMap.put(name, metadata);
            }
            this.metricMap.put(metricID, metric);
        }
        return metric;
    }

    private void verifyMetadataEquality(Metadata newMetadata, Metadata existingMetadata) {
        if (!existingMetadata.getTypeRaw().equals((Object)newMetadata.getTypeRaw())) {
            throw new IllegalStateException("Passed metric type does not match existing type");
        }
        if (!(newMetadata instanceof UnspecifiedMetadata)) {
            String newDescription;
            String newUnit;
            if (existingMetadata.isReusable() != newMetadata.isReusable()) {
                throw new IllegalStateException("Reusable flag differs from previous usage");
            }
            String existingUnit = existingMetadata.getUnit().orElse("none");
            if (!existingUnit.equals(newUnit = newMetadata.getUnit().orElse("none"))) {
                throw new IllegalStateException("Unit is different from the unit in previous usage (" + existingUnit + ")");
            }
            String existingDescription = existingMetadata.getDescription().orElse("none");
            if (!existingDescription.equals(newDescription = newMetadata.getDescription().orElse("none"))) {
                throw new IllegalStateException("Description differs from previous usage");
            }
            if (!existingMetadata.getDisplayName().equals(newMetadata.getDisplayName())) {
                throw new IllegalStateException("Display name differs from previous usage");
            }
        }
    }

    public Counter counter(String name) {
        return (Counter)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.COUNTER));
    }

    public Counter counter(String name, Tag ... tags) {
        return (Counter)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return (Counter)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata) {
        return (Counter)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.COUNTER));
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return (ConcurrentGauge)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return (ConcurrentGauge)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return (ConcurrentGauge)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return (ConcurrentGauge)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.CONCURRENT_GAUGE));
    }

    public Histogram histogram(String name) {
        return (Histogram)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata) {
        return (Histogram)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.HISTOGRAM));
    }

    public Histogram histogram(String name, Tag ... tags) {
        return (Histogram)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return (Histogram)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.HISTOGRAM));
    }

    public Meter meter(String name) {
        return (Meter)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.METERED));
    }

    public Meter meter(Metadata metadata) {
        return (Meter)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.METERED));
    }

    public Meter meter(String name, Tag ... tags) {
        return (Meter)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.METERED));
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return (Meter)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.METERED));
    }

    public Timer timer(String name) {
        return (Timer)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata) {
        return (Timer)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.TIMER));
    }

    public Timer timer(String name, Tag ... tags) {
        return (Timer)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return (Timer)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.TIMER));
    }

    private synchronized <T extends Metric> T get(MetricID metricID, Metadata metadata) {
        String name = metadata.getName();
        MetricType type = metadata.getTypeRaw();
        log.debugf("Get metric [id: %s, type: %s]", (Object)metricID, (Object)type);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        Metadata previousMetadata = this.metadataMap.get(name);
        Metric previousMetric = this.metricMap.get(metricID);
        if (previousMetric == null) {
            Object m;
            switch (type) {
                case COUNTER: {
                    m = new CounterImpl();
                    break;
                }
                case GAUGE: {
                    throw new IllegalArgumentException("Gauge " + name + " was not registered, this should not happen");
                }
                case METERED: {
                    m = new MeterImpl();
                    break;
                }
                case HISTOGRAM: {
                    m = new HistogramImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                case TIMER: {
                    m = new TimerImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                case CONCURRENT_GAUGE: {
                    m = new ConcurrentGaugeImpl();
                    break;
                }
                default: {
                    throw new IllegalStateException("Must not happen");
                }
            }
            if (metadata instanceof OriginAndMetadata) {
                log.debugf("Register metric [metricId: %s, type: %s, origin: %s]", (Object)metricID, (Object)type, ((OriginAndMetadata)metadata).getOrigin());
            } else {
                log.debugf("Register metric [metricId: %s, type: %s]", (Object)metricID, (Object)type);
            }
            this.register(metadata, m, metricID.getTagsAsList().toArray(new Tag[0]));
        } else {
            if (!previousMetadata.getTypeRaw().equals((Object)metadata.getTypeRaw())) {
                throw new IllegalArgumentException("Previously registered metric " + name + " is of type " + previousMetadata.getType() + ", expected " + metadata.getType());
            }
            if (!(metadata instanceof OriginAndMetadata) || this.originMap.get(metricID) == null || !this.areCompatibleOrigins(this.originMap.get(metricID), ((OriginAndMetadata)metadata).getOrigin())) {
                if (previousMetadata.isReusable() && !(metadata instanceof UnspecifiedMetadata) && !metadata.isReusable()) {
                    throw new IllegalArgumentException("Previously registered metric " + name + " was flagged as reusable, while current request is not.");
                }
                if (!previousMetadata.isReusable()) {
                    throw new IllegalArgumentException("Previously registered metric " + name + " was not flagged as reusable");
                }
                this.verifyMetadataEquality(metadata, previousMetadata);
            }
        }
        return (T)this.metricMap.get(metricID);
    }

    private boolean areCompatibleOrigins(Object left, Object right) {
        if (left.equals(right)) {
            return true;
        }
        return left instanceof InjectionPoint || right instanceof InjectionPoint;
    }

    public boolean remove(String metricName) {
        log.debugf("Removing metrics with [name: %s]", (Object)metricName);
        for (MetricID metricID : this.metricMap.keySet()) {
            if (!metricID.getName().equals(metricName)) continue;
            this.metricMap.remove(metricID);
        }
        return this.metadataMap.remove(metricName) != null;
    }

    public synchronized boolean remove(MetricID metricID) {
        if (this.metricMap.containsKey(metricID)) {
            log.debugf("Remove metric with [id: %s]", (Object)metricID);
            this.metricMap.remove(metricID);
            if (this.metricMap.keySet().stream().noneMatch(id -> id.getName().equals(metricID.getName()))) {
                log.debugf("Remove metadata for [name: %s]", (Object)metricID.getName());
                this.metadataMap.remove(metricID.getName());
            }
            return true;
        }
        return false;
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<MetricID, Metric> entry : this.metricMap.entrySet()) {
            if (!metricFilter.matches(entry.getKey(), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        TreeSet<String> out = new TreeSet<String>();
        for (MetricID id : this.metricMap.keySet()) {
            out.add(id.getName());
        }
        return out;
    }

    public SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.metricMap.keySet());
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.COUNTER, metricFilter);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.CONCURRENT_GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.HISTOGRAM, metricFilter);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.METERED, metricFilter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.TIMER, metricFilter);
    }

    public Map<MetricID, Metric> getMetrics() {
        return new HashMap<MetricID, Metric>(this.metricMap);
    }

    private Metadata sanitizeMetadata(Metadata metadata, MetricType metricType) {
        if (metadata.getTypeRaw() == null || metadata.getTypeRaw() == MetricType.INVALID) {
            return Metadata.builder((Metadata)metadata).withType(metricType).build();
        }
        if (metadata.getTypeRaw() != metricType) {
            throw new IllegalArgumentException("Attempting to register a " + metricType + ", but the passed metadata contains type=" + metadata.getType());
        }
        return metadata;
    }

    private <T extends Metric> SortedMap<MetricID, T> getMetrics(MetricType type, MetricFilter filter) {
        TreeMap<MetricID, Metric> out = new TreeMap<MetricID, Metric>();
        for (Map.Entry<MetricID, Metric> entry : this.metricMap.entrySet()) {
            if (!this.isSameType(entry.getValue(), type) || !filter.matches(entry.getKey(), entry.getValue())) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    private boolean isSameType(Metric metricInstance, MetricType type) {
        switch (type) {
            case CONCURRENT_GAUGE: {
                return metricInstance instanceof ConcurrentGauge;
            }
            case GAUGE: {
                return metricInstance instanceof Gauge;
            }
            case HISTOGRAM: {
                return metricInstance instanceof Histogram;
            }
            case TIMER: {
                return metricInstance instanceof Timer;
            }
            case METERED: {
                return metricInstance instanceof Meter;
            }
            case COUNTER: {
                return metricInstance instanceof Counter;
            }
        }
        throw new IllegalArgumentException();
    }

    public synchronized Map<String, Metadata> getMetadata() {
        return new HashMap<String, Metadata>(this.metadataMap);
    }
}

