package io.smallrye.jwt.config;

import java.util.Locale;
import java.io.Serializable;
import java.lang.Throwable;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class ConfigMessages_$bundle implements ConfigMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected ConfigMessages_$bundle() {}
    public static final ConfigMessages_$bundle INSTANCE = new ConfigMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String hmacNotSupported$str() {
        return "SRJWT02000: HMAC verification algorithms are not supported when the 'mp.jwt.verify.publickey.location' property is set, use 'smallrye.jwt.verify.key.location' instead";
    }
    @Override
    public final DeploymentException hmacNotSupported() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), hmacNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String parsingPublicKeyFailed$str() {
        return "SRJWT02001: Failed to decode the MP JWT Public Key";
    }
    @Override
    public final DeploymentException parsingPublicKeyFailed(final Throwable throwable) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), parsingPublicKeyFailed$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readingPublicKeyLocationFailed$str() {
        return "SRJWT02002: Failed to read the public key content from 'mp.jwt.verify.publickey.location'";
    }
    @Override
    public final DeploymentException readingPublicKeyLocationFailed(final Throwable throwable) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), readingPublicKeyLocationFailed$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPublicKeyLocation$str() {
        return "SRJWT02003: 'mp.jwt.verify.publickey.location' is invalid";
    }
    @Override
    public final DeploymentException invalidPublicKeyLocation() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), invalidPublicKeyLocation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readingDecryptKeyLocationFailed$str() {
        return "SRJWT02004: Failed to read the decryption key content from 'smallrye.jwt.decrypt.key.location'";
    }
    @Override
    public final DeploymentException readingDecryptKeyLocationFailed(final Throwable throwable) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), readingDecryptKeyLocationFailed$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDecryptKeyLocation$str() {
        return "SRJWT02005: 'smallrye.jwt.decrypt.key.location' is invalid";
    }
    @Override
    public final DeploymentException invalidDecryptKeyLocation() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), invalidDecryptKeyLocation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
