package io.smallrye.jwt.auth.principal;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.net.URL;
import java.util.ServiceLoader;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.ClassLoader;
import java.util.List;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class PrincipalLogging_$logger extends DelegatingBasicLogger implements PrincipalLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = PrincipalLogging_$logger.class.getName();
    public PrincipalLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void getAudienceFailure(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, getAudienceFailure$str());
    }
    protected String getAudienceFailure$str() {
        return "SRJWT08000: getAudience failure";
    }
    @Override
    public final void getGroupsFailure(final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, getGroupsFailure0$str());
    }
    protected String getGroupsFailure0$str() {
        return "SRJWT08001: getGroups failure: ";
    }
    @Override
    public final void getGroupsFailure(final String claimName, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, getGroupsFailure1$str(), claimName);
    }
    protected String getGroupsFailure1$str() {
        return "SRJWT08002: getClaimValue failure for: %s";
    }
    @Override
    public final void replaceClaimValueWithJsonFailure(final String claimName, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, replaceClaimValueWithJsonFailure$str(), claimName);
    }
    protected String replaceClaimValueWithJsonFailure$str() {
        return "SRJWT08003: replaceClaimValueWithJsonValue failure for: %s";
    }
    @Override
    public final void tokenInvalid() {
        super.log.logf(FQCN, DEBUG, null, tokenInvalid$str());
    }
    protected String tokenInvalid$str() {
        return "SRJWT08004: Token is invalid";
    }
    @Override
    public final void verificationKeyUnresolvable() {
        super.log.logf(FQCN, DEBUG, null, verificationKeyUnresolvable$str());
    }
    protected String verificationKeyUnresolvable$str() {
        return "SRJWT08005: Verification key is unresolvable";
    }
    @Override
    public final void claimAtPathIsNotAString(final String claimPath) {
        super.log.logf(FQCN, DEBUG, null, claimAtPathIsNotAString$str(), claimPath);
    }
    protected String claimAtPathIsNotAString$str() {
        return "SRJWT08006: Claim value at the path %s is not a String";
    }
    @Override
    public final void claimAtPathIsNotAnArrayOfStrings(final String claimPath) {
        super.log.logf(FQCN, DEBUG, null, claimAtPathIsNotAnArrayOfStrings$str(), claimPath);
    }
    protected String claimAtPathIsNotAnArrayOfStrings$str() {
        return "SRJWT08007: Claim value at the path %s is not an array of strings";
    }
    @Override
    public final void claimAtPathIsNeitherAnArrayOfStringsNorString(final String claimPath) {
        super.log.logf(FQCN, DEBUG, null, claimAtPathIsNeitherAnArrayOfStringsNorString$str(), claimPath);
    }
    protected String claimAtPathIsNeitherAnArrayOfStringsNorString$str() {
        return "SRJWT08008: Claim value at the path %s is neither an array of strings nor string";
    }
    @Override
    public final void updatedGroups(final List<String> groups) {
        super.log.logf(FQCN, TRACE, null, updatedGroups$str(), groups);
    }
    protected String updatedGroups$str() {
        return "SRJWT08009: Updated groups to: %s";
    }
    @Override
    public final void failedToAccessRolesMappingClaim(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, failedToAccessRolesMappingClaim$str());
    }
    protected String failedToAccessRolesMappingClaim$str() {
        return "SRJWT08010: Failed to access rolesMapping claim";
    }
    @Override
    public final void claimNotFoundAtPathAtSegment(final String claimPath, final String segment) {
        super.log.logf(FQCN, DEBUG, null, claimNotFoundAtPathAtSegment$str(), claimPath, segment);
    }
    protected String claimNotFoundAtPathAtSegment$str() {
        return "SRJWT08011: No claim exists at the path %s at segment %s";
    }
    @Override
    public final void claimValueIsNotAJson(final String claimPath) {
        super.log.logf(FQCN, DEBUG, null, claimValueIsNotAJson$str(), claimPath);
    }
    protected String claimValueIsNotAJson$str() {
        return "SRJWT08012: Claim value at the path %s is not a json object";
    }
    @Override
    public final void missingClaims(final String missingClaims) {
        super.log.logf(FQCN, DEBUG, null, missingClaims$str(), missingClaims);
    }
    protected String missingClaims$str() {
        return "SRJWT08014: Required claims %s are not present in the JWT";
    }
    @Override
    public final void loadSpi(final ClassLoader classLoader, final URL url, final ServiceLoader<io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory> serviceLoader) {
        super.log.logf(FQCN, DEBUG, null, loadSpi$str(), classLoader, url, serviceLoader);
    }
    protected String loadSpi$str() {
        return "SRJWT08015: loadSpi, cl=%s, u=%s, sl=%s";
    }
    @Override
    public final void multipleJWTCallerPrincipalFactoryFound(final String instanceName1, final String instanceName2) {
        super.log.logf(FQCN, WARN, null, multipleJWTCallerPrincipalFactoryFound$str(), instanceName1, instanceName2);
    }
    protected String multipleJWTCallerPrincipalFactoryFound$str() {
        return "SRJWT08016: Multiple JWTCallerPrincipalFactory implementations found: %s and %s";
    }
    @Override
    public final void currentSpi(final ServiceLoader<io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory> sl, final io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory spi) {
        super.log.logf(FQCN, DEBUG, null, currentSpi$str(), sl, spi);
    }
    protected String currentSpi$str() {
        return "SRJWT08017: sl=%s, loaded=%s";
    }
    @Override
    public final void failedToLocateJWTCallerPrincipalFactoryProvider(final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, failedToLocateJWTCallerPrincipalFactoryProvider$str());
    }
    protected String failedToLocateJWTCallerPrincipalFactoryProvider$str() {
        return "SRJWT08018: Failed to locate JWTCallerPrincipalFactory provider";
    }
    @Override
    public final void authContextInfo(final io.smallrye.jwt.auth.principal.JWTAuthContextInfo authContextInfo) {
        super.log.logf(FQCN, DEBUG, null, authContextInfo$str(), authContextInfo);
    }
    protected String authContextInfo$str() {
        return "SRJWT08019: AuthContextInfo is: %s";
    }
    @Override
    public final void failedToCreateKeyFromJWKSet(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, failedToCreateKeyFromJWKSet$str());
    }
    protected String failedToCreateKeyFromJWKSet$str() {
        return "SRJWT08020: Failed to create a key from the HTTPS JWK Set";
    }
    @Override
    public final void kidIsNotAvailableRefreshingJWKSet() {
        super.log.logf(FQCN, DEBUG, null, kidIsNotAvailableRefreshingJWKSet$str());
    }
    protected String kidIsNotAvailableRefreshingJWKSet$str() {
        return "SRJWT08021: JWK with a matching 'kid' is not available, refreshing HTTPS JWK Set";
    }
    @Override
    public final void failedToRefreshJWKSet(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, failedToRefreshJWKSet$str());
    }
    protected String failedToRefreshJWKSet$str() {
        return "SRJWT08022: Failed to refresh HTTPS JWK Set";
    }
    @Override
    public final void matchingKidIsNotAvailableButJWTSRefreshed(final int minutes) {
        super.log.logf(FQCN, DEBUG, null, matchingKidIsNotAvailableButJWTSRefreshed$str(), minutes);
    }
    protected String matchingKidIsNotAvailableButJWTSRefreshed$str() {
        return "SRJWT08023: JWK with a matching 'kid' is not available but HTTPS JWK Set has been refreshed less than %d minutes ago, trying to create a key from the HTTPS JWK Set one more time";
    }
    @Override
    public final void tryCreateKeyFromJWKSAfterRefresh() {
        super.log.logf(FQCN, DEBUG, null, tryCreateKeyFromJWKSAfterRefresh$str());
    }
    protected String tryCreateKeyFromJWKSAfterRefresh$str() {
        return "SRJWT08024: Trying to create a key from the HTTPS JWK Set after the refresh";
    }
    @Override
    public final void failedToCreateKeyFromJWKSAfterRefresh(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, failedToCreateKeyFromJWKSAfterRefresh$str());
    }
    protected String failedToCreateKeyFromJWKSAfterRefresh$str() {
        return "SRJWT08025: Failed to create a key from the HTTPS JWK Set after the refresh";
    }
    @Override
    public final void tryCreateKeyFromJWKS() {
        super.log.logf(FQCN, DEBUG, null, tryCreateKeyFromJWKS$str());
    }
    protected String tryCreateKeyFromJWKS$str() {
        return "SRJWT08026: Trying to create a key from the JWK(S)";
    }
    @Override
    public final void failedToCreateKeyFromJWKS(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, failedToCreateKeyFromJWKS$str());
    }
    protected String failedToCreateKeyFromJWKS$str() {
        return "SRJWT08027: Failed to create a key from the JWK(S)";
    }
    @Override
    public final void invalidTokenKidHeader(final String kidHeaderName, final String expectedName) {
        super.log.logf(FQCN, DEBUG, null, invalidTokenKidHeader$str(), kidHeaderName, expectedName);
    }
    protected String invalidTokenKidHeader$str() {
        return "SRJWT08028: Invalid token 'kid' header: %s, expected: %s";
    }
    @Override
    public final void tryLoadKeyFromJWKS() {
        super.log.logf(FQCN, DEBUG, null, tryLoadKeyFromJWKS$str());
    }
    protected String tryLoadKeyFromJWKS$str() {
        return "SRJWT08029: Trying to load the keys from the HTTPS JWK(S)";
    }
    @Override
    public final void checkKeyContentIsJWKKeyOrJWKKeySet() {
        super.log.logf(FQCN, DEBUG, null, checkKeyContentIsJWKKeyOrJWKKeySet$str());
    }
    protected String checkKeyContentIsJWKKeyOrJWKKeySet$str() {
        return "SRJWT08030: Checking if the key content is a JWK key or JWK key set";
    }
    @Override
    public final void checkKeyContentIsBase64EncodedJWKKeyOrJWKKeySet() {
        super.log.logf(FQCN, DEBUG, null, checkKeyContentIsBase64EncodedJWKKeyOrJWKKeySet$str());
    }
    protected String checkKeyContentIsBase64EncodedJWKKeyOrJWKKeySet$str() {
        return "SRJWT08031: Checking if the key content is a Base64URL encoded JWK key or JWK key set";
    }
    @Override
    public final void unableToDecodeContentUsingBase64(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, unableToDecodeContentUsingBase64$str());
    }
    protected String unableToDecodeContentUsingBase64$str() {
        return "SRJWT08032: Unable to decode content using Base64 decoder";
    }
    @Override
    public final void keyCreatedFromEncodedJWKKeyOrJWKKeySet() {
        super.log.logf(FQCN, DEBUG, null, keyCreatedFromEncodedJWKKeyOrJWKKeySet$str());
    }
    protected String keyCreatedFromEncodedJWKKeyOrJWKKeySet$str() {
        return "SRJWT08033: Key has been created from the encoded JWK key or JWK key set";
    }
    @Override
    public final void keyCreatedFromJWKKeyOrJWKKeySet() {
        super.log.logf(FQCN, DEBUG, null, keyCreatedFromJWKKeyOrJWKKeySet$str());
    }
    protected String keyCreatedFromJWKKeyOrJWKKeySet$str() {
        return "SRJWT08034: Key has been created from the JWK key or JWK key set";
    }
    @Override
    public final void checkKeyContentIsBase64EncodedPEMKey() {
        super.log.logf(FQCN, DEBUG, null, checkKeyContentIsBase64EncodedPEMKey$str());
    }
    protected String checkKeyContentIsBase64EncodedPEMKey$str() {
        return "SRJWT08035: Checking if the key content is a Base64 encoded PEM key";
    }
    @Override
    public final void keyCreatedFromEncodedPEMKey() {
        super.log.logf(FQCN, DEBUG, null, keyCreatedFromEncodedPEMKey$str());
    }
    protected String keyCreatedFromEncodedPEMKey$str() {
        return "SRJWT08036: Key has been created from the encoded PEM key";
    }
    @Override
    public final void keyContentIsNotValidEncodedPEMKey(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, keyContentIsNotValidEncodedPEMKey$str());
    }
    protected String keyContentIsNotValidEncodedPEMKey$str() {
        return "SRJWT08037: The key content is not a valid encoded PEM key";
    }
    @Override
    public final void checkKeyContentIsBase64EncodedPEMCertificate() {
        super.log.logf(FQCN, DEBUG, null, checkKeyContentIsBase64EncodedPEMCertificate$str());
    }
    protected String checkKeyContentIsBase64EncodedPEMCertificate$str() {
        return "SRJWT08038: Checking if the key content is a Base64 encoded PEM certificate";
    }
    @Override
    public final void publicKeyCreatedFromEncodedPEMCertificate() {
        super.log.logf(FQCN, DEBUG, null, publicKeyCreatedFromEncodedPEMCertificate$str());
    }
    protected String publicKeyCreatedFromEncodedPEMCertificate$str() {
        return "SRJWT08039: PublicKey has been created from the encoded PEM certificate";
    }
    @Override
    public final void keyContentIsNotValidEncodedPEMCertificate(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, keyContentIsNotValidEncodedPEMCertificate$str());
    }
    protected String keyContentIsNotValidEncodedPEMCertificate$str() {
        return "SRJWT08040: The key content is not a valid encoded PEM certificate";
    }
    @Override
    public final void decryptionKeyUnresolvable() {
        super.log.logf(FQCN, DEBUG, null, decryptionKeyUnresolvable$str());
    }
    protected String decryptionKeyUnresolvable$str() {
        return "SRJWT08041: Decryption key is unresolvable";
    }
    @Override
    public final void encryptedTokenSequenceInvalid() {
        super.log.logf(FQCN, DEBUG, null, encryptedTokenSequenceInvalid$str());
    }
    protected String encryptedTokenSequenceInvalid$str() {
        return "SRJWT08042: Encrypted token sequence is invalid";
    }
    @Override
    public final void tryCreateKeyFromHttpsJWKS() {
        super.log.logf(FQCN, DEBUG, null, tryCreateKeyFromHttpsJWKS$str());
    }
    protected String tryCreateKeyFromHttpsJWKS$str() {
        return "SRJWT08043: Trying to create a key from the HTTPS JWK(S)";
    }
    @Override
    public final void encryptedTokenMissingContentType() {
        super.log.logf(FQCN, DEBUG, null, encryptedTokenMissingContentType$str());
    }
    protected String encryptedTokenMissingContentType$str() {
        return "SRJWT08044: Encrypted token headers must contain a content type header";
    }
}
