/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class LRUCache<K, V> {
    private final int maxSize;
    private final Map<K, Entry<V>> cache = new ConcurrentHashMap<K, Entry<V>>();
    private final AtomicInteger size = new AtomicInteger();
    private Entry<V> start;
    private Entry<V> end;

    LRUCache(int maxSize) {
        this.maxSize = maxSize;
    }

    V get(K key) {
        Entry entry = this.cache.computeIfPresent(key, this::moveEntryToStart);
        return entry == null ? null : (V)entry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V computeIfAbsent(K key, Function<K, V> valueFunction) {
        AtomicBoolean called = new AtomicBoolean();
        Entry entry = this.cache.computeIfAbsent(key, (? super K k) -> {
            called.set(true);
            Entry e = new Entry(k, valueFunction.apply(k));
            this.addToStart(e);
            return e;
        });
        if (!called.get()) {
            this.cache.computeIfPresent(key, this::moveEntryToStart);
        } else {
            int newSize = this.size.incrementAndGet();
            if (newSize > this.maxSize) {
                AtomicBoolean removed = new AtomicBoolean();
                do {
                    Entry<V> entryToRemove;
                    LRUCache lRUCache = this;
                    synchronized (lRUCache) {
                        entryToRemove = this.end;
                    }
                    if (entryToRemove == null) break;
                    this.cache.computeIfPresent(entryToRemove.key, (k, v) -> {
                        if (v == entryToRemove) {
                            removed.set(true);
                            this.removeEntry(entryToRemove);
                            return null;
                        }
                        return v;
                    });
                } while (!removed.get());
                if (removed.get()) {
                    this.size.decrementAndGet();
                }
            }
        }
        return entry.value;
    }

    private synchronized Entry<V> moveEntryToStart(K key, Entry<V> entry) {
        if (this.start != entry) {
            this.removeEntry(entry);
            this.addToStart(entry);
        }
        return entry;
    }

    private synchronized void removeEntry(Entry<V> entry) {
        if (entry == null || entry.left == entry) {
            return;
        }
        if (entry.left != null) {
            entry.left.right = entry.right;
        } else {
            this.start = entry.right;
        }
        if (entry.right != null) {
            entry.right.left = entry.left;
        } else {
            this.end = entry.left;
        }
        entry.right = entry;
        entry.left = entry.right;
    }

    private synchronized void addToStart(Entry<V> entry) {
        if (entry == null) {
            return;
        }
        entry.right = this.start;
        entry.left = null;
        if (this.start != null) {
            this.start.left = entry;
        }
        this.start = entry;
        if (this.end == null) {
            this.end = this.start;
        }
    }

    private class Entry<V> {
        final K key;
        V value;
        Entry<V> left;
        Entry<V> right;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

