/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.vertx;

import io.smallrye.graphql.client.typesafe.api.AuthorizationHeader;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientException;
import io.smallrye.graphql.client.typesafe.api.Header;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodResolver;
import io.smallrye.graphql.client.typesafe.impl.reflection.ParameterInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class HeaderBuilder {
    private final Class<?> api;
    private final MethodInvocation method;
    private final Map<String, String> additionalHeaders;
    private static final Config CONFIG = ConfigProvider.getConfig();

    public HeaderBuilder(Class<?> api, MethodInvocation method, Map<String, String> additionalHeaders) {
        this.api = api;
        this.method = method;
        this.additionalHeaders = additionalHeaders;
    }

    public MultiMap build() {
        HeadersMultiMap headers = new HeadersMultiMap();
        this.method.getResolvedAnnotations(this.api, Header.class).forEach(arg_0 -> this.lambda$build$0((MultiMap)headers, arg_0));
        this.method.headerParameters().forEach(arg_0 -> HeaderBuilder.lambda$build$1((MultiMap)headers, arg_0));
        this.method.getResolvedAnnotations(this.api, AuthorizationHeader.class).reduce((first, second) -> second).map(header -> this.resolveAuthHeader(this.method.getDeclaringType(), (AuthorizationHeader)header)).ifPresent(arg_0 -> HeaderBuilder.lambda$build$4((MultiMap)headers, arg_0));
        if (this.additionalHeaders != null) {
            this.additionalHeaders.forEach((arg_0, arg_1) -> ((MultiMap)headers).set(arg_0, arg_1));
        }
        return headers;
    }

    private String resolveValue(Header header) {
        if (!header.method().isEmpty()) {
            if (!header.constant().isEmpty()) {
                throw new GraphQLClientException("Header with 'method' AND 'constant' not allowed: " + header);
            }
            return this.resolveMethodValue(header.method());
        }
        if (header.constant().isEmpty()) {
            throw new GraphQLClientException("Header must have either 'method' XOR 'constant': " + header);
        }
        return header.constant();
    }

    private String resolveMethodValue(String methodName) {
        TypeInfo declaringType = this.method.getDeclaringType();
        MethodInvocation method = new MethodResolver(declaringType, methodName).resolve();
        if (!method.isStatic()) {
            throw new GraphQLClientException("referenced header method '" + methodName + "' in " + declaringType.getTypeName() + " is not static");
        }
        try {
            return method.invoke(null).toString();
        }
        catch (RuntimeException e) {
            if (e instanceof GraphQLClientException) {
                throw e;
            }
            throw new GraphQLClientException("can't resolve header method expression '" + methodName + "' in " + declaringType.getTypeName(), (Throwable)e);
        }
    }

    private String resolveAuthHeader(TypeInfo declaringType, AuthorizationHeader header) {
        if (header.confPrefix().isEmpty()) {
            return HeaderBuilder.auth(header.type(), declaringType.getRawType());
        }
        return HeaderBuilder.auth(header.type(), header.confPrefix());
    }

    private static String auth(AuthorizationHeader.Type type, Class<?> api) {
        return HeaderBuilder.auth(type, HeaderBuilder.configKey(api));
    }

    private static String configKey(Class<?> api) {
        GraphQLClientApi annotation = api.getAnnotation(GraphQLClientApi.class);
        if (annotation == null || annotation.configKey().isEmpty()) {
            return api.getName();
        }
        return annotation.configKey();
    }

    private static String auth(AuthorizationHeader.Type type, String configKey) {
        String prefix = configKey.endsWith("*") ? configKey.substring(0, configKey.length() - 1) : configKey + "/mp-graphql/";
        switch (type) {
            case BASIC: {
                return HeaderBuilder.basic(prefix);
            }
            case BEARER: {
                return HeaderBuilder.bearer(prefix);
            }
        }
        throw new UnsupportedOperationException("unreachable");
    }

    private static String basic(String prefix) {
        String username = (String)CONFIG.getValue(prefix + "username", String.class);
        String password = (String)CONFIG.getValue(prefix + "password", String.class);
        String token = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    private static String bearer(String prefix) {
        return "Bearer " + (String)CONFIG.getValue(prefix + "bearer", String.class);
    }

    private static /* synthetic */ void lambda$build$4(MultiMap headers, String auth) {
        headers.set("Authorization", auth);
    }

    private static /* synthetic */ void lambda$build$1(MultiMap headers, ParameterInfo parameter) {
        Header header = ((Header[])parameter.getAnnotations(Header.class))[0];
        headers.set(header.name(), (String)parameter.getValue());
    }

    private /* synthetic */ void lambda$build$0(MultiMap headers, Header e) {
        headers.set(e.name(), this.resolveValue(e));
    }
}

