/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic.vertx;

import io.smallrye.graphql.client.Request;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.ResponseReader;
import io.smallrye.graphql.client.core.Document;
import io.smallrye.graphql.client.dynamic.RequestImpl;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class VertxDynamicGraphQLClient
implements DynamicGraphQLClient {
    private final WebClient webClient;
    private final HttpClient httpClient;
    private final String url;
    private final MultiMap headers;

    VertxDynamicGraphQLClient(Vertx vertx, String url, MultiMap headers, WebClientOptions options) {
        this.httpClient = options != null ? vertx.createHttpClient((HttpClientOptions)options) : vertx.createHttpClient();
        this.webClient = WebClient.wrap((HttpClient)this.httpClient);
        this.headers = headers;
        this.url = url;
    }

    public Response executeSync(Document document) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, null, null));
    }

    public Response executeSync(Document document, Map<String, Object> variables) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, variables, null));
    }

    public Response executeSync(Document document, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, null, operationName));
    }

    public Response executeSync(Document document, Map<String, Object> variables, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, variables, operationName));
    }

    public Response executeSync(Request request) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)request.toJson()));
    }

    public Response executeSync(String query) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, null, null).toJson()));
    }

    public Response executeSync(String query, Map<String, Object> variables) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, variables, null).toJson()));
    }

    public Response executeSync(String query, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, null, operationName).toJson()));
    }

    public Response executeSync(String query, Map<String, Object> variables, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, variables, operationName).toJson()));
    }

    private Response executeSync(Buffer buffer) throws ExecutionException, InterruptedException {
        HttpResponse result = (HttpResponse)this.webClient.postAbs(this.url).putHeaders(this.headers).sendBuffer(buffer).toCompletionStage().toCompletableFuture().get();
        return ResponseReader.readFrom((String)result.bodyAsString(), (List)result.headers().entries());
    }

    public Uni<Response> executeAsync(Document document) {
        return this.executeAsync(this.buildRequest(document, null, null));
    }

    public Uni<Response> executeAsync(Document document, Map<String, Object> variables) {
        return this.executeAsync(this.buildRequest(document, variables, null));
    }

    public Uni<Response> executeAsync(Document document, String operationName) {
        return this.executeAsync(this.buildRequest(document, null, operationName));
    }

    public Uni<Response> executeAsync(Document document, Map<String, Object> variables, String operationName) {
        return this.executeAsync(this.buildRequest(document, variables, operationName));
    }

    public Uni<Response> executeAsync(Request request) {
        return this.executeAsync(Buffer.buffer((String)request.toJson()));
    }

    public Uni<Response> executeAsync(String query) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, null, null).toJson()));
    }

    public Uni<Response> executeAsync(String query, Map<String, Object> variables) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, variables, null).toJson()));
    }

    public Uni<Response> executeAsync(String query, String operationName) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, null, operationName).toJson()));
    }

    public Uni<Response> executeAsync(String query, Map<String, Object> variables, String operationName) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, variables, operationName).toJson()));
    }

    private Uni<Response> executeAsync(Buffer buffer) {
        return Uni.createFrom().completionStage(this.webClient.postAbs(this.url).putHeaders(this.headers).sendBuffer(buffer).toCompletionStage()).map(response -> ResponseReader.readFrom((String)response.bodyAsString(), (List)response.headers().entries()));
    }

    public Multi<Response> subscription(Document document) {
        return this.subscription0(this.buildRequest(document, null, null).toJson());
    }

    public Multi<Response> subscription(Document document, Map<String, Object> variables) {
        return this.subscription0(this.buildRequest(document, variables, null).toJson());
    }

    public Multi<Response> subscription(Document document, String operationName) {
        return this.subscription0(this.buildRequest(document, null, operationName).toJson());
    }

    public Multi<Response> subscription(Document document, Map<String, Object> variables, String operationName) {
        return this.subscription0(this.buildRequest(document, variables, operationName).toJson());
    }

    public Multi<Response> subscription(Request request) {
        return this.subscription0(request.toJson());
    }

    public Multi<Response> subscription(String query) {
        return this.subscription0(this.buildRequest(query, null, null).toJson());
    }

    public Multi<Response> subscription(String query, Map<String, Object> variables) {
        return this.subscription0(this.buildRequest(query, variables, null).toJson());
    }

    public Multi<Response> subscription(String query, String operationName) {
        return this.subscription0(this.buildRequest(query, null, operationName).toJson());
    }

    public Multi<Response> subscription(String query, Map<String, Object> variables, String operationName) {
        return this.subscription0(this.buildRequest(query, variables, operationName).toJson());
    }

    private Multi<Response> subscription0(String requestJson) {
        String WSURL = this.url.replaceFirst("http", "ws");
        return Multi.createFrom().emitter(e -> this.httpClient.webSocketAbs(WSURL, this.headers, WebsocketVersion.V13, new ArrayList(), result -> {
            if (result.succeeded()) {
                WebSocket socket = (WebSocket)result.result();
                socket.writeTextMessage(requestJson);
                socket.handler(message -> e.emit((Object)ResponseReader.readFrom((String)message.toString(), Collections.emptyList())));
                socket.closeHandler(v -> e.complete());
                e.onTermination(() -> ((WebSocket)socket).close());
            } else {
                e.fail(result.cause());
            }
        }));
    }

    private Request buildRequest(Document document, Map<String, Object> variables, String operationName) {
        return this.buildRequest(document.build(), variables, operationName);
    }

    private Request buildRequest(String query, Map<String, Object> variables, String operationName) {
        RequestImpl request = new RequestImpl(query);
        if (variables != null) {
            request.setVariables(variables);
        }
        if (operationName != null && !operationName.isEmpty()) {
            request.setOperationName(operationName);
        }
        return request;
    }

    public void close() {
        this.httpClient.close();
    }
}

