/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.autoconfig.processor;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.smallrye.config.common.utils.StringUtil;
import io.smallrye.faulttolerance.autoconfig.AutoConfig;
import io.smallrye.faulttolerance.autoconfig.processor.TypeNames;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.smallrye.faulttolerance.autoconfig.AutoConfig"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AutoConfigProcessor
extends AbstractProcessor {
    private final Set<TypeElement> newConfigAnnotations = new HashSet<TypeElement>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                this.generateNewConfig(this.newConfigAnnotations);
            } else {
                this.doProcess(annotations, roundEnv);
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unexpected error: " + e.getMessage());
        }
        return false;
    }

    private void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
        if (!annotations.isEmpty()) {
            TypeElement generateConfigForAnnotation = annotations.iterator().next();
            for (Element element : roundEnv.getElementsAnnotatedWith(generateConfigForAnnotation)) {
                this.processConfigClass((TypeElement)element);
            }
        }
    }

    private void processConfigClass(TypeElement configClass) throws IOException {
        if (configClass.getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@AutoConfig type " + String.valueOf(configClass) + " must be an interface");
            return;
        }
        if (configClass.getNestingKind().isNested()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@AutoConfig interface " + String.valueOf(configClass) + " must be top-level");
            return;
        }
        List<? extends TypeMirror> interfaces = configClass.getInterfaces();
        if (interfaces.size() != 2) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@AutoConfig interface " + String.valueOf(configClass) + " must have 2 super-interfaces: the annotation type and io.smallrye.faulttolerance.autoconfig.Config");
            return;
        }
        Optional<TypeElement> annotationDeclaration = configClass.getInterfaces().stream().filter(it -> it.getKind() == TypeKind.DECLARED).map(it -> ((DeclaredType)it).asElement()).filter(it -> it.getKind() == ElementKind.ANNOTATION_TYPE).map(it -> (TypeElement)it).findAny();
        if (!annotationDeclaration.isPresent()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@AutoConfig interface " + String.valueOf(configClass) + " must extend the annotation type");
            return;
        }
        this.generateConfigImpl(configClass, annotationDeclaration.get());
    }

    private void generateConfigImpl(TypeElement configClass, TypeElement annotationDeclaration) throws IOException {
        AutoConfig autoConfig = configClass.getAnnotation(AutoConfig.class);
        boolean configurable = autoConfig.configurable();
        boolean newConfigAllowed = autoConfig.newConfigAllowed();
        if (configurable && newConfigAllowed) {
            this.newConfigAnnotations.add(annotationDeclaration);
        }
        String packageName = configClass.getQualifiedName().toString().replace("." + String.valueOf(configClass.getSimpleName()), "");
        ClassName configImplClassName = ClassName.get((String)packageName, (String)(String.valueOf(configClass.getSimpleName()) + "Impl"), (String[])new String[0]);
        TypeName annotationType = TypeName.get((TypeMirror)annotationDeclaration.asType());
        JavaFile.builder((String)packageName, (TypeSpec)TypeSpec.classBuilder((ClassName)configImplClassName).addOriginatingElement((Element)configClass).addJavadoc("Automatically generated from the {@link $L} config interface, do not modify.", new Object[]{configClass.getSimpleName()}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(configClass.asType()).addField(TypeNames.CLASS, "beanClass", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(TypeNames.METHOD_DESCRIPTOR, "method", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(FieldSpec.builder((TypeName)annotationType, (String)"instance", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addJavadoc(configurable ? "Backing annotation instance. Used when runtime configuration doesn't override it." : "Backing annotation instance.", new Object[0]).build()).addField(FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)"onMethod", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addJavadoc("{@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.", new Object[0]).build()).addFields(configurable ? (Iterable)ElementFilter.methodsIn(annotationDeclaration.getEnclosedElements()).stream().map(annotationMember -> FieldSpec.builder((TypeName)TypeName.get((TypeMirror)annotationMember.getReturnType()).box(), (String)("_" + String.valueOf(annotationMember.getSimpleName())), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc("Cached value of the {@code $1L.$2L} annotation member; {@code null} if not looked up yet.", new Object[]{annotationDeclaration.getSimpleName(), annotationMember.getSimpleName()}).build()).collect(Collectors.toList()) : Collections.emptyList()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(TypeNames.FAULT_TOLERANCE_METHOD, "method", new Modifier[0]).addStatement("this.beanClass = method.beanClass", new Object[0]).addStatement("this.method = method.method", new Object[0]).addStatement("this.instance = method.$1L", new Object[]{AutoConfigProcessor.firstToLowerCase(annotationDeclaration.getSimpleName().toString())}).addStatement("this.onMethod = method.annotationsPresentDirectly.contains($1T.class)", new Object[]{annotationType}).build()).addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)configImplClassName).addParameter(TypeNames.FAULT_TOLERANCE_METHOD, "method", new Modifier[0]).beginControlFlow("if (method.$L == null)", new Object[]{AutoConfigProcessor.firstToLowerCase(annotationDeclaration.getSimpleName().toString())}).addStatement("return null", new Object[0]).endControlFlow().addCode(configurable ? CodeBlock.builder().beginControlFlow("if (!$1T.isEnabled($2T.class, method.method))", new Object[]{TypeNames.CONFIG_UTIL, annotationType}).addStatement("return null", new Object[0]).endControlFlow().build() : CodeBlock.builder().build()).addStatement("return new $T(method)", new Object[]{configImplClassName}).build()).addMethod(MethodSpec.methodBuilder((String)"beanClass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeNames.CLASS).addStatement("return beanClass", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"method").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeNames.METHOD_DESCRIPTOR).addStatement("return method", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"annotationType").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeNames.CLASS_OF_ANNOTATION).addStatement("return $T.class", new Object[]{annotationType}).build()).addMethod(MethodSpec.methodBuilder((String)"isOnMethod").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return onMethod", new Object[0]).build()).addMethods((Iterable)ElementFilter.methodsIn(annotationDeclaration.getEnclosedElements()).stream().map(annotationMember -> MethodSpec.methodBuilder((String)annotationMember.getSimpleName().toString()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)annotationMember.getReturnType())).addCode(configurable ? this.generateConfigurableMethod((ExecutableElement)annotationMember, annotationDeclaration, newConfigAllowed) : this.generateNonconfigurableMethod((ExecutableElement)annotationMember)).build()).collect(Collectors.toList())).addMethod(MethodSpec.methodBuilder((String)"materialize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addCode(this.generateMaterializeMethod(annotationDeclaration)).build()).build()).indent("    ").build().writeTo(this.processingEnv.getFiler());
    }

    private CodeBlock generateConfigurableMethod(ExecutableElement annotationMember, TypeElement annotationDeclaration, boolean newConfigAllowed) {
        if (newConfigAllowed) {
            return CodeBlock.builder().beginControlFlow("if (_$L == null)", new Object[]{annotationMember.getSimpleName()}).addStatement("$1T config = $2T.getConfig()", new Object[]{TypeNames.MP_CONFIG, TypeNames.MP_CONFIG_PROVIDER}).beginControlFlow("if (onMethod)", new Object[0]).add("// smallrye.faulttolerance.\"<classname>/<methodname>\".<annotation>.<member>\n", new Object[0]).addStatement("String newKey = ConfigUtil.newKey($1T.class, $2S, method.declaringClass, method.name)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).add("// <classname>/<methodname>/<annotation>/<member>\n", new Object[0]).addStatement("String oldKey = ConfigUtil.oldKey($1T.class, $2S, method.declaringClass, method.name)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).addStatement("_$1L = config.getOptionalValue(newKey, $2T.class).or(() -> config.getOptionalValue(oldKey, $2T.class)).orElse(null)", new Object[]{annotationMember.getSimpleName(), AutoConfigProcessor.rawType(annotationMember.getReturnType())}).nextControlFlow("else", new Object[0]).add("// smallrye.faulttolerance.\"<classname>\".<annotation>.<member>\n", new Object[0]).addStatement("String newKey = ConfigUtil.newKey($1T.class, $2S, method.declaringClass)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).add("// <classname>/<annotation>/<member>\n", new Object[0]).addStatement("String oldKey = ConfigUtil.oldKey($1T.class, $2S, method.declaringClass)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).addStatement("_$1L = config.getOptionalValue(newKey, $2T.class).or(() -> config.getOptionalValue(oldKey, $2T.class)).orElse(null)", new Object[]{annotationMember.getSimpleName(), AutoConfigProcessor.rawType(annotationMember.getReturnType())}).endControlFlow().beginControlFlow("if (_$L == null)", new Object[]{annotationMember.getSimpleName()}).add("// smallrye.faulttolerance.global.<annotation>.<member>\n", new Object[0]).addStatement("String newKey = ConfigUtil.newKey($1T.class, $2S)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).add("// <annotation>/<member>\n", new Object[0]).addStatement("String oldKey = ConfigUtil.oldKey($1T.class, $2S)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).addStatement("_$1L = config.getOptionalValue(newKey, $2T.class).or(() -> config.getOptionalValue(oldKey, $2T.class)).orElse(null)", new Object[]{annotationMember.getSimpleName(), AutoConfigProcessor.rawType(annotationMember.getReturnType())}).endControlFlow().beginControlFlow("if (_$L == null)", new Object[]{annotationMember.getSimpleName()}).add("// annotation value\n", new Object[0]).addStatement("_$1L = instance.$1L()", new Object[]{annotationMember.getSimpleName()}).endControlFlow().endControlFlow().addStatement("return _$L", new Object[]{annotationMember.getSimpleName()}).build();
        }
        return CodeBlock.builder().beginControlFlow("if (_$L == null)", new Object[]{annotationMember.getSimpleName()}).addStatement("$1T config = $2T.getConfig()", new Object[]{TypeNames.MP_CONFIG, TypeNames.MP_CONFIG_PROVIDER}).beginControlFlow("if (onMethod)", new Object[0]).add("// <classname>/<methodname>/<annotation>/<member>\n", new Object[0]).addStatement("String key = ConfigUtil.oldKey($1T.class, $2S, method.declaringClass, method.name)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).addStatement("_$1L = config.getOptionalValue(key, $2T.class).orElse(null)", new Object[]{annotationMember.getSimpleName(), AutoConfigProcessor.rawType(annotationMember.getReturnType())}).nextControlFlow("else", new Object[0]).add("// <classname>/<annotation>/<member>\n", new Object[0]).addStatement("String key = ConfigUtil.oldKey($1T.class, $2S, method.declaringClass)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).addStatement("_$1L = config.getOptionalValue(key, $2T.class).orElse(null)", new Object[]{annotationMember.getSimpleName(), AutoConfigProcessor.rawType(annotationMember.getReturnType())}).endControlFlow().beginControlFlow("if (_$L == null)", new Object[]{annotationMember.getSimpleName()}).add("// <annotation>/<member>\n", new Object[0]).addStatement("String key = ConfigUtil.oldKey($1T.class, $2S)", new Object[]{TypeName.get((TypeMirror)annotationDeclaration.asType()), annotationMember.getSimpleName()}).addStatement("_$1L = config.getOptionalValue(key, $2T.class).orElse(null)", new Object[]{annotationMember.getSimpleName(), AutoConfigProcessor.rawType(annotationMember.getReturnType())}).endControlFlow().beginControlFlow("if (_$L == null)", new Object[]{annotationMember.getSimpleName()}).add("// annotation value\n", new Object[0]).addStatement("_$1L = instance.$1L()", new Object[]{annotationMember.getSimpleName()}).endControlFlow().endControlFlow().addStatement("return _$L", new Object[]{annotationMember.getSimpleName()}).build();
    }

    private CodeBlock generateNonconfigurableMethod(ExecutableElement annotationMember) {
        return CodeBlock.builder().addStatement("return instance.$1L()", new Object[]{annotationMember.getSimpleName()}).build();
    }

    private CodeBlock generateMaterializeMethod(TypeElement annotationDeclaration) {
        CodeBlock.Builder builder = CodeBlock.builder();
        for (ExecutableElement annotationElement : ElementFilter.methodsIn(annotationDeclaration.getEnclosedElements())) {
            builder.addStatement("$L()", new Object[]{annotationElement.getSimpleName()});
        }
        return builder.build();
    }

    private static TypeName rawType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<TypeName, Void>(){

            @Override
            public TypeName visitArray(ArrayType t, Void unused) {
                TypeName componentType = AutoConfigProcessor.rawType(t.getComponentType());
                return ArrayTypeName.of((TypeName)componentType);
            }

            @Override
            public TypeName visitDeclared(DeclaredType t, Void unused) {
                return ClassName.get((TypeElement)((TypeElement)t.asElement()));
            }

            @Override
            public TypeName visitPrimitive(PrimitiveType t, Void unused) {
                return TypeName.get((TypeMirror)t);
            }

            @Override
            protected TypeName defaultAction(TypeMirror e, Void unused) {
                throw new IllegalArgumentException("Unexpected type mirror: " + String.valueOf(e));
            }
        }, null);
    }

    private static String firstToLowerCase(String str) {
        return str.substring(0, 1).toLowerCase(Locale.ROOT) + str.substring(1);
    }

    private void generateNewConfig(Set<TypeElement> configAnnotations) throws IOException {
        String packageName = "io.smallrye.faulttolerance.config";
        ClassName mappingClassName = ClassName.get((String)packageName, (String)"NewConfig", (String[])new String[0]);
        JavaFile.builder((String)packageName, (TypeSpec)TypeSpec.classBuilder((ClassName)mappingClassName).addJavadoc("Automatically generated from all config annotations, do not modify.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(FieldSpec.builder((TypeName)TypeNames.HASHMAP_OF_STRING_TO_STRING, (String)"MAP", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("mapping()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"mapping").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(TypeNames.HASHMAP_OF_STRING_TO_STRING).addCode(this.generateMappingTable(configAnnotations)).build()).addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeNames.STRING).addParameter(TypeNames.CLASS_OF_ANNOTATION, "annotation", new Modifier[0]).addStatement("return MAP.get(annotation.getSimpleName())", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeNames.STRING).addParameter(TypeNames.CLASS_OF_ANNOTATION, "annotation", new Modifier[0]).addParameter(TypeNames.STRING, "member", new Modifier[0]).addStatement("return MAP.get(annotation.getSimpleName() + \"/\" + member)", new Object[0]).build()).build()).indent("    ").build().writeTo(this.processingEnv.getFiler());
    }

    private CodeBlock generateMappingTable(Set<TypeElement> configAnnotations) {
        CodeBlock.Builder result = CodeBlock.builder();
        result.addStatement("$1T result = new $1T()", new Object[]{TypeNames.HASHMAP_OF_STRING_TO_STRING});
        configAnnotations.stream().sorted(Comparator.comparing(it -> it.getSimpleName().toString())).forEach(configAnnotation -> {
            String originalName = configAnnotation.getSimpleName().toString();
            String proprietaryName = StringUtil.skewer((String)originalName);
            result.addStatement("result.put($S, $S)", new Object[]{originalName, proprietaryName});
            result.addStatement("result.put($S, $S)", new Object[]{originalName + "/enabled", proprietaryName + ".enabled"});
            ElementFilter.methodsIn(configAnnotation.getEnclosedElements()).stream().sorted(Comparator.comparing(it -> it.getSimpleName().toString())).forEach(method -> {
                String methodOriginalName = originalName + "/" + String.valueOf(method.getSimpleName());
                String fixedName = method.getSimpleName().toString();
                switch (method.getSimpleName().toString()) {
                    case "jitterDelayUnit": {
                        fixedName = "jitterUnit";
                        break;
                    }
                    case "durationUnit": {
                        fixedName = "maxDurationUnit";
                    }
                }
                String methodProprietaryName = proprietaryName + "." + StringUtil.skewer((String)fixedName);
                result.addStatement("result.put($S, $S)", new Object[]{methodOriginalName, methodProprietaryName});
            });
        });
        result.addStatement("return result", new Object[0]);
        return result.build();
    }
}

