/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.api.ManagedExecutorConfig;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class DefaultValues {
    private final String EXEC_ASYNC = "ManagedExecutor/maxAsync";
    private final String EXEC_QUEUE = "ManagedExecutor/maxQueued";
    private final String EXEC_PROPAGATED = "ManagedExecutor/propagated";
    private final String EXEC_CLEARED = "ManagedExecutor/cleared";
    private final String THREAD_CLEARED = "ThreadContext/cleared";
    private final String THREAD_PROPAGATED = "ThreadContext/propagated";
    private final String THREAD_UNCHANGED = "ThreadContext/unchanged";
    private String[] executorPropagated;
    private String[] executorCleared;
    private int executorAsync;
    private int executorQueue;
    private String[] threadPropagated;
    private String[] threadCleared;
    private String[] threadUnchanged;

    public DefaultValues() {
        Config config = ConfigProvider.getConfig();
        this.executorAsync = config.getOptionalValue("ManagedExecutor/maxAsync", Integer.class).orElse(ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxAsync());
        this.executorQueue = config.getOptionalValue("ManagedExecutor/maxQueued", Integer.class).orElse(ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxQueued());
        this.executorPropagated = this.resolveConfiguration(config, "ManagedExecutor/propagated", SmallRyeContextManager.ALL_REMAINING_ARRAY);
        this.executorCleared = this.resolveConfiguration(config, "ManagedExecutor/cleared", SmallRyeContextManager.NO_STRING);
        this.threadCleared = this.resolveConfiguration(config, "ThreadContext/cleared", SmallRyeContextManager.NO_STRING);
        this.threadPropagated = this.resolveConfiguration(config, "ThreadContext/propagated", SmallRyeContextManager.ALL_REMAINING_ARRAY);
        this.threadUnchanged = this.resolveConfiguration(config, "ThreadContext/unchanged", SmallRyeContextManager.NO_STRING);
    }

    private String[] resolveConfiguration(Config mpConfig, String key, String[] originalValue) {
        try {
            return (String[])mpConfig.getValue(key, String[].class);
        }
        catch (NoSuchElementException e) {
            return originalValue;
        }
    }

    public String[] getExecutorPropagated() {
        return this.executorPropagated;
    }

    public String[] getExecutorCleared() {
        return this.executorCleared;
    }

    public int getExecutorAsync() {
        return this.executorAsync;
    }

    public int getExecutorQueue() {
        return this.executorQueue;
    }

    public String[] getThreadPropagated() {
        return this.threadPropagated;
    }

    public String[] getThreadCleared() {
        return this.threadCleared;
    }

    public String[] getThreadUnchanged() {
        return this.threadUnchanged;
    }
}

