/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.CapturedContextState;
import io.smallrye.context.impl.DefaultValues;
import io.smallrye.context.impl.ManagedExecutorBuilderImpl;
import io.smallrye.context.impl.ThreadContextBuilderImpl;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

public class SmallRyeContextManager
implements ContextManager {
    public static final String[] NO_STRING = new String[0];
    public static final String[] ALL_REMAINING_ARRAY = new String[]{"Remaining"};
    private List<ThreadContextProvider> providers;
    private List<ContextManagerExtension> extensions;
    private Map<String, ThreadContextProvider> providersByType;
    private String[] allProviderTypes;
    private DefaultValues defaultValues;

    SmallRyeContextManager(List<ThreadContextProvider> providers, List<ContextManagerExtension> extensions) {
        this.providers = new ArrayList<ThreadContextProvider>(providers);
        this.providersByType = new HashMap<String, ThreadContextProvider>();
        for (ThreadContextProvider provider : providers) {
            this.providersByType.put(provider.getThreadContextType(), provider);
        }
        this.allProviderTypes = this.providersByType.keySet().toArray(new String[this.providers.size()]);
        this.extensions = new ArrayList<ContextManagerExtension>(extensions);
        this.defaultValues = new DefaultValues();
        for (ContextManagerExtension extension : extensions) {
            extension.setup((ContextManager)this);
        }
    }

    public String[] getAllProviderTypes() {
        return this.allProviderTypes;
    }

    public CapturedContextState captureContext(ThreadContextProviderPlan plan) {
        Map<String, String> props = Collections.emptyMap();
        return new CapturedContextState(this, plan, props);
    }

    public ThreadContextProviderPlan getProviderPlan() {
        return this.getProviderPlan(this.allProviderTypes, NO_STRING, NO_STRING);
    }

    public ThreadContextProviderPlan getProviderPlan(String[] propagated, String[] unchanged, String[] cleared) {
        HashSet propagatedSet = new HashSet();
        Collections.addAll(propagatedSet, propagated);
        HashSet clearedSet = new HashSet();
        Collections.addAll(clearedSet, cleared);
        HashSet unchangedSet = new HashSet();
        Collections.addAll(unchangedSet, unchanged);
        if (propagatedSet.removeAll(unchangedSet) || propagatedSet.removeAll(clearedSet) || clearedSet.removeAll(propagatedSet) || clearedSet.removeAll(unchangedSet) || unchangedSet.removeAll(propagatedSet) || unchangedSet.removeAll(clearedSet)) {
            throw new IllegalStateException("Cannot use ALL_REMAINING in more than one of propagated, cleared, unchanged");
        }
        boolean hadAllRemaining = false;
        if (propagatedSet.contains("Remaining")) {
            propagatedSet.remove("Remaining");
            Collections.addAll(propagatedSet, this.allProviderTypes);
            propagatedSet.removeAll(clearedSet);
            propagatedSet.removeAll(unchangedSet);
            hadAllRemaining = true;
        }
        if (unchangedSet.contains("Remaining")) {
            unchangedSet.remove("Remaining");
            Collections.addAll(unchangedSet, this.allProviderTypes);
            unchangedSet.removeAll(propagatedSet);
            unchangedSet.removeAll(clearedSet);
            hadAllRemaining = true;
        }
        if (clearedSet.contains("Remaining") || !hadAllRemaining) {
            clearedSet.remove("Remaining");
            Collections.addAll(clearedSet, this.allProviderTypes);
            clearedSet.removeAll(propagatedSet);
            clearedSet.removeAll(unchangedSet);
        }
        HashSet<ThreadContextProvider> propagatedProviders = new HashSet<ThreadContextProvider>();
        for (Object type : propagatedSet) {
            if (((String)type).isEmpty()) continue;
            ThreadContextProvider provider = this.providersByType.get(type);
            if (provider == null) {
                throw new IllegalStateException("Missing propagated provider type: " + (String)type);
            }
            propagatedProviders.add(provider);
        }
        HashSet<ThreadContextProvider> unchangedProviders = new HashSet<ThreadContextProvider>();
        for (String type : unchangedSet) {
            ThreadContextProvider provider;
            if (type.isEmpty() || (provider = this.providersByType.get(type)) == null) continue;
            unchangedProviders.add(provider);
        }
        HashSet<ThreadContextProvider> clearedProviders = new HashSet<ThreadContextProvider>();
        for (String type : clearedSet) {
            ThreadContextProvider provider;
            if (type.isEmpty() || (provider = this.providersByType.get(type)) == null) continue;
            clearedProviders.add(provider);
        }
        return new ThreadContextProviderPlan(propagatedProviders, unchangedProviders, clearedProviders);
    }

    public ManagedExecutor.Builder newManagedExecutorBuilder() {
        return new ManagedExecutorBuilderImpl(this);
    }

    public ThreadContext.Builder newThreadContextBuilder() {
        return new ThreadContextBuilderImpl(this);
    }

    public List<ContextManagerExtension> getExtensions() {
        return this.extensions;
    }

    public DefaultValues getDefaultValues() {
        return this.defaultValues;
    }
}

