/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava1;

import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.functions.Func1;

public class ContextPropagatorOnCompleteCreateAction
implements Func1<Completable.OnSubscribe, Completable.OnSubscribe> {
    private ThreadContext threadContext;

    public ContextPropagatorOnCompleteCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public Completable.OnSubscribe call(Completable.OnSubscribe t) {
        return new ContextCapturerCompletable(t, this.threadContext.currentContextExecutor());
    }

    static final class ContextCapturerCompletable
    implements Completable.OnSubscribe {
        final Completable.OnSubscribe source;
        private Executor contextExecutor;

        public ContextCapturerCompletable(Completable.OnSubscribe source, Executor contextExecutor) {
            this.source = source;
            this.contextExecutor = contextExecutor;
        }

        public void call(CompletableSubscriber t) {
            this.contextExecutor.execute(() -> this.source.call((Object)new OnAssemblyCompletableSubscriber(t, this.contextExecutor)));
        }

        static final class OnAssemblyCompletableSubscriber
        implements CompletableSubscriber {
            final CompletableSubscriber actual;
            private Executor contextExecutor;

            public OnAssemblyCompletableSubscriber(CompletableSubscriber actual, Executor contextExecutor) {
                this.actual = actual;
                this.contextExecutor = contextExecutor;
            }

            public void onError(Throwable e) {
                this.contextExecutor.execute(() -> this.actual.onError(e));
            }

            public void onCompleted() {
                this.contextExecutor.execute(() -> this.actual.onCompleted());
            }

            public void onSubscribe(Subscription d) {
                this.contextExecutor.execute(() -> this.actual.onSubscribe(d));
            }
        }
    }
}

