/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.inject;

import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.api.ManagedExecutorConfig;
import io.smallrye.context.api.NamedInstance;
import io.smallrye.context.api.ThreadContextConfig;
import io.smallrye.context.inject.InjectionPointName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;

public class SmallryeContextCdiExtension
implements Extension {
    private final String nameDelimiter = "/";
    private final String maxAsync = "/maxAsync";
    private final String maxQueued = "/maxQueued";
    private final String cleared = "/cleared";
    private final String propagated = "/propagated";
    private final String unchanged = "/unchanged";
    private final String MEConfig = "/ManagedExecutorConfig";
    private final String TCConfig = "/ThreadContextConfig";
    private final Config mpConfig = ConfigProvider.getConfig();
    private Map<InjectionPointName, ManagedExecutorConfig> executorMap = new HashMap<InjectionPointName, ManagedExecutorConfig>();
    private Set<InjectionPointName> unconfiguredExecutorIPs = new HashSet<InjectionPointName>();
    private Map<InjectionPointName, ThreadContextConfig> threadContextMap = new HashMap<InjectionPointName, ThreadContextConfig>();
    private Set<InjectionPointName> unconfiguredContextIPs = new HashSet<InjectionPointName>();
    private Set<InjectionPointName> userDefinedMEProducers = new HashSet<InjectionPointName>();
    private Set<InjectionPointName> userDefinedTCProducers = new HashSet<InjectionPointName>();

    public void processInjectionPointME(@Observes ProcessInjectionPoint<?, ManagedExecutor> pip) {
        InjectionPoint ip = pip.getInjectionPoint();
        if (this.hasCustomQualifiers(ip)) {
            return;
        }
        String uniqueName = this.getUniqueName(ip);
        String mpConfigIpName = this.createUniqueName(ip);
        if (uniqueName == null) {
            uniqueName = mpConfigIpName;
            pip.configureInjectionPoint().addQualifier((Annotation)NamedInstance.Literal.of((String)uniqueName));
        }
        InjectionPointName injectionPointName = new InjectionPointName(uniqueName, mpConfigIpName);
        ManagedExecutorConfig annotation = this.extractAnnotationFromIP(ip, ManagedExecutorConfig.class);
        ManagedExecutorConfig previousValue = null;
        if (annotation == null) {
            this.unconfiguredExecutorIPs.add(injectionPointName);
        } else {
            previousValue = this.executorMap.putIfAbsent(injectionPointName, annotation);
        }
        if (previousValue != null) {
            // empty if block
        }
    }

    public void processInjectionPointTC(@Observes ProcessInjectionPoint<?, ThreadContext> pip) {
        InjectionPoint ip = pip.getInjectionPoint();
        if (this.hasCustomQualifiers(ip)) {
            return;
        }
        String uniqueName = this.getUniqueName(ip);
        String mpConfigIpName = this.createUniqueName(ip);
        if (uniqueName == null) {
            uniqueName = mpConfigIpName;
            pip.configureInjectionPoint().addQualifier((Annotation)NamedInstance.Literal.of((String)uniqueName));
        }
        InjectionPointName injectionPointName = new InjectionPointName(uniqueName, mpConfigIpName);
        ThreadContextConfig annotation = this.extractAnnotationFromIP(ip, ThreadContextConfig.class);
        ThreadContextConfig previousValue = null;
        if (annotation == null) {
            this.unconfiguredContextIPs.add(injectionPointName);
        } else {
            previousValue = this.threadContextMap.putIfAbsent(injectionPointName, annotation);
        }
        if (previousValue != null) {
            // empty if block
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        ManagedExecutorConfig annotation;
        this.unconfiguredExecutorIPs.removeAll(this.unconfiguredExecutorIPs.stream().filter(name -> this.executorMap.containsKey(name)).collect(Collectors.toSet()));
        this.unconfiguredContextIPs.removeAll(this.unconfiguredContextIPs.stream().filter(name -> this.threadContextMap.containsKey(name)).collect(Collectors.toSet()));
        this.unconfiguredExecutorIPs.removeAll(this.userDefinedMEProducers);
        this.unconfiguredContextIPs.removeAll(this.userDefinedTCProducers);
        for (InjectionPointName injectionPointName : this.userDefinedMEProducers) {
            this.executorMap.remove(injectionPointName);
        }
        for (InjectionPointName injectionPointName : this.userDefinedTCProducers) {
            this.threadContextMap.remove(injectionPointName);
        }
        for (Map.Entry entry : this.executorMap.entrySet()) {
            annotation = (ManagedExecutorConfig)entry.getValue();
            abd.addBean().beanClass(ManagedExecutor.class).addTransitiveTypeClosure(ManagedExecutor.class).addQualifier((Annotation)NamedInstance.Literal.of((String)((InjectionPointName)entry.getKey()).getNamedInstanceName())).scope(ApplicationScoped.class).disposeWith((t, u) -> t.shutdown()).createWith(param -> ((SmallRyeManagedExecutor.Builder)ManagedExecutor.builder()).injectionPointName(((InjectionPointName)entry.getKey()).getMpConfigName()).maxAsync(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ManagedExecutorConfig" + "/maxAsync", Integer.class, annotation.maxAsync()).intValue()).maxQueued(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ManagedExecutorConfig" + "/maxQueued", Integer.class, annotation.maxQueued()).intValue()).cleared(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ManagedExecutorConfig" + "/cleared", String[].class, annotation.cleared())).propagated(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ManagedExecutorConfig" + "/propagated", String[].class, annotation.propagated())).build());
        }
        for (InjectionPointName injectionPointName : this.unconfiguredExecutorIPs) {
            abd.addBean().beanClass(ManagedExecutor.class).addTransitiveTypeClosure(ManagedExecutor.class).addQualifier((Annotation)NamedInstance.Literal.of((String)injectionPointName.getNamedInstanceName())).scope(ApplicationScoped.class).disposeWith((t, u) -> t.shutdown()).createWith(param -> ((SmallRyeManagedExecutor.Builder)ManagedExecutor.builder()).injectionPointName(ipName.getMpConfigName()).maxAsync(this.resolveConfiguration(ipName.getMpConfigName() + "/ManagedExecutorConfig" + "/maxAsync", Integer.class, ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxAsync()).intValue()).maxQueued(this.resolveConfiguration(ipName.getMpConfigName() + "/ManagedExecutorConfig" + "/maxQueued", Integer.class, ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxQueued()).intValue()).cleared(this.resolveConfiguration(ipName.getMpConfigName() + "/ManagedExecutorConfig" + "/cleared", String[].class, ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.cleared())).propagated(this.resolveConfiguration(ipName.getMpConfigName() + "/ManagedExecutorConfig" + "/propagated", String[].class, ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.propagated())).build());
        }
        for (Map.Entry entry : this.threadContextMap.entrySet()) {
            annotation = (ThreadContextConfig)entry.getValue();
            abd.addBean().beanClass(ThreadContext.class).addTransitiveTypeClosure(ThreadContext.class).addQualifier((Annotation)NamedInstance.Literal.of((String)((InjectionPointName)entry.getKey()).getNamedInstanceName())).scope(ApplicationScoped.class).disposeWith((t, u) -> {}).createWith(arg_0 -> this.lambda$afterBeanDiscovery$7(entry, (ThreadContextConfig)annotation, arg_0));
        }
        for (InjectionPointName injectionPointName : this.unconfiguredContextIPs) {
            abd.addBean().beanClass(ThreadContext.class).addTransitiveTypeClosure(ThreadContext.class).addQualifier((Annotation)NamedInstance.Literal.of((String)injectionPointName.getNamedInstanceName())).scope(ApplicationScoped.class).disposeWith((t, u) -> {}).createWith(param -> ((SmallRyeThreadContext.Builder)ThreadContext.builder()).injectionPointName(ipName.getMpConfigName()).cleared(this.resolveConfiguration(ipName.getMpConfigName() + "/ThreadContextConfig" + "/cleared", String[].class, ThreadContextConfig.Literal.DEFAULT_INSTANCE.cleared())).unchanged(this.resolveConfiguration(ipName.getMpConfigName() + "/ThreadContextConfig" + "/unchanged", String[].class, ThreadContextConfig.Literal.DEFAULT_INSTANCE.unchanged())).propagated(this.resolveConfiguration(ipName.getMpConfigName() + "/ThreadContextConfig" + "/propagated", String[].class, ThreadContextConfig.Literal.DEFAULT_INSTANCE.propagated())).build());
        }
    }

    public void processThreadContextProducers(@Observes ProcessProducer<?, ThreadContext> processProducer) {
        NamedInstance annotation = null;
        Member javaMember = processProducer.getAnnotatedMember().getJavaMember();
        if (javaMember instanceof Method) {
            annotation = ((Method)javaMember).getAnnotation(NamedInstance.class);
        } else if (javaMember instanceof Field) {
            annotation = ((Field)javaMember).getAnnotation(NamedInstance.class);
        }
        if (annotation != null) {
            this.userDefinedTCProducers.add(new InjectionPointName(annotation.value()));
        }
    }

    public void processMEProducers(@Observes ProcessProducer<?, ManagedExecutor> processProducer) {
        NamedInstance annotation = null;
        Member javaMember = processProducer.getAnnotatedMember().getJavaMember();
        if (javaMember instanceof Method) {
            annotation = ((Method)javaMember).getAnnotation(NamedInstance.class);
        } else if (javaMember instanceof Field) {
            annotation = ((Field)javaMember).getAnnotation(NamedInstance.class);
        }
        if (annotation != null) {
            this.userDefinedMEProducers.add(new InjectionPointName(annotation.value()));
        }
    }

    private <T extends Annotation> T extractAnnotationFromIP(InjectionPoint injectionPoint, Class<T> annotationClazz) {
        Annotation annotation = null;
        if (injectionPoint.getAnnotated().isAnnotationPresent(annotationClazz)) {
            annotation = injectionPoint.getAnnotated().getAnnotation(annotationClazz);
        }
        return (T)annotation;
    }

    private String getUniqueName(InjectionPoint ip) {
        Optional<NamedInstance> optionalQulifier = ip.getQualifiers().stream().filter(ann -> ann.annotationType().equals(NamedInstance.class)).map(ann -> (NamedInstance)ann).findFirst();
        return optionalQulifier.isPresent() ? optionalQulifier.get().value() : null;
    }

    private String createUniqueName(InjectionPoint ip) {
        StringBuilder builder = new StringBuilder(ip.getMember().getDeclaringClass().getName() + "/" + ip.getMember().getName());
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedParameter) {
            builder.append("/" + (((AnnotatedParameter)annotated).getPosition() + 1));
        }
        String result = builder.toString();
        return result;
    }

    private boolean hasCustomQualifiers(InjectionPoint ip) {
        return ip.getQualifiers().stream().anyMatch(ann -> !ann.annotationType().equals(NamedInstance.class) && !ann.annotationType().equals(Default.class) && !ann.annotationType().equals(Any.class));
    }

    private <K> K resolveConfiguration(String mpConfigName, Class<K> expectedReturnType, K originalValue) {
        try {
            return (K)this.mpConfig.getValue(mpConfigName, expectedReturnType);
        }
        catch (NoSuchElementException e) {
            return originalValue;
        }
    }

    public void cleanup(@Observes AfterDeploymentValidation adv) {
        this.unconfiguredContextIPs.clear();
        this.unconfiguredExecutorIPs.clear();
        this.userDefinedMEProducers.clear();
        this.userDefinedTCProducers.clear();
        this.executorMap.clear();
        this.threadContextMap.clear();
    }

    private /* synthetic */ ThreadContext lambda$afterBeanDiscovery$7(Map.Entry entry, ThreadContextConfig annotation, CreationalContext param) {
        return ((SmallRyeThreadContext.Builder)ThreadContext.builder()).injectionPointName(((InjectionPointName)entry.getKey()).getMpConfigName()).cleared(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ThreadContextConfig" + "/cleared", String[].class, annotation.cleared())).unchanged(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ThreadContextConfig" + "/unchanged", String[].class, annotation.unchanged())).propagated(this.resolveConfiguration(((InjectionPointName)entry.getKey()).getMpConfigName() + "/ThreadContextConfig" + "/propagated", String[].class, annotation.propagated())).build();
    }
}

