/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class LazySource
implements Publisher<Message<?>> {
    private PublisherBuilder<? extends Message<?>> delegate;
    private final String source;
    private final Merge.Mode mode;

    LazySource(String source, Merge.Mode mode) {
        this.source = source;
        this.mode = mode;
    }

    public void configure(ChannelRegistry registry) {
        List list = registry.getPublishers(this.source);
        if (!list.isEmpty()) {
            switch (this.mode) {
                case MERGE: {
                    this.merge(list);
                    break;
                }
                case ONE: {
                    this.delegate = (PublisherBuilder)list.get(0);
                    if (list.size() <= 1) break;
                    ProviderLogging.log.multiplePublisherFound(this.source);
                    break;
                }
                case CONCAT: {
                    this.concat(list);
                    break;
                }
                default: {
                    throw ProviderExceptions.ex.illegalArgumentMergePolicy(this.source, this.mode);
                }
            }
        }
    }

    private void merge(List<PublisherBuilder<? extends Message<?>>> list) {
        this.delegate = ReactiveStreams.fromPublisher((Publisher)Multi.createBy().merging().streams((Iterable)list.stream().map(PublisherBuilder::buildRs).collect(Collectors.toList())));
    }

    private void concat(List<PublisherBuilder<? extends Message<?>>> list) {
        this.delegate = ReactiveStreams.fromPublisher((Publisher)Multi.createBy().concatenating().streams((Iterable)list.stream().map(PublisherBuilder::buildRs).collect(Collectors.toList())));
    }

    public void subscribe(Subscriber<? super Message<?>> s) {
        this.delegate.to(s).run();
    }
}

