package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Base platform interface for handlers that provide functionality to the application platform.
 *
 * Two examples are:
 *
 * <ul>
 *   <li>{@link io.vertx.mutiny.ext.web.handler.BodyHandler}</li>
 *   <li>{@link io.vertx.mutiny.ext.web.handler.SessionHandler}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.PlatformHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.PlatformHandler.class)
public interface PlatformHandler extends io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.PlatformHandler getDelegate();

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0);

  default public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  PlatformHandler newInstance(io.vertx.ext.web.handler.PlatformHandler arg) {
    return arg != null ? new PlatformHandlerImpl(arg) : null;
  }

}

class PlatformHandlerImpl implements PlatformHandler {
  private final io.vertx.ext.web.handler.PlatformHandler delegate;
  
  public io.vertx.ext.web.handler.PlatformHandler getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PlatformHandlerImpl() {
    this.delegate = null;
  }

  public PlatformHandlerImpl(io.vertx.ext.web.handler.PlatformHandler delegate) {
    this.delegate = delegate;
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

}
