/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.stomp;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.User;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Frame;
import io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider;
import io.vertx.mutiny.ext.stomp.Acknowledgement;
import io.vertx.mutiny.ext.stomp.Destination;
import io.vertx.mutiny.ext.stomp.DestinationFactory;
import io.vertx.mutiny.ext.stomp.ServerFrame;
import io.vertx.mutiny.ext.stomp.StompServerConnection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.ext.stomp.StompServerHandler.class)
public class StompServerHandler
implements Handler<ServerFrame>,
Consumer<ServerFrame> {
    public static final TypeArg<StompServerHandler> __TYPE_ARG = new TypeArg(obj -> new StompServerHandler((io.vertx.ext.stomp.StompServerHandler)obj), StompServerHandler::getDelegate);
    private final io.vertx.ext.stomp.StompServerHandler delegate;
    static final TypeArg<Destination> TYPE_ARG_0 = new TypeArg(o1 -> Destination.newInstance((io.vertx.ext.stomp.Destination)o1), o1 -> o1.getDelegate());

    public StompServerHandler(io.vertx.ext.stomp.StompServerHandler delegate) {
        this.delegate = delegate;
    }

    public StompServerHandler(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompServerHandler)delegate;
    }

    StompServerHandler() {
        this.delegate = null;
    }

    public io.vertx.ext.stomp.StompServerHandler getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompServerHandler that = (StompServerHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void handle(ServerFrame arg0) {
        this.delegate.handle((Object)arg0.getDelegate());
    }

    public static StompServerHandler create(io.vertx.mutiny.core.Vertx vertx) {
        StompServerHandler ret = StompServerHandler.newInstance(io.vertx.ext.stomp.StompServerHandler.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    @Fluent
    private StompServerHandler __receivedFrameHandler(final Handler<ServerFrame> handler) {
        this.delegate.receivedFrameHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler receivedFrameHandler(Consumer<ServerFrame> handler) {
        return this.__receivedFrameHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __connectHandler(final Handler<ServerFrame> handler) {
        this.delegate.connectHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler connectHandler(Consumer<ServerFrame> handler) {
        return this.__connectHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __stompHandler(final Handler<ServerFrame> handler) {
        this.delegate.stompHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler stompHandler(Consumer<ServerFrame> handler) {
        return this.__stompHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __subscribeHandler(final Handler<ServerFrame> handler) {
        this.delegate.subscribeHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler subscribeHandler(Consumer<ServerFrame> handler) {
        return this.__subscribeHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __unsubscribeHandler(final Handler<ServerFrame> handler) {
        this.delegate.unsubscribeHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler unsubscribeHandler(Consumer<ServerFrame> handler) {
        return this.__unsubscribeHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __sendHandler(final Handler<ServerFrame> handler) {
        this.delegate.sendHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler sendHandler(Consumer<ServerFrame> handler) {
        return this.__sendHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __closeHandler(final Handler<StompServerConnection> handler) {
        this.delegate.closeHandler((Handler)new Handler<io.vertx.ext.stomp.StompServerConnection>(){

            public void handle(io.vertx.ext.stomp.StompServerConnection event) {
                handler.handle((Object)StompServerConnection.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler closeHandler(Consumer<StompServerConnection> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    public void onClose(StompServerConnection connection) {
        this.delegate.onClose(connection.getDelegate());
    }

    @Fluent
    private StompServerHandler __commitHandler(final Handler<ServerFrame> handler) {
        this.delegate.commitHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler commitHandler(Consumer<ServerFrame> handler) {
        return this.__commitHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __abortHandler(final Handler<ServerFrame> handler) {
        this.delegate.abortHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler abortHandler(Consumer<ServerFrame> handler) {
        return this.__abortHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __beginHandler(final Handler<ServerFrame> handler) {
        this.delegate.beginHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler beginHandler(Consumer<ServerFrame> handler) {
        return this.__beginHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __disconnectHandler(final Handler<ServerFrame> handler) {
        this.delegate.disconnectHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler disconnectHandler(Consumer<ServerFrame> handler) {
        return this.__disconnectHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __ackHandler(final Handler<ServerFrame> handler) {
        this.delegate.ackHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler ackHandler(Consumer<ServerFrame> handler) {
        return this.__ackHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __nackHandler(final Handler<ServerFrame> handler) {
        this.delegate.nackHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler nackHandler(Consumer<ServerFrame> handler) {
        return this.__nackHandler(handler != null ? handler::accept : null);
    }

    public Uni<Boolean> onAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        return AsyncResultUni.toUni(handler -> this.delegate.onAuthenticationRequest(connection.getDelegate(), login, passcode, handler));
    }

    public Boolean onAuthenticationRequestAndAwait(StompServerConnection connection, String login, String passcode) {
        return (Boolean)this.onAuthenticationRequest(connection, login, passcode).await().indefinitely();
    }

    @Fluent
    public StompServerHandler onAuthenticationRequestAndForget(StompServerConnection connection, String login, String passcode) {
        this.onAuthenticationRequest(connection, login, passcode).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public io.vertx.mutiny.ext.auth.User getUserBySession(String session) {
        io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((User)this.delegate.getUserBySession(session));
        return ret;
    }

    @Fluent
    public StompServerHandler authProvider(AuthenticationProvider handler) {
        this.delegate.authProvider(handler.getDelegate());
        return this;
    }

    public List<Destination> getDestinations() {
        List<Destination> ret = this.delegate.getDestinations().stream().map(elt -> Destination.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public Destination getDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getDestination(destination));
        return ret;
    }

    @Fluent
    public StompServerHandler onAck(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onAck(connection.getDelegate(), subscribe, messages);
        return this;
    }

    @Fluent
    public StompServerHandler onNack(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onNack(connection.getDelegate(), subscribe, messages);
        return this;
    }

    @Fluent
    private StompServerHandler __onAckHandler(final Handler<Acknowledgement> handler) {
        this.delegate.onAckHandler((Handler)new Handler<io.vertx.ext.stomp.Acknowledgement>(){

            public void handle(io.vertx.ext.stomp.Acknowledgement event) {
                handler.handle((Object)Acknowledgement.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler onAckHandler(Consumer<Acknowledgement> handler) {
        return this.__onAckHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __onNackHandler(final Handler<Acknowledgement> handler) {
        this.delegate.onNackHandler((Handler)new Handler<io.vertx.ext.stomp.Acknowledgement>(){

            public void handle(io.vertx.ext.stomp.Acknowledgement event) {
                handler.handle((Object)Acknowledgement.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler onNackHandler(Consumer<Acknowledgement> handler) {
        return this.__onNackHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompServerHandler __pingHandler(final Handler<StompServerConnection> handler) {
        this.delegate.pingHandler((Handler)new Handler<io.vertx.ext.stomp.StompServerConnection>(){

            public void handle(io.vertx.ext.stomp.StompServerConnection event) {
                handler.handle((Object)StompServerConnection.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler pingHandler(Consumer<StompServerConnection> handler) {
        return this.__pingHandler(handler != null ? handler::accept : null);
    }

    public Destination getOrCreateDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getOrCreateDestination(destination));
        return ret;
    }

    @Fluent
    public StompServerHandler destinationFactory(DestinationFactory factory) {
        this.delegate.destinationFactory(factory.getDelegate());
        return this;
    }

    @Fluent
    public StompServerHandler bridge(BridgeOptions options) {
        this.delegate.bridge(options);
        return this;
    }

    @Override
    public void accept(ServerFrame item) {
        this.handle(item);
    }

    public static StompServerHandler newInstance(io.vertx.ext.stomp.StompServerHandler arg) {
        return arg != null ? new StompServerHandler(arg) : null;
    }
}

