package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * <b>Auto generated</b> API Commands to interact with REDIS.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Command original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.Command.class)
public class Command {

  public static final io.smallrye.mutiny.vertx.TypeArg<Command> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Command((io.vertx.redis.client.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.redis.client.Command delegate;
  
  public Command(io.vertx.redis.client.Command delegate) {
    this.delegate = delegate;
  }

  public Command(Object delegate) {
    this.delegate = (io.vertx.redis.client.Command)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Command() {
    this.delegate = null;
  }

  public io.vertx.redis.client.Command getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param command command name
   * @return the cacheable immutable command instance
   */
  public static io.vertx.mutiny.redis.client.Command create(String command) { 
    io.vertx.mutiny.redis.client.Command ret = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.create(command));
    return ret;
  }

  public static final io.vertx.mutiny.redis.client.Command ACL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ACL);
  public static final io.vertx.mutiny.redis.client.Command APPEND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.APPEND);
  public static final io.vertx.mutiny.redis.client.Command ASKING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ASKING);
  public static final io.vertx.mutiny.redis.client.Command AUTH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.AUTH);
  public static final io.vertx.mutiny.redis.client.Command BF_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_ADD);
  public static final io.vertx.mutiny.redis.client.Command BF_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command BF_EXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_EXISTS);
  public static final io.vertx.mutiny.redis.client.Command BF_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_INFO);
  public static final io.vertx.mutiny.redis.client.Command BF_INSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_INSERT);
  public static final io.vertx.mutiny.redis.client.Command BF_LOADCHUNK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_LOADCHUNK);
  public static final io.vertx.mutiny.redis.client.Command BF_MADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_MADD);
  public static final io.vertx.mutiny.redis.client.Command BF_MEXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_MEXISTS);
  public static final io.vertx.mutiny.redis.client.Command BF_RESERVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_RESERVE);
  public static final io.vertx.mutiny.redis.client.Command BF_SCANDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_SCANDUMP);
  public static final io.vertx.mutiny.redis.client.Command BGREWRITEAOF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BGREWRITEAOF);
  public static final io.vertx.mutiny.redis.client.Command BGSAVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BGSAVE);
  public static final io.vertx.mutiny.redis.client.Command BITCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITCOUNT);
  public static final io.vertx.mutiny.redis.client.Command BITFIELD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITFIELD);
  public static final io.vertx.mutiny.redis.client.Command BITFIELD_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITFIELD_RO);
  public static final io.vertx.mutiny.redis.client.Command BITOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITOP);
  public static final io.vertx.mutiny.redis.client.Command BITPOS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITPOS);
  public static final io.vertx.mutiny.redis.client.Command BLMOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLMOVE);
  public static final io.vertx.mutiny.redis.client.Command BLMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLMPOP);
  public static final io.vertx.mutiny.redis.client.Command BLPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLPOP);
  public static final io.vertx.mutiny.redis.client.Command BRPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BRPOP);
  public static final io.vertx.mutiny.redis.client.Command BRPOPLPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BRPOPLPUSH);
  public static final io.vertx.mutiny.redis.client.Command BZMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZMPOP);
  public static final io.vertx.mutiny.redis.client.Command BZPOPMAX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZPOPMAX);
  public static final io.vertx.mutiny.redis.client.Command BZPOPMIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZPOPMIN);
  public static final io.vertx.mutiny.redis.client.Command CF_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_ADD);
  public static final io.vertx.mutiny.redis.client.Command CF_ADDNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_ADDNX);
  public static final io.vertx.mutiny.redis.client.Command CF_COMPACT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_COMPACT);
  public static final io.vertx.mutiny.redis.client.Command CF_COUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_COUNT);
  public static final io.vertx.mutiny.redis.client.Command CF_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command CF_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_DEL);
  public static final io.vertx.mutiny.redis.client.Command CF_EXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_EXISTS);
  public static final io.vertx.mutiny.redis.client.Command CF_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_INFO);
  public static final io.vertx.mutiny.redis.client.Command CF_INSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_INSERT);
  public static final io.vertx.mutiny.redis.client.Command CF_INSERTNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_INSERTNX);
  public static final io.vertx.mutiny.redis.client.Command CF_LOADCHUNK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_LOADCHUNK);
  public static final io.vertx.mutiny.redis.client.Command CF_MEXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_MEXISTS);
  public static final io.vertx.mutiny.redis.client.Command CF_RESERVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_RESERVE);
  public static final io.vertx.mutiny.redis.client.Command CF_SCANDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_SCANDUMP);
  public static final io.vertx.mutiny.redis.client.Command CLIENT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CLIENT);
  public static final io.vertx.mutiny.redis.client.Command CLUSTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CLUSTER);
  public static final io.vertx.mutiny.redis.client.Command CMS_INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INCRBY);
  public static final io.vertx.mutiny.redis.client.Command CMS_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INFO);
  public static final io.vertx.mutiny.redis.client.Command CMS_INITBYDIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INITBYDIM);
  public static final io.vertx.mutiny.redis.client.Command CMS_INITBYPROB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INITBYPROB);
  public static final io.vertx.mutiny.redis.client.Command CMS_MERGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_MERGE);
  public static final io.vertx.mutiny.redis.client.Command CMS_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_QUERY);
  public static final io.vertx.mutiny.redis.client.Command COMMAND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.COMMAND);
  public static final io.vertx.mutiny.redis.client.Command CONFIG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CONFIG);
  public static final io.vertx.mutiny.redis.client.Command COPY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.COPY);
  public static final io.vertx.mutiny.redis.client.Command DBSIZE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DBSIZE);
  public static final io.vertx.mutiny.redis.client.Command DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DEBUG);
  public static final io.vertx.mutiny.redis.client.Command DECR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DECR);
  public static final io.vertx.mutiny.redis.client.Command DECRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DECRBY);
  public static final io.vertx.mutiny.redis.client.Command DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DEL);
  public static final io.vertx.mutiny.redis.client.Command DISCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DISCARD);
  public static final io.vertx.mutiny.redis.client.Command DUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DUMP);
  public static final io.vertx.mutiny.redis.client.Command ECHO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ECHO);
  public static final io.vertx.mutiny.redis.client.Command EVAL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVAL);
  public static final io.vertx.mutiny.redis.client.Command EVALSHA = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVALSHA);
  public static final io.vertx.mutiny.redis.client.Command EVALSHA_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVALSHA_RO);
  public static final io.vertx.mutiny.redis.client.Command EVAL_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVAL_RO);
  public static final io.vertx.mutiny.redis.client.Command EXEC = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXEC);
  public static final io.vertx.mutiny.redis.client.Command EXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXISTS);
  public static final io.vertx.mutiny.redis.client.Command EXPIRE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIRE);
  public static final io.vertx.mutiny.redis.client.Command EXPIREAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIREAT);
  public static final io.vertx.mutiny.redis.client.Command EXPIRETIME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIRETIME);
  public static final io.vertx.mutiny.redis.client.Command FAILOVER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FAILOVER);
  public static final io.vertx.mutiny.redis.client.Command FCALL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FCALL);
  public static final io.vertx.mutiny.redis.client.Command FCALL_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FCALL_RO);
  public static final io.vertx.mutiny.redis.client.Command FLUSHALL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FLUSHALL);
  public static final io.vertx.mutiny.redis.client.Command FLUSHDB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FLUSHDB);
  public static final io.vertx.mutiny.redis.client.Command FT_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ADD);
  public static final io.vertx.mutiny.redis.client.Command FT_AGGREGATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_AGGREGATE);
  public static final io.vertx.mutiny.redis.client.Command FT_ALIASADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALIASADD);
  public static final io.vertx.mutiny.redis.client.Command FT_ALIASDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALIASDEL);
  public static final io.vertx.mutiny.redis.client.Command FT_ALIASUPDATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALIASUPDATE);
  public static final io.vertx.mutiny.redis.client.Command FT_ALTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALTER);
  public static final io.vertx.mutiny.redis.client.Command FT_CONFIG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_CONFIG);
  public static final io.vertx.mutiny.redis.client.Command FT_CREATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_CREATE);
  public static final io.vertx.mutiny.redis.client.Command FT_CURSOR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_CURSOR);
  public static final io.vertx.mutiny.redis.client.Command FT_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command FT_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DEL);
  public static final io.vertx.mutiny.redis.client.Command FT_DICTADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DICTADD);
  public static final io.vertx.mutiny.redis.client.Command FT_DICTDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DICTDEL);
  public static final io.vertx.mutiny.redis.client.Command FT_DICTDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DICTDUMP);
  public static final io.vertx.mutiny.redis.client.Command FT_DROP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DROP);
  public static final io.vertx.mutiny.redis.client.Command FT_DROPINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DROPINDEX);
  public static final io.vertx.mutiny.redis.client.Command FT_EXPLAIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_EXPLAIN);
  public static final io.vertx.mutiny.redis.client.Command FT_EXPLAINCLI = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_EXPLAINCLI);
  public static final io.vertx.mutiny.redis.client.Command FT_GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_GET);
  public static final io.vertx.mutiny.redis.client.Command FT_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_INFO);
  public static final io.vertx.mutiny.redis.client.Command FT_MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_MGET);
  public static final io.vertx.mutiny.redis.client.Command FT_PROFILE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_PROFILE);
  public static final io.vertx.mutiny.redis.client.Command FT_SAFEADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SAFEADD);
  public static final io.vertx.mutiny.redis.client.Command FT_SEARCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SEARCH);
  public static final io.vertx.mutiny.redis.client.Command FT_SPELLCHECK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SPELLCHECK);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGADD);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGDEL);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGGET);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGLEN);
  public static final io.vertx.mutiny.redis.client.Command FT_SYNADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SYNADD);
  public static final io.vertx.mutiny.redis.client.Command FT_SYNDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SYNDUMP);
  public static final io.vertx.mutiny.redis.client.Command FT_SYNUPDATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SYNUPDATE);
  public static final io.vertx.mutiny.redis.client.Command FT_TAGVALS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_TAGVALS);
  public static final io.vertx.mutiny.redis.client.Command FT__ALIASADDIFNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__ALIASADDIFNX);
  public static final io.vertx.mutiny.redis.client.Command FT__ALIASDELIFX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__ALIASDELIFX);
  public static final io.vertx.mutiny.redis.client.Command FT__ALTERIFNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__ALTERIFNX);
  public static final io.vertx.mutiny.redis.client.Command FT__CREATEIFNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__CREATEIFNX);
  public static final io.vertx.mutiny.redis.client.Command FT__DROPIFX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__DROPIFX);
  public static final io.vertx.mutiny.redis.client.Command FT__DROPINDEXIFX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__DROPINDEXIFX);
  public static final io.vertx.mutiny.redis.client.Command FT__LIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__LIST);
  public static final io.vertx.mutiny.redis.client.Command FUNCTION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FUNCTION);
  public static final io.vertx.mutiny.redis.client.Command GEOADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOADD);
  public static final io.vertx.mutiny.redis.client.Command GEODIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEODIST);
  public static final io.vertx.mutiny.redis.client.Command GEOHASH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOHASH);
  public static final io.vertx.mutiny.redis.client.Command GEOPOS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOPOS);
  public static final io.vertx.mutiny.redis.client.Command GEORADIUS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUS);
  public static final io.vertx.mutiny.redis.client.Command GEORADIUSBYMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUSBYMEMBER);
  public static final io.vertx.mutiny.redis.client.Command GEORADIUSBYMEMBER_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUSBYMEMBER_RO);
  public static final io.vertx.mutiny.redis.client.Command GEORADIUS_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUS_RO);
  public static final io.vertx.mutiny.redis.client.Command GEOSEARCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOSEARCH);
  public static final io.vertx.mutiny.redis.client.Command GEOSEARCHSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOSEARCHSTORE);
  public static final io.vertx.mutiny.redis.client.Command GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GET);
  public static final io.vertx.mutiny.redis.client.Command GETBIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETBIT);
  public static final io.vertx.mutiny.redis.client.Command GETDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETDEL);
  public static final io.vertx.mutiny.redis.client.Command GETEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETEX);
  public static final io.vertx.mutiny.redis.client.Command GETRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETRANGE);
  public static final io.vertx.mutiny.redis.client.Command GETSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETSET);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_BULK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_BULK);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_CONFIG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_CONFIG);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_DELETE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_DELETE);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_EXPLAIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_EXPLAIN);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_LIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_LIST);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_PROFILE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_PROFILE);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_QUERY);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_RO_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_RO_QUERY);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_SLOWLOG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_SLOWLOG);
  public static final io.vertx.mutiny.redis.client.Command HDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HDEL);
  public static final io.vertx.mutiny.redis.client.Command HELLO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HELLO);
  public static final io.vertx.mutiny.redis.client.Command HEXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HEXISTS);
  public static final io.vertx.mutiny.redis.client.Command HGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HGET);
  public static final io.vertx.mutiny.redis.client.Command HGETALL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HGETALL);
  public static final io.vertx.mutiny.redis.client.Command HINCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HINCRBY);
  public static final io.vertx.mutiny.redis.client.Command HINCRBYFLOAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HINCRBYFLOAT);
  public static final io.vertx.mutiny.redis.client.Command HKEYS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HKEYS);
  public static final io.vertx.mutiny.redis.client.Command HLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HLEN);
  public static final io.vertx.mutiny.redis.client.Command HMGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HMGET);
  public static final io.vertx.mutiny.redis.client.Command HMSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HMSET);
  public static final io.vertx.mutiny.redis.client.Command HRANDFIELD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HRANDFIELD);
  public static final io.vertx.mutiny.redis.client.Command HSCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSCAN);
  public static final io.vertx.mutiny.redis.client.Command HSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSET);
  public static final io.vertx.mutiny.redis.client.Command HSETNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSETNX);
  public static final io.vertx.mutiny.redis.client.Command HSTRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSTRLEN);
  public static final io.vertx.mutiny.redis.client.Command HVALS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HVALS);
  public static final io.vertx.mutiny.redis.client.Command INCR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCR);
  public static final io.vertx.mutiny.redis.client.Command INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCRBY);
  public static final io.vertx.mutiny.redis.client.Command INCRBYFLOAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCRBYFLOAT);
  public static final io.vertx.mutiny.redis.client.Command INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INFO);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRAPPEND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRAPPEND);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRINDEX);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRINSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRINSERT);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRLEN);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRPOP);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRTRIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRTRIM);
  public static final io.vertx.mutiny.redis.client.Command JSON_CLEAR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_CLEAR);
  public static final io.vertx.mutiny.redis.client.Command JSON_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command JSON_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_DEL);
  public static final io.vertx.mutiny.redis.client.Command JSON_FORGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_FORGET);
  public static final io.vertx.mutiny.redis.client.Command JSON_GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_GET);
  public static final io.vertx.mutiny.redis.client.Command JSON_MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_MGET);
  public static final io.vertx.mutiny.redis.client.Command JSON_NUMINCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_NUMINCRBY);
  public static final io.vertx.mutiny.redis.client.Command JSON_NUMMULTBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_NUMMULTBY);
  public static final io.vertx.mutiny.redis.client.Command JSON_NUMPOWBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_NUMPOWBY);
  public static final io.vertx.mutiny.redis.client.Command JSON_OBJKEYS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_OBJKEYS);
  public static final io.vertx.mutiny.redis.client.Command JSON_OBJLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_OBJLEN);
  public static final io.vertx.mutiny.redis.client.Command JSON_RESP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_RESP);
  public static final io.vertx.mutiny.redis.client.Command JSON_SET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_SET);
  public static final io.vertx.mutiny.redis.client.Command JSON_STRAPPEND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_STRAPPEND);
  public static final io.vertx.mutiny.redis.client.Command JSON_STRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_STRLEN);
  public static final io.vertx.mutiny.redis.client.Command JSON_TOGGLE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_TOGGLE);
  public static final io.vertx.mutiny.redis.client.Command JSON_TYPE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_TYPE);
  public static final io.vertx.mutiny.redis.client.Command KEYS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.KEYS);
  public static final io.vertx.mutiny.redis.client.Command LASTSAVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LASTSAVE);
  public static final io.vertx.mutiny.redis.client.Command LATENCY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LATENCY);
  public static final io.vertx.mutiny.redis.client.Command LCS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LCS);
  public static final io.vertx.mutiny.redis.client.Command LINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LINDEX);
  public static final io.vertx.mutiny.redis.client.Command LINSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LINSERT);
  public static final io.vertx.mutiny.redis.client.Command LLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LLEN);
  public static final io.vertx.mutiny.redis.client.Command LMOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LMOVE);
  public static final io.vertx.mutiny.redis.client.Command LMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LMPOP);
  public static final io.vertx.mutiny.redis.client.Command LOLWUT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LOLWUT);
  public static final io.vertx.mutiny.redis.client.Command LPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPOP);
  public static final io.vertx.mutiny.redis.client.Command LPOS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPOS);
  public static final io.vertx.mutiny.redis.client.Command LPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPUSH);
  public static final io.vertx.mutiny.redis.client.Command LPUSHX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPUSHX);
  public static final io.vertx.mutiny.redis.client.Command LRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LRANGE);
  public static final io.vertx.mutiny.redis.client.Command LREM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LREM);
  public static final io.vertx.mutiny.redis.client.Command LSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LSET);
  public static final io.vertx.mutiny.redis.client.Command LTRIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LTRIM);
  public static final io.vertx.mutiny.redis.client.Command MEMORY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MEMORY);
  public static final io.vertx.mutiny.redis.client.Command MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MGET);
  public static final io.vertx.mutiny.redis.client.Command MIGRATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MIGRATE);
  public static final io.vertx.mutiny.redis.client.Command MODULE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MODULE);
  public static final io.vertx.mutiny.redis.client.Command MONITOR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MONITOR);
  public static final io.vertx.mutiny.redis.client.Command MOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MOVE);
  public static final io.vertx.mutiny.redis.client.Command MSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MSET);
  public static final io.vertx.mutiny.redis.client.Command MSETNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MSETNX);
  public static final io.vertx.mutiny.redis.client.Command MULTI = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MULTI);
  public static final io.vertx.mutiny.redis.client.Command OBJECT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.OBJECT);
  public static final io.vertx.mutiny.redis.client.Command PERSIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PERSIST);
  public static final io.vertx.mutiny.redis.client.Command PEXPIRE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIRE);
  public static final io.vertx.mutiny.redis.client.Command PEXPIREAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIREAT);
  public static final io.vertx.mutiny.redis.client.Command PEXPIRETIME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIRETIME);
  public static final io.vertx.mutiny.redis.client.Command PFADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFADD);
  public static final io.vertx.mutiny.redis.client.Command PFCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFCOUNT);
  public static final io.vertx.mutiny.redis.client.Command PFDEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFDEBUG);
  public static final io.vertx.mutiny.redis.client.Command PFMERGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFMERGE);
  public static final io.vertx.mutiny.redis.client.Command PFSELFTEST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFSELFTEST);
  public static final io.vertx.mutiny.redis.client.Command PING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PING);
  public static final io.vertx.mutiny.redis.client.Command PSETEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSETEX);
  public static final io.vertx.mutiny.redis.client.Command PSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSUBSCRIBE);
  public static final io.vertx.mutiny.redis.client.Command PSYNC = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSYNC);
  public static final io.vertx.mutiny.redis.client.Command PTTL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PTTL);
  public static final io.vertx.mutiny.redis.client.Command PUBLISH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUBLISH);
  public static final io.vertx.mutiny.redis.client.Command PUBSUB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUBSUB);
  public static final io.vertx.mutiny.redis.client.Command PUNSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUNSUBSCRIBE);
  public static final io.vertx.mutiny.redis.client.Command QUIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.QUIT);
  public static final io.vertx.mutiny.redis.client.Command RANDOMKEY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RANDOMKEY);
  public static final io.vertx.mutiny.redis.client.Command READONLY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.READONLY);
  public static final io.vertx.mutiny.redis.client.Command READWRITE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.READWRITE);
  public static final io.vertx.mutiny.redis.client.Command RENAME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RENAME);
  public static final io.vertx.mutiny.redis.client.Command RENAMENX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RENAMENX);
  public static final io.vertx.mutiny.redis.client.Command REPLCONF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.REPLCONF);
  public static final io.vertx.mutiny.redis.client.Command REPLICAOF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.REPLICAOF);
  public static final io.vertx.mutiny.redis.client.Command RESET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESET);
  public static final io.vertx.mutiny.redis.client.Command RESTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESTORE);
  public static final io.vertx.mutiny.redis.client.Command RESTORE_ASKING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESTORE_ASKING);
  public static final io.vertx.mutiny.redis.client.Command ROLE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ROLE);
  public static final io.vertx.mutiny.redis.client.Command RPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPOP);
  public static final io.vertx.mutiny.redis.client.Command RPOPLPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPOPLPUSH);
  public static final io.vertx.mutiny.redis.client.Command RPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPUSH);
  public static final io.vertx.mutiny.redis.client.Command RPUSHX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPUSHX);
  public static final io.vertx.mutiny.redis.client.Command SADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SADD);
  public static final io.vertx.mutiny.redis.client.Command SAVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SAVE);
  public static final io.vertx.mutiny.redis.client.Command SCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCAN);
  public static final io.vertx.mutiny.redis.client.Command SCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCARD);
  public static final io.vertx.mutiny.redis.client.Command SCRIPT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCRIPT);
  public static final io.vertx.mutiny.redis.client.Command SDIFF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SDIFF);
  public static final io.vertx.mutiny.redis.client.Command SDIFFSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SDIFFSTORE);
  public static final io.vertx.mutiny.redis.client.Command SELECT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SELECT);
  public static final io.vertx.mutiny.redis.client.Command SET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SET);
  public static final io.vertx.mutiny.redis.client.Command SETBIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETBIT);
  public static final io.vertx.mutiny.redis.client.Command SETEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETEX);
  public static final io.vertx.mutiny.redis.client.Command SETNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETNX);
  public static final io.vertx.mutiny.redis.client.Command SETRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETRANGE);
  public static final io.vertx.mutiny.redis.client.Command SHUTDOWN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SHUTDOWN);
  public static final io.vertx.mutiny.redis.client.Command SINTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTER);
  public static final io.vertx.mutiny.redis.client.Command SINTERCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTERCARD);
  public static final io.vertx.mutiny.redis.client.Command SINTERSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTERSTORE);
  public static final io.vertx.mutiny.redis.client.Command SISMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SISMEMBER);
  public static final io.vertx.mutiny.redis.client.Command SLAVEOF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SLAVEOF);
  public static final io.vertx.mutiny.redis.client.Command SLOWLOG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SLOWLOG);
  public static final io.vertx.mutiny.redis.client.Command SMEMBERS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMEMBERS);
  public static final io.vertx.mutiny.redis.client.Command SMISMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMISMEMBER);
  public static final io.vertx.mutiny.redis.client.Command SMOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMOVE);
  public static final io.vertx.mutiny.redis.client.Command SORT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SORT);
  public static final io.vertx.mutiny.redis.client.Command SORT_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SORT_RO);
  public static final io.vertx.mutiny.redis.client.Command SPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SPOP);
  public static final io.vertx.mutiny.redis.client.Command SPUBLISH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SPUBLISH);
  public static final io.vertx.mutiny.redis.client.Command SRANDMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SRANDMEMBER);
  public static final io.vertx.mutiny.redis.client.Command SREM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SREM);
  public static final io.vertx.mutiny.redis.client.Command SSCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SSCAN);
  public static final io.vertx.mutiny.redis.client.Command SSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SSUBSCRIBE);
  public static final io.vertx.mutiny.redis.client.Command STRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.STRLEN);
  public static final io.vertx.mutiny.redis.client.Command SUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUBSCRIBE);
  public static final io.vertx.mutiny.redis.client.Command SUBSTR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUBSTR);
  public static final io.vertx.mutiny.redis.client.Command SUNION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNION);
  public static final io.vertx.mutiny.redis.client.Command SUNIONSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNIONSTORE);
  public static final io.vertx.mutiny.redis.client.Command SUNSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNSUBSCRIBE);
  public static final io.vertx.mutiny.redis.client.Command SWAPDB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SWAPDB);
  public static final io.vertx.mutiny.redis.client.Command SYNC = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SYNC);
  public static final io.vertx.mutiny.redis.client.Command TIME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIME);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_CLUSTERSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_CLUSTERSET);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_CLUSTERSETFROMSHARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_CLUSTERSETFROMSHARD);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_HELLO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_HELLO);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_INFOCLUSTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_INFOCLUSTER);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_INNERCOMMUNICATION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_INNERCOMMUNICATION);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_NETWORKTEST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_NETWORKTEST);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_REFRESHCLUSTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_REFRESHCLUSTER);
  public static final io.vertx.mutiny.redis.client.Command TOPK_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_ADD);
  public static final io.vertx.mutiny.redis.client.Command TOPK_COUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_COUNT);
  public static final io.vertx.mutiny.redis.client.Command TOPK_INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_INCRBY);
  public static final io.vertx.mutiny.redis.client.Command TOPK_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_INFO);
  public static final io.vertx.mutiny.redis.client.Command TOPK_LIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_LIST);
  public static final io.vertx.mutiny.redis.client.Command TOPK_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_QUERY);
  public static final io.vertx.mutiny.redis.client.Command TOPK_RESERVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_RESERVE);
  public static final io.vertx.mutiny.redis.client.Command TOUCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOUCH);
  public static final io.vertx.mutiny.redis.client.Command TS_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_ADD);
  public static final io.vertx.mutiny.redis.client.Command TS_ALTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_ALTER);
  public static final io.vertx.mutiny.redis.client.Command TS_CREATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_CREATE);
  public static final io.vertx.mutiny.redis.client.Command TS_CREATERULE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_CREATERULE);
  public static final io.vertx.mutiny.redis.client.Command TS_DECRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_DECRBY);
  public static final io.vertx.mutiny.redis.client.Command TS_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_DEL);
  public static final io.vertx.mutiny.redis.client.Command TS_DELETERULE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_DELETERULE);
  public static final io.vertx.mutiny.redis.client.Command TS_GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_GET);
  public static final io.vertx.mutiny.redis.client.Command TS_INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_INCRBY);
  public static final io.vertx.mutiny.redis.client.Command TS_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_INFO);
  public static final io.vertx.mutiny.redis.client.Command TS_MADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MADD);
  public static final io.vertx.mutiny.redis.client.Command TS_MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MGET);
  public static final io.vertx.mutiny.redis.client.Command TS_MRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MRANGE);
  public static final io.vertx.mutiny.redis.client.Command TS_MREVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MREVRANGE);
  public static final io.vertx.mutiny.redis.client.Command TS_QUERYINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_QUERYINDEX);
  public static final io.vertx.mutiny.redis.client.Command TS_RANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_RANGE);
  public static final io.vertx.mutiny.redis.client.Command TS_REVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_REVRANGE);
  public static final io.vertx.mutiny.redis.client.Command TTL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TTL);
  public static final io.vertx.mutiny.redis.client.Command TYPE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TYPE);
  public static final io.vertx.mutiny.redis.client.Command UNLINK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNLINK);
  public static final io.vertx.mutiny.redis.client.Command UNSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNSUBSCRIBE);
  public static final io.vertx.mutiny.redis.client.Command UNWATCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNWATCH);
  public static final io.vertx.mutiny.redis.client.Command WAIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.WAIT);
  public static final io.vertx.mutiny.redis.client.Command WATCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.WATCH);
  public static final io.vertx.mutiny.redis.client.Command XACK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XACK);
  public static final io.vertx.mutiny.redis.client.Command XADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XADD);
  public static final io.vertx.mutiny.redis.client.Command XAUTOCLAIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XAUTOCLAIM);
  public static final io.vertx.mutiny.redis.client.Command XCLAIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XCLAIM);
  public static final io.vertx.mutiny.redis.client.Command XDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XDEL);
  public static final io.vertx.mutiny.redis.client.Command XGROUP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XGROUP);
  public static final io.vertx.mutiny.redis.client.Command XINFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XINFO);
  public static final io.vertx.mutiny.redis.client.Command XLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XLEN);
  public static final io.vertx.mutiny.redis.client.Command XPENDING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XPENDING);
  public static final io.vertx.mutiny.redis.client.Command XRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XRANGE);
  public static final io.vertx.mutiny.redis.client.Command XREAD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREAD);
  public static final io.vertx.mutiny.redis.client.Command XREADGROUP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREADGROUP);
  public static final io.vertx.mutiny.redis.client.Command XREVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREVRANGE);
  public static final io.vertx.mutiny.redis.client.Command XSETID = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XSETID);
  public static final io.vertx.mutiny.redis.client.Command XTRIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XTRIM);
  public static final io.vertx.mutiny.redis.client.Command ZADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZADD);
  public static final io.vertx.mutiny.redis.client.Command ZCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZCARD);
  public static final io.vertx.mutiny.redis.client.Command ZCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZCOUNT);
  public static final io.vertx.mutiny.redis.client.Command ZDIFF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZDIFF);
  public static final io.vertx.mutiny.redis.client.Command ZDIFFSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZDIFFSTORE);
  public static final io.vertx.mutiny.redis.client.Command ZINCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINCRBY);
  public static final io.vertx.mutiny.redis.client.Command ZINTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTER);
  public static final io.vertx.mutiny.redis.client.Command ZINTERCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTERCARD);
  public static final io.vertx.mutiny.redis.client.Command ZINTERSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTERSTORE);
  public static final io.vertx.mutiny.redis.client.Command ZLEXCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZLEXCOUNT);
  public static final io.vertx.mutiny.redis.client.Command ZMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZMPOP);
  public static final io.vertx.mutiny.redis.client.Command ZMSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZMSCORE);
  public static final io.vertx.mutiny.redis.client.Command ZPOPMAX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZPOPMAX);
  public static final io.vertx.mutiny.redis.client.Command ZPOPMIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZPOPMIN);
  public static final io.vertx.mutiny.redis.client.Command ZRANDMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANDMEMBER);
  public static final io.vertx.mutiny.redis.client.Command ZRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGE);
  public static final io.vertx.mutiny.redis.client.Command ZRANGEBYLEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGEBYLEX);
  public static final io.vertx.mutiny.redis.client.Command ZRANGEBYSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGEBYSCORE);
  public static final io.vertx.mutiny.redis.client.Command ZRANGESTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGESTORE);
  public static final io.vertx.mutiny.redis.client.Command ZRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANK);
  public static final io.vertx.mutiny.redis.client.Command ZREM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREM);
  public static final io.vertx.mutiny.redis.client.Command ZREMRANGEBYLEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYLEX);
  public static final io.vertx.mutiny.redis.client.Command ZREMRANGEBYRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYRANK);
  public static final io.vertx.mutiny.redis.client.Command ZREMRANGEBYSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYSCORE);
  public static final io.vertx.mutiny.redis.client.Command ZREVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGE);
  public static final io.vertx.mutiny.redis.client.Command ZREVRANGEBYLEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGEBYLEX);
  public static final io.vertx.mutiny.redis.client.Command ZREVRANGEBYSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGEBYSCORE);
  public static final io.vertx.mutiny.redis.client.Command ZREVRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANK);
  public static final io.vertx.mutiny.redis.client.Command ZSCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZSCAN);
  public static final io.vertx.mutiny.redis.client.Command ZSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZSCORE);
  public static final io.vertx.mutiny.redis.client.Command ZUNION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZUNION);
  public static final io.vertx.mutiny.redis.client.Command ZUNIONSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZUNIONSTORE);
  public static final io.vertx.mutiny.redis.client.Command SENTINEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SENTINEL);
  public static  Command newInstance(io.vertx.redis.client.Command arg) {
    return arg != null ? new Command(arg) : null;
  }

}
