/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.redis.client;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.redis.client.RedisConnection.class)
public class RedisConnection
implements ReadStream<Response> {
    public static final TypeArg<RedisConnection> __TYPE_ARG = new TypeArg(obj -> new RedisConnection((io.vertx.redis.client.RedisConnection)obj), RedisConnection::getDelegate);
    private final io.vertx.redis.client.RedisConnection delegate;
    static final TypeArg<Response> TYPE_ARG_0 = new TypeArg(o1 -> Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());
    private Multi<Response> multi;

    public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
        this.delegate = delegate;
    }

    public RedisConnection(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
    }

    RedisConnection() {
        this.delegate = null;
    }

    public io.vertx.redis.client.RedisConnection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConnection that = (RedisConnection)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Pipe<Response> pipe() {
        Pipe ret = Pipe.newInstance((io.vertx.core.streams.Pipe)this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Response> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    public Void pipeToAndAwait(WriteStream<Response> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    public void pipeToAndForget(WriteStream<Response> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private RedisConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public RedisConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private RedisConnection __handler(Handler<Response> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> Response.newInstance(event)));
        return this;
    }

    public RedisConnection handler(Consumer<Response> handler) {
        return this.__handler((Handler<Response>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    public RedisConnection pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public RedisConnection resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    public RedisConnection fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private RedisConnection __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RedisConnection endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    @CheckReturnValue
    public Uni<Response> send(Request command) {
        return AsyncResultUni.toUni(onSend -> this.delegate.send(command.getDelegate(), (Handler)new DelegatingHandler(onSend, ar -> ar.map(event -> Response.newInstance(event)))));
    }

    public Response sendAndAwait(Request command) {
        return (Response)this.send(command).await().indefinitely();
    }

    @Fluent
    public RedisConnection sendAndForget(Request command) {
        this.send(command).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<Response>> batch(List<Request> commands) {
        return AsyncResultUni.toUni(onSend -> this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new DelegatingHandler(onSend, ar -> ar.map(event -> event.stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())))));
    }

    public List<Response> batchAndAwait(List<Request> commands) {
        return (List)this.batch(commands).await().indefinitely();
    }

    @Fluent
    public RedisConnection batchAndForget(List<Request> commands) {
        this.batch(commands).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(onClose -> this.delegate.close(onClose));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    @Fluent
    public RedisConnection closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public boolean pendingQueueFull() {
        boolean ret = this.delegate.pendingQueueFull();
        return ret;
    }

    @CheckReturnValue
    public synchronized Multi<Response> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Response> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Response> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
        return arg != null ? new RedisConnection(arg) : null;
    }
}

