/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.redis;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.redis.RedisTransaction;
import io.vertx.mutiny.redis.Script;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.List;
import java.util.Map;

@MutinyGen(value=io.vertx.redis.RedisClient.class)
public class RedisClient {
    public static final TypeArg<RedisClient> __TYPE_ARG = new TypeArg(obj -> new RedisClient((io.vertx.redis.RedisClient)obj), RedisClient::getDelegate);
    private final io.vertx.redis.RedisClient delegate;

    public RedisClient(io.vertx.redis.RedisClient delegate) {
        this.delegate = delegate;
    }

    RedisClient() {
        this.delegate = null;
    }

    public io.vertx.redis.RedisClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisClient that = (RedisClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static RedisClient create(io.vertx.mutiny.core.Vertx vertx) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RedisClient create(io.vertx.mutiny.core.Vertx vertx, JsonObject config) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private RedisClient __append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    public Uni<Long> append(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__append(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long appendAndAwait(String key, String value) {
        return (Long)this.append(key, value).await().indefinitely();
    }

    private RedisClient __auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    public Uni<String> auth(String password) {
        return AsyncResultUni.toUni(handler -> this.__auth(password, (Handler<AsyncResult<String>>)handler));
    }

    public String authAndAwait(String password) {
        return (String)this.auth(password).await().indefinitely();
    }

    private RedisClient __bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    public Uni<String> bgrewriteaof() {
        return AsyncResultUni.toUni(handler -> this.__bgrewriteaof((Handler<AsyncResult<String>>)handler));
    }

    public String bgrewriteaofAndAwait() {
        return (String)this.bgrewriteaof().await().indefinitely();
    }

    private RedisClient __bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    public Uni<String> bgsave() {
        return AsyncResultUni.toUni(handler -> this.__bgsave((Handler<AsyncResult<String>>)handler));
    }

    public String bgsaveAndAwait() {
        return (String)this.bgsave().await().indefinitely();
    }

    private RedisClient __bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    public Uni<Long> bitcount(String key) {
        return AsyncResultUni.toUni(handler -> this.__bitcount(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long bitcountAndAwait(String key) {
        return (Long)this.bitcount(key).await().indefinitely();
    }

    private RedisClient __bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    public Uni<Long> bitcountRange(String key, long start, long end) {
        return AsyncResultUni.toUni(handler -> this.__bitcountRange(key, start, end, (Handler<AsyncResult<Long>>)handler));
    }

    public Long bitcountRangeAndAwait(String key, long start, long end) {
        return (Long)this.bitcountRange(key, start, end).await().indefinitely();
    }

    private RedisClient __bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    public Uni<Long> bitop(BitOperation operation, String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__bitop(operation, destkey, keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long bitopAndAwait(BitOperation operation, String destkey, List<String> keys) {
        return (Long)this.bitop(operation, destkey, keys).await().indefinitely();
    }

    private RedisClient __bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    public Uni<Long> bitpos(String key, int bit) {
        return AsyncResultUni.toUni(handler -> this.__bitpos(key, bit, (Handler<AsyncResult<Long>>)handler));
    }

    public Long bitposAndAwait(String key, int bit) {
        return (Long)this.bitpos(key, bit).await().indefinitely();
    }

    private RedisClient __bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    public Uni<Long> bitposFrom(String key, int bit, int start) {
        return AsyncResultUni.toUni(handler -> this.__bitposFrom(key, bit, start, (Handler<AsyncResult<Long>>)handler));
    }

    public Long bitposFromAndAwait(String key, int bit, int start) {
        return (Long)this.bitposFrom(key, bit, start).await().indefinitely();
    }

    private RedisClient __bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    public Uni<Long> bitposRange(String key, int bit, int start, int stop) {
        return AsyncResultUni.toUni(handler -> this.__bitposRange(key, bit, start, stop, (Handler<AsyncResult<Long>>)handler));
    }

    public Long bitposRangeAndAwait(String key, int bit, int start, int stop) {
        return (Long)this.bitposRange(key, bit, start, stop).await().indefinitely();
    }

    private RedisClient __blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    public Uni<JsonArray> blpop(String key, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__blpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray blpopAndAwait(String key, int seconds) {
        return (JsonArray)this.blpop(key, seconds).await().indefinitely();
    }

    private RedisClient __blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    public Uni<JsonArray> blpopMany(List<String> keys, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__blpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray blpopManyAndAwait(List<String> keys, int seconds) {
        return (JsonArray)this.blpopMany(keys, seconds).await().indefinitely();
    }

    private RedisClient __brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    public Uni<JsonArray> brpop(String key, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__brpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray brpopAndAwait(String key, int seconds) {
        return (JsonArray)this.brpop(key, seconds).await().indefinitely();
    }

    private RedisClient __brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    public Uni<JsonArray> brpopMany(List<String> keys, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__brpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray brpopManyAndAwait(List<String> keys, int seconds) {
        return (JsonArray)this.brpopMany(keys, seconds).await().indefinitely();
    }

    private RedisClient __brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    public Uni<String> brpoplpush(String key, String destkey, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String brpoplpushAndAwait(String key, String destkey, int seconds) {
        return (String)this.brpoplpush(key, destkey, seconds).await().indefinitely();
    }

    private RedisClient __clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    public Uni<Long> clientKill(KillFilter filter) {
        return AsyncResultUni.toUni(handler -> this.__clientKill(filter, (Handler<AsyncResult<Long>>)handler));
    }

    public Long clientKillAndAwait(KillFilter filter) {
        return (Long)this.clientKill(filter).await().indefinitely();
    }

    private RedisClient __clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    public Uni<String> clientList() {
        return AsyncResultUni.toUni(handler -> this.__clientList((Handler<AsyncResult<String>>)handler));
    }

    public String clientListAndAwait() {
        return (String)this.clientList().await().indefinitely();
    }

    private RedisClient __clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    public Uni<String> clientGetname() {
        return AsyncResultUni.toUni(handler -> this.__clientGetname((Handler<AsyncResult<String>>)handler));
    }

    public String clientGetnameAndAwait() {
        return (String)this.clientGetname().await().indefinitely();
    }

    private RedisClient __clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    public Uni<String> clientPause(long millis) {
        return AsyncResultUni.toUni(handler -> this.__clientPause(millis, (Handler<AsyncResult<String>>)handler));
    }

    public String clientPauseAndAwait(long millis) {
        return (String)this.clientPause(millis).await().indefinitely();
    }

    private RedisClient __clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    public Uni<String> clientSetname(String name) {
        return AsyncResultUni.toUni(handler -> this.__clientSetname(name, (Handler<AsyncResult<String>>)handler));
    }

    public String clientSetnameAndAwait(String name) {
        return (String)this.clientSetname(name).await().indefinitely();
    }

    private RedisClient __clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    public Uni<Void> clusterAddslots(List<Long> slots) {
        return AsyncResultUni.toUni(handler -> this.__clusterAddslots(slots, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterAddslotsAndAwait(List<Long> slots) {
        return (Void)this.clusterAddslots(slots).await().indefinitely();
    }

    private RedisClient __clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    public Uni<Long> clusterCountFailureReports(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterCountFailureReports(nodeId, (Handler<AsyncResult<Long>>)handler));
    }

    public Long clusterCountFailureReportsAndAwait(String nodeId) {
        return (Long)this.clusterCountFailureReports(nodeId).await().indefinitely();
    }

    private RedisClient __clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    public Uni<Long> clusterCountkeysinslot(long slot) {
        return AsyncResultUni.toUni(handler -> this.__clusterCountkeysinslot(slot, (Handler<AsyncResult<Long>>)handler));
    }

    public Long clusterCountkeysinslotAndAwait(long slot) {
        return (Long)this.clusterCountkeysinslot(slot).await().indefinitely();
    }

    private RedisClient __clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    public Uni<Void> clusterDelslots(long slot) {
        return AsyncResultUni.toUni(handler -> this.__clusterDelslots(slot, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterDelslotsAndAwait(long slot) {
        return (Void)this.clusterDelslots(slot).await().indefinitely();
    }

    private RedisClient __clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    public Uni<Void> clusterDelslotsMany(List<Long> slots) {
        return AsyncResultUni.toUni(handler -> this.__clusterDelslotsMany(slots, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterDelslotsManyAndAwait(List<Long> slots) {
        return (Void)this.clusterDelslotsMany(slots).await().indefinitely();
    }

    private RedisClient __clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    public Uni<Void> clusterFailover() {
        return AsyncResultUni.toUni(handler -> this.__clusterFailover((Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterFailoverAndAwait() {
        return (Void)this.clusterFailover().await().indefinitely();
    }

    private RedisClient __clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    public Uni<Void> clusterFailOverWithOptions(FailoverOptions options) {
        return AsyncResultUni.toUni(handler -> this.__clusterFailOverWithOptions(options, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterFailOverWithOptionsAndAwait(FailoverOptions options) {
        return (Void)this.clusterFailOverWithOptions(options).await().indefinitely();
    }

    private RedisClient __clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    public Uni<Void> clusterForget(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterForget(nodeId, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterForgetAndAwait(String nodeId) {
        return (Void)this.clusterForget(nodeId).await().indefinitely();
    }

    private RedisClient __clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    public Uni<JsonArray> clusterGetkeysinslot(long slot, long count) {
        return AsyncResultUni.toUni(handler -> this.__clusterGetkeysinslot(slot, count, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray clusterGetkeysinslotAndAwait(long slot, long count) {
        return (JsonArray)this.clusterGetkeysinslot(slot, count).await().indefinitely();
    }

    private RedisClient __clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    public Uni<JsonArray> clusterInfo() {
        return AsyncResultUni.toUni(handler -> this.__clusterInfo((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray clusterInfoAndAwait() {
        return (JsonArray)this.clusterInfo().await().indefinitely();
    }

    private RedisClient __clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    public Uni<Long> clusterKeyslot(String key) {
        return AsyncResultUni.toUni(handler -> this.__clusterKeyslot(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long clusterKeyslotAndAwait(String key) {
        return (Long)this.clusterKeyslot(key).await().indefinitely();
    }

    private RedisClient __clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    public Uni<Void> clusterMeet(String ip, long port) {
        return AsyncResultUni.toUni(handler -> this.__clusterMeet(ip, port, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterMeetAndAwait(String ip, long port) {
        return (Void)this.clusterMeet(ip, port).await().indefinitely();
    }

    private RedisClient __clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    public Uni<JsonArray> clusterNodes() {
        return AsyncResultUni.toUni(handler -> this.__clusterNodes((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray clusterNodesAndAwait() {
        return (JsonArray)this.clusterNodes().await().indefinitely();
    }

    private RedisClient __clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    public Uni<Void> clusterReplicate(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterReplicate(nodeId, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterReplicateAndAwait(String nodeId) {
        return (Void)this.clusterReplicate(nodeId).await().indefinitely();
    }

    private RedisClient __clusterReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    public Uni<Void> clusterReset() {
        return AsyncResultUni.toUni(handler -> this.__clusterReset((Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterResetAndAwait() {
        return (Void)this.clusterReset().await().indefinitely();
    }

    private RedisClient __clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    public Uni<Void> clusterResetWithOptions(ResetOptions options) {
        return AsyncResultUni.toUni(handler -> this.__clusterResetWithOptions(options, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterResetWithOptionsAndAwait(ResetOptions options) {
        return (Void)this.clusterResetWithOptions(options).await().indefinitely();
    }

    private RedisClient __clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    public Uni<Void> clusterSaveconfig() {
        return AsyncResultUni.toUni(handler -> this.__clusterSaveconfig((Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterSaveconfigAndAwait() {
        return (Void)this.clusterSaveconfig().await().indefinitely();
    }

    private RedisClient __clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    public Uni<Void> clusterSetConfigEpoch(long epoch) {
        return AsyncResultUni.toUni(handler -> this.__clusterSetConfigEpoch(epoch, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterSetConfigEpochAndAwait(long epoch) {
        return (Void)this.clusterSetConfigEpoch(epoch).await().indefinitely();
    }

    private RedisClient __clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    public Uni<Void> clusterSetslot(long slot, SlotCmd subcommand) {
        return AsyncResultUni.toUni(handler -> this.__clusterSetslot(slot, subcommand, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterSetslotAndAwait(long slot, SlotCmd subcommand) {
        return (Void)this.clusterSetslot(slot, subcommand).await().indefinitely();
    }

    private RedisClient __clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    public Uni<Void> clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<Void>>)handler));
    }

    public Void clusterSetslotWithNodeAndAwait(long slot, SlotCmd subcommand, String nodeId) {
        return (Void)this.clusterSetslotWithNode(slot, subcommand, nodeId).await().indefinitely();
    }

    private RedisClient __clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    public Uni<JsonArray> clusterSlaves(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterSlaves(nodeId, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray clusterSlavesAndAwait(String nodeId) {
        return (JsonArray)this.clusterSlaves(nodeId).await().indefinitely();
    }

    private RedisClient __clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    public Uni<JsonArray> clusterSlots() {
        return AsyncResultUni.toUni(handler -> this.__clusterSlots((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray clusterSlotsAndAwait() {
        return (JsonArray)this.clusterSlots().await().indefinitely();
    }

    private RedisClient __command(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.command(handler);
        return this;
    }

    public Uni<JsonArray> command() {
        return AsyncResultUni.toUni(handler -> this.__command((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray commandAndAwait() {
        return (JsonArray)this.command().await().indefinitely();
    }

    private RedisClient __commandCount(Handler<AsyncResult<Long>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    public Uni<Long> commandCount() {
        return AsyncResultUni.toUni(handler -> this.__commandCount((Handler<AsyncResult<Long>>)handler));
    }

    public Long commandCountAndAwait() {
        return (Long)this.commandCount().await().indefinitely();
    }

    private RedisClient __commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    public Uni<JsonArray> commandGetkeys() {
        return AsyncResultUni.toUni(handler -> this.__commandGetkeys((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray commandGetkeysAndAwait() {
        return (JsonArray)this.commandGetkeys().await().indefinitely();
    }

    private RedisClient __commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    public Uni<JsonArray> commandInfo(List<String> commands) {
        return AsyncResultUni.toUni(handler -> this.__commandInfo(commands, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray commandInfoAndAwait(List<String> commands) {
        return (JsonArray)this.commandInfo(commands).await().indefinitely();
    }

    private RedisClient __configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    public Uni<JsonArray> configGet(String parameter) {
        return AsyncResultUni.toUni(handler -> this.__configGet(parameter, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray configGetAndAwait(String parameter) {
        return (JsonArray)this.configGet(parameter).await().indefinitely();
    }

    private RedisClient __configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    public Uni<String> configRewrite() {
        return AsyncResultUni.toUni(handler -> this.__configRewrite((Handler<AsyncResult<String>>)handler));
    }

    public String configRewriteAndAwait() {
        return (String)this.configRewrite().await().indefinitely();
    }

    private RedisClient __configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    public Uni<String> configSet(String parameter, String value) {
        return AsyncResultUni.toUni(handler -> this.__configSet(parameter, value, (Handler<AsyncResult<String>>)handler));
    }

    public String configSetAndAwait(String parameter, String value) {
        return (String)this.configSet(parameter, value).await().indefinitely();
    }

    private RedisClient __configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    public Uni<String> configResetstat() {
        return AsyncResultUni.toUni(handler -> this.__configResetstat((Handler<AsyncResult<String>>)handler));
    }

    public String configResetstatAndAwait() {
        return (String)this.configResetstat().await().indefinitely();
    }

    private RedisClient __dbsize(Handler<AsyncResult<Long>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    public Uni<Long> dbsize() {
        return AsyncResultUni.toUni(handler -> this.__dbsize((Handler<AsyncResult<Long>>)handler));
    }

    public Long dbsizeAndAwait() {
        return (Long)this.dbsize().await().indefinitely();
    }

    private RedisClient __debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    public Uni<String> debugObject(String key) {
        return AsyncResultUni.toUni(handler -> this.__debugObject(key, (Handler<AsyncResult<String>>)handler));
    }

    public String debugObjectAndAwait(String key) {
        return (String)this.debugObject(key).await().indefinitely();
    }

    private RedisClient __debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    public Uni<String> debugSegfault() {
        return AsyncResultUni.toUni(handler -> this.__debugSegfault((Handler<AsyncResult<String>>)handler));
    }

    public String debugSegfaultAndAwait() {
        return (String)this.debugSegfault().await().indefinitely();
    }

    private RedisClient __decr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    public Uni<Long> decr(String key) {
        return AsyncResultUni.toUni(handler -> this.__decr(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long decrAndAwait(String key) {
        return (Long)this.decr(key).await().indefinitely();
    }

    private RedisClient __decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    public Uni<Long> decrby(String key, long decrement) {
        return AsyncResultUni.toUni(handler -> this.__decrby(key, decrement, (Handler<AsyncResult<Long>>)handler));
    }

    public Long decrbyAndAwait(String key, long decrement) {
        return (Long)this.decrby(key, decrement).await().indefinitely();
    }

    private RedisClient __del(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    public Uni<Long> del(String key) {
        return AsyncResultUni.toUni(handler -> this.__del(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long delAndAwait(String key) {
        return (Long)this.del(key).await().indefinitely();
    }

    private RedisClient __delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    public Uni<Long> delMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__delMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long delManyAndAwait(List<String> keys) {
        return (Long)this.delMany(keys).await().indefinitely();
    }

    private RedisClient __dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    public Uni<String> dump(String key) {
        return AsyncResultUni.toUni(handler -> this.__dump(key, (Handler<AsyncResult<String>>)handler));
    }

    public String dumpAndAwait(String key) {
        return (String)this.dump(key).await().indefinitely();
    }

    private RedisClient __echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    public Uni<String> echo(String message) {
        return AsyncResultUni.toUni(handler -> this.__echo(message, (Handler<AsyncResult<String>>)handler));
    }

    public String echoAndAwait(String message) {
        return (String)this.echo(message).await().indefinitely();
    }

    private RedisClient __eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    public Uni<JsonArray> eval(String script, List<String> keys, List<String> args) {
        return AsyncResultUni.toUni(handler -> this.__eval(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray evalAndAwait(String script, List<String> keys, List<String> args) {
        return (JsonArray)this.eval(script, keys, args).await().indefinitely();
    }

    private RedisClient __evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    public Uni<JsonArray> evalsha(String sha1, List<String> keys, List<String> values) {
        return AsyncResultUni.toUni(handler -> this.__evalsha(sha1, keys, values, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray evalshaAndAwait(String sha1, List<String> keys, List<String> values) {
        return (JsonArray)this.evalsha(sha1, keys, values).await().indefinitely();
    }

    private RedisClient __evalScript(Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalScript(script.getDelegate(), keys, args, handler);
        return this;
    }

    public Uni<JsonArray> evalScript(Script script, List<String> keys, List<String> args) {
        return AsyncResultUni.toUni(handler -> this.__evalScript(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray evalScriptAndAwait(Script script, List<String> keys, List<String> args) {
        return (JsonArray)this.evalScript(script, keys, args).await().indefinitely();
    }

    private RedisClient __exists(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    public Uni<Long> exists(String key) {
        return AsyncResultUni.toUni(handler -> this.__exists(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long existsAndAwait(String key) {
        return (Long)this.exists(key).await().indefinitely();
    }

    private RedisClient __existsMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.existsMany(keys, handler);
        return this;
    }

    public Uni<Long> existsMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__existsMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long existsManyAndAwait(List<String> keys) {
        return (Long)this.existsMany(keys).await().indefinitely();
    }

    private RedisClient __expire(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    public Uni<Long> expire(String key, long seconds) {
        return AsyncResultUni.toUni(handler -> this.__expire(key, seconds, (Handler<AsyncResult<Long>>)handler));
    }

    public Long expireAndAwait(String key, long seconds) {
        return (Long)this.expire(key, seconds).await().indefinitely();
    }

    private RedisClient __expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    public Uni<Long> expireat(String key, long seconds) {
        return AsyncResultUni.toUni(handler -> this.__expireat(key, seconds, (Handler<AsyncResult<Long>>)handler));
    }

    public Long expireatAndAwait(String key, long seconds) {
        return (Long)this.expireat(key, seconds).await().indefinitely();
    }

    private RedisClient __flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    public Uni<String> flushall() {
        return AsyncResultUni.toUni(handler -> this.__flushall((Handler<AsyncResult<String>>)handler));
    }

    public String flushallAndAwait() {
        return (String)this.flushall().await().indefinitely();
    }

    private RedisClient __flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    public Uni<String> flushdb() {
        return AsyncResultUni.toUni(handler -> this.__flushdb((Handler<AsyncResult<String>>)handler));
    }

    public String flushdbAndAwait() {
        return (String)this.flushdb().await().indefinitely();
    }

    private RedisClient __get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    public Uni<String> get(String key) {
        return AsyncResultUni.toUni(handler -> this.__get(key, (Handler<AsyncResult<String>>)handler));
    }

    public String getAndAwait(String key) {
        return (String)this.get(key).await().indefinitely();
    }

    private RedisClient __getBinary(String key, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.getBinary(key, (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)((io.vertx.core.buffer.Buffer)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<Buffer> getBinary(String key) {
        return AsyncResultUni.toUni(handler -> this.__getBinary(key, (Handler<AsyncResult<Buffer>>)handler));
    }

    public Buffer getBinaryAndAwait(String key) {
        return (Buffer)this.getBinary(key).await().indefinitely();
    }

    private RedisClient __getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    public Uni<Long> getbit(String key, long offset) {
        return AsyncResultUni.toUni(handler -> this.__getbit(key, offset, (Handler<AsyncResult<Long>>)handler));
    }

    public Long getbitAndAwait(String key, long offset) {
        return (Long)this.getbit(key, offset).await().indefinitely();
    }

    private RedisClient __getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    public Uni<String> getrange(String key, long start, long end) {
        return AsyncResultUni.toUni(handler -> this.__getrange(key, start, end, (Handler<AsyncResult<String>>)handler));
    }

    public String getrangeAndAwait(String key, long start, long end) {
        return (String)this.getrange(key, start, end).await().indefinitely();
    }

    private RedisClient __getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    public Uni<String> getset(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__getset(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String getsetAndAwait(String key, String value) {
        return (String)this.getset(key, value).await().indefinitely();
    }

    private RedisClient __hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    public Uni<Long> hdel(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hdel(key, field, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hdelAndAwait(String key, String field) {
        return (Long)this.hdel(key, field).await().indefinitely();
    }

    private RedisClient __hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    public Uni<Long> hdelMany(String key, List<String> fields) {
        return AsyncResultUni.toUni(handler -> this.__hdelMany(key, fields, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hdelManyAndAwait(String key, List<String> fields) {
        return (Long)this.hdelMany(key, fields).await().indefinitely();
    }

    private RedisClient __hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    public Uni<Long> hexists(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hexists(key, field, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hexistsAndAwait(String key, String field) {
        return (Long)this.hexists(key, field).await().indefinitely();
    }

    private RedisClient __hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    public Uni<String> hget(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hget(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public String hgetAndAwait(String key, String field) {
        return (String)this.hget(key, field).await().indefinitely();
    }

    private RedisClient __hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    public Uni<JsonObject> hgetall(String key) {
        return AsyncResultUni.toUni(handler -> this.__hgetall(key, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject hgetallAndAwait(String key) {
        return (JsonObject)this.hgetall(key).await().indefinitely();
    }

    private RedisClient __hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    public Uni<Long> hincrby(String key, String field, long increment) {
        return AsyncResultUni.toUni(handler -> this.__hincrby(key, field, increment, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hincrbyAndAwait(String key, String field, long increment) {
        return (Long)this.hincrby(key, field, increment).await().indefinitely();
    }

    private RedisClient __hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    public Uni<String> hincrbyfloat(String key, String field, double increment) {
        return AsyncResultUni.toUni(handler -> this.__hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler));
    }

    public String hincrbyfloatAndAwait(String key, String field, double increment) {
        return (String)this.hincrbyfloat(key, field, increment).await().indefinitely();
    }

    private RedisClient __hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    public Uni<JsonArray> hkeys(String key) {
        return AsyncResultUni.toUni(handler -> this.__hkeys(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray hkeysAndAwait(String key) {
        return (JsonArray)this.hkeys(key).await().indefinitely();
    }

    private RedisClient __hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    public Uni<Long> hlen(String key) {
        return AsyncResultUni.toUni(handler -> this.__hlen(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hlenAndAwait(String key) {
        return (Long)this.hlen(key).await().indefinitely();
    }

    private RedisClient __hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    public Uni<JsonArray> hmget(String key, List<String> fields) {
        return AsyncResultUni.toUni(handler -> this.__hmget(key, fields, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray hmgetAndAwait(String key, List<String> fields) {
        return (JsonArray)this.hmget(key, fields).await().indefinitely();
    }

    private RedisClient __hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    public Uni<String> hmset(String key, JsonObject values) {
        return AsyncResultUni.toUni(handler -> this.__hmset(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public String hmsetAndAwait(String key, JsonObject values) {
        return (String)this.hmset(key, values).await().indefinitely();
    }

    private RedisClient __hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    public Uni<Long> hset(String key, String field, String value) {
        return AsyncResultUni.toUni(handler -> this.__hset(key, field, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hsetAndAwait(String key, String field, String value) {
        return (Long)this.hset(key, field, value).await().indefinitely();
    }

    private RedisClient __hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    public Uni<Long> hsetnx(String key, String field, String value) {
        return AsyncResultUni.toUni(handler -> this.__hsetnx(key, field, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hsetnxAndAwait(String key, String field, String value) {
        return (Long)this.hsetnx(key, field, value).await().indefinitely();
    }

    private RedisClient __hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    public Uni<JsonArray> hvals(String key) {
        return AsyncResultUni.toUni(handler -> this.__hvals(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray hvalsAndAwait(String key) {
        return (JsonArray)this.hvals(key).await().indefinitely();
    }

    private RedisClient __incr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    public Uni<Long> incr(String key) {
        return AsyncResultUni.toUni(handler -> this.__incr(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long incrAndAwait(String key) {
        return (Long)this.incr(key).await().indefinitely();
    }

    private RedisClient __incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    public Uni<Long> incrby(String key, long increment) {
        return AsyncResultUni.toUni(handler -> this.__incrby(key, increment, (Handler<AsyncResult<Long>>)handler));
    }

    public Long incrbyAndAwait(String key, long increment) {
        return (Long)this.incrby(key, increment).await().indefinitely();
    }

    private RedisClient __incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    public Uni<String> incrbyfloat(String key, double increment) {
        return AsyncResultUni.toUni(handler -> this.__incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler));
    }

    public String incrbyfloatAndAwait(String key, double increment) {
        return (String)this.incrbyfloat(key, increment).await().indefinitely();
    }

    private RedisClient __info(Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.info(handler);
        return this;
    }

    public Uni<JsonObject> info() {
        return AsyncResultUni.toUni(handler -> this.__info((Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject infoAndAwait() {
        return (JsonObject)this.info().await().indefinitely();
    }

    private RedisClient __infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    public Uni<JsonObject> infoSection(String section) {
        return AsyncResultUni.toUni(handler -> this.__infoSection(section, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject infoSectionAndAwait(String section) {
        return (JsonObject)this.infoSection(section).await().indefinitely();
    }

    private RedisClient __keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    public Uni<JsonArray> keys(String pattern) {
        return AsyncResultUni.toUni(handler -> this.__keys(pattern, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray keysAndAwait(String pattern) {
        return (JsonArray)this.keys(pattern).await().indefinitely();
    }

    private RedisClient __lastsave(Handler<AsyncResult<Long>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    public Uni<Long> lastsave() {
        return AsyncResultUni.toUni(handler -> this.__lastsave((Handler<AsyncResult<Long>>)handler));
    }

    public Long lastsaveAndAwait() {
        return (Long)this.lastsave().await().indefinitely();
    }

    private RedisClient __lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    public Uni<String> lindex(String key, int index) {
        return AsyncResultUni.toUni(handler -> this.__lindex(key, index, (Handler<AsyncResult<String>>)handler));
    }

    public String lindexAndAwait(String key, int index) {
        return (String)this.lindex(key, index).await().indefinitely();
    }

    private RedisClient __linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    public Uni<Long> linsert(String key, InsertOptions option, String pivot, String value) {
        return AsyncResultUni.toUni(handler -> this.__linsert(key, option, pivot, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long linsertAndAwait(String key, InsertOptions option, String pivot, String value) {
        return (Long)this.linsert(key, option, pivot, value).await().indefinitely();
    }

    private RedisClient __llen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    public Uni<Long> llen(String key) {
        return AsyncResultUni.toUni(handler -> this.__llen(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long llenAndAwait(String key) {
        return (Long)this.llen(key).await().indefinitely();
    }

    private RedisClient __lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    public Uni<String> lpop(String key) {
        return AsyncResultUni.toUni(handler -> this.__lpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public String lpopAndAwait(String key) {
        return (String)this.lpop(key).await().indefinitely();
    }

    private RedisClient __lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    public Uni<Long> lpushMany(String key, List<String> values) {
        return AsyncResultUni.toUni(handler -> this.__lpushMany(key, values, (Handler<AsyncResult<Long>>)handler));
    }

    public Long lpushManyAndAwait(String key, List<String> values) {
        return (Long)this.lpushMany(key, values).await().indefinitely();
    }

    private RedisClient __lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    public Uni<Long> lpush(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__lpush(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long lpushAndAwait(String key, String value) {
        return (Long)this.lpush(key, value).await().indefinitely();
    }

    private RedisClient __lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    public Uni<Long> lpushx(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__lpushx(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long lpushxAndAwait(String key, String value) {
        return (Long)this.lpushx(key, value).await().indefinitely();
    }

    private RedisClient __lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    public Uni<JsonArray> lrange(String key, long from, long to) {
        return AsyncResultUni.toUni(handler -> this.__lrange(key, from, to, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray lrangeAndAwait(String key, long from, long to) {
        return (JsonArray)this.lrange(key, from, to).await().indefinitely();
    }

    private RedisClient __lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    public Uni<Long> lrem(String key, long count, String value) {
        return AsyncResultUni.toUni(handler -> this.__lrem(key, count, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long lremAndAwait(String key, long count, String value) {
        return (Long)this.lrem(key, count, value).await().indefinitely();
    }

    private RedisClient __lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    public Uni<String> lset(String key, long index, String value) {
        return AsyncResultUni.toUni(handler -> this.__lset(key, index, value, (Handler<AsyncResult<String>>)handler));
    }

    public String lsetAndAwait(String key, long index, String value) {
        return (String)this.lset(key, index, value).await().indefinitely();
    }

    private RedisClient __ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    public Uni<String> ltrim(String key, long from, long to) {
        return AsyncResultUni.toUni(handler -> this.__ltrim(key, from, to, (Handler<AsyncResult<String>>)handler));
    }

    public String ltrimAndAwait(String key, long from, long to) {
        return (String)this.ltrim(key, from, to).await().indefinitely();
    }

    private RedisClient __mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    public Uni<JsonArray> mget(String key) {
        return AsyncResultUni.toUni(handler -> this.__mget(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray mgetAndAwait(String key) {
        return (JsonArray)this.mget(key).await().indefinitely();
    }

    private RedisClient __mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    public Uni<JsonArray> mgetMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__mgetMany(keys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray mgetManyAndAwait(List<String> keys) {
        return (JsonArray)this.mgetMany(keys).await().indefinitely();
    }

    private RedisClient __migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    public Uni<String> migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler));
    }

    public String migrateAndAwait(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return (String)this.migrate(host, port, key, destdb, timeout, options).await().indefinitely();
    }

    private RedisClient __monitor(Handler<AsyncResult<Void>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    public Uni<Void> monitor() {
        return AsyncResultUni.toUni(handler -> this.__monitor((Handler<AsyncResult<Void>>)handler));
    }

    public Void monitorAndAwait() {
        return (Void)this.monitor().await().indefinitely();
    }

    private RedisClient __move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    public Uni<Long> move(String key, int destdb) {
        return AsyncResultUni.toUni(handler -> this.__move(key, destdb, (Handler<AsyncResult<Long>>)handler));
    }

    public Long moveAndAwait(String key, int destdb) {
        return (Long)this.move(key, destdb).await().indefinitely();
    }

    private RedisClient __mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    public Uni<String> mset(JsonObject keyvals) {
        return AsyncResultUni.toUni(handler -> this.__mset(keyvals, (Handler<AsyncResult<String>>)handler));
    }

    public String msetAndAwait(JsonObject keyvals) {
        return (String)this.mset(keyvals).await().indefinitely();
    }

    private RedisClient __msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    public Uni<Long> msetnx(JsonObject keyvals) {
        return AsyncResultUni.toUni(handler -> this.__msetnx(keyvals, (Handler<AsyncResult<Long>>)handler));
    }

    public Long msetnxAndAwait(JsonObject keyvals) {
        return (Long)this.msetnx(keyvals).await().indefinitely();
    }

    private RedisClient __object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    public Uni<Void> object(String key, ObjectCmd cmd) {
        return AsyncResultUni.toUni(handler -> this.__object(key, cmd, (Handler<AsyncResult<Void>>)handler));
    }

    public Void objectAndAwait(String key, ObjectCmd cmd) {
        return (Void)this.object(key, cmd).await().indefinitely();
    }

    private RedisClient __persist(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    public Uni<Long> persist(String key) {
        return AsyncResultUni.toUni(handler -> this.__persist(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long persistAndAwait(String key) {
        return (Long)this.persist(key).await().indefinitely();
    }

    private RedisClient __pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    public Uni<Long> pexpire(String key, long millis) {
        return AsyncResultUni.toUni(handler -> this.__pexpire(key, millis, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pexpireAndAwait(String key, long millis) {
        return (Long)this.pexpire(key, millis).await().indefinitely();
    }

    private RedisClient __pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    public Uni<Long> pexpireat(String key, long millis) {
        return AsyncResultUni.toUni(handler -> this.__pexpireat(key, millis, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pexpireatAndAwait(String key, long millis) {
        return (Long)this.pexpireat(key, millis).await().indefinitely();
    }

    private RedisClient __pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    public Uni<Long> pfadd(String key, String element) {
        return AsyncResultUni.toUni(handler -> this.__pfadd(key, element, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pfaddAndAwait(String key, String element) {
        return (Long)this.pfadd(key, element).await().indefinitely();
    }

    private RedisClient __pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    public Uni<Long> pfaddMany(String key, List<String> elements) {
        return AsyncResultUni.toUni(handler -> this.__pfaddMany(key, elements, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pfaddManyAndAwait(String key, List<String> elements) {
        return (Long)this.pfaddMany(key, elements).await().indefinitely();
    }

    private RedisClient __pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    public Uni<Long> pfcount(String key) {
        return AsyncResultUni.toUni(handler -> this.__pfcount(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pfcountAndAwait(String key) {
        return (Long)this.pfcount(key).await().indefinitely();
    }

    private RedisClient __pfcountMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    public Uni<Long> pfcountMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__pfcountMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pfcountManyAndAwait(List<String> keys) {
        return (Long)this.pfcountMany(keys).await().indefinitely();
    }

    private RedisClient __pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    public Uni<String> pfmerge(String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public String pfmergeAndAwait(String destkey, List<String> keys) {
        return (String)this.pfmerge(destkey, keys).await().indefinitely();
    }

    private RedisClient __ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public Uni<String> ping() {
        return AsyncResultUni.toUni(handler -> this.__ping((Handler<AsyncResult<String>>)handler));
    }

    public String pingAndAwait() {
        return (String)this.ping().await().indefinitely();
    }

    private RedisClient __psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    public Uni<Void> psetex(String key, long millis, String value) {
        return AsyncResultUni.toUni(handler -> this.__psetex(key, millis, value, (Handler<AsyncResult<Void>>)handler));
    }

    public Void psetexAndAwait(String key, long millis, String value) {
        return (Void)this.psetex(key, millis, value).await().indefinitely();
    }

    private RedisClient __psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    public Uni<JsonArray> psubscribe(String pattern) {
        return AsyncResultUni.toUni(handler -> this.__psubscribe(pattern, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray psubscribeAndAwait(String pattern) {
        return (JsonArray)this.psubscribe(pattern).await().indefinitely();
    }

    private RedisClient __psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    public Uni<JsonArray> psubscribeMany(List<String> patterns) {
        return AsyncResultUni.toUni(handler -> this.__psubscribeMany(patterns, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray psubscribeManyAndAwait(List<String> patterns) {
        return (JsonArray)this.psubscribeMany(patterns).await().indefinitely();
    }

    private RedisClient __pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    public Uni<JsonArray> pubsubChannels(String pattern) {
        return AsyncResultUni.toUni(handler -> this.__pubsubChannels(pattern, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray pubsubChannelsAndAwait(String pattern) {
        return (JsonArray)this.pubsubChannels(pattern).await().indefinitely();
    }

    private RedisClient __pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    public Uni<JsonArray> pubsubNumsub(List<String> channels) {
        return AsyncResultUni.toUni(handler -> this.__pubsubNumsub(channels, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray pubsubNumsubAndAwait(List<String> channels) {
        return (JsonArray)this.pubsubNumsub(channels).await().indefinitely();
    }

    private RedisClient __pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    public Uni<Long> pubsubNumpat() {
        return AsyncResultUni.toUni(handler -> this.__pubsubNumpat((Handler<AsyncResult<Long>>)handler));
    }

    public Long pubsubNumpatAndAwait() {
        return (Long)this.pubsubNumpat().await().indefinitely();
    }

    private RedisClient __pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    public Uni<Long> pttl(String key) {
        return AsyncResultUni.toUni(handler -> this.__pttl(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long pttlAndAwait(String key) {
        return (Long)this.pttl(key).await().indefinitely();
    }

    private RedisClient __publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    public Uni<Long> publish(String channel, String message) {
        return AsyncResultUni.toUni(handler -> this.__publish(channel, message, (Handler<AsyncResult<Long>>)handler));
    }

    public Long publishAndAwait(String channel, String message) {
        return (Long)this.publish(channel, message).await().indefinitely();
    }

    private RedisClient __punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    public Uni<Void> punsubscribe(List<String> patterns) {
        return AsyncResultUni.toUni(handler -> this.__punsubscribe(patterns, (Handler<AsyncResult<Void>>)handler));
    }

    public Void punsubscribeAndAwait(List<String> patterns) {
        return (Void)this.punsubscribe(patterns).await().indefinitely();
    }

    private RedisClient __randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    public Uni<String> randomkey() {
        return AsyncResultUni.toUni(handler -> this.__randomkey((Handler<AsyncResult<String>>)handler));
    }

    public String randomkeyAndAwait() {
        return (String)this.randomkey().await().indefinitely();
    }

    private RedisClient __rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    public Uni<String> rename(String key, String newkey) {
        return AsyncResultUni.toUni(handler -> this.__rename(key, newkey, (Handler<AsyncResult<String>>)handler));
    }

    public String renameAndAwait(String key, String newkey) {
        return (String)this.rename(key, newkey).await().indefinitely();
    }

    private RedisClient __renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    public Uni<Long> renamenx(String key, String newkey) {
        return AsyncResultUni.toUni(handler -> this.__renamenx(key, newkey, (Handler<AsyncResult<Long>>)handler));
    }

    public Long renamenxAndAwait(String key, String newkey) {
        return (Long)this.renamenx(key, newkey).await().indefinitely();
    }

    private RedisClient __restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    public Uni<String> restore(String key, long millis, String serialized) {
        return AsyncResultUni.toUni(handler -> this.__restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler));
    }

    public String restoreAndAwait(String key, long millis, String serialized) {
        return (String)this.restore(key, millis, serialized).await().indefinitely();
    }

    private RedisClient __role(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.role(handler);
        return this;
    }

    public Uni<JsonArray> role() {
        return AsyncResultUni.toUni(handler -> this.__role((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray roleAndAwait() {
        return (JsonArray)this.role().await().indefinitely();
    }

    private RedisClient __rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    public Uni<String> rpop(String key) {
        return AsyncResultUni.toUni(handler -> this.__rpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public String rpopAndAwait(String key) {
        return (String)this.rpop(key).await().indefinitely();
    }

    private RedisClient __rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    public Uni<String> rpoplpush(String key, String destkey) {
        return AsyncResultUni.toUni(handler -> this.__rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler));
    }

    public String rpoplpushAndAwait(String key, String destkey) {
        return (String)this.rpoplpush(key, destkey).await().indefinitely();
    }

    private RedisClient __rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    public Uni<Long> rpushMany(String key, List<String> values) {
        return AsyncResultUni.toUni(handler -> this.__rpushMany(key, values, (Handler<AsyncResult<Long>>)handler));
    }

    public Long rpushManyAndAwait(String key, List<String> values) {
        return (Long)this.rpushMany(key, values).await().indefinitely();
    }

    private RedisClient __rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    public Uni<Long> rpush(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__rpush(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long rpushAndAwait(String key, String value) {
        return (Long)this.rpush(key, value).await().indefinitely();
    }

    private RedisClient __rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    public Uni<Long> rpushx(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__rpushx(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long rpushxAndAwait(String key, String value) {
        return (Long)this.rpushx(key, value).await().indefinitely();
    }

    private RedisClient __sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    public Uni<Long> sadd(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__sadd(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long saddAndAwait(String key, String member) {
        return (Long)this.sadd(key, member).await().indefinitely();
    }

    private RedisClient __saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    public Uni<Long> saddMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__saddMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public Long saddManyAndAwait(String key, List<String> members) {
        return (Long)this.saddMany(key, members).await().indefinitely();
    }

    private RedisClient __save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    public Uni<String> save() {
        return AsyncResultUni.toUni(handler -> this.__save((Handler<AsyncResult<String>>)handler));
    }

    public String saveAndAwait() {
        return (String)this.save().await().indefinitely();
    }

    private RedisClient __scard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    public Uni<Long> scard(String key) {
        return AsyncResultUni.toUni(handler -> this.__scard(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long scardAndAwait(String key) {
        return (Long)this.scard(key).await().indefinitely();
    }

    private RedisClient __scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    public Uni<JsonArray> scriptExists(String script) {
        return AsyncResultUni.toUni(handler -> this.__scriptExists(script, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray scriptExistsAndAwait(String script) {
        return (JsonArray)this.scriptExists(script).await().indefinitely();
    }

    private RedisClient __scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    public Uni<JsonArray> scriptExistsMany(List<String> scripts) {
        return AsyncResultUni.toUni(handler -> this.__scriptExistsMany(scripts, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray scriptExistsManyAndAwait(List<String> scripts) {
        return (JsonArray)this.scriptExistsMany(scripts).await().indefinitely();
    }

    private RedisClient __scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    public Uni<String> scriptFlush() {
        return AsyncResultUni.toUni(handler -> this.__scriptFlush((Handler<AsyncResult<String>>)handler));
    }

    public String scriptFlushAndAwait() {
        return (String)this.scriptFlush().await().indefinitely();
    }

    private RedisClient __scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    public Uni<String> scriptKill() {
        return AsyncResultUni.toUni(handler -> this.__scriptKill((Handler<AsyncResult<String>>)handler));
    }

    public String scriptKillAndAwait() {
        return (String)this.scriptKill().await().indefinitely();
    }

    private RedisClient __scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    public Uni<String> scriptLoad(String script) {
        return AsyncResultUni.toUni(handler -> this.__scriptLoad(script, (Handler<AsyncResult<String>>)handler));
    }

    public String scriptLoadAndAwait(String script) {
        return (String)this.scriptLoad(script).await().indefinitely();
    }

    private RedisClient __sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    public Uni<JsonArray> sdiff(String key, List<String> cmpkeys) {
        return AsyncResultUni.toUni(handler -> this.__sdiff(key, cmpkeys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray sdiffAndAwait(String key, List<String> cmpkeys) {
        return (JsonArray)this.sdiff(key, cmpkeys).await().indefinitely();
    }

    private RedisClient __sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    public Uni<Long> sdiffstore(String destkey, String key, List<String> cmpkeys) {
        return AsyncResultUni.toUni(handler -> this.__sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long sdiffstoreAndAwait(String destkey, String key, List<String> cmpkeys) {
        return (Long)this.sdiffstore(destkey, key, cmpkeys).await().indefinitely();
    }

    private RedisClient __select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    public Uni<String> select(int dbindex) {
        return AsyncResultUni.toUni(handler -> this.__select(dbindex, (Handler<AsyncResult<String>>)handler));
    }

    public String selectAndAwait(int dbindex) {
        return (String)this.select(dbindex).await().indefinitely();
    }

    private RedisClient __set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    public Uni<Void> set(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__set(key, value, (Handler<AsyncResult<Void>>)handler));
    }

    public Void setAndAwait(String key, String value) {
        return (Void)this.set(key, value).await().indefinitely();
    }

    private RedisClient __setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    public Uni<String> setWithOptions(String key, String value, SetOptions options) {
        return AsyncResultUni.toUni(handler -> this.__setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler));
    }

    public String setWithOptionsAndAwait(String key, String value, SetOptions options) {
        return (String)this.setWithOptions(key, value, options).await().indefinitely();
    }

    private RedisClient __setBinary(String key, Buffer value, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinary(key, value.getDelegate(), handler);
        return this;
    }

    public Uni<Void> setBinary(String key, Buffer value) {
        return AsyncResultUni.toUni(handler -> this.__setBinary(key, value, (Handler<AsyncResult<Void>>)handler));
    }

    public Void setBinaryAndAwait(String key, Buffer value) {
        return (Void)this.setBinary(key, value).await().indefinitely();
    }

    private RedisClient __setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
        return this;
    }

    public Uni<Void> setBinaryWithOptions(String key, Buffer value, SetOptions options) {
        return AsyncResultUni.toUni(handler -> this.__setBinaryWithOptions(key, value, options, (Handler<AsyncResult<Void>>)handler));
    }

    public Void setBinaryWithOptionsAndAwait(String key, Buffer value, SetOptions options) {
        return (Void)this.setBinaryWithOptions(key, value, options).await().indefinitely();
    }

    private RedisClient __setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    public Uni<Long> setbit(String key, long offset, int bit) {
        return AsyncResultUni.toUni(handler -> this.__setbit(key, offset, bit, (Handler<AsyncResult<Long>>)handler));
    }

    public Long setbitAndAwait(String key, long offset, int bit) {
        return (Long)this.setbit(key, offset, bit).await().indefinitely();
    }

    private RedisClient __setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    public Uni<String> setex(String key, long seconds, String value) {
        return AsyncResultUni.toUni(handler -> this.__setex(key, seconds, value, (Handler<AsyncResult<String>>)handler));
    }

    public String setexAndAwait(String key, long seconds, String value) {
        return (String)this.setex(key, seconds, value).await().indefinitely();
    }

    private RedisClient __setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    public Uni<Long> setnx(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__setnx(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long setnxAndAwait(String key, String value) {
        return (Long)this.setnx(key, value).await().indefinitely();
    }

    private RedisClient __setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    public Uni<Long> setrange(String key, int offset, String value) {
        return AsyncResultUni.toUni(handler -> this.__setrange(key, offset, value, (Handler<AsyncResult<Long>>)handler));
    }

    public Long setrangeAndAwait(String key, int offset, String value) {
        return (Long)this.setrange(key, offset, value).await().indefinitely();
    }

    private RedisClient __sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    public Uni<JsonArray> sinter(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sinter(keys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray sinterAndAwait(List<String> keys) {
        return (JsonArray)this.sinter(keys).await().indefinitely();
    }

    private RedisClient __sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    public Uni<Long> sinterstore(String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sinterstore(destkey, keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long sinterstoreAndAwait(String destkey, List<String> keys) {
        return (Long)this.sinterstore(destkey, keys).await().indefinitely();
    }

    private RedisClient __sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    public Uni<Long> sismember(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__sismember(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long sismemberAndAwait(String key, String member) {
        return (Long)this.sismember(key, member).await().indefinitely();
    }

    private RedisClient __slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    public Uni<String> slaveof(String host, int port) {
        return AsyncResultUni.toUni(handler -> this.__slaveof(host, port, (Handler<AsyncResult<String>>)handler));
    }

    public String slaveofAndAwait(String host, int port) {
        return (String)this.slaveof(host, port).await().indefinitely();
    }

    private RedisClient __slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    public Uni<String> slaveofNoone() {
        return AsyncResultUni.toUni(handler -> this.__slaveofNoone((Handler<AsyncResult<String>>)handler));
    }

    public String slaveofNooneAndAwait() {
        return (String)this.slaveofNoone().await().indefinitely();
    }

    private RedisClient __slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    public Uni<JsonArray> slowlogGet(int limit) {
        return AsyncResultUni.toUni(handler -> this.__slowlogGet(limit, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray slowlogGetAndAwait(int limit) {
        return (JsonArray)this.slowlogGet(limit).await().indefinitely();
    }

    private RedisClient __slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    public Uni<Long> slowlogLen() {
        return AsyncResultUni.toUni(handler -> this.__slowlogLen((Handler<AsyncResult<Long>>)handler));
    }

    public Long slowlogLenAndAwait() {
        return (Long)this.slowlogLen().await().indefinitely();
    }

    private RedisClient __slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    public Uni<Void> slowlogReset() {
        return AsyncResultUni.toUni(handler -> this.__slowlogReset((Handler<AsyncResult<Void>>)handler));
    }

    public Void slowlogResetAndAwait() {
        return (Void)this.slowlogReset().await().indefinitely();
    }

    private RedisClient __smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    public Uni<JsonArray> smembers(String key) {
        return AsyncResultUni.toUni(handler -> this.__smembers(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray smembersAndAwait(String key) {
        return (JsonArray)this.smembers(key).await().indefinitely();
    }

    private RedisClient __smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    public Uni<Long> smove(String key, String destkey, String member) {
        return AsyncResultUni.toUni(handler -> this.__smove(key, destkey, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long smoveAndAwait(String key, String destkey, String member) {
        return (Long)this.smove(key, destkey, member).await().indefinitely();
    }

    private RedisClient __sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    public Uni<JsonArray> sort(String key, SortOptions options) {
        return AsyncResultUni.toUni(handler -> this.__sort(key, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray sortAndAwait(String key, SortOptions options) {
        return (JsonArray)this.sort(key, options).await().indefinitely();
    }

    private RedisClient __spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    public Uni<String> spop(String key) {
        return AsyncResultUni.toUni(handler -> this.__spop(key, (Handler<AsyncResult<String>>)handler));
    }

    public String spopAndAwait(String key) {
        return (String)this.spop(key).await().indefinitely();
    }

    private RedisClient __spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    public Uni<JsonArray> spopMany(String key, int count) {
        return AsyncResultUni.toUni(handler -> this.__spopMany(key, count, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray spopManyAndAwait(String key, int count) {
        return (JsonArray)this.spopMany(key, count).await().indefinitely();
    }

    private RedisClient __srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    public Uni<String> srandmember(String key) {
        return AsyncResultUni.toUni(handler -> this.__srandmember(key, (Handler<AsyncResult<String>>)handler));
    }

    public String srandmemberAndAwait(String key) {
        return (String)this.srandmember(key).await().indefinitely();
    }

    private RedisClient __srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    public Uni<JsonArray> srandmemberCount(String key, int count) {
        return AsyncResultUni.toUni(handler -> this.__srandmemberCount(key, count, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray srandmemberCountAndAwait(String key, int count) {
        return (JsonArray)this.srandmemberCount(key, count).await().indefinitely();
    }

    private RedisClient __srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    public Uni<Long> srem(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__srem(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long sremAndAwait(String key, String member) {
        return (Long)this.srem(key, member).await().indefinitely();
    }

    private RedisClient __sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    public Uni<Long> sremMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__sremMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public Long sremManyAndAwait(String key, List<String> members) {
        return (Long)this.sremMany(key, members).await().indefinitely();
    }

    private RedisClient __strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    public Uni<Long> strlen(String key) {
        return AsyncResultUni.toUni(handler -> this.__strlen(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long strlenAndAwait(String key) {
        return (Long)this.strlen(key).await().indefinitely();
    }

    private RedisClient __subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    public Uni<JsonArray> subscribe(String channel) {
        return AsyncResultUni.toUni(handler -> this.__subscribe(channel, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray subscribeAndAwait(String channel) {
        return (JsonArray)this.subscribe(channel).await().indefinitely();
    }

    private RedisClient __subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    public Uni<JsonArray> subscribeMany(List<String> channels) {
        return AsyncResultUni.toUni(handler -> this.__subscribeMany(channels, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray subscribeManyAndAwait(List<String> channels) {
        return (JsonArray)this.subscribeMany(channels).await().indefinitely();
    }

    private RedisClient __sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    public Uni<JsonArray> sunion(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sunion(keys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray sunionAndAwait(List<String> keys) {
        return (JsonArray)this.sunion(keys).await().indefinitely();
    }

    private RedisClient __sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    public Uni<Long> sunionstore(String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sunionstore(destkey, keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long sunionstoreAndAwait(String destkey, List<String> keys) {
        return (Long)this.sunionstore(destkey, keys).await().indefinitely();
    }

    private RedisClient __sync(Handler<AsyncResult<Void>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    public Uni<Void> sync() {
        return AsyncResultUni.toUni(handler -> this.__sync((Handler<AsyncResult<Void>>)handler));
    }

    public Void syncAndAwait() {
        return (Void)this.sync().await().indefinitely();
    }

    private RedisClient __time(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.time(handler);
        return this;
    }

    public Uni<JsonArray> time() {
        return AsyncResultUni.toUni(handler -> this.__time((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray timeAndAwait() {
        return (JsonArray)this.time().await().indefinitely();
    }

    public RedisTransaction transaction() {
        RedisTransaction ret = RedisTransaction.newInstance(this.delegate.transaction());
        return ret;
    }

    private RedisClient __ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    public Uni<Long> ttl(String key) {
        return AsyncResultUni.toUni(handler -> this.__ttl(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long ttlAndAwait(String key) {
        return (Long)this.ttl(key).await().indefinitely();
    }

    private RedisClient __type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    public Uni<String> type(String key) {
        return AsyncResultUni.toUni(handler -> this.__type(key, (Handler<AsyncResult<String>>)handler));
    }

    public String typeAndAwait(String key) {
        return (String)this.type(key).await().indefinitely();
    }

    private RedisClient __unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    public Uni<Void> unsubscribe(List<String> channels) {
        return AsyncResultUni.toUni(handler -> this.__unsubscribe(channels, (Handler<AsyncResult<Void>>)handler));
    }

    public Void unsubscribeAndAwait(List<String> channels) {
        return (Void)this.unsubscribe(channels).await().indefinitely();
    }

    private RedisClient __wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    public Uni<String> wait(long numSlaves, long timeout) {
        return AsyncResultUni.toUni(handler -> this.__wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler));
    }

    public String waitAndAwait(long numSlaves, long timeout) {
        return (String)this.wait(numSlaves, timeout).await().indefinitely();
    }

    private RedisClient __zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    public Uni<Long> zadd(String key, double score, String member) {
        return AsyncResultUni.toUni(handler -> this.__zadd(key, score, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zaddAndAwait(String key, double score, String member) {
        return (Long)this.zadd(key, score, member).await().indefinitely();
    }

    private RedisClient __zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    public Uni<Long> zaddMany(String key, Map<String, Double> members) {
        return AsyncResultUni.toUni(handler -> this.__zaddMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zaddManyAndAwait(String key, Map<String, Double> members) {
        return (Long)this.zaddMany(key, members).await().indefinitely();
    }

    private RedisClient __zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    public Uni<Long> zcard(String key) {
        return AsyncResultUni.toUni(handler -> this.__zcard(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zcardAndAwait(String key) {
        return (Long)this.zcard(key).await().indefinitely();
    }

    private RedisClient __zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    public Uni<Long> zcount(String key, double min, double max) {
        return AsyncResultUni.toUni(handler -> this.__zcount(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zcountAndAwait(String key, double min, double max) {
        return (Long)this.zcount(key, min, max).await().indefinitely();
    }

    private RedisClient __zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    public Uni<String> zincrby(String key, double increment, String member) {
        return AsyncResultUni.toUni(handler -> this.__zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zincrbyAndAwait(String key, double increment, String member) {
        return (String)this.zincrby(key, increment, member).await().indefinitely();
    }

    private RedisClient __zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    public Uni<Long> zinterstore(String destkey, List<String> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zinterstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zinterstoreAndAwait(String destkey, List<String> sets, AggregateOptions options) {
        return (Long)this.zinterstore(destkey, sets, options).await().indefinitely();
    }

    private RedisClient __zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    public Uni<Long> zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zinterstoreWeighedAndAwait(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return (Long)this.zinterstoreWeighed(destkey, sets, options).await().indefinitely();
    }

    private RedisClient __zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    public Uni<Long> zlexcount(String key, String min, String max) {
        return AsyncResultUni.toUni(handler -> this.__zlexcount(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zlexcountAndAwait(String key, String min, String max) {
        return (Long)this.zlexcount(key, min, max).await().indefinitely();
    }

    private RedisClient __zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    public Uni<JsonArray> zrange(String key, long start, long stop) {
        return AsyncResultUni.toUni(handler -> this.__zrange(key, start, stop, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrangeAndAwait(String key, long start, long stop) {
        return (JsonArray)this.zrange(key, start, stop).await().indefinitely();
    }

    private RedisClient __zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    public Uni<JsonArray> zrangeWithOptions(String key, long start, long stop, RangeOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrangeWithOptionsAndAwait(String key, long start, long stop, RangeOptions options) {
        return (JsonArray)this.zrangeWithOptions(key, start, stop, options).await().indefinitely();
    }

    private RedisClient __zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    public Uni<JsonArray> zrangebylex(String key, String min, String max, LimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrangebylex(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrangebylexAndAwait(String key, String min, String max, LimitOptions options) {
        return (JsonArray)this.zrangebylex(key, min, max, options).await().indefinitely();
    }

    private RedisClient __zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    public Uni<JsonArray> zrangebyscore(String key, String min, String max, RangeLimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrangebyscore(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrangebyscoreAndAwait(String key, String min, String max, RangeLimitOptions options) {
        return (JsonArray)this.zrangebyscore(key, min, max, options).await().indefinitely();
    }

    private RedisClient __zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    public Uni<Long> zrank(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zrank(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zrankAndAwait(String key, String member) {
        return (Long)this.zrank(key, member).await().indefinitely();
    }

    private RedisClient __zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    public Uni<Long> zrem(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zrem(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zremAndAwait(String key, String member) {
        return (Long)this.zrem(key, member).await().indefinitely();
    }

    private RedisClient __zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    public Uni<Long> zremMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__zremMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zremManyAndAwait(String key, List<String> members) {
        return (Long)this.zremMany(key, members).await().indefinitely();
    }

    private RedisClient __zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    public Uni<Long> zremrangebylex(String key, String min, String max) {
        return AsyncResultUni.toUni(handler -> this.__zremrangebylex(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zremrangebylexAndAwait(String key, String min, String max) {
        return (Long)this.zremrangebylex(key, min, max).await().indefinitely();
    }

    private RedisClient __zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    public Uni<Long> zremrangebyrank(String key, long start, long stop) {
        return AsyncResultUni.toUni(handler -> this.__zremrangebyrank(key, start, stop, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zremrangebyrankAndAwait(String key, long start, long stop) {
        return (Long)this.zremrangebyrank(key, start, stop).await().indefinitely();
    }

    private RedisClient __zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    public Uni<Long> zremrangebyscore(String key, String min, String max) {
        return AsyncResultUni.toUni(handler -> this.__zremrangebyscore(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zremrangebyscoreAndAwait(String key, String min, String max) {
        return (Long)this.zremrangebyscore(key, min, max).await().indefinitely();
    }

    private RedisClient __zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    public Uni<JsonArray> zrevrange(String key, long start, long stop, RangeOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrevrange(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrevrangeAndAwait(String key, long start, long stop, RangeOptions options) {
        return (JsonArray)this.zrevrange(key, start, stop, options).await().indefinitely();
    }

    private RedisClient __zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    public Uni<JsonArray> zrevrangebylex(String key, String max, String min, LimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrevrangebylex(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrevrangebylexAndAwait(String key, String max, String min, LimitOptions options) {
        return (JsonArray)this.zrevrangebylex(key, max, min, options).await().indefinitely();
    }

    private RedisClient __zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    public Uni<JsonArray> zrevrangebyscore(String key, String max, String min, RangeLimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zrevrangebyscoreAndAwait(String key, String max, String min, RangeLimitOptions options) {
        return (JsonArray)this.zrevrangebyscore(key, max, min, options).await().indefinitely();
    }

    private RedisClient __zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    public Uni<Long> zrevrank(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zrevrank(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zrevrankAndAwait(String key, String member) {
        return (Long)this.zrevrank(key, member).await().indefinitely();
    }

    private RedisClient __zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    public Uni<String> zscore(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zscore(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zscoreAndAwait(String key, String member) {
        return (String)this.zscore(key, member).await().indefinitely();
    }

    private RedisClient __zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    public Uni<Long> zunionstore(String destkey, List<String> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zunionstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zunionstoreAndAwait(String destkey, List<String> sets, AggregateOptions options) {
        return (Long)this.zunionstore(destkey, sets, options).await().indefinitely();
    }

    private RedisClient __zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    public Uni<Long> zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public Long zunionstoreWeighedAndAwait(String key, Map<String, Double> sets, AggregateOptions options) {
        return (Long)this.zunionstoreWeighed(key, sets, options).await().indefinitely();
    }

    private RedisClient __scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    public Uni<JsonArray> scan(String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__scan(cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray scanAndAwait(String cursor, ScanOptions options) {
        return (JsonArray)this.scan(cursor, options).await().indefinitely();
    }

    private RedisClient __sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    public Uni<JsonArray> sscan(String key, String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__sscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray sscanAndAwait(String key, String cursor, ScanOptions options) {
        return (JsonArray)this.sscan(key, cursor, options).await().indefinitely();
    }

    private RedisClient __hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    public Uni<JsonArray> hscan(String key, String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__hscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray hscanAndAwait(String key, String cursor, ScanOptions options) {
        return (JsonArray)this.hscan(key, cursor, options).await().indefinitely();
    }

    private RedisClient __zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    public Uni<JsonArray> zscan(String key, String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray zscanAndAwait(String key, String cursor, ScanOptions options) {
        return (JsonArray)this.zscan(key, cursor, options).await().indefinitely();
    }

    private RedisClient __geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    public Uni<Long> geoadd(String key, double longitude, double latitude, String member) {
        return AsyncResultUni.toUni(handler -> this.__geoadd(key, longitude, latitude, member, (Handler<AsyncResult<Long>>)handler));
    }

    public Long geoaddAndAwait(String key, double longitude, double latitude, String member) {
        return (Long)this.geoadd(key, longitude, latitude, member).await().indefinitely();
    }

    private RedisClient __geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    public Uni<Long> geoaddMany(String key, List<GeoMember> members) {
        return AsyncResultUni.toUni(handler -> this.__geoaddMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public Long geoaddManyAndAwait(String key, List<GeoMember> members) {
        return (Long)this.geoaddMany(key, members).await().indefinitely();
    }

    private RedisClient __geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    public Uni<JsonArray> geohash(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__geohash(key, member, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray geohashAndAwait(String key, String member) {
        return (JsonArray)this.geohash(key, member).await().indefinitely();
    }

    private RedisClient __geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    public Uni<JsonArray> geohashMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__geohashMany(key, members, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray geohashManyAndAwait(String key, List<String> members) {
        return (JsonArray)this.geohashMany(key, members).await().indefinitely();
    }

    private RedisClient __geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    public Uni<JsonArray> geopos(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__geopos(key, member, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray geoposAndAwait(String key, String member) {
        return (JsonArray)this.geopos(key, member).await().indefinitely();
    }

    private RedisClient __geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    public Uni<JsonArray> geoposMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__geoposMany(key, members, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray geoposManyAndAwait(String key, List<String> members) {
        return (JsonArray)this.geoposMany(key, members).await().indefinitely();
    }

    private RedisClient __geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    public Uni<String> geodist(String key, String member1, String member2) {
        return AsyncResultUni.toUni(handler -> this.__geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler));
    }

    public String geodistAndAwait(String key, String member1, String member2) {
        return (String)this.geodist(key, member1, member2).await().indefinitely();
    }

    private RedisClient __geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    public Uni<String> geodistWithUnit(String key, String member1, String member2, GeoUnit unit) {
        return AsyncResultUni.toUni(handler -> this.__geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler));
    }

    public String geodistWithUnitAndAwait(String key, String member1, String member2, GeoUnit unit) {
        return (String)this.geodistWithUnit(key, member1, member2, unit).await().indefinitely();
    }

    private RedisClient __georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    public Uni<JsonArray> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return AsyncResultUni.toUni(handler -> this.__georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray georadiusAndAwait(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return (JsonArray)this.georadius(key, longitude, latitude, radius, unit).await().indefinitely();
    }

    private RedisClient __georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    public Uni<JsonArray> georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return AsyncResultUni.toUni(handler -> this.__georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray georadiusWithOptionsAndAwait(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return (JsonArray)this.georadiusWithOptions(key, longitude, latitude, radius, unit, options).await().indefinitely();
    }

    private RedisClient __georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    public Uni<JsonArray> georadiusbymember(String key, String member, double radius, GeoUnit unit) {
        return AsyncResultUni.toUni(handler -> this.__georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray georadiusbymemberAndAwait(String key, String member, double radius, GeoUnit unit) {
        return (JsonArray)this.georadiusbymember(key, member, radius, unit).await().indefinitely();
    }

    private RedisClient __georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    public Uni<JsonArray> georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return AsyncResultUni.toUni(handler -> this.__georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray georadiusbymemberWithOptionsAndAwait(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return (JsonArray)this.georadiusbymemberWithOptions(key, member, radius, unit, options).await().indefinitely();
    }

    private RedisClient __clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clientReply(options, handler);
        return this;
    }

    public Uni<String> clientReply(ClientReplyOptions options) {
        return AsyncResultUni.toUni(handler -> this.__clientReply(options, (Handler<AsyncResult<String>>)handler));
    }

    public String clientReplyAndAwait(ClientReplyOptions options) {
        return (String)this.clientReply(options).await().indefinitely();
    }

    private RedisClient __hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hstrlen(key, field, handler);
        return this;
    }

    public Uni<Long> hstrlen(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hstrlen(key, field, (Handler<AsyncResult<Long>>)handler));
    }

    public Long hstrlenAndAwait(String key, String field) {
        return (Long)this.hstrlen(key, field).await().indefinitely();
    }

    private RedisClient __touch(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.touch(key, handler);
        return this;
    }

    public Uni<Long> touch(String key) {
        return AsyncResultUni.toUni(handler -> this.__touch(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long touchAndAwait(String key) {
        return (Long)this.touch(key).await().indefinitely();
    }

    private RedisClient __touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.touchMany(keys, handler);
        return this;
    }

    public Uni<Long> touchMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__touchMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long touchManyAndAwait(List<String> keys) {
        return (Long)this.touchMany(keys).await().indefinitely();
    }

    private RedisClient __scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptDebug(scriptDebugOptions, handler);
        return this;
    }

    public Uni<String> scriptDebug(ScriptDebugOptions scriptDebugOptions) {
        return AsyncResultUni.toUni(handler -> this.__scriptDebug(scriptDebugOptions, (Handler<AsyncResult<String>>)handler));
    }

    public String scriptDebugAndAwait(ScriptDebugOptions scriptDebugOptions) {
        return (String)this.scriptDebug(scriptDebugOptions).await().indefinitely();
    }

    private RedisClient __bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.bitfield(key, bitFieldOptions, handler);
        return this;
    }

    public Uni<JsonArray> bitfield(String key, BitFieldOptions bitFieldOptions) {
        return AsyncResultUni.toUni(handler -> this.__bitfield(key, bitFieldOptions, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray bitfieldAndAwait(String key, BitFieldOptions bitFieldOptions) {
        return (JsonArray)this.bitfield(key, bitFieldOptions).await().indefinitely();
    }

    private RedisClient __bitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.bitfieldWithOverflow(key, commands, overflow, handler);
        return this;
    }

    public Uni<JsonArray> bitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow) {
        return AsyncResultUni.toUni(handler -> this.__bitfieldWithOverflow(key, commands, overflow, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray bitfieldWithOverflowAndAwait(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow) {
        return (JsonArray)this.bitfieldWithOverflow(key, commands, overflow).await().indefinitely();
    }

    private RedisClient __unlink(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.unlink(key, handler);
        return this;
    }

    public Uni<Long> unlink(String key) {
        return AsyncResultUni.toUni(handler -> this.__unlink(key, (Handler<AsyncResult<Long>>)handler));
    }

    public Long unlinkAndAwait(String key) {
        return (Long)this.unlink(key).await().indefinitely();
    }

    private RedisClient __unlinkMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.unlinkMany(keys, handler);
        return this;
    }

    public Uni<Long> unlinkMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__unlinkMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public Long unlinkManyAndAwait(List<String> keys) {
        return (Long)this.unlinkMany(keys).await().indefinitely();
    }

    private RedisClient __swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
        this.delegate.swapdb(index1, index2, handler);
        return this;
    }

    public Uni<String> swapdb(int index1, int index2) {
        return AsyncResultUni.toUni(handler -> this.__swapdb(index1, index2, (Handler<AsyncResult<String>>)handler));
    }

    public String swapdbAndAwait(int index1, int index2) {
        return (String)this.swapdb(index1, index2).await().indefinitely();
    }

    public static RedisClient newInstance(io.vertx.redis.RedisClient arg) {
        return arg != null ? new RedisClient(arg) : null;
    }
}

