/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.redis;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.List;
import java.util.Map;

@MutinyGen(value=io.vertx.redis.RedisTransaction.class)
public class RedisTransaction {
    public static final TypeArg<RedisTransaction> __TYPE_ARG = new TypeArg(obj -> new RedisTransaction((io.vertx.redis.RedisTransaction)obj), RedisTransaction::getDelegate);
    private final io.vertx.redis.RedisTransaction delegate;

    public RedisTransaction(io.vertx.redis.RedisTransaction delegate) {
        this.delegate = delegate;
    }

    RedisTransaction() {
        this.delegate = null;
    }

    public io.vertx.redis.RedisTransaction getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisTransaction that = (RedisTransaction)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private RedisTransaction __append(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    public Uni<String> append(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__append(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String appendAndAwait(String key, String value) {
        return (String)this.append(key, value).await().indefinitely();
    }

    private RedisTransaction __auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    public Uni<String> auth(String password) {
        return AsyncResultUni.toUni(handler -> this.__auth(password, (Handler<AsyncResult<String>>)handler));
    }

    public String authAndAwait(String password) {
        return (String)this.auth(password).await().indefinitely();
    }

    private RedisTransaction __bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    public Uni<String> bgrewriteaof() {
        return AsyncResultUni.toUni(handler -> this.__bgrewriteaof((Handler<AsyncResult<String>>)handler));
    }

    public String bgrewriteaofAndAwait() {
        return (String)this.bgrewriteaof().await().indefinitely();
    }

    private RedisTransaction __bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    public Uni<String> bgsave() {
        return AsyncResultUni.toUni(handler -> this.__bgsave((Handler<AsyncResult<String>>)handler));
    }

    public String bgsaveAndAwait() {
        return (String)this.bgsave().await().indefinitely();
    }

    private RedisTransaction __bitcount(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    public Uni<String> bitcount(String key) {
        return AsyncResultUni.toUni(handler -> this.__bitcount(key, (Handler<AsyncResult<String>>)handler));
    }

    public String bitcountAndAwait(String key) {
        return (String)this.bitcount(key).await().indefinitely();
    }

    private RedisTransaction __bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    public Uni<String> bitcountRange(String key, long start, long end) {
        return AsyncResultUni.toUni(handler -> this.__bitcountRange(key, start, end, (Handler<AsyncResult<String>>)handler));
    }

    public String bitcountRangeAndAwait(String key, long start, long end) {
        return (String)this.bitcountRange(key, start, end).await().indefinitely();
    }

    private RedisTransaction __bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    public Uni<String> bitop(BitOperation operation, String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__bitop(operation, destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public String bitopAndAwait(BitOperation operation, String destkey, List<String> keys) {
        return (String)this.bitop(operation, destkey, keys).await().indefinitely();
    }

    private RedisTransaction __bitpos(String key, int bit, Handler<AsyncResult<String>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    public Uni<String> bitpos(String key, int bit) {
        return AsyncResultUni.toUni(handler -> this.__bitpos(key, bit, (Handler<AsyncResult<String>>)handler));
    }

    public String bitposAndAwait(String key, int bit) {
        return (String)this.bitpos(key, bit).await().indefinitely();
    }

    private RedisTransaction __bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    public Uni<String> bitposFrom(String key, int bit, int start) {
        return AsyncResultUni.toUni(handler -> this.__bitposFrom(key, bit, start, (Handler<AsyncResult<String>>)handler));
    }

    public String bitposFromAndAwait(String key, int bit, int start) {
        return (String)this.bitposFrom(key, bit, start).await().indefinitely();
    }

    private RedisTransaction __bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    public Uni<String> bitposRange(String key, int bit, int start, int stop) {
        return AsyncResultUni.toUni(handler -> this.__bitposRange(key, bit, start, stop, (Handler<AsyncResult<String>>)handler));
    }

    public String bitposRangeAndAwait(String key, int bit, int start, int stop) {
        return (String)this.bitposRange(key, bit, start, stop).await().indefinitely();
    }

    private RedisTransaction __blpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    public Uni<String> blpop(String key, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__blpop(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String blpopAndAwait(String key, int seconds) {
        return (String)this.blpop(key, seconds).await().indefinitely();
    }

    private RedisTransaction __blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    public Uni<String> blpopMany(List<String> keys, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__blpopMany(keys, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String blpopManyAndAwait(List<String> keys, int seconds) {
        return (String)this.blpopMany(keys, seconds).await().indefinitely();
    }

    private RedisTransaction __brpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    public Uni<String> brpop(String key, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__brpop(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String brpopAndAwait(String key, int seconds) {
        return (String)this.brpop(key, seconds).await().indefinitely();
    }

    private RedisTransaction __brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    public Uni<String> brpopMany(List<String> keys, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__brpopMany(keys, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String brpopManyAndAwait(List<String> keys, int seconds) {
        return (String)this.brpopMany(keys, seconds).await().indefinitely();
    }

    private RedisTransaction __brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    public Uni<String> brpoplpush(String key, String destkey, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String brpoplpushAndAwait(String key, String destkey, int seconds) {
        return (String)this.brpoplpush(key, destkey, seconds).await().indefinitely();
    }

    private RedisTransaction __clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    public Uni<String> clientKill(KillFilter filter) {
        return AsyncResultUni.toUni(handler -> this.__clientKill(filter, (Handler<AsyncResult<String>>)handler));
    }

    public String clientKillAndAwait(KillFilter filter) {
        return (String)this.clientKill(filter).await().indefinitely();
    }

    private RedisTransaction __clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    public Uni<String> clientList() {
        return AsyncResultUni.toUni(handler -> this.__clientList((Handler<AsyncResult<String>>)handler));
    }

    public String clientListAndAwait() {
        return (String)this.clientList().await().indefinitely();
    }

    private RedisTransaction __clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    public Uni<String> clientGetname() {
        return AsyncResultUni.toUni(handler -> this.__clientGetname((Handler<AsyncResult<String>>)handler));
    }

    public String clientGetnameAndAwait() {
        return (String)this.clientGetname().await().indefinitely();
    }

    private RedisTransaction __clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    public Uni<String> clientPause(long millis) {
        return AsyncResultUni.toUni(handler -> this.__clientPause(millis, (Handler<AsyncResult<String>>)handler));
    }

    public String clientPauseAndAwait(long millis) {
        return (String)this.clientPause(millis).await().indefinitely();
    }

    private RedisTransaction __clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    public Uni<String> clientSetname(String name) {
        return AsyncResultUni.toUni(handler -> this.__clientSetname(name, (Handler<AsyncResult<String>>)handler));
    }

    public String clientSetnameAndAwait(String name) {
        return (String)this.clientSetname(name).await().indefinitely();
    }

    private RedisTransaction __clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    public Uni<String> clusterAddslots(List<String> slots) {
        return AsyncResultUni.toUni(handler -> this.__clusterAddslots(slots, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterAddslotsAndAwait(List<String> slots) {
        return (String)this.clusterAddslots(slots).await().indefinitely();
    }

    private RedisTransaction __clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    public Uni<String> clusterCountFailureReports(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterCountFailureReports(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterCountFailureReportsAndAwait(String nodeId) {
        return (String)this.clusterCountFailureReports(nodeId).await().indefinitely();
    }

    private RedisTransaction __clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    public Uni<String> clusterCountkeysinslot(long slot) {
        return AsyncResultUni.toUni(handler -> this.__clusterCountkeysinslot(slot, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterCountkeysinslotAndAwait(long slot) {
        return (String)this.clusterCountkeysinslot(slot).await().indefinitely();
    }

    private RedisTransaction __clusterDelslots(long slot, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    public Uni<String> clusterDelslots(long slot) {
        return AsyncResultUni.toUni(handler -> this.__clusterDelslots(slot, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterDelslotsAndAwait(long slot) {
        return (String)this.clusterDelslots(slot).await().indefinitely();
    }

    private RedisTransaction __clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    public Uni<String> clusterDelslotsMany(List<String> slots) {
        return AsyncResultUni.toUni(handler -> this.__clusterDelslotsMany(slots, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterDelslotsManyAndAwait(List<String> slots) {
        return (String)this.clusterDelslotsMany(slots).await().indefinitely();
    }

    private RedisTransaction __clusterFailover(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    public Uni<String> clusterFailover() {
        return AsyncResultUni.toUni(handler -> this.__clusterFailover((Handler<AsyncResult<String>>)handler));
    }

    public String clusterFailoverAndAwait() {
        return (String)this.clusterFailover().await().indefinitely();
    }

    private RedisTransaction __clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    public Uni<String> clusterFailOverWithOptions(FailoverOptions options) {
        return AsyncResultUni.toUni(handler -> this.__clusterFailOverWithOptions(options, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterFailOverWithOptionsAndAwait(FailoverOptions options) {
        return (String)this.clusterFailOverWithOptions(options).await().indefinitely();
    }

    private RedisTransaction __clusterForget(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    public Uni<String> clusterForget(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterForget(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterForgetAndAwait(String nodeId) {
        return (String)this.clusterForget(nodeId).await().indefinitely();
    }

    private RedisTransaction __clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    public Uni<String> clusterGetkeysinslot(long slot, long count) {
        return AsyncResultUni.toUni(handler -> this.__clusterGetkeysinslot(slot, count, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterGetkeysinslotAndAwait(long slot, long count) {
        return (String)this.clusterGetkeysinslot(slot, count).await().indefinitely();
    }

    private RedisTransaction __clusterInfo(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    public Uni<String> clusterInfo() {
        return AsyncResultUni.toUni(handler -> this.__clusterInfo((Handler<AsyncResult<String>>)handler));
    }

    public String clusterInfoAndAwait() {
        return (String)this.clusterInfo().await().indefinitely();
    }

    private RedisTransaction __clusterKeyslot(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    public Uni<String> clusterKeyslot(String key) {
        return AsyncResultUni.toUni(handler -> this.__clusterKeyslot(key, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterKeyslotAndAwait(String key) {
        return (String)this.clusterKeyslot(key).await().indefinitely();
    }

    private RedisTransaction __clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    public Uni<String> clusterMeet(String ip, long port) {
        return AsyncResultUni.toUni(handler -> this.__clusterMeet(ip, port, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterMeetAndAwait(String ip, long port) {
        return (String)this.clusterMeet(ip, port).await().indefinitely();
    }

    private RedisTransaction __clusterNodes(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    public Uni<String> clusterNodes() {
        return AsyncResultUni.toUni(handler -> this.__clusterNodes((Handler<AsyncResult<String>>)handler));
    }

    public String clusterNodesAndAwait() {
        return (String)this.clusterNodes().await().indefinitely();
    }

    private RedisTransaction __clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    public Uni<String> clusterReplicate(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterReplicate(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterReplicateAndAwait(String nodeId) {
        return (String)this.clusterReplicate(nodeId).await().indefinitely();
    }

    private RedisTransaction __clusterReset(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    public Uni<String> clusterReset() {
        return AsyncResultUni.toUni(handler -> this.__clusterReset((Handler<AsyncResult<String>>)handler));
    }

    public String clusterResetAndAwait() {
        return (String)this.clusterReset().await().indefinitely();
    }

    private RedisTransaction __clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    public Uni<String> clusterResetWithOptions(ResetOptions options) {
        return AsyncResultUni.toUni(handler -> this.__clusterResetWithOptions(options, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterResetWithOptionsAndAwait(ResetOptions options) {
        return (String)this.clusterResetWithOptions(options).await().indefinitely();
    }

    private RedisTransaction __clusterSaveconfig(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    public Uni<String> clusterSaveconfig() {
        return AsyncResultUni.toUni(handler -> this.__clusterSaveconfig((Handler<AsyncResult<String>>)handler));
    }

    public String clusterSaveconfigAndAwait() {
        return (String)this.clusterSaveconfig().await().indefinitely();
    }

    private RedisTransaction __clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    public Uni<String> clusterSetConfigEpoch(long epoch) {
        return AsyncResultUni.toUni(handler -> this.__clusterSetConfigEpoch(epoch, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterSetConfigEpochAndAwait(long epoch) {
        return (String)this.clusterSetConfigEpoch(epoch).await().indefinitely();
    }

    private RedisTransaction __clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    public Uni<String> clusterSetslot(long slot, SlotCmd subcommand) {
        return AsyncResultUni.toUni(handler -> this.__clusterSetslot(slot, subcommand, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterSetslotAndAwait(long slot, SlotCmd subcommand) {
        return (String)this.clusterSetslot(slot, subcommand).await().indefinitely();
    }

    private RedisTransaction __clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    public Uni<String> clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterSetslotWithNodeAndAwait(long slot, SlotCmd subcommand, String nodeId) {
        return (String)this.clusterSetslotWithNode(slot, subcommand, nodeId).await().indefinitely();
    }

    private RedisTransaction __clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    public Uni<String> clusterSlaves(String nodeId) {
        return AsyncResultUni.toUni(handler -> this.__clusterSlaves(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public String clusterSlavesAndAwait(String nodeId) {
        return (String)this.clusterSlaves(nodeId).await().indefinitely();
    }

    private RedisTransaction __clusterSlots(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    public Uni<String> clusterSlots() {
        return AsyncResultUni.toUni(handler -> this.__clusterSlots((Handler<AsyncResult<String>>)handler));
    }

    public String clusterSlotsAndAwait() {
        return (String)this.clusterSlots().await().indefinitely();
    }

    private RedisTransaction __command(Handler<AsyncResult<String>> handler) {
        this.delegate.command(handler);
        return this;
    }

    public Uni<String> command() {
        return AsyncResultUni.toUni(handler -> this.__command((Handler<AsyncResult<String>>)handler));
    }

    public String commandAndAwait() {
        return (String)this.command().await().indefinitely();
    }

    private RedisTransaction __commandCount(Handler<AsyncResult<String>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    public Uni<String> commandCount() {
        return AsyncResultUni.toUni(handler -> this.__commandCount((Handler<AsyncResult<String>>)handler));
    }

    public String commandCountAndAwait() {
        return (String)this.commandCount().await().indefinitely();
    }

    private RedisTransaction __commandGetkeys(Handler<AsyncResult<String>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    public Uni<String> commandGetkeys() {
        return AsyncResultUni.toUni(handler -> this.__commandGetkeys((Handler<AsyncResult<String>>)handler));
    }

    public String commandGetkeysAndAwait() {
        return (String)this.commandGetkeys().await().indefinitely();
    }

    private RedisTransaction __commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    public Uni<String> commandInfo(List<String> commands) {
        return AsyncResultUni.toUni(handler -> this.__commandInfo(commands, (Handler<AsyncResult<String>>)handler));
    }

    public String commandInfoAndAwait(List<String> commands) {
        return (String)this.commandInfo(commands).await().indefinitely();
    }

    private RedisTransaction __configGet(String parameter, Handler<AsyncResult<String>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    public Uni<String> configGet(String parameter) {
        return AsyncResultUni.toUni(handler -> this.__configGet(parameter, (Handler<AsyncResult<String>>)handler));
    }

    public String configGetAndAwait(String parameter) {
        return (String)this.configGet(parameter).await().indefinitely();
    }

    private RedisTransaction __configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    public Uni<String> configRewrite() {
        return AsyncResultUni.toUni(handler -> this.__configRewrite((Handler<AsyncResult<String>>)handler));
    }

    public String configRewriteAndAwait() {
        return (String)this.configRewrite().await().indefinitely();
    }

    private RedisTransaction __configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    public Uni<String> configSet(String parameter, String value) {
        return AsyncResultUni.toUni(handler -> this.__configSet(parameter, value, (Handler<AsyncResult<String>>)handler));
    }

    public String configSetAndAwait(String parameter, String value) {
        return (String)this.configSet(parameter, value).await().indefinitely();
    }

    private RedisTransaction __configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    public Uni<String> configResetstat() {
        return AsyncResultUni.toUni(handler -> this.__configResetstat((Handler<AsyncResult<String>>)handler));
    }

    public String configResetstatAndAwait() {
        return (String)this.configResetstat().await().indefinitely();
    }

    private RedisTransaction __dbsize(Handler<AsyncResult<String>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    public Uni<String> dbsize() {
        return AsyncResultUni.toUni(handler -> this.__dbsize((Handler<AsyncResult<String>>)handler));
    }

    public String dbsizeAndAwait() {
        return (String)this.dbsize().await().indefinitely();
    }

    private RedisTransaction __debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    public Uni<String> debugObject(String key) {
        return AsyncResultUni.toUni(handler -> this.__debugObject(key, (Handler<AsyncResult<String>>)handler));
    }

    public String debugObjectAndAwait(String key) {
        return (String)this.debugObject(key).await().indefinitely();
    }

    private RedisTransaction __debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    public Uni<String> debugSegfault() {
        return AsyncResultUni.toUni(handler -> this.__debugSegfault((Handler<AsyncResult<String>>)handler));
    }

    public String debugSegfaultAndAwait() {
        return (String)this.debugSegfault().await().indefinitely();
    }

    private RedisTransaction __decr(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    public Uni<String> decr(String key) {
        return AsyncResultUni.toUni(handler -> this.__decr(key, (Handler<AsyncResult<String>>)handler));
    }

    public String decrAndAwait(String key) {
        return (String)this.decr(key).await().indefinitely();
    }

    private RedisTransaction __decrby(String key, long decrement, Handler<AsyncResult<String>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    public Uni<String> decrby(String key, long decrement) {
        return AsyncResultUni.toUni(handler -> this.__decrby(key, decrement, (Handler<AsyncResult<String>>)handler));
    }

    public String decrbyAndAwait(String key, long decrement) {
        return (String)this.decrby(key, decrement).await().indefinitely();
    }

    private RedisTransaction __del(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    public Uni<String> del(String key) {
        return AsyncResultUni.toUni(handler -> this.__del(key, (Handler<AsyncResult<String>>)handler));
    }

    public String delAndAwait(String key) {
        return (String)this.del(key).await().indefinitely();
    }

    private RedisTransaction __delMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    public Uni<String> delMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__delMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String delManyAndAwait(List<String> keys) {
        return (String)this.delMany(keys).await().indefinitely();
    }

    private RedisTransaction __discard(Handler<AsyncResult<String>> handler) {
        this.delegate.discard(handler);
        return this;
    }

    public Uni<String> discard() {
        return AsyncResultUni.toUni(handler -> this.__discard((Handler<AsyncResult<String>>)handler));
    }

    public String discardAndAwait() {
        return (String)this.discard().await().indefinitely();
    }

    private RedisTransaction __dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    public Uni<String> dump(String key) {
        return AsyncResultUni.toUni(handler -> this.__dump(key, (Handler<AsyncResult<String>>)handler));
    }

    public String dumpAndAwait(String key) {
        return (String)this.dump(key).await().indefinitely();
    }

    private RedisTransaction __echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    public Uni<String> echo(String message) {
        return AsyncResultUni.toUni(handler -> this.__echo(message, (Handler<AsyncResult<String>>)handler));
    }

    public String echoAndAwait(String message) {
        return (String)this.echo(message).await().indefinitely();
    }

    private RedisTransaction __eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    public Uni<String> eval(String script, List<String> keys, List<String> args) {
        return AsyncResultUni.toUni(handler -> this.__eval(script, keys, args, (Handler<AsyncResult<String>>)handler));
    }

    public String evalAndAwait(String script, List<String> keys, List<String> args) {
        return (String)this.eval(script, keys, args).await().indefinitely();
    }

    private RedisTransaction __evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    public Uni<String> evalsha(String sha1, List<String> keys, List<String> values) {
        return AsyncResultUni.toUni(handler -> this.__evalsha(sha1, keys, values, (Handler<AsyncResult<String>>)handler));
    }

    public String evalshaAndAwait(String sha1, List<String> keys, List<String> values) {
        return (String)this.evalsha(sha1, keys, values).await().indefinitely();
    }

    private RedisTransaction __exec(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.exec(handler);
        return this;
    }

    public Uni<JsonArray> exec() {
        return AsyncResultUni.toUni(handler -> this.__exec((Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray execAndAwait() {
        return (JsonArray)this.exec().await().indefinitely();
    }

    private RedisTransaction __exists(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    public Uni<String> exists(String key) {
        return AsyncResultUni.toUni(handler -> this.__exists(key, (Handler<AsyncResult<String>>)handler));
    }

    public String existsAndAwait(String key) {
        return (String)this.exists(key).await().indefinitely();
    }

    private RedisTransaction __existsMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.existsMany(keys, handler);
        return this;
    }

    public Uni<String> existsMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__existsMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String existsManyAndAwait(List<String> keys) {
        return (String)this.existsMany(keys).await().indefinitely();
    }

    private RedisTransaction __expire(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    public Uni<String> expire(String key, int seconds) {
        return AsyncResultUni.toUni(handler -> this.__expire(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String expireAndAwait(String key, int seconds) {
        return (String)this.expire(key, seconds).await().indefinitely();
    }

    private RedisTransaction __expireat(String key, long seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    public Uni<String> expireat(String key, long seconds) {
        return AsyncResultUni.toUni(handler -> this.__expireat(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public String expireatAndAwait(String key, long seconds) {
        return (String)this.expireat(key, seconds).await().indefinitely();
    }

    private RedisTransaction __flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    public Uni<String> flushall() {
        return AsyncResultUni.toUni(handler -> this.__flushall((Handler<AsyncResult<String>>)handler));
    }

    public String flushallAndAwait() {
        return (String)this.flushall().await().indefinitely();
    }

    private RedisTransaction __flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    public Uni<String> flushdb() {
        return AsyncResultUni.toUni(handler -> this.__flushdb((Handler<AsyncResult<String>>)handler));
    }

    public String flushdbAndAwait() {
        return (String)this.flushdb().await().indefinitely();
    }

    private RedisTransaction __get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    public Uni<String> get(String key) {
        return AsyncResultUni.toUni(handler -> this.__get(key, (Handler<AsyncResult<String>>)handler));
    }

    public String getAndAwait(String key) {
        return (String)this.get(key).await().indefinitely();
    }

    private RedisTransaction __getBinary(String key, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.getBinary(key, (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)((io.vertx.core.buffer.Buffer)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<Buffer> getBinary(String key) {
        return AsyncResultUni.toUni(handler -> this.__getBinary(key, (Handler<AsyncResult<Buffer>>)handler));
    }

    public Buffer getBinaryAndAwait(String key) {
        return (Buffer)this.getBinary(key).await().indefinitely();
    }

    private RedisTransaction __getbit(String key, long offset, Handler<AsyncResult<String>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    public Uni<String> getbit(String key, long offset) {
        return AsyncResultUni.toUni(handler -> this.__getbit(key, offset, (Handler<AsyncResult<String>>)handler));
    }

    public String getbitAndAwait(String key, long offset) {
        return (String)this.getbit(key, offset).await().indefinitely();
    }

    private RedisTransaction __getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    public Uni<String> getrange(String key, long start, long end) {
        return AsyncResultUni.toUni(handler -> this.__getrange(key, start, end, (Handler<AsyncResult<String>>)handler));
    }

    public String getrangeAndAwait(String key, long start, long end) {
        return (String)this.getrange(key, start, end).await().indefinitely();
    }

    private RedisTransaction __getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    public Uni<String> getset(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__getset(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String getsetAndAwait(String key, String value) {
        return (String)this.getset(key, value).await().indefinitely();
    }

    private RedisTransaction __hdel(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    public Uni<String> hdel(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hdel(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public String hdelAndAwait(String key, String field) {
        return (String)this.hdel(key, field).await().indefinitely();
    }

    private RedisTransaction __hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    public Uni<String> hdelMany(String key, List<String> fields) {
        return AsyncResultUni.toUni(handler -> this.__hdelMany(key, fields, (Handler<AsyncResult<String>>)handler));
    }

    public String hdelManyAndAwait(String key, List<String> fields) {
        return (String)this.hdelMany(key, fields).await().indefinitely();
    }

    private RedisTransaction __hexists(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    public Uni<String> hexists(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hexists(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public String hexistsAndAwait(String key, String field) {
        return (String)this.hexists(key, field).await().indefinitely();
    }

    private RedisTransaction __hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    public Uni<String> hget(String key, String field) {
        return AsyncResultUni.toUni(handler -> this.__hget(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public String hgetAndAwait(String key, String field) {
        return (String)this.hget(key, field).await().indefinitely();
    }

    private RedisTransaction __hgetall(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    public Uni<String> hgetall(String key) {
        return AsyncResultUni.toUni(handler -> this.__hgetall(key, (Handler<AsyncResult<String>>)handler));
    }

    public String hgetallAndAwait(String key) {
        return (String)this.hgetall(key).await().indefinitely();
    }

    private RedisTransaction __hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    public Uni<String> hincrby(String key, String field, long increment) {
        return AsyncResultUni.toUni(handler -> this.__hincrby(key, field, increment, (Handler<AsyncResult<String>>)handler));
    }

    public String hincrbyAndAwait(String key, String field, long increment) {
        return (String)this.hincrby(key, field, increment).await().indefinitely();
    }

    private RedisTransaction __hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    public Uni<String> hincrbyfloat(String key, String field, double increment) {
        return AsyncResultUni.toUni(handler -> this.__hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler));
    }

    public String hincrbyfloatAndAwait(String key, String field, double increment) {
        return (String)this.hincrbyfloat(key, field, increment).await().indefinitely();
    }

    private RedisTransaction __hkeys(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    public Uni<String> hkeys(String key) {
        return AsyncResultUni.toUni(handler -> this.__hkeys(key, (Handler<AsyncResult<String>>)handler));
    }

    public String hkeysAndAwait(String key) {
        return (String)this.hkeys(key).await().indefinitely();
    }

    private RedisTransaction __hlen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    public Uni<String> hlen(String key) {
        return AsyncResultUni.toUni(handler -> this.__hlen(key, (Handler<AsyncResult<String>>)handler));
    }

    public String hlenAndAwait(String key) {
        return (String)this.hlen(key).await().indefinitely();
    }

    private RedisTransaction __hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    public Uni<String> hmget(String key, List<String> fields) {
        return AsyncResultUni.toUni(handler -> this.__hmget(key, fields, (Handler<AsyncResult<String>>)handler));
    }

    public String hmgetAndAwait(String key, List<String> fields) {
        return (String)this.hmget(key, fields).await().indefinitely();
    }

    private RedisTransaction __hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    public Uni<String> hmset(String key, JsonObject values) {
        return AsyncResultUni.toUni(handler -> this.__hmset(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public String hmsetAndAwait(String key, JsonObject values) {
        return (String)this.hmset(key, values).await().indefinitely();
    }

    private RedisTransaction __hset(String key, String field, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    public Uni<String> hset(String key, String field, String value) {
        return AsyncResultUni.toUni(handler -> this.__hset(key, field, value, (Handler<AsyncResult<String>>)handler));
    }

    public String hsetAndAwait(String key, String field, String value) {
        return (String)this.hset(key, field, value).await().indefinitely();
    }

    private RedisTransaction __hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    public Uni<String> hsetnx(String key, String field, String value) {
        return AsyncResultUni.toUni(handler -> this.__hsetnx(key, field, value, (Handler<AsyncResult<String>>)handler));
    }

    public String hsetnxAndAwait(String key, String field, String value) {
        return (String)this.hsetnx(key, field, value).await().indefinitely();
    }

    private RedisTransaction __hvals(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    public Uni<String> hvals(String key) {
        return AsyncResultUni.toUni(handler -> this.__hvals(key, (Handler<AsyncResult<String>>)handler));
    }

    public String hvalsAndAwait(String key) {
        return (String)this.hvals(key).await().indefinitely();
    }

    private RedisTransaction __incr(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    public Uni<String> incr(String key) {
        return AsyncResultUni.toUni(handler -> this.__incr(key, (Handler<AsyncResult<String>>)handler));
    }

    public String incrAndAwait(String key) {
        return (String)this.incr(key).await().indefinitely();
    }

    private RedisTransaction __incrby(String key, long increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    public Uni<String> incrby(String key, long increment) {
        return AsyncResultUni.toUni(handler -> this.__incrby(key, increment, (Handler<AsyncResult<String>>)handler));
    }

    public String incrbyAndAwait(String key, long increment) {
        return (String)this.incrby(key, increment).await().indefinitely();
    }

    private RedisTransaction __incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    public Uni<String> incrbyfloat(String key, double increment) {
        return AsyncResultUni.toUni(handler -> this.__incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler));
    }

    public String incrbyfloatAndAwait(String key, double increment) {
        return (String)this.incrbyfloat(key, increment).await().indefinitely();
    }

    private RedisTransaction __info(Handler<AsyncResult<String>> handler) {
        this.delegate.info(handler);
        return this;
    }

    public Uni<String> info() {
        return AsyncResultUni.toUni(handler -> this.__info((Handler<AsyncResult<String>>)handler));
    }

    public String infoAndAwait() {
        return (String)this.info().await().indefinitely();
    }

    private RedisTransaction __infoSection(String section, Handler<AsyncResult<String>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    public Uni<String> infoSection(String section) {
        return AsyncResultUni.toUni(handler -> this.__infoSection(section, (Handler<AsyncResult<String>>)handler));
    }

    public String infoSectionAndAwait(String section) {
        return (String)this.infoSection(section).await().indefinitely();
    }

    private RedisTransaction __keys(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    public Uni<String> keys(String pattern) {
        return AsyncResultUni.toUni(handler -> this.__keys(pattern, (Handler<AsyncResult<String>>)handler));
    }

    public String keysAndAwait(String pattern) {
        return (String)this.keys(pattern).await().indefinitely();
    }

    private RedisTransaction __lastsave(Handler<AsyncResult<String>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    public Uni<String> lastsave() {
        return AsyncResultUni.toUni(handler -> this.__lastsave((Handler<AsyncResult<String>>)handler));
    }

    public String lastsaveAndAwait() {
        return (String)this.lastsave().await().indefinitely();
    }

    private RedisTransaction __lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    public Uni<String> lindex(String key, int index) {
        return AsyncResultUni.toUni(handler -> this.__lindex(key, index, (Handler<AsyncResult<String>>)handler));
    }

    public String lindexAndAwait(String key, int index) {
        return (String)this.lindex(key, index).await().indefinitely();
    }

    private RedisTransaction __linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    public Uni<String> linsert(String key, InsertOptions option, String pivot, String value) {
        return AsyncResultUni.toUni(handler -> this.__linsert(key, option, pivot, value, (Handler<AsyncResult<String>>)handler));
    }

    public String linsertAndAwait(String key, InsertOptions option, String pivot, String value) {
        return (String)this.linsert(key, option, pivot, value).await().indefinitely();
    }

    private RedisTransaction __llen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    public Uni<String> llen(String key) {
        return AsyncResultUni.toUni(handler -> this.__llen(key, (Handler<AsyncResult<String>>)handler));
    }

    public String llenAndAwait(String key) {
        return (String)this.llen(key).await().indefinitely();
    }

    private RedisTransaction __lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    public Uni<String> lpop(String key) {
        return AsyncResultUni.toUni(handler -> this.__lpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public String lpopAndAwait(String key) {
        return (String)this.lpop(key).await().indefinitely();
    }

    private RedisTransaction __lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    public Uni<String> lpushMany(String key, List<String> values) {
        return AsyncResultUni.toUni(handler -> this.__lpushMany(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public String lpushManyAndAwait(String key, List<String> values) {
        return (String)this.lpushMany(key, values).await().indefinitely();
    }

    private RedisTransaction __lpush(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    public Uni<String> lpush(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__lpush(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String lpushAndAwait(String key, String value) {
        return (String)this.lpush(key, value).await().indefinitely();
    }

    private RedisTransaction __lpushx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    public Uni<String> lpushx(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__lpushx(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String lpushxAndAwait(String key, String value) {
        return (String)this.lpushx(key, value).await().indefinitely();
    }

    private RedisTransaction __lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    public Uni<String> lrange(String key, long from, long to) {
        return AsyncResultUni.toUni(handler -> this.__lrange(key, from, to, (Handler<AsyncResult<String>>)handler));
    }

    public String lrangeAndAwait(String key, long from, long to) {
        return (String)this.lrange(key, from, to).await().indefinitely();
    }

    private RedisTransaction __lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    public Uni<String> lrem(String key, long count, String value) {
        return AsyncResultUni.toUni(handler -> this.__lrem(key, count, value, (Handler<AsyncResult<String>>)handler));
    }

    public String lremAndAwait(String key, long count, String value) {
        return (String)this.lrem(key, count, value).await().indefinitely();
    }

    private RedisTransaction __lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    public Uni<String> lset(String key, long index, String value) {
        return AsyncResultUni.toUni(handler -> this.__lset(key, index, value, (Handler<AsyncResult<String>>)handler));
    }

    public String lsetAndAwait(String key, long index, String value) {
        return (String)this.lset(key, index, value).await().indefinitely();
    }

    private RedisTransaction __ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    public Uni<String> ltrim(String key, long from, long to) {
        return AsyncResultUni.toUni(handler -> this.__ltrim(key, from, to, (Handler<AsyncResult<String>>)handler));
    }

    public String ltrimAndAwait(String key, long from, long to) {
        return (String)this.ltrim(key, from, to).await().indefinitely();
    }

    private RedisTransaction __mget(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    public Uni<String> mget(String key) {
        return AsyncResultUni.toUni(handler -> this.__mget(key, (Handler<AsyncResult<String>>)handler));
    }

    public String mgetAndAwait(String key) {
        return (String)this.mget(key).await().indefinitely();
    }

    private RedisTransaction __mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    public Uni<String> mgetMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__mgetMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String mgetManyAndAwait(List<String> keys) {
        return (String)this.mgetMany(keys).await().indefinitely();
    }

    private RedisTransaction __migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    public Uni<String> migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler));
    }

    public String migrateAndAwait(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return (String)this.migrate(host, port, key, destdb, timeout, options).await().indefinitely();
    }

    private RedisTransaction __monitor(Handler<AsyncResult<String>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    public Uni<String> monitor() {
        return AsyncResultUni.toUni(handler -> this.__monitor((Handler<AsyncResult<String>>)handler));
    }

    public String monitorAndAwait() {
        return (String)this.monitor().await().indefinitely();
    }

    private RedisTransaction __move(String key, int destdb, Handler<AsyncResult<String>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    public Uni<String> move(String key, int destdb) {
        return AsyncResultUni.toUni(handler -> this.__move(key, destdb, (Handler<AsyncResult<String>>)handler));
    }

    public String moveAndAwait(String key, int destdb) {
        return (String)this.move(key, destdb).await().indefinitely();
    }

    private RedisTransaction __mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    public Uni<String> mset(JsonObject keyvals) {
        return AsyncResultUni.toUni(handler -> this.__mset(keyvals, (Handler<AsyncResult<String>>)handler));
    }

    public String msetAndAwait(JsonObject keyvals) {
        return (String)this.mset(keyvals).await().indefinitely();
    }

    private RedisTransaction __msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    public Uni<String> msetnx(JsonObject keyvals) {
        return AsyncResultUni.toUni(handler -> this.__msetnx(keyvals, (Handler<AsyncResult<String>>)handler));
    }

    public String msetnxAndAwait(JsonObject keyvals) {
        return (String)this.msetnx(keyvals).await().indefinitely();
    }

    private RedisTransaction __multi(Handler<AsyncResult<String>> handler) {
        this.delegate.multi(handler);
        return this;
    }

    public Uni<String> multi() {
        return AsyncResultUni.toUni(handler -> this.__multi((Handler<AsyncResult<String>>)handler));
    }

    public String multiAndAwait() {
        return (String)this.multi().await().indefinitely();
    }

    private RedisTransaction __object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    public Uni<String> object(String key, ObjectCmd cmd) {
        return AsyncResultUni.toUni(handler -> this.__object(key, cmd, (Handler<AsyncResult<String>>)handler));
    }

    public String objectAndAwait(String key, ObjectCmd cmd) {
        return (String)this.object(key, cmd).await().indefinitely();
    }

    private RedisTransaction __persist(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    public Uni<String> persist(String key) {
        return AsyncResultUni.toUni(handler -> this.__persist(key, (Handler<AsyncResult<String>>)handler));
    }

    public String persistAndAwait(String key) {
        return (String)this.persist(key).await().indefinitely();
    }

    private RedisTransaction __pexpire(String key, long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    public Uni<String> pexpire(String key, long millis) {
        return AsyncResultUni.toUni(handler -> this.__pexpire(key, millis, (Handler<AsyncResult<String>>)handler));
    }

    public String pexpireAndAwait(String key, long millis) {
        return (String)this.pexpire(key, millis).await().indefinitely();
    }

    private RedisTransaction __pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    public Uni<String> pexpireat(String key, long millis) {
        return AsyncResultUni.toUni(handler -> this.__pexpireat(key, millis, (Handler<AsyncResult<String>>)handler));
    }

    public String pexpireatAndAwait(String key, long millis) {
        return (String)this.pexpireat(key, millis).await().indefinitely();
    }

    private RedisTransaction __pfadd(String key, String element, Handler<AsyncResult<String>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    public Uni<String> pfadd(String key, String element) {
        return AsyncResultUni.toUni(handler -> this.__pfadd(key, element, (Handler<AsyncResult<String>>)handler));
    }

    public String pfaddAndAwait(String key, String element) {
        return (String)this.pfadd(key, element).await().indefinitely();
    }

    private RedisTransaction __pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    public Uni<String> pfaddMany(String key, List<String> elements) {
        return AsyncResultUni.toUni(handler -> this.__pfaddMany(key, elements, (Handler<AsyncResult<String>>)handler));
    }

    public String pfaddManyAndAwait(String key, List<String> elements) {
        return (String)this.pfaddMany(key, elements).await().indefinitely();
    }

    private RedisTransaction __pfcount(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    public Uni<String> pfcount(String key) {
        return AsyncResultUni.toUni(handler -> this.__pfcount(key, (Handler<AsyncResult<String>>)handler));
    }

    public String pfcountAndAwait(String key) {
        return (String)this.pfcount(key).await().indefinitely();
    }

    private RedisTransaction __pfcountMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    public Uni<String> pfcountMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__pfcountMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String pfcountManyAndAwait(List<String> keys) {
        return (String)this.pfcountMany(keys).await().indefinitely();
    }

    private RedisTransaction __pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    public Uni<String> pfmerge(String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public String pfmergeAndAwait(String destkey, List<String> keys) {
        return (String)this.pfmerge(destkey, keys).await().indefinitely();
    }

    private RedisTransaction __ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public Uni<String> ping() {
        return AsyncResultUni.toUni(handler -> this.__ping((Handler<AsyncResult<String>>)handler));
    }

    public String pingAndAwait() {
        return (String)this.ping().await().indefinitely();
    }

    private RedisTransaction __psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    public Uni<String> psetex(String key, long millis, String value) {
        return AsyncResultUni.toUni(handler -> this.__psetex(key, millis, value, (Handler<AsyncResult<String>>)handler));
    }

    public String psetexAndAwait(String key, long millis, String value) {
        return (String)this.psetex(key, millis, value).await().indefinitely();
    }

    private RedisTransaction __psubscribe(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    public Uni<String> psubscribe(String pattern) {
        return AsyncResultUni.toUni(handler -> this.__psubscribe(pattern, (Handler<AsyncResult<String>>)handler));
    }

    public String psubscribeAndAwait(String pattern) {
        return (String)this.psubscribe(pattern).await().indefinitely();
    }

    private RedisTransaction __psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    public Uni<String> psubscribeMany(List<String> patterns) {
        return AsyncResultUni.toUni(handler -> this.__psubscribeMany(patterns, (Handler<AsyncResult<String>>)handler));
    }

    public String psubscribeManyAndAwait(List<String> patterns) {
        return (String)this.psubscribeMany(patterns).await().indefinitely();
    }

    private RedisTransaction __pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    public Uni<String> pubsubChannels(String pattern) {
        return AsyncResultUni.toUni(handler -> this.__pubsubChannels(pattern, (Handler<AsyncResult<String>>)handler));
    }

    public String pubsubChannelsAndAwait(String pattern) {
        return (String)this.pubsubChannels(pattern).await().indefinitely();
    }

    private RedisTransaction __pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    public Uni<String> pubsubNumsub(List<String> channels) {
        return AsyncResultUni.toUni(handler -> this.__pubsubNumsub(channels, (Handler<AsyncResult<String>>)handler));
    }

    public String pubsubNumsubAndAwait(List<String> channels) {
        return (String)this.pubsubNumsub(channels).await().indefinitely();
    }

    private RedisTransaction __pubsubNumpat(Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    public Uni<String> pubsubNumpat() {
        return AsyncResultUni.toUni(handler -> this.__pubsubNumpat((Handler<AsyncResult<String>>)handler));
    }

    public String pubsubNumpatAndAwait() {
        return (String)this.pubsubNumpat().await().indefinitely();
    }

    private RedisTransaction __pttl(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    public Uni<String> pttl(String key) {
        return AsyncResultUni.toUni(handler -> this.__pttl(key, (Handler<AsyncResult<String>>)handler));
    }

    public String pttlAndAwait(String key) {
        return (String)this.pttl(key).await().indefinitely();
    }

    private RedisTransaction __publish(String channel, String message, Handler<AsyncResult<String>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    public Uni<String> publish(String channel, String message) {
        return AsyncResultUni.toUni(handler -> this.__publish(channel, message, (Handler<AsyncResult<String>>)handler));
    }

    public String publishAndAwait(String channel, String message) {
        return (String)this.publish(channel, message).await().indefinitely();
    }

    private RedisTransaction __punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    public Uni<String> punsubscribe(List<String> patterns) {
        return AsyncResultUni.toUni(handler -> this.__punsubscribe(patterns, (Handler<AsyncResult<String>>)handler));
    }

    public String punsubscribeAndAwait(List<String> patterns) {
        return (String)this.punsubscribe(patterns).await().indefinitely();
    }

    private RedisTransaction __randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    public Uni<String> randomkey() {
        return AsyncResultUni.toUni(handler -> this.__randomkey((Handler<AsyncResult<String>>)handler));
    }

    public String randomkeyAndAwait() {
        return (String)this.randomkey().await().indefinitely();
    }

    private RedisTransaction __rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    public Uni<String> rename(String key, String newkey) {
        return AsyncResultUni.toUni(handler -> this.__rename(key, newkey, (Handler<AsyncResult<String>>)handler));
    }

    public String renameAndAwait(String key, String newkey) {
        return (String)this.rename(key, newkey).await().indefinitely();
    }

    private RedisTransaction __renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    public Uni<String> renamenx(String key, String newkey) {
        return AsyncResultUni.toUni(handler -> this.__renamenx(key, newkey, (Handler<AsyncResult<String>>)handler));
    }

    public String renamenxAndAwait(String key, String newkey) {
        return (String)this.renamenx(key, newkey).await().indefinitely();
    }

    private RedisTransaction __restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    public Uni<String> restore(String key, long millis, String serialized) {
        return AsyncResultUni.toUni(handler -> this.__restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler));
    }

    public String restoreAndAwait(String key, long millis, String serialized) {
        return (String)this.restore(key, millis, serialized).await().indefinitely();
    }

    private RedisTransaction __role(Handler<AsyncResult<String>> handler) {
        this.delegate.role(handler);
        return this;
    }

    public Uni<String> role() {
        return AsyncResultUni.toUni(handler -> this.__role((Handler<AsyncResult<String>>)handler));
    }

    public String roleAndAwait() {
        return (String)this.role().await().indefinitely();
    }

    private RedisTransaction __rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    public Uni<String> rpop(String key) {
        return AsyncResultUni.toUni(handler -> this.__rpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public String rpopAndAwait(String key) {
        return (String)this.rpop(key).await().indefinitely();
    }

    private RedisTransaction __rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    public Uni<String> rpoplpush(String key, String destkey) {
        return AsyncResultUni.toUni(handler -> this.__rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler));
    }

    public String rpoplpushAndAwait(String key, String destkey) {
        return (String)this.rpoplpush(key, destkey).await().indefinitely();
    }

    private RedisTransaction __rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    public Uni<String> rpushMany(String key, List<String> values) {
        return AsyncResultUni.toUni(handler -> this.__rpushMany(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public String rpushManyAndAwait(String key, List<String> values) {
        return (String)this.rpushMany(key, values).await().indefinitely();
    }

    private RedisTransaction __rpush(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    public Uni<String> rpush(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__rpush(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String rpushAndAwait(String key, String value) {
        return (String)this.rpush(key, value).await().indefinitely();
    }

    private RedisTransaction __rpushx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    public Uni<String> rpushx(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__rpushx(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String rpushxAndAwait(String key, String value) {
        return (String)this.rpushx(key, value).await().indefinitely();
    }

    private RedisTransaction __sadd(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    public Uni<String> sadd(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__sadd(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String saddAndAwait(String key, String member) {
        return (String)this.sadd(key, member).await().indefinitely();
    }

    private RedisTransaction __saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    public Uni<String> saddMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__saddMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String saddManyAndAwait(String key, List<String> members) {
        return (String)this.saddMany(key, members).await().indefinitely();
    }

    private RedisTransaction __save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    public Uni<String> save() {
        return AsyncResultUni.toUni(handler -> this.__save((Handler<AsyncResult<String>>)handler));
    }

    public String saveAndAwait() {
        return (String)this.save().await().indefinitely();
    }

    private RedisTransaction __scard(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    public Uni<String> scard(String key) {
        return AsyncResultUni.toUni(handler -> this.__scard(key, (Handler<AsyncResult<String>>)handler));
    }

    public String scardAndAwait(String key) {
        return (String)this.scard(key).await().indefinitely();
    }

    private RedisTransaction __scriptExists(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    public Uni<String> scriptExists(String script) {
        return AsyncResultUni.toUni(handler -> this.__scriptExists(script, (Handler<AsyncResult<String>>)handler));
    }

    public String scriptExistsAndAwait(String script) {
        return (String)this.scriptExists(script).await().indefinitely();
    }

    private RedisTransaction __scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    public Uni<String> scriptExistsMany(List<String> scripts) {
        return AsyncResultUni.toUni(handler -> this.__scriptExistsMany(scripts, (Handler<AsyncResult<String>>)handler));
    }

    public String scriptExistsManyAndAwait(List<String> scripts) {
        return (String)this.scriptExistsMany(scripts).await().indefinitely();
    }

    private RedisTransaction __scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    public Uni<String> scriptFlush() {
        return AsyncResultUni.toUni(handler -> this.__scriptFlush((Handler<AsyncResult<String>>)handler));
    }

    public String scriptFlushAndAwait() {
        return (String)this.scriptFlush().await().indefinitely();
    }

    private RedisTransaction __scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    public Uni<String> scriptKill() {
        return AsyncResultUni.toUni(handler -> this.__scriptKill((Handler<AsyncResult<String>>)handler));
    }

    public String scriptKillAndAwait() {
        return (String)this.scriptKill().await().indefinitely();
    }

    private RedisTransaction __scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    public Uni<String> scriptLoad(String script) {
        return AsyncResultUni.toUni(handler -> this.__scriptLoad(script, (Handler<AsyncResult<String>>)handler));
    }

    public String scriptLoadAndAwait(String script) {
        return (String)this.scriptLoad(script).await().indefinitely();
    }

    private RedisTransaction __sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    public Uni<String> sdiff(String key, List<String> cmpkeys) {
        return AsyncResultUni.toUni(handler -> this.__sdiff(key, cmpkeys, (Handler<AsyncResult<String>>)handler));
    }

    public String sdiffAndAwait(String key, List<String> cmpkeys) {
        return (String)this.sdiff(key, cmpkeys).await().indefinitely();
    }

    private RedisTransaction __sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    public Uni<String> sdiffstore(String destkey, String key, List<String> cmpkeys) {
        return AsyncResultUni.toUni(handler -> this.__sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<String>>)handler));
    }

    public String sdiffstoreAndAwait(String destkey, String key, List<String> cmpkeys) {
        return (String)this.sdiffstore(destkey, key, cmpkeys).await().indefinitely();
    }

    private RedisTransaction __select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    public Uni<String> select(int dbindex) {
        return AsyncResultUni.toUni(handler -> this.__select(dbindex, (Handler<AsyncResult<String>>)handler));
    }

    public String selectAndAwait(int dbindex) {
        return (String)this.select(dbindex).await().indefinitely();
    }

    private RedisTransaction __set(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    public Uni<String> set(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__set(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String setAndAwait(String key, String value) {
        return (String)this.set(key, value).await().indefinitely();
    }

    private RedisTransaction __setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    public Uni<String> setWithOptions(String key, String value, SetOptions options) {
        return AsyncResultUni.toUni(handler -> this.__setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler));
    }

    public String setWithOptionsAndAwait(String key, String value, SetOptions options) {
        return (String)this.setWithOptions(key, value, options).await().indefinitely();
    }

    private RedisTransaction __setBinary(String key, Buffer value, Handler<AsyncResult<String>> handler) {
        this.delegate.setBinary(key, value.getDelegate(), handler);
        return this;
    }

    public Uni<String> setBinary(String key, Buffer value) {
        return AsyncResultUni.toUni(handler -> this.__setBinary(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String setBinaryAndAwait(String key, Buffer value) {
        return (String)this.setBinary(key, value).await().indefinitely();
    }

    private RedisTransaction __setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
        return this;
    }

    public Uni<String> setBinaryWithOptions(String key, Buffer value, SetOptions options) {
        return AsyncResultUni.toUni(handler -> this.__setBinaryWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler));
    }

    public String setBinaryWithOptionsAndAwait(String key, Buffer value, SetOptions options) {
        return (String)this.setBinaryWithOptions(key, value, options).await().indefinitely();
    }

    private RedisTransaction __setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    public Uni<String> setbit(String key, long offset, int bit) {
        return AsyncResultUni.toUni(handler -> this.__setbit(key, offset, bit, (Handler<AsyncResult<String>>)handler));
    }

    public String setbitAndAwait(String key, long offset, int bit) {
        return (String)this.setbit(key, offset, bit).await().indefinitely();
    }

    private RedisTransaction __setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    public Uni<String> setex(String key, long seconds, String value) {
        return AsyncResultUni.toUni(handler -> this.__setex(key, seconds, value, (Handler<AsyncResult<String>>)handler));
    }

    public String setexAndAwait(String key, long seconds, String value) {
        return (String)this.setex(key, seconds, value).await().indefinitely();
    }

    private RedisTransaction __setnx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    public Uni<String> setnx(String key, String value) {
        return AsyncResultUni.toUni(handler -> this.__setnx(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public String setnxAndAwait(String key, String value) {
        return (String)this.setnx(key, value).await().indefinitely();
    }

    private RedisTransaction __setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    public Uni<String> setrange(String key, int offset, String value) {
        return AsyncResultUni.toUni(handler -> this.__setrange(key, offset, value, (Handler<AsyncResult<String>>)handler));
    }

    public String setrangeAndAwait(String key, int offset, String value) {
        return (String)this.setrange(key, offset, value).await().indefinitely();
    }

    private RedisTransaction __sinter(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    public Uni<String> sinter(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sinter(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String sinterAndAwait(List<String> keys) {
        return (String)this.sinter(keys).await().indefinitely();
    }

    private RedisTransaction __sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    public Uni<String> sinterstore(String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sinterstore(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public String sinterstoreAndAwait(String destkey, List<String> keys) {
        return (String)this.sinterstore(destkey, keys).await().indefinitely();
    }

    private RedisTransaction __sismember(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    public Uni<String> sismember(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__sismember(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String sismemberAndAwait(String key, String member) {
        return (String)this.sismember(key, member).await().indefinitely();
    }

    private RedisTransaction __slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    public Uni<String> slaveof(String host, int port) {
        return AsyncResultUni.toUni(handler -> this.__slaveof(host, port, (Handler<AsyncResult<String>>)handler));
    }

    public String slaveofAndAwait(String host, int port) {
        return (String)this.slaveof(host, port).await().indefinitely();
    }

    private RedisTransaction __slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    public Uni<String> slaveofNoone() {
        return AsyncResultUni.toUni(handler -> this.__slaveofNoone((Handler<AsyncResult<String>>)handler));
    }

    public String slaveofNooneAndAwait() {
        return (String)this.slaveofNoone().await().indefinitely();
    }

    private RedisTransaction __slowlogGet(int limit, Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    public Uni<String> slowlogGet(int limit) {
        return AsyncResultUni.toUni(handler -> this.__slowlogGet(limit, (Handler<AsyncResult<String>>)handler));
    }

    public String slowlogGetAndAwait(int limit) {
        return (String)this.slowlogGet(limit).await().indefinitely();
    }

    private RedisTransaction __slowlogLen(Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    public Uni<String> slowlogLen() {
        return AsyncResultUni.toUni(handler -> this.__slowlogLen((Handler<AsyncResult<String>>)handler));
    }

    public String slowlogLenAndAwait() {
        return (String)this.slowlogLen().await().indefinitely();
    }

    private RedisTransaction __slowlogReset(Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    public Uni<String> slowlogReset() {
        return AsyncResultUni.toUni(handler -> this.__slowlogReset((Handler<AsyncResult<String>>)handler));
    }

    public String slowlogResetAndAwait() {
        return (String)this.slowlogReset().await().indefinitely();
    }

    private RedisTransaction __smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    public Uni<JsonArray> smembers(String key) {
        return AsyncResultUni.toUni(handler -> this.__smembers(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public JsonArray smembersAndAwait(String key) {
        return (JsonArray)this.smembers(key).await().indefinitely();
    }

    private RedisTransaction __smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    public Uni<String> smove(String key, String destkey, String member) {
        return AsyncResultUni.toUni(handler -> this.__smove(key, destkey, member, (Handler<AsyncResult<String>>)handler));
    }

    public String smoveAndAwait(String key, String destkey, String member) {
        return (String)this.smove(key, destkey, member).await().indefinitely();
    }

    private RedisTransaction __sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    public Uni<String> sort(String key, SortOptions options) {
        return AsyncResultUni.toUni(handler -> this.__sort(key, options, (Handler<AsyncResult<String>>)handler));
    }

    public String sortAndAwait(String key, SortOptions options) {
        return (String)this.sort(key, options).await().indefinitely();
    }

    private RedisTransaction __spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    public Uni<String> spop(String key) {
        return AsyncResultUni.toUni(handler -> this.__spop(key, (Handler<AsyncResult<String>>)handler));
    }

    public String spopAndAwait(String key) {
        return (String)this.spop(key).await().indefinitely();
    }

    private RedisTransaction __spopMany(String key, int count, Handler<AsyncResult<String>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    public Uni<String> spopMany(String key, int count) {
        return AsyncResultUni.toUni(handler -> this.__spopMany(key, count, (Handler<AsyncResult<String>>)handler));
    }

    public String spopManyAndAwait(String key, int count) {
        return (String)this.spopMany(key, count).await().indefinitely();
    }

    private RedisTransaction __srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    public Uni<String> srandmember(String key) {
        return AsyncResultUni.toUni(handler -> this.__srandmember(key, (Handler<AsyncResult<String>>)handler));
    }

    public String srandmemberAndAwait(String key) {
        return (String)this.srandmember(key).await().indefinitely();
    }

    private RedisTransaction __srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    public Uni<String> srandmemberCount(String key, int count) {
        return AsyncResultUni.toUni(handler -> this.__srandmemberCount(key, count, (Handler<AsyncResult<String>>)handler));
    }

    public String srandmemberCountAndAwait(String key, int count) {
        return (String)this.srandmemberCount(key, count).await().indefinitely();
    }

    private RedisTransaction __srem(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    public Uni<String> srem(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__srem(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String sremAndAwait(String key, String member) {
        return (String)this.srem(key, member).await().indefinitely();
    }

    private RedisTransaction __sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    public Uni<String> sremMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__sremMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String sremManyAndAwait(String key, List<String> members) {
        return (String)this.sremMany(key, members).await().indefinitely();
    }

    private RedisTransaction __strlen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    public Uni<String> strlen(String key) {
        return AsyncResultUni.toUni(handler -> this.__strlen(key, (Handler<AsyncResult<String>>)handler));
    }

    public String strlenAndAwait(String key) {
        return (String)this.strlen(key).await().indefinitely();
    }

    private RedisTransaction __subscribe(String channel, Handler<AsyncResult<String>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    public Uni<String> subscribe(String channel) {
        return AsyncResultUni.toUni(handler -> this.__subscribe(channel, (Handler<AsyncResult<String>>)handler));
    }

    public String subscribeAndAwait(String channel) {
        return (String)this.subscribe(channel).await().indefinitely();
    }

    private RedisTransaction __subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    public Uni<String> subscribeMany(List<String> channels) {
        return AsyncResultUni.toUni(handler -> this.__subscribeMany(channels, (Handler<AsyncResult<String>>)handler));
    }

    public String subscribeManyAndAwait(List<String> channels) {
        return (String)this.subscribeMany(channels).await().indefinitely();
    }

    private RedisTransaction __sunion(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    public Uni<String> sunion(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sunion(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String sunionAndAwait(List<String> keys) {
        return (String)this.sunion(keys).await().indefinitely();
    }

    private RedisTransaction __sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    public Uni<String> sunionstore(String destkey, List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__sunionstore(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public String sunionstoreAndAwait(String destkey, List<String> keys) {
        return (String)this.sunionstore(destkey, keys).await().indefinitely();
    }

    private RedisTransaction __sync(Handler<AsyncResult<String>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    public Uni<String> sync() {
        return AsyncResultUni.toUni(handler -> this.__sync((Handler<AsyncResult<String>>)handler));
    }

    public String syncAndAwait() {
        return (String)this.sync().await().indefinitely();
    }

    private RedisTransaction __time(Handler<AsyncResult<String>> handler) {
        this.delegate.time(handler);
        return this;
    }

    public Uni<String> time() {
        return AsyncResultUni.toUni(handler -> this.__time((Handler<AsyncResult<String>>)handler));
    }

    public String timeAndAwait() {
        return (String)this.time().await().indefinitely();
    }

    private RedisTransaction __ttl(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    public Uni<String> ttl(String key) {
        return AsyncResultUni.toUni(handler -> this.__ttl(key, (Handler<AsyncResult<String>>)handler));
    }

    public String ttlAndAwait(String key) {
        return (String)this.ttl(key).await().indefinitely();
    }

    private RedisTransaction __type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    public Uni<String> type(String key) {
        return AsyncResultUni.toUni(handler -> this.__type(key, (Handler<AsyncResult<String>>)handler));
    }

    public String typeAndAwait(String key) {
        return (String)this.type(key).await().indefinitely();
    }

    private RedisTransaction __unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    public Uni<String> unsubscribe(List<String> channels) {
        return AsyncResultUni.toUni(handler -> this.__unsubscribe(channels, (Handler<AsyncResult<String>>)handler));
    }

    public String unsubscribeAndAwait(List<String> channels) {
        return (String)this.unsubscribe(channels).await().indefinitely();
    }

    private RedisTransaction __unwatch(Handler<AsyncResult<String>> handler) {
        this.delegate.unwatch(handler);
        return this;
    }

    public Uni<String> unwatch() {
        return AsyncResultUni.toUni(handler -> this.__unwatch((Handler<AsyncResult<String>>)handler));
    }

    public String unwatchAndAwait() {
        return (String)this.unwatch().await().indefinitely();
    }

    private RedisTransaction __wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    public Uni<String> wait(long numSlaves, long timeout) {
        return AsyncResultUni.toUni(handler -> this.__wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler));
    }

    public String waitAndAwait(long numSlaves, long timeout) {
        return (String)this.wait(numSlaves, timeout).await().indefinitely();
    }

    private RedisTransaction __watch(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.watch(key, handler);
        return this;
    }

    public Uni<String> watch(String key) {
        return AsyncResultUni.toUni(handler -> this.__watch(key, (Handler<AsyncResult<String>>)handler));
    }

    public String watchAndAwait(String key) {
        return (String)this.watch(key).await().indefinitely();
    }

    private RedisTransaction __watchMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.watchMany(keys, handler);
        return this;
    }

    public Uni<String> watchMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__watchMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String watchManyAndAwait(List<String> keys) {
        return (String)this.watchMany(keys).await().indefinitely();
    }

    private RedisTransaction __zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    public Uni<String> zadd(String key, double score, String member) {
        return AsyncResultUni.toUni(handler -> this.__zadd(key, score, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zaddAndAwait(String key, double score, String member) {
        return (String)this.zadd(key, score, member).await().indefinitely();
    }

    private RedisTransaction __zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<String>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    public Uni<String> zaddMany(String key, Map<String, Double> members) {
        return AsyncResultUni.toUni(handler -> this.__zaddMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String zaddManyAndAwait(String key, Map<String, Double> members) {
        return (String)this.zaddMany(key, members).await().indefinitely();
    }

    private RedisTransaction __zcard(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    public Uni<String> zcard(String key) {
        return AsyncResultUni.toUni(handler -> this.__zcard(key, (Handler<AsyncResult<String>>)handler));
    }

    public String zcardAndAwait(String key) {
        return (String)this.zcard(key).await().indefinitely();
    }

    private RedisTransaction __zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    public Uni<String> zcount(String key, double min, double max) {
        return AsyncResultUni.toUni(handler -> this.__zcount(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public String zcountAndAwait(String key, double min, double max) {
        return (String)this.zcount(key, min, max).await().indefinitely();
    }

    private RedisTransaction __zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    public Uni<String> zincrby(String key, double increment, String member) {
        return AsyncResultUni.toUni(handler -> this.__zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zincrbyAndAwait(String key, double increment, String member) {
        return (String)this.zincrby(key, increment, member).await().indefinitely();
    }

    private RedisTransaction __zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    public Uni<String> zinterstore(String destkey, List<String> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zinterstore(destkey, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zinterstoreAndAwait(String destkey, List<String> sets, AggregateOptions options) {
        return (String)this.zinterstore(destkey, sets, options).await().indefinitely();
    }

    private RedisTransaction __zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    public Uni<String> zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zinterstoreWeighedAndAwait(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return (String)this.zinterstoreWeighed(destkey, sets, options).await().indefinitely();
    }

    private RedisTransaction __zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    public Uni<String> zlexcount(String key, String min, String max) {
        return AsyncResultUni.toUni(handler -> this.__zlexcount(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public String zlexcountAndAwait(String key, String min, String max) {
        return (String)this.zlexcount(key, min, max).await().indefinitely();
    }

    private RedisTransaction __zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    public Uni<String> zrange(String key, long start, long stop) {
        return AsyncResultUni.toUni(handler -> this.__zrange(key, start, stop, (Handler<AsyncResult<String>>)handler));
    }

    public String zrangeAndAwait(String key, long start, long stop) {
        return (String)this.zrange(key, start, stop).await().indefinitely();
    }

    private RedisTransaction __zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    public Uni<String> zrangeWithOptions(String key, long start, long stop, RangeOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zrangeWithOptionsAndAwait(String key, long start, long stop, RangeOptions options) {
        return (String)this.zrangeWithOptions(key, start, stop, options).await().indefinitely();
    }

    private RedisTransaction __zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    public Uni<String> zrangebylex(String key, String min, String max, LimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrangebylex(key, min, max, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zrangebylexAndAwait(String key, String min, String max, LimitOptions options) {
        return (String)this.zrangebylex(key, min, max, options).await().indefinitely();
    }

    private RedisTransaction __zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    public Uni<String> zrangebyscore(String key, String min, String max, RangeLimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrangebyscore(key, min, max, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zrangebyscoreAndAwait(String key, String min, String max, RangeLimitOptions options) {
        return (String)this.zrangebyscore(key, min, max, options).await().indefinitely();
    }

    private RedisTransaction __zrank(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    public Uni<String> zrank(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zrank(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zrankAndAwait(String key, String member) {
        return (String)this.zrank(key, member).await().indefinitely();
    }

    private RedisTransaction __zrem(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    public Uni<String> zrem(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zrem(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zremAndAwait(String key, String member) {
        return (String)this.zrem(key, member).await().indefinitely();
    }

    private RedisTransaction __zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    public Uni<String> zremMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__zremMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String zremManyAndAwait(String key, List<String> members) {
        return (String)this.zremMany(key, members).await().indefinitely();
    }

    private RedisTransaction __zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    public Uni<String> zremrangebylex(String key, String min, String max) {
        return AsyncResultUni.toUni(handler -> this.__zremrangebylex(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public String zremrangebylexAndAwait(String key, String min, String max) {
        return (String)this.zremrangebylex(key, min, max).await().indefinitely();
    }

    private RedisTransaction __zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    public Uni<String> zremrangebyrank(String key, long start, long stop) {
        return AsyncResultUni.toUni(handler -> this.__zremrangebyrank(key, start, stop, (Handler<AsyncResult<String>>)handler));
    }

    public String zremrangebyrankAndAwait(String key, long start, long stop) {
        return (String)this.zremrangebyrank(key, start, stop).await().indefinitely();
    }

    private RedisTransaction __zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    public Uni<String> zremrangebyscore(String key, String min, String max) {
        return AsyncResultUni.toUni(handler -> this.__zremrangebyscore(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public String zremrangebyscoreAndAwait(String key, String min, String max) {
        return (String)this.zremrangebyscore(key, min, max).await().indefinitely();
    }

    private RedisTransaction __zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    public Uni<String> zrevrange(String key, long start, long stop, RangeOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrevrange(key, start, stop, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zrevrangeAndAwait(String key, long start, long stop, RangeOptions options) {
        return (String)this.zrevrange(key, start, stop, options).await().indefinitely();
    }

    private RedisTransaction __zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    public Uni<String> zrevrangebylex(String key, String max, String min, LimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrevrangebylex(key, max, min, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zrevrangebylexAndAwait(String key, String max, String min, LimitOptions options) {
        return (String)this.zrevrangebylex(key, max, min, options).await().indefinitely();
    }

    private RedisTransaction __zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    public Uni<String> zrevrangebyscore(String key, String max, String min, RangeLimitOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zrevrangebyscoreAndAwait(String key, String max, String min, RangeLimitOptions options) {
        return (String)this.zrevrangebyscore(key, max, min, options).await().indefinitely();
    }

    private RedisTransaction __zrevrank(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    public Uni<String> zrevrank(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zrevrank(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zrevrankAndAwait(String key, String member) {
        return (String)this.zrevrank(key, member).await().indefinitely();
    }

    private RedisTransaction __zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    public Uni<String> zscore(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__zscore(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String zscoreAndAwait(String key, String member) {
        return (String)this.zscore(key, member).await().indefinitely();
    }

    private RedisTransaction __zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    public Uni<String> zunionstore(String destkey, List<String> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zunionstore(destkey, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zunionstoreAndAwait(String destkey, List<String> sets, AggregateOptions options) {
        return (String)this.zunionstore(destkey, sets, options).await().indefinitely();
    }

    private RedisTransaction __zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    public Uni<String> zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zunionstoreWeighedAndAwait(String key, Map<String, Double> sets, AggregateOptions options) {
        return (String)this.zunionstoreWeighed(key, sets, options).await().indefinitely();
    }

    private RedisTransaction __scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    public Uni<String> scan(String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__scan(cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public String scanAndAwait(String cursor, ScanOptions options) {
        return (String)this.scan(cursor, options).await().indefinitely();
    }

    private RedisTransaction __sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    public Uni<String> sscan(String key, String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__sscan(key, cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public String sscanAndAwait(String key, String cursor, ScanOptions options) {
        return (String)this.sscan(key, cursor, options).await().indefinitely();
    }

    private RedisTransaction __hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    public Uni<String> hscan(String key, String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__hscan(key, cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public String hscanAndAwait(String key, String cursor, ScanOptions options) {
        return (String)this.hscan(key, cursor, options).await().indefinitely();
    }

    private RedisTransaction __zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    public Uni<String> zscan(String key, String cursor, ScanOptions options) {
        return AsyncResultUni.toUni(handler -> this.__zscan(key, cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public String zscanAndAwait(String key, String cursor, ScanOptions options) {
        return (String)this.zscan(key, cursor, options).await().indefinitely();
    }

    private RedisTransaction __geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    public Uni<String> geoadd(String key, double longitude, double latitude, String member) {
        return AsyncResultUni.toUni(handler -> this.__geoadd(key, longitude, latitude, member, (Handler<AsyncResult<String>>)handler));
    }

    public String geoaddAndAwait(String key, double longitude, double latitude, String member) {
        return (String)this.geoadd(key, longitude, latitude, member).await().indefinitely();
    }

    private RedisTransaction __geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    public Uni<String> geoaddMany(String key, List<GeoMember> members) {
        return AsyncResultUni.toUni(handler -> this.__geoaddMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String geoaddManyAndAwait(String key, List<GeoMember> members) {
        return (String)this.geoaddMany(key, members).await().indefinitely();
    }

    private RedisTransaction __geohash(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    public Uni<String> geohash(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__geohash(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String geohashAndAwait(String key, String member) {
        return (String)this.geohash(key, member).await().indefinitely();
    }

    private RedisTransaction __geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    public Uni<String> geohashMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__geohashMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String geohashManyAndAwait(String key, List<String> members) {
        return (String)this.geohashMany(key, members).await().indefinitely();
    }

    private RedisTransaction __geopos(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    public Uni<String> geopos(String key, String member) {
        return AsyncResultUni.toUni(handler -> this.__geopos(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public String geoposAndAwait(String key, String member) {
        return (String)this.geopos(key, member).await().indefinitely();
    }

    private RedisTransaction __geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    public Uni<String> geoposMany(String key, List<String> members) {
        return AsyncResultUni.toUni(handler -> this.__geoposMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public String geoposManyAndAwait(String key, List<String> members) {
        return (String)this.geoposMany(key, members).await().indefinitely();
    }

    private RedisTransaction __geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    public Uni<String> geodist(String key, String member1, String member2) {
        return AsyncResultUni.toUni(handler -> this.__geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler));
    }

    public String geodistAndAwait(String key, String member1, String member2) {
        return (String)this.geodist(key, member1, member2).await().indefinitely();
    }

    private RedisTransaction __geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    public Uni<String> geodistWithUnit(String key, String member1, String member2, GeoUnit unit) {
        return AsyncResultUni.toUni(handler -> this.__geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler));
    }

    public String geodistWithUnitAndAwait(String key, String member1, String member2, GeoUnit unit) {
        return (String)this.geodistWithUnit(key, member1, member2, unit).await().indefinitely();
    }

    private RedisTransaction __georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    public Uni<String> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return AsyncResultUni.toUni(handler -> this.__georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<String>>)handler));
    }

    public String georadiusAndAwait(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return (String)this.georadius(key, longitude, latitude, radius, unit).await().indefinitely();
    }

    private RedisTransaction __georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    public Uni<String> georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return AsyncResultUni.toUni(handler -> this.__georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<String>>)handler));
    }

    public String georadiusWithOptionsAndAwait(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return (String)this.georadiusWithOptions(key, longitude, latitude, radius, unit, options).await().indefinitely();
    }

    private RedisTransaction __georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    public Uni<String> georadiusbymember(String key, String member, double radius, GeoUnit unit) {
        return AsyncResultUni.toUni(handler -> this.__georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<String>>)handler));
    }

    public String georadiusbymemberAndAwait(String key, String member, double radius, GeoUnit unit) {
        return (String)this.georadiusbymember(key, member, radius, unit).await().indefinitely();
    }

    private RedisTransaction __georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    public Uni<String> georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return AsyncResultUni.toUni(handler -> this.__georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<String>>)handler));
    }

    public String georadiusbymemberWithOptionsAndAwait(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return (String)this.georadiusbymemberWithOptions(key, member, radius, unit, options).await().indefinitely();
    }

    private RedisTransaction __unlink(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.unlink(key, handler);
        return this;
    }

    public Uni<String> unlink(String key) {
        return AsyncResultUni.toUni(handler -> this.__unlink(key, (Handler<AsyncResult<String>>)handler));
    }

    public String unlinkAndAwait(String key) {
        return (String)this.unlink(key).await().indefinitely();
    }

    private RedisTransaction __unlinkMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.unlinkMany(keys, handler);
        return this;
    }

    public Uni<String> unlinkMany(List<String> keys) {
        return AsyncResultUni.toUni(handler -> this.__unlinkMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public String unlinkManyAndAwait(List<String> keys) {
        return (String)this.unlinkMany(keys).await().indefinitely();
    }

    private RedisTransaction __swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
        this.delegate.swapdb(index1, index2, handler);
        return this;
    }

    public Uni<String> swapdb(int index1, int index2) {
        return AsyncResultUni.toUni(handler -> this.__swapdb(index1, index2, (Handler<AsyncResult<String>>)handler));
    }

    public String swapdbAndAwait(int index1, int index2) {
        return (String)this.swapdb(index1, index2).await().indefinitely();
    }

    public static RedisTransaction newInstance(io.vertx.redis.RedisTransaction arg) {
        return arg != null ? new RedisTransaction(arg) : null;
    }
}

