/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.mongo;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.List;
import java.util.concurrent.Flow;

@MutinyGen(value=io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient {
    public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg(obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient)obj), MongoGridFsClient::getDelegate);
    private final io.vertx.ext.mongo.MongoGridFsClient delegate;
    static final TypeArg<Buffer> TYPE_ARG_2 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)((io.vertx.core.buffer.Buffer)o1)), o1 -> o1.getDelegate());
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)((io.vertx.core.buffer.Buffer)o1)), o1 -> o1.getDelegate());
    static final TypeArg<Buffer> TYPE_ARG_1 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)((io.vertx.core.buffer.Buffer)o1)), o1 -> o1.getDelegate());

    public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
        this.delegate = delegate;
    }

    public MongoGridFsClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
    }

    MongoGridFsClient() {
        this.delegate = null;
    }

    public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoGridFsClient that = (MongoGridFsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<Void> delete(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.delete(id, resultHandler));
    }

    public Void deleteAndAwait(String id) {
        return (Void)this.delete(id).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient deleteAndForget(String id) {
        this.delete(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public ReadStream<Buffer> readByFileName(String fileName) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.readByFileName(fileName), TYPE_ARG_0);
        return ret;
    }

    public ReadStream<Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.readByFileNameWithOptions(fileName, options), TYPE_ARG_1);
        return ret;
    }

    public ReadStream<Buffer> readById(String id) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.readById(id), TYPE_ARG_2);
        return ret;
    }

    @CheckReturnValue
    public Uni<Long> downloadByFileName(WriteStream<Buffer> stream, String fileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.downloadByFileName(stream.getDelegate(), fileName, resultHandler));
    }

    public Long downloadByFileNameAndAwait(WriteStream<Buffer> stream, String fileName) {
        return (Long)this.downloadByFileName(stream, fileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient downloadByFileNameAndForget(WriteStream<Buffer> stream, String fileName) {
        this.downloadByFileName(stream, fileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> downloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler));
    }

    public Long downloadByFileNameWithOptionsAndAwait(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return (Long)this.downloadByFileNameWithOptions(stream, fileName, options).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient downloadByFileNameWithOptionsAndForget(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        this.downloadByFileNameWithOptions(stream, fileName, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> downloadById(WriteStream<Buffer> stream, String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.downloadById(stream.getDelegate(), id, resultHandler));
    }

    public Long downloadByIdAndAwait(WriteStream<Buffer> stream, String id) {
        return (Long)this.downloadById(stream, id).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient downloadByIdAndForget(WriteStream<Buffer> stream, String id) {
        this.downloadById(stream, id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> downloadFile(String fileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.downloadFile(fileName, resultHandler));
    }

    public Long downloadFileAndAwait(String fileName) {
        return (Long)this.downloadFile(fileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient downloadFileAndForget(String fileName) {
        this.downloadFile(fileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> downloadFileAs(String fileName, String newFileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.downloadFileAs(fileName, newFileName, resultHandler));
    }

    public Long downloadFileAsAndAwait(String fileName, String newFileName) {
        return (Long)this.downloadFileAs(fileName, newFileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient downloadFileAsAndForget(String fileName, String newFileName) {
        this.downloadFileAs(fileName, newFileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> downloadFileByID(String id, String fileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.downloadFileByID(id, fileName, resultHandler));
    }

    public Long downloadFileByIDAndAwait(String id, String fileName) {
        return (Long)this.downloadFileByID(id, fileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient downloadFileByIDAndForget(String id, String fileName) {
        this.downloadFileByID(id, fileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> drop() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.drop(resultHandler));
    }

    public Void dropAndAwait() {
        return (Void)this.drop().await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient dropAndForget() {
        this.drop().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> findAllIds() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findAllIds(resultHandler));
    }

    public List<String> findAllIdsAndAwait() {
        return (List)this.findAllIds().await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient findAllIdsAndForget() {
        this.findAllIds().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> findIds(JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findIds(query, resultHandler));
    }

    public List<String> findIdsAndAwait(JsonObject query) {
        return (List)this.findIds(query).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient findIdsAndForget(JsonObject query) {
        this.findIds(query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> uploadByFileName(ReadStream<Buffer> stream, String fileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.uploadByFileName(stream.getDelegate(), fileName, resultHandler));
    }

    public String uploadByFileNameAndAwait(ReadStream<Buffer> stream, String fileName) {
        return (String)this.uploadByFileName(stream, fileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient uploadByFileNameAndForget(ReadStream<Buffer> stream, String fileName) {
        this.uploadByFileName(stream, fileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> uploadByFileName(Flow.Publisher<Buffer> stream, String fileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.uploadByFileName(ReadStreamSubscriber.asReadStream((Flow.Publisher)stream, obj -> obj.getDelegate()).resume(), fileName, resultHandler));
    }

    public String uploadByFileNameAndAwait(Flow.Publisher<Buffer> stream, String fileName) {
        return (String)this.uploadByFileName(stream, fileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient uploadByFileNameAndForget(Flow.Publisher<Buffer> stream, String fileName) {
        this.uploadByFileName(stream, fileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> uploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler));
    }

    public String uploadByFileNameWithOptionsAndAwait(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return (String)this.uploadByFileNameWithOptions(stream, fileName, options).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient uploadByFileNameWithOptionsAndForget(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        this.uploadByFileNameWithOptions(stream, fileName, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> uploadByFileNameWithOptions(Flow.Publisher<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.uploadByFileNameWithOptions(ReadStreamSubscriber.asReadStream((Flow.Publisher)stream, obj -> obj.getDelegate()).resume(), fileName, options, resultHandler));
    }

    public String uploadByFileNameWithOptionsAndAwait(Flow.Publisher<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return (String)this.uploadByFileNameWithOptions(stream, fileName, options).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient uploadByFileNameWithOptionsAndForget(Flow.Publisher<Buffer> stream, String fileName, GridFsUploadOptions options) {
        this.uploadByFileNameWithOptions(stream, fileName, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> uploadFile(String fileName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.uploadFile(fileName, resultHandler));
    }

    public String uploadFileAndAwait(String fileName) {
        return (String)this.uploadFile(fileName).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient uploadFileAndForget(String fileName) {
        this.uploadFile(fileName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.uploadFileWithOptions(fileName, options, resultHandler));
    }

    public String uploadFileWithOptionsAndAwait(String fileName, GridFsUploadOptions options) {
        return (String)this.uploadFileWithOptions(fileName, options).await().indefinitely();
    }

    @Fluent
    public MongoGridFsClient uploadFileWithOptionsAndForget(String fileName, GridFsUploadOptions options) {
        this.uploadFileWithOptions(fileName, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
        return arg != null ? new MongoGridFsClient(arg) : null;
    }
}

