/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.junit5;

import io.vertx.core.VertxException;
import io.vertx.junit5.ParameterClosingConsumer;
import io.vertx.junit5.VertxExtensionParameterProvider;
import io.vertx.mutiny.core.Vertx;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class VertxParameterProvider
implements VertxExtensionParameterProvider<Vertx> {
    public Class<Vertx> type() {
        return Vertx.class;
    }

    public String key() {
        return "Vertx";
    }

    public Vertx newInstance(ExtensionContext extensionContext, ParameterContext parameterContext) {
        return Vertx.vertx();
    }

    public ParameterClosingConsumer<Vertx> parameterClosingConsumer() {
        return vertx -> {
            try {
                vertx.close().await().atMost(Duration.of(30L, ChronoUnit.SECONDS));
            }
            catch (Throwable err) {
                if (err instanceof TimeoutException) {
                    throw err;
                }
                if (err instanceof CompletionException) {
                    throw new VertxException(err.getCause());
                }
                if (err instanceof Exception) {
                    throw err;
                }
                throw new VertxException(err);
            }
        };
    }
}

