/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.sql;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.mutiny.ext.sql.SQLConnection;
import io.vertx.mutiny.ext.sql.SQLOperations;
import io.vertx.mutiny.ext.sql.SQLRowStream;

@MutinyGen(value=io.vertx.ext.sql.SQLClient.class)
public class SQLClient
implements SQLOperations {
    public static final TypeArg<SQLClient> __TYPE_ARG = new TypeArg(obj -> new SQLClient((io.vertx.ext.sql.SQLClient)obj), SQLClient::getDelegate);
    private final io.vertx.ext.sql.SQLClient delegate;

    public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
        this.delegate = delegate;
    }

    public SQLClient(Object delegate) {
        this.delegate = (io.vertx.ext.sql.SQLClient)delegate;
    }

    SQLClient() {
        this.delegate = null;
    }

    public io.vertx.ext.sql.SQLClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLClient that = (SQLClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    @CheckReturnValue
    public Uni<JsonArray> querySingle(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.querySingle(sql, handler));
    }

    @Override
    public JsonArray querySingleAndAwait(String sql) {
        return (JsonArray)this.querySingle(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations querySingleAndForget(String sql) {
        this.querySingle(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments) {
        return AsyncResultUni.toUni(handler -> this.delegate.querySingleWithParams(sql, arguments, handler));
    }

    @Override
    public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments) {
        return (JsonArray)this.querySingleWithParams(sql, arguments).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments) {
        this.querySingleWithParams(sql, arguments).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<SQLConnection> getConnection() {
        return AsyncResultUni.toUni(handler -> this.delegate.getConnection((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> SQLConnection.newInstance(event)))));
    }

    public SQLConnection getConnectionAndAwait() {
        return (SQLConnection)this.getConnection().await().indefinitely();
    }

    @Fluent
    public SQLClient getConnectionAndForget() {
        this.getConnection().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> query(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.query(sql, handler));
    }

    @Override
    public ResultSet queryAndAwait(String sql) {
        return (ResultSet)this.query(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient queryAndForget(String sql) {
        this.query(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<SQLRowStream> queryStream(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryStream(sql, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> SQLRowStream.newInstance(event)))));
    }

    @Override
    public SQLRowStream queryStreamAndAwait(String sql) {
        return (SQLRowStream)this.queryStream(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient queryStreamAndForget(String sql) {
        this.queryStream(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<SQLRowStream> queryStreamWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryStreamWithParams(sql, params, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> SQLRowStream.newInstance(event)))));
    }

    @Override
    public SQLRowStream queryStreamWithParamsAndAwait(String sql, JsonArray params) {
        return (SQLRowStream)this.queryStreamWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient queryStreamWithParamsAndForget(String sql, JsonArray params) {
        this.queryStreamWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> queryWithParams(String sql, JsonArray arguments) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryWithParams(sql, arguments, handler));
    }

    @Override
    public ResultSet queryWithParamsAndAwait(String sql, JsonArray arguments) {
        return (ResultSet)this.queryWithParams(sql, arguments).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient queryWithParamsAndForget(String sql, JsonArray arguments) {
        this.queryWithParams(sql, arguments).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<UpdateResult> update(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.update(sql, handler));
    }

    @Override
    public UpdateResult updateAndAwait(String sql) {
        return (UpdateResult)this.update(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient updateAndForget(String sql) {
        this.update(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<UpdateResult> updateWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateWithParams(sql, params, handler));
    }

    @Override
    public UpdateResult updateWithParamsAndAwait(String sql, JsonArray params) {
        return (UpdateResult)this.updateWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient updateWithParamsAndForget(String sql, JsonArray params) {
        this.updateWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> call(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.call(sql, handler));
    }

    @Override
    public ResultSet callAndAwait(String sql) {
        return (ResultSet)this.call(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient callAndForget(String sql) {
        this.call(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> callWithParams(String sql, JsonArray params, JsonArray outputs) {
        return AsyncResultUni.toUni(handler -> this.delegate.callWithParams(sql, params, outputs, handler));
    }

    @Override
    public ResultSet callWithParamsAndAwait(String sql, JsonArray params, JsonArray outputs) {
        return (ResultSet)this.callWithParams(sql, params, outputs).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLClient callWithParamsAndForget(String sql, JsonArray params, JsonArray outputs) {
        this.callWithParams(sql, params, outputs).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
        return arg != null ? new SQLClient(arg) : null;
    }
}

