/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.sql;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.mutiny.ext.sql.SQLOperations;
import io.vertx.mutiny.ext.sql.SQLRowStream;
import java.util.List;

@MutinyGen(value=io.vertx.ext.sql.SQLConnection.class)
public class SQLConnection
implements SQLOperations {
    public static final TypeArg<SQLConnection> __TYPE_ARG = new TypeArg(obj -> new SQLConnection((io.vertx.ext.sql.SQLConnection)obj), SQLConnection::getDelegate);
    private final io.vertx.ext.sql.SQLConnection delegate;

    public SQLConnection(io.vertx.ext.sql.SQLConnection delegate) {
        this.delegate = delegate;
    }

    public SQLConnection(Object delegate) {
        this.delegate = (io.vertx.ext.sql.SQLConnection)delegate;
    }

    SQLConnection() {
        this.delegate = null;
    }

    public io.vertx.ext.sql.SQLConnection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLConnection that = (SQLConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Uni<JsonArray> querySingle(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.querySingle(sql, handler));
    }

    @Override
    public JsonArray querySingleAndAwait(String sql) {
        return (JsonArray)this.querySingle(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations querySingleAndForget(String sql) {
        this.querySingle(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments) {
        return AsyncResultUni.toUni(handler -> this.delegate.querySingleWithParams(sql, arguments, handler));
    }

    @Override
    public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments) {
        return (JsonArray)this.querySingleWithParams(sql, arguments).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments) {
        this.querySingleWithParams(sql, arguments).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public SQLConnection setOptions(SQLOptions options) {
        this.delegate.setOptions(options);
        return this;
    }

    public Uni<Void> setAutoCommit(boolean autoCommit) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.setAutoCommit(autoCommit, resultHandler));
    }

    public Void setAutoCommitAndAwait(boolean autoCommit) {
        return (Void)this.setAutoCommit(autoCommit).await().indefinitely();
    }

    @Fluent
    public SQLConnection setAutoCommitAndForget(boolean autoCommit) {
        this.setAutoCommit(autoCommit).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> execute(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.execute(sql, resultHandler));
    }

    public Void executeAndAwait(String sql) {
        return (Void)this.execute(sql).await().indefinitely();
    }

    @Fluent
    public SQLConnection executeAndForget(String sql) {
        this.execute(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<ResultSet> query(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.query(sql, resultHandler));
    }

    @Override
    public ResultSet queryAndAwait(String sql) {
        return (ResultSet)this.query(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection queryAndForget(String sql) {
        this.query(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<SQLRowStream> queryStream(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryStream(sql, (Handler)new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Override
    public SQLRowStream queryStreamAndAwait(String sql) {
        return (SQLRowStream)this.queryStream(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection queryStreamAndForget(String sql) {
        this.queryStream(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<ResultSet> queryWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queryWithParams(sql, params, resultHandler));
    }

    @Override
    public ResultSet queryWithParamsAndAwait(String sql, JsonArray params) {
        return (ResultSet)this.queryWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection queryWithParamsAndForget(String sql, JsonArray params) {
        this.queryWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<SQLRowStream> queryStreamWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryStreamWithParams(sql, params, (Handler)new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Override
    public SQLRowStream queryStreamWithParamsAndAwait(String sql, JsonArray params) {
        return (SQLRowStream)this.queryStreamWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection queryStreamWithParamsAndForget(String sql, JsonArray params) {
        this.queryStreamWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<UpdateResult> update(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.update(sql, resultHandler));
    }

    @Override
    public UpdateResult updateAndAwait(String sql) {
        return (UpdateResult)this.update(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection updateAndForget(String sql) {
        this.update(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<UpdateResult> updateWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateWithParams(sql, params, resultHandler));
    }

    @Override
    public UpdateResult updateWithParamsAndAwait(String sql, JsonArray params) {
        return (UpdateResult)this.updateWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection updateWithParamsAndForget(String sql, JsonArray params) {
        this.updateWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<ResultSet> call(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.call(sql, resultHandler));
    }

    @Override
    public ResultSet callAndAwait(String sql) {
        return (ResultSet)this.call(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection callAndForget(String sql) {
        this.call(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public Uni<ResultSet> callWithParams(String sql, JsonArray params, JsonArray outputs) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.callWithParams(sql, params, outputs, resultHandler));
    }

    @Override
    public ResultSet callWithParamsAndAwait(String sql, JsonArray params, JsonArray outputs) {
        return (ResultSet)this.callWithParams(sql, params, outputs).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLConnection callWithParamsAndForget(String sql, JsonArray params, JsonArray outputs) {
        this.callWithParams(sql, params, outputs).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> commit() {
        return AsyncResultUni.toUni(handler -> this.delegate.commit(handler));
    }

    public Void commitAndAwait() {
        return (Void)this.commit().await().indefinitely();
    }

    @Fluent
    public SQLConnection commitAndForget() {
        this.commit().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> rollback() {
        return AsyncResultUni.toUni(handler -> this.delegate.rollback(handler));
    }

    public Void rollbackAndAwait() {
        return (Void)this.rollback().await().indefinitely();
    }

    @Fluent
    public SQLConnection rollbackAndForget() {
        this.rollback().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    @Fluent
    public SQLConnection setQueryTimeout(int timeoutInSeconds) {
        this.delegate.setQueryTimeout(timeoutInSeconds);
        return this;
    }

    public Uni<List<Integer>> batch(List<String> sqlStatements) {
        return AsyncResultUni.toUni(handler -> this.delegate.batch(sqlStatements, handler));
    }

    public List<Integer> batchAndAwait(List<String> sqlStatements) {
        return (List)this.batch(sqlStatements).await().indefinitely();
    }

    @Fluent
    public SQLConnection batchAndForget(List<String> sqlStatements) {
        this.batch(sqlStatements).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<List<Integer>> batchWithParams(String sqlStatement, List<JsonArray> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.batchWithParams(sqlStatement, args, handler));
    }

    public List<Integer> batchWithParamsAndAwait(String sqlStatement, List<JsonArray> args) {
        return (List)this.batchWithParams(sqlStatement, args).await().indefinitely();
    }

    @Fluent
    public SQLConnection batchWithParamsAndForget(String sqlStatement, List<JsonArray> args) {
        this.batchWithParams(sqlStatement, args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<List<Integer>> batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
        return AsyncResultUni.toUni(handler -> this.delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler));
    }

    public List<Integer> batchCallableWithParamsAndAwait(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
        return (List)this.batchCallableWithParams(sqlStatement, inArgs, outArgs).await().indefinitely();
    }

    @Fluent
    public SQLConnection batchCallableWithParamsAndForget(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
        this.batchCallableWithParams(sqlStatement, inArgs, outArgs).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> setTransactionIsolation(TransactionIsolation isolation) {
        return AsyncResultUni.toUni(handler -> this.delegate.setTransactionIsolation(isolation, handler));
    }

    public Void setTransactionIsolationAndAwait(TransactionIsolation isolation) {
        return (Void)this.setTransactionIsolation(isolation).await().indefinitely();
    }

    @Fluent
    public SQLConnection setTransactionIsolationAndForget(TransactionIsolation isolation) {
        this.setTransactionIsolation(isolation).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<TransactionIsolation> getTransactionIsolation() {
        return AsyncResultUni.toUni(handler -> this.delegate.getTransactionIsolation(handler));
    }

    public TransactionIsolation getTransactionIsolationAndAwait() {
        return (TransactionIsolation)this.getTransactionIsolation().await().indefinitely();
    }

    @Fluent
    public SQLConnection getTransactionIsolationAndForget() {
        this.getTransactionIsolation().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static SQLConnection newInstance(io.vertx.ext.sql.SQLConnection arg) {
        return arg != null ? new SQLConnection(arg) : null;
    }
}

