/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.httpproxy;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.http.HttpClientRequest;
import io.vertx.mutiny.core.http.HttpServerRequest;
import io.vertx.mutiny.core.net.HostAndPort;
import io.vertx.mutiny.httpproxy.Body;
import io.vertx.mutiny.httpproxy.ProxyResponse;

@MutinyGen(value=io.vertx.httpproxy.ProxyRequest.class)
public class ProxyRequest
implements MutinyDelegate {
    public static final TypeArg<ProxyRequest> __TYPE_ARG = new TypeArg(obj -> new ProxyRequest((io.vertx.httpproxy.ProxyRequest)obj), ProxyRequest::getDelegate);
    private final io.vertx.httpproxy.ProxyRequest delegate;
    static final TypeArg<ProxyResponse> TYPE_ARG_0 = new TypeArg(o1 -> ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());

    public ProxyRequest(io.vertx.httpproxy.ProxyRequest delegate) {
        this.delegate = delegate;
    }

    public ProxyRequest(Object delegate) {
        this.delegate = (io.vertx.httpproxy.ProxyRequest)delegate;
    }

    ProxyRequest() {
        this.delegate = null;
    }

    public io.vertx.httpproxy.ProxyRequest getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyRequest that = (ProxyRequest)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static ProxyRequest reverseProxy(HttpServerRequest proxiedRequest) {
        ProxyRequest ret = ProxyRequest.newInstance(io.vertx.httpproxy.ProxyRequest.reverseProxy((io.vertx.core.http.HttpServerRequest)proxiedRequest.getDelegate()));
        return ret;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public HttpMethod getMethod() {
        HttpMethod ret = this.delegate.getMethod();
        return ret;
    }

    @Fluent
    public ProxyRequest setMethod(HttpMethod method) {
        this.delegate.setMethod(method);
        return this;
    }

    public String getURI() {
        String ret = this.delegate.getURI();
        return ret;
    }

    @Fluent
    public ProxyRequest setURI(String uri) {
        this.delegate.setURI(uri);
        return this;
    }

    public Body getBody() {
        Body ret = Body.newInstance(this.delegate.getBody());
        return ret;
    }

    @Fluent
    public ProxyRequest setBody(Body body) {
        this.delegate.setBody(body.getDelegate());
        return this;
    }

    @Fluent
    public ProxyRequest setAuthority(HostAndPort authority) {
        this.delegate.setAuthority(authority.getDelegate());
        return this;
    }

    public HostAndPort getAuthority() {
        HostAndPort ret = HostAndPort.newInstance((io.vertx.core.net.HostAndPort)this.delegate.getAuthority());
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance((io.vertx.core.MultiMap)this.delegate.headers());
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> proxy(HttpClientRequest request) {
        return UniHelper.toUni((Future)this.delegate.proxy(request.getDelegate()));
    }

    public Void proxyAndAwait(HttpClientRequest request) {
        return (Void)this.proxy(request).await().indefinitely();
    }

    public void proxyAndForget(HttpClientRequest request) {
        this.proxy(request).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<ProxyResponse> send(HttpClientRequest request) {
        return UniHelper.toUni((Future)this.delegate.send(request.getDelegate()).map(x -> ProxyResponse.newInstance(x)));
    }

    public ProxyResponse sendAndAwait(HttpClientRequest request) {
        return (ProxyResponse)this.send(request).await().indefinitely();
    }

    public void sendAndForget(HttpClientRequest request) {
        this.send(request).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    public ProxyRequest release() {
        this.delegate.release();
        return this;
    }

    public HttpServerRequest proxiedRequest() {
        HttpServerRequest ret = HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)this.delegate.proxiedRequest());
        return ret;
    }

    public ProxyResponse response() {
        ProxyResponse ret = ProxyResponse.newInstance(this.delegate.response());
        return ret;
    }

    public static ProxyRequest newInstance(io.vertx.httpproxy.ProxyRequest arg) {
        return arg != null ? new ProxyRequest(arg) : null;
    }
}

