package io.vertx.mutiny.core.net;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a socket-like interface to a TCP connection on either the
 * client or the server side.
 * <p>
 * Instances of this class are created on the client side by an {@link io.vertx.mutiny.core.net.NetClient}
 * when a connection to a server is made, or on the server side by a {@link io.vertx.mutiny.core.net.NetServer}
 * when a server accepts a connection.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetSocket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.NetSocket.class)
public class NetSocket implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<NetSocket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new NetSocket((io.vertx.core.net.NetSocket) obj),
    NetSocket::getDelegate
  );

  private final io.vertx.core.net.NetSocket delegate;
  
  public NetSocket(io.vertx.core.net.NetSocket delegate) {
    this.delegate = delegate;
  }

  public NetSocket(Object delegate) {
    this.delegate = (io.vertx.core.net.NetSocket)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  NetSocket() {
    this.delegate = null;
  }

  public io.vertx.core.net.NetSocket getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetSocket that = (NetSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> subscriber;

  @CheckReturnValue
  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    end(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.core.net.NetSocket __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.core.net.NetSocket __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.core.net.NetSocket pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.net.NetSocket resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.net.NetSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param endHandler 
   * @return the instance of NetSocket to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.core.net.NetSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   */
  public io.vertx.mutiny.core.net.NetSocket endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  public io.vertx.mutiny.core.net.NetSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.net.NetSocket __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket drainHandler(java.lang.Runnable handler) {
    return __drainHandler(ignored -> handler.run()
);
  }

  /**
   * @return the write handler ID
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param str 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(String str) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(str, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param str 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(String str) { 
    return (Void) write(str).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#write(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#write(String)} but you don't need to compose it with other operations.
   * @param str 
   */
  public void writeAndForget(String str) { 
    write(str).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param str 
   * @param enc 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(String str, String enc) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(str, enc, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param str 
   * @param enc 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(String str, String enc) { 
    return (Void) write(str, enc).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)} but you don't need to compose it with other operations.
   * @param str 
   * @param enc 
   */
  public void writeAndForget(String str, String enc) { 
    write(str, enc).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.streams.WriteStream#write} but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param message 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(message.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param message 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer message) { 
    return (Void) write(message).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param message 
   */
  public void writeAndForget(io.vertx.mutiny.core.buffer.Buffer message) { 
    write(message).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename file name of the file to send
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendFile(String filename) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendFile(filename, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename file name of the file to send
   * @return the Void instance produced by the operation.
   */
  public Void sendFileAndAwait(String filename) { 
    return (Void) sendFile(filename).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)} but you don't need to compose it with other operations.
   * @param filename file name of the file to send
   * @return the instance of NetSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetSocket sendFileAndForget(String filename) { 
    sendFile(filename).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename file name of the file to send
   * @param offset offset
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendFile(String filename, long offset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendFile(filename, offset, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename file name of the file to send
   * @param offset offset
   * @return the Void instance produced by the operation.
   */
  public Void sendFileAndAwait(String filename, long offset) { 
    return (Void) sendFile(filename, offset).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)} but you don't need to compose it with other operations.
   * @param filename file name of the file to send
   * @param offset offset
   * @return the instance of NetSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetSocket sendFileAndForget(String filename, long offset) { 
    sendFile(filename, offset).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendFile(String filename, long offset, long length) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendFile(filename, offset, length, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return the Void instance produced by the operation.
   */
  public Void sendFileAndAwait(String filename, long offset, long length) { 
    return (Void) sendFile(filename, offset, length).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)} but you don't need to compose it with other operations.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return the instance of NetSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetSocket sendFileAndForget(String filename, long offset, long length) { 
    sendFile(filename, offset, length).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param real 
   * @return 
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress(boolean real) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress(real));
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param real 
   * @return 
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress(boolean real) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress(real));
    return ret;
  }

  /**
   * Calls {@link io.vertx.mutiny.core.net.NetSocket#end}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.net.NetSocket __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.net.NetSocket closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> upgradeToSsl() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.upgradeToSsl(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void upgradeToSslAndAwait() { 
    return (Void) upgradeToSsl().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl} but you don't need to compose it with other operations.
   * @return the instance of NetSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetSocket upgradeToSslAndForget() { 
    upgradeToSsl().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param serverName the server name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> upgradeToSsl(String serverName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.upgradeToSsl(serverName, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param serverName the server name
   * @return the Void instance produced by the operation.
   */
  public Void upgradeToSslAndAwait(String serverName) { 
    return (Void) upgradeToSsl(serverName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#upgradeToSsl(String)} but you don't need to compose it with other operations.
   * @param serverName the server name
   * @return the instance of NetSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetSocket upgradeToSslAndForget(String serverName) { 
    upgradeToSsl(serverName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.net.NetSocket} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return the application-level protocol negotiated during the TLS handshake
   */
  public String applicationLayerProtocol() { 
    String ret = delegate.applicationLayerProtocol();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
    return arg != null ? new NetSocket(arg) : null;
  }

}
