package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Base WebSocket implementation.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketBase original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.WebSocketBase.class)
public interface WebSocketBase extends io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> {

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  io.vertx.core.http.WebSocketBase getDelegate();

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   */
  public void writeAndForget(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull();

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe();

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst);

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst);

  public io.vertx.mutiny.core.http.WebSocketBase exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler);

  public io.vertx.mutiny.core.http.WebSocketBase handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler);

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase pause();

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase resume();

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase fetch(long amount);

  public io.vertx.mutiny.core.http.WebSocketBase endHandler(java.lang.Runnable endHandler);

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize);

  public io.vertx.mutiny.core.http.WebSocketBase drainHandler(java.lang.Runnable handler);

  /**
   * @return the binary handler id
   */
  public String binaryHandlerID();

  /**
   * @return the text handler id
   */
  public String textHandlerID();

  /**
   * @return 
   */
  public String subProtocol();

  /**
   * @return 
   */
  public Short closeStatusCode();

  /**
   * @return 
   */
  public String closeReason();

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers();

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param frame 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param frame 
   * @return the Void instance produced by the operation.
   */
  public Void writeFrameAndAwait(io.vertx.mutiny.core.http.WebSocketFrame frame);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)} but you don't need to compose it with other operations.
   * @param frame 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeFrameAndForget(io.vertx.mutiny.core.http.WebSocketFrame frame);

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeFinalTextFrame(String text);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation.
   */
  public Void writeFinalTextFrameAndAwait(String text);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)} but you don't need to compose it with other operations.
   * @param text 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeFinalTextFrameAndForget(String text);

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeFinalBinaryFrameAndAwait(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeFinalBinaryFrameAndForget(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeBinaryMessageAndAwait(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeBinaryMessageAndForget(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeTextMessage(String text);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation.
   */
  public Void writeTextMessageAndAwait(String text);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)} but you don't need to compose it with other operations.
   * @param text 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeTextMessageAndForget(String text);

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data the data to write, may be at most 125 bytes
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writePing(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data the data to write, may be at most 125 bytes
   * @return the Void instance produced by the operation.
   */
  public Void writePingAndAwait(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write, may be at most 125 bytes
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writePingAndForget(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data the data to write, may be at most 125 bytes
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writePong(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data the data to write, may be at most 125 bytes
   * @return the Void instance produced by the operation.
   */
  public Void writePongAndAwait(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write, may be at most 125 bytes
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writePongAndForget(io.vertx.mutiny.core.buffer.Buffer data);

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase closeHandler(java.lang.Runnable handler);

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase frameHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.WebSocketFrame> handler);

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase textMessageHandler(java.util.function.Consumer<String> handler);

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase binaryMessageHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler);

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase pongHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler);

  /**
   * 
   *
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end();

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait();

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#end} but you don't need to compose it with other operations.
   */
  public void endAndForget();

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close();

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait();

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget();

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close(short statusCode);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait(short statusCode);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} but you don't need to compose it with other operations.
   * @param statusCode 
   */
  public void closeAndForget(short statusCode);

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @param reason 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close(short statusCode, String reason);

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @param reason 
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait(short statusCode, String reason);

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} but you don't need to compose it with other operations.
   * @param statusCode 
   * @param reason 
   */
  public void closeAndForget(short statusCode, String reason);

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress();

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress();

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl();

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed();

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession();

  public static  WebSocketBase newInstance(io.vertx.core.http.WebSocketBase arg) {
    return arg != null ? new WebSocketBaseImpl(arg) : null;
  }

}

class WebSocketBaseImpl implements WebSocketBase {
  private final io.vertx.core.http.WebSocketBase delegate;
  
  public io.vertx.core.http.WebSocketBase getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebSocketBaseImpl() {
    this.delegate = null;
  }

  public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
    this.delegate = delegate;
  }

  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) write(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   */
  public void writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    write(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    end(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase drainHandler(java.lang.Runnable handler) {
    return __drainHandler(ignored -> handler.run()
);
  }

  /**
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * @return the text handler id
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param frame 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writeFrame(frame.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param frame 
   * @return the Void instance produced by the operation.
   */
  public Void writeFrameAndAwait(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return (Void) writeFrame(frame).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)} but you don't need to compose it with other operations.
   * @param frame 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeFrameAndForget(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    writeFrame(frame).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeFinalTextFrame(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writeFinalTextFrame(text, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation.
   */
  public Void writeFinalTextFrameAndAwait(String text) { 
    return (Void) writeFinalTextFrame(text).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)} but you don't need to compose it with other operations.
   * @param text 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeFinalTextFrameAndForget(String text) { 
    writeFinalTextFrame(text).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeFinalBinaryFrameAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeFinalBinaryFrame(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeFinalBinaryFrameAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    writeFinalBinaryFrame(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writeBinaryMessage(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeBinaryMessageAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeBinaryMessage(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeBinaryMessageAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    writeBinaryMessage(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeTextMessage(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writeTextMessage(text, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation.
   */
  public Void writeTextMessageAndAwait(String text) { 
    return (Void) writeTextMessage(text).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)} but you don't need to compose it with other operations.
   * @param text 
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writeTextMessageAndForget(String text) { 
    writeTextMessage(text).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data the data to write, may be at most 125 bytes
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writePing(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writePing(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data the data to write, may be at most 125 bytes
   * @return the Void instance produced by the operation.
   */
  public Void writePingAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writePing(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writePing(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write, may be at most 125 bytes
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writePingAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    writePing(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data the data to write, may be at most 125 bytes
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writePong(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writePong(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data the data to write, may be at most 125 bytes
   * @return the Void instance produced by the operation.
   */
  public Void writePongAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writePong(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writePong(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write, may be at most 125 bytes
   * @return the instance of WebSocketBase to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.WebSocketBase writePongAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    writePong(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __frameHandler(Handler<io.vertx.mutiny.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase frameHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.WebSocketFrame> handler) {
    return __frameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase textMessageHandler(java.util.function.Consumer<String> handler) {
    return __textMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __binaryMessageHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase binaryMessageHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __binaryMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.WebSocketBase __pongHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.WebSocketBase pongHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __pongHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * 
   *
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close(short statusCode) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(statusCode, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait(short statusCode) { 
    return (Void) close(statusCode).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} but you don't need to compose it with other operations.
   * @param statusCode 
   */
  public void closeAndForget(short statusCode) { 
    close(statusCode).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @param reason 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close(short statusCode, String reason) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(statusCode, reason, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @param reason 
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait(short statusCode, String reason) { 
    return (Void) close(statusCode, reason).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} but you don't need to compose it with other operations.
   * @param statusCode 
   * @param reason 
   */
  public void closeAndForget(short statusCode, String reason) { 
    close(statusCode, reason).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
}
