package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import javax.net.ssl.SSLSession;
import io.vertx.core.Future;

/**
 * A server WebSocket handshake, allows to control acceptance or rejection of a WebSocket.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.ServerWebSocketHandshake original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.ServerWebSocketHandshake.class)
public class ServerWebSocketHandshake implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServerWebSocketHandshake> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServerWebSocketHandshake((io.vertx.core.http.ServerWebSocketHandshake) obj),
    ServerWebSocketHandshake::getDelegate
  );

  private final io.vertx.core.http.ServerWebSocketHandshake delegate;
  
  public ServerWebSocketHandshake(io.vertx.core.http.ServerWebSocketHandshake delegate) {
    this.delegate = delegate;
  }

  public ServerWebSocketHandshake(Object delegate) {
    this.delegate = (io.vertx.core.http.ServerWebSocketHandshake)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServerWebSocketHandshake() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.http.ServerWebSocketHandshake getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.ServerWebSocket> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.http.ServerWebSocket>(o1 -> io.vertx.mutiny.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerWebSocketHandshake that = (ServerWebSocketHandshake) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * @return the WebSocket handshake scheme
   */
  public String scheme() { 
    String ret = delegate.scheme();
    return ret;
  }

  /**
   * @return the WebSocket handshake authority
   */
  public io.vertx.mutiny.core.net.HostAndPort authority() { 
    io.vertx.mutiny.core.net.HostAndPort ret = io.vertx.mutiny.core.net.HostAndPort.newInstance((io.vertx.core.net.HostAndPort)delegate.authority());
    return ret;
  }

  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the WebSocket handshake path.
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }

  /**
   * @return the WebSocket handshake query string.
   */
  public String query() { 
    String ret = delegate.query();
    return ret;
  }

  /**
   * Accept the WebSocket and terminate the WebSocket handshake.
   * <p/>
   * This method should be called from the WebSocket handler to explicitly accept the WebSocket and
   * terminate the WebSocket handshake.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.ServerWebSocket> accept() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.accept().map(x -> ServerWebSocket.newInstance(x)));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#accept}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ServerWebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.ServerWebSocket acceptAndAwait() { 
    return accept().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#accept} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#accept}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#accept} but you don't need to compose it with other operations.
   */
  public void acceptAndForget() { 
    accept().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * Reject the WebSocket.
   * <p>
   * Calling this method from the WebSocket handler when it is first passed to you gives you the opportunity to reject
   * the WebSocket, which will cause the WebSocket handshake to fail by returning
   * a  response code.
   * <p>
   * You might use this method, if for example you only want to accept WebSockets with a particular path.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> reject() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.reject());}

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void rejectAndAwait() { 
    return reject().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject} but you don't need to compose it with other operations.
   */
  public void rejectAndForget() { 
    reject().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * Like {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject} but with a <code>status</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param status 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> reject(int status) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.reject(status));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param status 
   * @return the Void instance produced by the operation.
   */
  public Void rejectAndAwait(int status) { 
    return reject(status).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.ServerWebSocketHandshake#reject(int)} but you don't need to compose it with other operations.
   * @param status 
   */
  public void rejectAndForget(int status) { 
    reject(status).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  public static  ServerWebSocketHandshake newInstance(io.vertx.core.http.ServerWebSocketHandshake arg) {
    return arg != null ? new ServerWebSocketHandshake(arg) : null;
  }

}
