package io.vertx.mutiny.core;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;

/**
 * A timer task that can be used as a future.
 *
 * The future is completed when the timeout expires, when the task is cancelled the future is failed
 * with a {@link java.util.concurrent.CancellationException}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Timer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.Timer.class)
public class Timer implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Timer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Timer((io.vertx.core.Timer) obj),
    Timer::getDelegate
  );

  private final io.vertx.core.Timer delegate;
  
  public Timer(io.vertx.core.Timer delegate) {
    this.delegate = delegate;
  }

  public Timer(Object delegate) {
    this.delegate = (io.vertx.core.Timer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Timer() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.Timer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Timer that = (Timer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> when the future was cancelled and the timeout didn't fire.
   */
  public boolean cancel() { 
    boolean ret = delegate.cancel();
    return ret;
  }

  public static  Timer newInstance(io.vertx.core.Timer arg) {
    return arg != null ? new Timer(arg) : null;
  }

}
