package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.http.HttpVersion;

/**
 * The state of the HTTP response head:
 *
 * <ul>
 *   <li>Status code / Message</li>
 *   <li>Headers</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpResponseHead original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpResponseHead.class)
public interface HttpResponseHead {

  io.vertx.core.http.HttpResponseHead getDelegate();

  /**
   * @return the version of the response
   */
  public io.vertx.core.http.HttpVersion version();

  /**
   * @return the status code of the response
   */
  public int statusCode();

  /**
   * @return the status message of the response
   */
  public String statusMessage();

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers();

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName);

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public List<String> cookies();

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(java.lang.CharSequence headerName);

  public static  HttpResponseHead newInstance(io.vertx.core.http.HttpResponseHead arg) {
    return arg != null ? new HttpResponseHeadImpl(arg) : null;
  }

}

class HttpResponseHeadImpl implements HttpResponseHead {
  private final io.vertx.core.http.HttpResponseHead delegate;
  
  public io.vertx.core.http.HttpResponseHead getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpResponseHeadImpl() {
    this.delegate = null;
  }

  public HttpResponseHeadImpl(io.vertx.core.http.HttpResponseHead delegate) {
    this.delegate = delegate;
  }

  /**
   * @return the version of the response
   */
  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the status code of the response
   */
  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  /**
   * @return the status message of the response
   */
  public String statusMessage() { 
    String ret = delegate.statusMessage();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public List<String> cookies() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<String> ret = delegate.cookies();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(java.lang.CharSequence headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  private io.vertx.mutiny.core.MultiMap cached_0;
  private List<String> cached_1;
}
