package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.Handler;
import java.util.function.Function;
import io.vertx.core.Future;

/**
 * A builder for {@link io.vertx.mutiny.core.http.HttpClient}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientBuilder original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpClientBuilder.class)
public class HttpClientBuilder {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpClientBuilder> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpClientBuilder((io.vertx.core.http.HttpClientBuilder) obj),
    HttpClientBuilder::getDelegate
  );

  private final io.vertx.core.http.HttpClientBuilder delegate;
  
  public HttpClientBuilder(io.vertx.core.http.HttpClientBuilder delegate) {
    this.delegate = delegate;
  }

  public HttpClientBuilder(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpClientBuilder)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpClientBuilder() {
    this.delegate = null;
  }

  public io.vertx.core.http.HttpClientBuilder getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientBuilder that = (HttpClientBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param options the client options
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpClientBuilder with(io.vertx.core.http.HttpClientOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * @param options the pool options
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpClientBuilder with(io.vertx.core.http.PoolOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpClientBuilder __withConnectHandler(Handler<io.vertx.mutiny.core.http.HttpConnection> handler) { 
    delegate.withConnectHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event)));
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientBuilder withConnectHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.HttpConnection> handler) {
    return __withConnectHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the new redirect handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpClientBuilder withRedirectHandler(Function<io.vertx.mutiny.core.http.HttpClientResponse, io.smallrye.mutiny.Uni<io.vertx.core.http.RequestOptions>> handler) { 
    delegate.withRedirectHandler(new java.util.function.Function<io.vertx.core.http.HttpClientResponse,io.vertx.core.Future<io.vertx.core.http.RequestOptions>>() {
      public io.vertx.core.Future<io.vertx.core.http.RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 handler.apply(io.vertx.mutiny.core.http.HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)arg))
            );
         }
     });
    return this;
  }

  /**
   * @return the client as configured by this builder
   */
  public io.vertx.mutiny.core.http.HttpClient build() { 
    io.vertx.mutiny.core.http.HttpClient ret = io.vertx.mutiny.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)delegate.build());
    return ret;
  }

  public static  HttpClientBuilder newInstance(io.vertx.core.http.HttpClientBuilder arg) {
    return arg != null ? new HttpClientBuilder(arg) : null;
  }

}
