package io.vertx.mutiny.core.file;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Represents properties of the file system.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.FileSystemProps original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.file.FileSystemProps.class)
public class FileSystemProps {

  public static final io.smallrye.mutiny.vertx.TypeArg<FileSystemProps> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new FileSystemProps((io.vertx.core.file.FileSystemProps) obj),
    FileSystemProps::getDelegate
  );

  private final io.vertx.core.file.FileSystemProps delegate;
  
  public FileSystemProps(io.vertx.core.file.FileSystemProps delegate) {
    this.delegate = delegate;
  }

  public FileSystemProps(Object delegate) {
    this.delegate = (io.vertx.core.file.FileSystemProps)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  FileSystemProps() {
    this.delegate = null;
  }

  public io.vertx.core.file.FileSystemProps getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileSystemProps that = (FileSystemProps) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return The total space on the file system, in bytes
   */
  public long totalSpace() { 
    long ret = delegate.totalSpace();
    return ret;
  }

  /**
   * @return The total un-allocated space on the file system, in bytes
   */
  public long unallocatedSpace() { 
    long ret = delegate.unallocatedSpace();
    return ret;
  }

  /**
   * @return The total usable space on the file system, in bytes
   */
  public long usableSpace() { 
    long ret = delegate.usableSpace();
    return ret;
  }

  public static  FileSystemProps newInstance(io.vertx.core.file.FileSystemProps arg) {
    return arg != null ? new FileSystemProps(arg) : null;
  }

}
