package io.vertx.mutiny.core.buffer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import java.nio.ByteBuffer;

/**
 * Most data is shuffled around inside Vert.x using buffers.
 * <p>
 * A buffer is a sequence of zero or more bytes that can read from or written to and which expands automatically as
 * necessary to accommodate any bytes written to it. You can perhaps think of a buffer as smart byte array.
 * <p>
 * Please consult the documentation for more information on buffers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.buffer.Buffer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.buffer.Buffer.class)
public class Buffer implements io.vertx.core.shareddata.impl.ClusterSerializable {

  public static final io.smallrye.mutiny.vertx.TypeArg<Buffer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Buffer((io.vertx.core.buffer.Buffer) obj),
    Buffer::getDelegate
  );

  private final io.vertx.core.buffer.Buffer delegate;
  
  public Buffer(io.vertx.core.buffer.Buffer delegate) {
    this.delegate = delegate;
  }

  public Buffer(Object delegate) {
    this.delegate = (io.vertx.core.buffer.Buffer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Buffer() {
    this.delegate = null;
  }

  public io.vertx.core.buffer.Buffer getDelegate() {
    return delegate;
  }

  @Override
  public void writeToBuffer(io.vertx.core.buffer.Buffer buffer) {
    delegate.writeToBuffer(buffer);
  }

  @Override
  public int readFromBuffer(int pos, io.vertx.core.buffer.Buffer buffer) {
    return delegate.readFromBuffer(pos, buffer);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Buffer that = (Buffer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the buffer
   */
  public static io.vertx.mutiny.core.buffer.Buffer buffer() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer());
    return ret;
  }

  /**
   * @param initialSizeHint the hint, in bytes
   * @return the buffer
   */
  public static io.vertx.mutiny.core.buffer.Buffer buffer(int initialSizeHint) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(initialSizeHint));
    return ret;
  }

  /**
   * @param string the string
   * @return the buffer
   */
  public static io.vertx.mutiny.core.buffer.Buffer buffer(String string) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(string));
    return ret;
  }

  /**
   * @param string the string
   * @param enc 
   * @return the buffer
   */
  public static io.vertx.mutiny.core.buffer.Buffer buffer(String string, String enc) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(string, enc));
    return ret;
  }

  /**
   * @return 
   */
  public String toString() { 
    String ret = delegate.toString();
    return ret;
  }

  /**
   * @param enc 
   * @return 
   */
  public String toString(String enc) { 
    String ret = delegate.toString(enc);
    return ret;
  }

  /**
   * @return 
   */
  public JsonObject toJsonObject() { 
    JsonObject ret = delegate.toJsonObject();
    return ret;
  }

  /**
   * @return 
   */
  public JsonArray toJsonArray() { 
    JsonArray ret = delegate.toJsonArray();
    return ret;
  }

  /**
   * @return a Json value which can be a , , {@link java.lang.String}, ... if the buffer contains an array, object, string, ...etc
   */
  public java.lang.Object toJsonValue() { 
    java.lang.Object ret = (Object) delegate.toJsonValue();
    return ret;
  }

  /**
   * @return 
   * @deprecated instead use {@link #toJsonValue()}   */
  @Deprecated
  public java.lang.Object toJson() { 
    java.lang.Object ret = (Object) delegate.toJson();
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public byte getByte(int pos) { 
    byte ret = delegate.getByte(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public short getUnsignedByte(int pos) { 
    short ret = delegate.getUnsignedByte(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getInt(int pos) { 
    int ret = delegate.getInt(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getIntLE(int pos) { 
    int ret = delegate.getIntLE(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public long getUnsignedInt(int pos) { 
    long ret = delegate.getUnsignedInt(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public long getUnsignedIntLE(int pos) { 
    long ret = delegate.getUnsignedIntLE(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public long getLong(int pos) { 
    long ret = delegate.getLong(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public long getLongLE(int pos) { 
    long ret = delegate.getLongLE(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public double getDouble(int pos) { 
    double ret = delegate.getDouble(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public float getFloat(int pos) { 
    float ret = delegate.getFloat(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public short getShort(int pos) { 
    short ret = delegate.getShort(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public short getShortLE(int pos) { 
    short ret = delegate.getShortLE(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getUnsignedShort(int pos) { 
    int ret = delegate.getUnsignedShort(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getUnsignedShortLE(int pos) { 
    int ret = delegate.getUnsignedShortLE(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getMedium(int pos) { 
    int ret = delegate.getMedium(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getMediumLE(int pos) { 
    int ret = delegate.getMediumLE(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getUnsignedMedium(int pos) { 
    int ret = delegate.getUnsignedMedium(pos);
    return ret;
  }

  /**
   * @param pos 
   * @return 
   */
  public int getUnsignedMediumLE(int pos) { 
    int ret = delegate.getUnsignedMediumLE(pos);
    return ret;
  }

  /**
   * @param start 
   * @param end 
   * @return 
   */
  public io.vertx.mutiny.core.buffer.Buffer getBuffer(int start, int end) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(start, end));
    return ret;
  }

  /**
   * @param start 
   * @param end 
   * @param enc 
   * @return 
   */
  public String getString(int start, int end, String enc) { 
    String ret = delegate.getString(start, end, enc);
    return ret;
  }

  /**
   * @param start 
   * @param end 
   * @return 
   */
  public String getString(int start, int end) { 
    String ret = delegate.getString(start, end);
    return ret;
  }

  /**
   * @param buff 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendBuffer(io.vertx.mutiny.core.buffer.Buffer buff) { 
    delegate.appendBuffer(buff.getDelegate());
    return this;
  }

  /**
   * @param buff 
   * @param offset 
   * @param len 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendBuffer(io.vertx.mutiny.core.buffer.Buffer buff, int offset, int len) { 
    delegate.appendBuffer(buff.getDelegate(), offset, len);
    return this;
  }

  /**
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendByte(byte b) { 
    delegate.appendByte(b);
    return this;
  }

  /**
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendUnsignedByte(short b) { 
    delegate.appendUnsignedByte(b);
    return this;
  }

  /**
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendInt(int i) { 
    delegate.appendInt(i);
    return this;
  }

  /**
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendIntLE(int i) { 
    delegate.appendIntLE(i);
    return this;
  }

  /**
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendUnsignedInt(long i) { 
    delegate.appendUnsignedInt(i);
    return this;
  }

  /**
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendUnsignedIntLE(long i) { 
    delegate.appendUnsignedIntLE(i);
    return this;
  }

  /**
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendMedium(int i) { 
    delegate.appendMedium(i);
    return this;
  }

  /**
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendMediumLE(int i) { 
    delegate.appendMediumLE(i);
    return this;
  }

  /**
   * @param l 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendLong(long l) { 
    delegate.appendLong(l);
    return this;
  }

  /**
   * @param l 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendLongLE(long l) { 
    delegate.appendLongLE(l);
    return this;
  }

  /**
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendShort(short s) { 
    delegate.appendShort(s);
    return this;
  }

  /**
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendShortLE(short s) { 
    delegate.appendShortLE(s);
    return this;
  }

  /**
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendUnsignedShort(int s) { 
    delegate.appendUnsignedShort(s);
    return this;
  }

  /**
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendUnsignedShortLE(int s) { 
    delegate.appendUnsignedShortLE(s);
    return this;
  }

  /**
   * @param f 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendFloat(float f) { 
    delegate.appendFloat(f);
    return this;
  }

  /**
   * @param d 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendDouble(double d) { 
    delegate.appendDouble(d);
    return this;
  }

  /**
   * @param str 
   * @param enc 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendString(String str, String enc) { 
    delegate.appendString(str, enc);
    return this;
  }

  /**
   * @param str 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendString(String str) { 
    delegate.appendString(str);
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setByte(int pos, byte b) { 
    delegate.setByte(pos, b);
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setUnsignedByte(int pos, short b) { 
    delegate.setUnsignedByte(pos, b);
    return this;
  }

  /**
   * @param pos 
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setInt(int pos, int i) { 
    delegate.setInt(pos, i);
    return this;
  }

  /**
   * @param pos 
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setIntLE(int pos, int i) { 
    delegate.setIntLE(pos, i);
    return this;
  }

  /**
   * @param pos 
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setUnsignedInt(int pos, long i) { 
    delegate.setUnsignedInt(pos, i);
    return this;
  }

  /**
   * @param pos 
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setUnsignedIntLE(int pos, long i) { 
    delegate.setUnsignedIntLE(pos, i);
    return this;
  }

  /**
   * @param pos 
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setMedium(int pos, int i) { 
    delegate.setMedium(pos, i);
    return this;
  }

  /**
   * @param pos 
   * @param i 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setMediumLE(int pos, int i) { 
    delegate.setMediumLE(pos, i);
    return this;
  }

  /**
   * @param pos 
   * @param l 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setLong(int pos, long l) { 
    delegate.setLong(pos, l);
    return this;
  }

  /**
   * @param pos 
   * @param l 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setLongLE(int pos, long l) { 
    delegate.setLongLE(pos, l);
    return this;
  }

  /**
   * @param pos 
   * @param d 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setDouble(int pos, double d) { 
    delegate.setDouble(pos, d);
    return this;
  }

  /**
   * @param pos 
   * @param f 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setFloat(int pos, float f) { 
    delegate.setFloat(pos, f);
    return this;
  }

  /**
   * @param pos 
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setShort(int pos, short s) { 
    delegate.setShort(pos, s);
    return this;
  }

  /**
   * @param pos 
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setShortLE(int pos, short s) { 
    delegate.setShortLE(pos, s);
    return this;
  }

  /**
   * @param pos 
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setUnsignedShort(int pos, int s) { 
    delegate.setUnsignedShort(pos, s);
    return this;
  }

  /**
   * @param pos 
   * @param s 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setUnsignedShortLE(int pos, int s) { 
    delegate.setUnsignedShortLE(pos, s);
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setBuffer(int pos, io.vertx.mutiny.core.buffer.Buffer b) { 
    delegate.setBuffer(pos, b.getDelegate());
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @param offset 
   * @param len 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setBuffer(int pos, io.vertx.mutiny.core.buffer.Buffer b, int offset, int len) { 
    delegate.setBuffer(pos, b.getDelegate(), offset, len);
    return this;
  }

  /**
   * @param pos 
   * @param str 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setString(int pos, String str) { 
    delegate.setString(pos, str);
    return this;
  }

  /**
   * @param pos 
   * @param str 
   * @param enc 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setString(int pos, String str, String enc) { 
    delegate.setString(pos, str, enc);
    return this;
  }

  /**
   * @return 
   */
  public int length() { 
    int ret = delegate.length();
    return ret;
  }

  /**
   * @return 
   */
  public io.vertx.mutiny.core.buffer.Buffer copy() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.copy());
    return ret;
  }

  /**
   * @return 
   */
  public io.vertx.mutiny.core.buffer.Buffer slice() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.slice());
    return ret;
  }

  /**
   * @param start 
   * @param end 
   * @return 
   */
  public io.vertx.mutiny.core.buffer.Buffer slice(int start, int end) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.slice(start, end));
    return ret;
  }

  /**
   * @param bytes the byte array
   * @return the buffer
   */
  public static io.vertx.mutiny.core.buffer.Buffer buffer(byte[] bytes) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(bytes));
    return ret;
  }

  /**
   * @param byteBuf the Netty ByteBuf
   * @return the buffer
   * @deprecated removed from public API in Vert.x 5   */
  @Deprecated
  public static io.vertx.mutiny.core.buffer.Buffer buffer(io.netty.buffer.ByteBuf byteBuf) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(byteBuf));
    return ret;
  }

  /**
   * @param enc 
   * @return 
   */
  public String toString(java.nio.charset.Charset enc) { 
    String ret = delegate.toString(enc);
    return ret;
  }

  /**
   * @return 
   */
  public byte[] getBytes() { 
    byte[] ret = delegate.getBytes();
    return ret;
  }

  /**
   * @param start 
   * @param end 
   * @return 
   */
  public byte[] getBytes(int start, int end) { 
    byte[] ret = delegate.getBytes(start, end);
    return ret;
  }

  /**
   * @param dst the destination byte array
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer getBytes(byte[] dst) { 
    delegate.getBytes(dst);
    return this;
  }

  /**
   * @param dst the destination byte array
   * @param dstIndex 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer getBytes(byte[] dst, int dstIndex) { 
    delegate.getBytes(dst, dstIndex);
    return this;
  }

  /**
   * @param start 
   * @param end 
   * @param dst the destination byte array
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer getBytes(int start, int end, byte[] dst) { 
    delegate.getBytes(start, end, dst);
    return this;
  }

  /**
   * @param start 
   * @param end 
   * @param dst the destination byte array
   * @param dstIndex 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer getBytes(int start, int end, byte[] dst, int dstIndex) { 
    delegate.getBytes(start, end, dst, dstIndex);
    return this;
  }

  /**
   * @param bytes 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendBytes(byte[] bytes) { 
    delegate.appendBytes(bytes);
    return this;
  }

  /**
   * @param bytes 
   * @param offset 
   * @param len 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer appendBytes(byte[] bytes, int offset, int len) { 
    delegate.appendBytes(bytes, offset, len);
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setBytes(int pos, java.nio.ByteBuffer b) { 
    delegate.setBytes(pos, b);
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setBytes(int pos, byte[] b) { 
    delegate.setBytes(pos, b);
    return this;
  }

  /**
   * @param pos 
   * @param b 
   * @param offset 
   * @param len 
   * @return the instance of Buffer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.buffer.Buffer setBytes(int pos, byte[] b, int offset, int len) { 
    delegate.setBytes(pos, b, offset, len);
    return this;
  }

  /**
   * @return 
   * @deprecated removed from public API in Vert.x 5   */
  @Deprecated
  public io.netty.buffer.ByteBuf getByteBuf() { 
    io.netty.buffer.ByteBuf ret = delegate.getByteBuf();
    return ret;
  }

  public static  Buffer newInstance(io.vertx.core.buffer.Buffer arg) {
    return arg != null ? new Buffer(arg) : null;
  }

}
