package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import java.util.Set;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An asynchronous map.
 * <p>
 * {@link io.vertx.mutiny.core.shareddata.AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> {

  public static final io.smallrye.mutiny.vertx.TypeArg<AsyncMap> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public AsyncMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.core.shareddata.AsyncMap)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AsyncMap() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Get a value from the map, asynchronously.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<V> get(K k) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.get(__typeArg_0.<K>unwrap(k), new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> (V)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#get(K)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @return the V instance produced by the operation.
   */
  public V getAndAwait(K k) { 
    return (V) get(k).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#get(K)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#get(K)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#get(K)} but you don't need to compose it with other operations.
   * @param k the key
   */
  public void getAndForget(K k) { 
    get(k).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Put a value in the map, asynchronously.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> put(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the value
   * @return the Void instance produced by the operation.
   */
  public Void putAndAwait(K k, V v) { 
    return (Void) put(k, v).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the value
   */
  public void putAndForget(K k, V v) { 
    put(k, v).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> put(K k, V v, long ttl) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return the Void instance produced by the operation.
   */
  public Void putAndAwait(K k, V v, long ttl) { 
    return (Void) put(k, v, ttl).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#put(K,V,long)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   */
  public void putAndForget(K k, V v, long ttl) { 
    put(k, v, ttl).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<V> putIfAbsent(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new io.smallrye.mutiny.vertx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> (V)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the value
   * @return the V instance produced by the operation.
   */
  public V putIfAbsentAndAwait(K k, V v) { 
    return (V) putIfAbsent(k, v).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the value
   */
  public void putIfAbsentAndForget(K k, V v) { 
    putIfAbsent(k, v).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Link {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<V> putIfAbsent(K k, V v, long ttl) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, new io.smallrye.mutiny.vertx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> (V)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return the V instance produced by the operation.
   */
  public V putIfAbsentAndAwait(K k, V v, long ttl) { 
    return (V) putIfAbsent(k, v, ttl).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent(K,V,long)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   */
  public void putIfAbsentAndForget(K k, V v, long ttl) { 
    putIfAbsent(k, v, ttl).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Remove a value from the map, asynchronously.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<V> remove(K k) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.remove(__typeArg_0.<K>unwrap(k), new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> (V)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#remove(K)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @return the V instance produced by the operation.
   */
  public V removeAndAwait(K k) { 
    return (V) remove(k).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#remove(K)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#remove(K)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#remove(K)} but you don't need to compose it with other operations.
   * @param k the key
   */
  public void removeAndForget(K k) { 
    remove(k).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> removeIfPresent(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.removeIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#removeIfPresent(K,V)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the value
   * @return the Boolean instance produced by the operation.
   */
  public Boolean removeIfPresentAndAwait(K k, V v) { 
    return (Boolean) removeIfPresent(k, v).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#removeIfPresent(K,V)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#removeIfPresent(K,V)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#removeIfPresent(K,V)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the value
   */
  public void removeIfPresentAndForget(K k, V v) { 
    removeIfPresent(k, v).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the new value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<V> replace(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> (V)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the new value
   * @return the V instance produced by the operation.
   */
  public V replaceAndAwait(K k, V v) { 
    return (V) replace(k, v).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the new value
   */
  public void replaceAndForget(K k, V v) { 
    replace(k, v).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param v the new value
   * @param ttl The time to live (in ms) for the entry
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<V> replace(K k, V v, long ttl) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> (V)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param v the new value
   * @param ttl The time to live (in ms) for the entry
   * @return the V instance produced by the operation.
   */
  public V replaceAndAwait(K k, V v, long ttl) { 
    return (V) replace(k, v, ttl).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#replace(K,V,long)} but you don't need to compose it with other operations.
   * @param k the key
   * @param v the new value
   * @param ttl The time to live (in ms) for the entry
   */
  public void replaceAndForget(K k, V v, long ttl) { 
    replace(k, v, ttl).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> replaceIfPresent(K k, V oldValue, V newValue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return the Boolean instance produced by the operation.
   */
  public Boolean replaceIfPresentAndAwait(K k, V oldValue, V newValue) { 
    return (Boolean) replaceIfPresent(k, oldValue, newValue).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V)} but you don't need to compose it with other operations.
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   */
  public void replaceIfPresentAndForget(K k, V oldValue, V newValue) { 
    replaceIfPresent(k, oldValue, newValue).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param ttl The time to live (in ms) for the entry
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), ttl, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param ttl The time to live (in ms) for the entry
   * @return the Boolean instance produced by the operation.
   */
  public Boolean replaceIfPresentAndAwait(K k, V oldValue, V newValue, long ttl) { 
    return (Boolean) replaceIfPresent(k, oldValue, newValue, ttl).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#replaceIfPresent(K,V,V,long)} but you don't need to compose it with other operations.
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param ttl The time to live (in ms) for the entry
   */
  public void replaceIfPresentAndForget(K k, V oldValue, V newValue, long ttl) { 
    replaceIfPresent(k, oldValue, newValue, ttl).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Clear all entries in the map
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> clear() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.clear(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#clear}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void clearAndAwait() { 
    return (Void) clear().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#clear} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#clear}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#clear} but you don't need to compose it with other operations.
   */
  public void clearAndForget() { 
    clear().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Provide the number of entries in the map
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> size() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.size(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#size}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Integer instance produced by the operation.
   */
  public Integer sizeAndAwait() { 
    return (Integer) size().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#size} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#size}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#size} but you don't need to compose it with other operations.
   */
  public void sizeAndForget() { 
    size().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the keys of the map, asynchronously.
   * <p>
   * Use this method with care as the map may contain a large number of keys,
   * which may not fit entirely in memory of a single node.
   * In this case, the invocation will result in an {@link java.lang.OutOfMemoryError}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Set<K>> keys() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.keys(new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> event.stream().map(elt -> (K)__typeArg_0.wrap(elt)).collect(java.util.stream.Collectors.toSet()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#keys}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<K> instance produced by the operation.
   */
  public Set<K> keysAndAwait() { 
    return (Set<K>) keys().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#keys} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#keys}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#keys} but you don't need to compose it with other operations.
   */
  public void keysAndForget() { 
    keys().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the values of the map, asynchronously.
   * <p>
   * Use this method with care as the map may contain a large number of values,
   * which may not fit entirely in memory of a single node.
   * In this case, the invocation will result in an {@link java.lang.OutOfMemoryError}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<V>> values() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.values(new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> event.stream().map(elt -> (V)__typeArg_1.wrap(elt)).collect(java.util.stream.Collectors.toList()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#values}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<V> instance produced by the operation.
   */
  public List<V> valuesAndAwait() { 
    return (List<V>) values().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.AsyncMap#values} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.AsyncMap#values}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.AsyncMap#values} but you don't need to compose it with other operations.
   */
  public void valuesAndForget() { 
    values().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }


  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
