package io.vertx.mutiny.core.net;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.net.InetSocketAddress;

/**
 * The address of a socket, an inet socket address or a domain socket address.
 * <p/>
 * Use {@link io.vertx.mutiny.core.net.SocketAddress#inetSocketAddress} to create an inet socket address and {@link io.vertx.mutiny.core.net.SocketAddress#domainSocketAddress}
 * to create a domain socket address
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SocketAddress original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.SocketAddress.class)
public class SocketAddress {

  public static final io.smallrye.mutiny.vertx.TypeArg<SocketAddress> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SocketAddress((io.vertx.core.net.SocketAddress) obj),
    SocketAddress::getDelegate
  );

  private final io.vertx.core.net.SocketAddress delegate;
  
  public SocketAddress(io.vertx.core.net.SocketAddress delegate) {
    this.delegate = delegate;
  }

  public SocketAddress(Object delegate) {
    this.delegate = (io.vertx.core.net.SocketAddress)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SocketAddress() {
    this.delegate = null;
  }

  public io.vertx.core.net.SocketAddress getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SocketAddress that = (SocketAddress) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param port the port
   * @param host the host
   * @return the created socket address
   */
  public static io.vertx.mutiny.core.net.SocketAddress inetSocketAddress(int port, String host) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)io.vertx.core.net.SocketAddress.inetSocketAddress(port, host));
    return ret;
  }

  /**
   * @param path the address path
   * @return the created socket address
   */
  public static io.vertx.mutiny.core.net.SocketAddress domainSocketAddress(String path) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)io.vertx.core.net.SocketAddress.domainSocketAddress(path));
    return ret;
  }

  /**
   * @return the host address
   */
  public String host() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.host();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the host name
   */
  public String hostName() { 
    if (cached_1 != null) {
      return cached_1;
    }
    String ret = delegate.hostName();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the host address
   */
  public String hostAddress() { 
    if (cached_2 != null) {
      return cached_2;
    }
    String ret = delegate.hostAddress();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the address port or <code>-1</code> for a domain socket
   */
  public int port() { 
    if (cached_3 != null) {
      return cached_3;
    }
    int ret = delegate.port();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the domain socket path or <code>null</code> for a inet socket address.
   */
  public String path() { 
    if (cached_4 != null) {
      return cached_4;
    }
    String ret = delegate.path();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> for an inet socket address
   */
  public boolean isInetSocket() { 
    if (cached_5 != null) {
      return cached_5;
    }
    boolean ret = delegate.isInetSocket();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> for an domain socket address
   */
  public boolean isDomainSocket() { 
    if (cached_6 != null) {
      return cached_6;
    }
    boolean ret = delegate.isDomainSocket();
    cached_6 = ret;
    return ret;
  }

  /**
   * @param address the address
   * @return the created socket address
   */
  public static io.vertx.mutiny.core.net.SocketAddress inetSocketAddress(java.net.InetSocketAddress address) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)io.vertx.core.net.SocketAddress.inetSocketAddress(address));
    return ret;
  }

  private String cached_0;
  private String cached_1;
  private String cached_2;
  private java.lang.Integer cached_3;
  private String cached_4;
  private java.lang.Boolean cached_5;
  private java.lang.Boolean cached_6;
  public static  SocketAddress newInstance(io.vertx.core.net.SocketAddress arg) {
    return arg != null ? new SocketAddress(arg) : null;
  }

}
